/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.xmlpull.v1.XmlPullParserException;

public class Keyboard {
    public static final int EDGE_BOTTOM = 8;
    public static final int EDGE_LEFT = 1;
    public static final int EDGE_RIGHT = 2;
    public static final int EDGE_TOP = 4;
    private static final int GRID_HEIGHT = 5;
    private static final int GRID_SIZE = 50;
    private static final int GRID_WIDTH = 10;
    public static final int KEYCODE_ALT = 250;
    public static final int KEYCODE_CANCEL = 253;
    public static final int KEYCODE_DELETE = 251;
    public static final int KEYCODE_DONE = 252;
    public static final int KEYCODE_MODE_CHANGE = 254;
    public static final int KEYCODE_SHIFT = 255;
    private static float SEARCH_DISTANCE = 0.0f;
    static final String TAG = "Keyboard";
    private static final String TAG_KEY = "Key";
    private static final String TAG_KEYBOARD = "Keyboard";
    private static final String TAG_ROW = "Row";
    private int mCellHeight;
    private int mCellWidth;
    private int mDefaultHeight;
    private int mDefaultHorizontalGap;
    private int mDefaultVerticalGap;
    private int mDefaultWidth;
    private int mDisplayHeight;
    private int mDisplayWidth;
    private int[][] mGridNeighbors;
    private int mKeyHeight;
    private int mKeyWidth;
    private int mKeyboardMode;
    private List<Key> mKeys;
    private CharSequence mLabel;
    private List<Key> mModifierKeys;
    private int mProximityThreshold;
    private Key mShiftKey;
    private int mShiftKeyIndex = -1;
    private boolean mShifted;
    private int mTotalHeight;
    private int mTotalWidth;

    static {
        SEARCH_DISTANCE = 1.8f;
    }

    public Keyboard(Context context, int n) {
        this(context, n, 0);
    }

    public Keyboard(Context context, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mDisplayWidth = n6 = displayMetrics.widthPixels;
        this.mDisplayHeight = n5 = displayMetrics.heightPixels;
        this.mDefaultHorizontalGap = 0;
        this.mDefaultWidth = n4 = this.mDisplayWidth / 10;
        this.mDefaultVerticalGap = 0;
        this.mDefaultHeight = n3 = this.mDefaultWidth;
        ArrayList<Key> arrayList = new ArrayList<Key>();
        this.mKeys = arrayList;
        ArrayList<Key> arrayList2 = new ArrayList<Key>();
        this.mModifierKeys = arrayList2;
        this.mKeyboardMode = n2;
        XmlResourceParser xmlResourceParser = context.getResources().getXml(n);
        this.loadKeyboard(context, xmlResourceParser);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Keyboard(Context context, int n, CharSequence charSequence, int n2, int n3) {
        this(context, n);
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        this.mTotalWidth = 0;
        Row row = new Row(this);
        row.defaultHeight = n7 = this.mDefaultHeight;
        row.defaultWidth = n6 = this.mDefaultWidth;
        row.defaultHorizontalGap = n5 = this.mDefaultHorizontalGap;
        row.verticalGap = n4 = this.mDefaultVerticalGap;
        row.rowEdgeFlags = 12;
        int n11 = n2 == -1 ? Integer.MAX_VALUE : n2;
        int n12 = 0;
        while (true) {
            int n13;
            int n14;
            int n15;
            if (n12 >= (n15 = charSequence.length())) {
                int n16;
                this.mTotalHeight = n16 = this.mDefaultHeight + n9;
                return;
            }
            char c = charSequence.charAt(n12);
            if (n10 >= n11 || (n14 = this.mDefaultWidth + n8 + n3) > (n13 = this.mDisplayWidth)) {
                n8 = 0;
                int n17 = this.mDefaultVerticalGap;
                int n18 = this.mDefaultHeight;
                int n19 = n17 + n18;
                n9 += n19;
                n10 = 0;
            }
            Key key = new Key(row);
            key.x = n8;
            key.y = n9;
            String string2 = String.valueOf(c);
            key.label = string2;
            int[] nArray = new int[]{c};
            key.codes = nArray;
            ++n10;
            int n20 = key.width;
            int n21 = key.gap;
            int n22 = n20 + n21;
            boolean bl = this.mKeys.add(key);
            int n23 = this.mTotalWidth;
            if ((n8 += n22) > n23) {
                this.mTotalWidth = n8;
            }
            ++n12;
        }
    }

    private void computeNearestNeighbors() {
        int n;
        int n2;
        this.mCellWidth = n2 = (this.getMinWidth() + 10 - 1) / 10;
        this.mCellHeight = n = (this.getHeight() + 5 - 1) / 5;
        int[] nArray = new int[50];
        this.mGridNeighbors = (int[][])nArray;
        int[] nArray2 = new int[this.mKeys.size()];
        int n3 = this.mCellWidth * 10;
        int n4 = this.mCellHeight * 5;
        int n5 = 0;
        while (n5 < n3) {
            int n6;
            for (int i = 0; i < n4; i += n6) {
                int n7;
                int n8 = 0;
                for (int j = 0; j < (n7 = this.mKeys.size()); ++j) {
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    Key key = this.mKeys.get(j);
                    int n20 = key.squaredDistanceFrom(n5, i);
                    if (n20 >= (n19 = this.mProximityThreshold) && (n18 = key.squaredDistanceFrom(n17 = this.mCellWidth + n5 - 1, i)) >= (n16 = this.mProximityThreshold) && (n15 = key.squaredDistanceFrom(n14 = this.mCellWidth + n5 - 1, n13 = this.mCellHeight + i - 1)) >= (n12 = this.mProximityThreshold) && (n11 = key.squaredDistanceFrom(n5, n10 = this.mCellHeight + i - 1)) >= (n9 = this.mProximityThreshold)) continue;
                    int n21 = n8 + 1;
                    nArray2[n8] = j;
                    n8 = n21;
                }
                int[] nArray3 = new int[n8];
                System.arraycopy(nArray2, 0, nArray3, 0, n8);
                int[][] nArray4 = this.mGridNeighbors;
                int n22 = this.mCellHeight;
                int n23 = i / n22 * 10;
                int n24 = this.mCellWidth;
                int n25 = n5 / n24;
                int n26 = n23 + n25;
                nArray4[n26] = nArray3;
                n6 = this.mCellHeight;
            }
            int n27 = this.mCellWidth;
            n5 += n27;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int getDimensionOrFraction(TypedArray typedArray, int n, int n2, int n3) {
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue == null) {
            return n3;
        }
        if (typedValue.type == 5) {
            return typedArray.getDimensionPixelOffset(n, n3);
        }
        if (typedValue.type != 6) return n3;
        float f = n3;
        return Math.round(typedArray.getFraction(n, n2, n2, f));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadKeyboard(Context context, XmlResourceParser xmlResourceParser) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Key key = null;
        Row row = null;
        Resources resources = context.getResources();
        while (true) {
            int n4;
            block9: {
                String string2;
                block10: {
                    int n5;
                    try {
                        while ((n4 = xmlResourceParser.next()) != 1) {
                            if (n4 != 2) break block9;
                            String string3 = TAG_ROW;
                            string2 = xmlResourceParser.getName();
                            String string4 = string2;
                            if (string3.equals(string4)) {
                                int n6;
                                int n7;
                                bl2 = true;
                                n2 = 0;
                                Keyboard keyboard = this;
                                Resources resources2 = resources;
                                XmlResourceParser xmlResourceParser2 = xmlResourceParser;
                                row = keyboard.createRowFromXml(resources2, xmlResourceParser2);
                                boolean bl3 = row.mode != 0 && (n7 = row.mode) != (n6 = this.mKeyboardMode);
                                if (!bl3) continue;
                                Keyboard keyboard2 = this;
                                XmlResourceParser xmlResourceParser3 = xmlResourceParser;
                                keyboard2.skipToEndOfRow(xmlResourceParser3);
                                bl2 = false;
                                continue;
                            }
                            String string5 = TAG_KEY;
                            String string6 = string2;
                            if (string5.equals(string6)) {
                                bl = true;
                                Keyboard keyboard = this;
                                XmlResourceParser xmlResourceParser4 = xmlResourceParser;
                                key = keyboard.createKeyFromXml(resources, row, n2, n3, xmlResourceParser4);
                                boolean bl4 = this.mKeys.add(key);
                                if (key.codes[0] == -1) {
                                    int n8;
                                    Key key2;
                                    this.mShiftKey = key2 = key;
                                    this.mShiftKeyIndex = n8 = this.mKeys.size() - 1;
                                    boolean bl5 = this.mModifierKeys.add(key);
                                    continue;
                                }
                                if (key.codes[0] != -1) continue;
                                boolean bl6 = this.mModifierKeys.add(key);
                                continue;
                            }
                            break block10;
                        }
                    }
                    catch (Exception exception) {
                        String string7 = "Parse error:" + exception;
                        int n9 = Log.e("Keyboard", string7);
                        exception.printStackTrace();
                    }
                    int n10 = this.mDefaultVerticalGap;
                    this.mTotalHeight = n5 = n3 - n10;
                    return;
                }
                String string8 = "Keyboard";
                String string9 = string2;
                if (!string8.equals(string9)) continue;
                Keyboard keyboard = this;
                Resources resources3 = resources;
                XmlResourceParser xmlResourceParser5 = xmlResourceParser;
                keyboard.parseKeyboardAttributes(resources3, xmlResourceParser5);
                continue;
            }
            if (n4 != 3) continue;
            if (bl) {
                int n11;
                bl = false;
                int n12 = key.gap;
                int n13 = key.width;
                int n14 = n12 + n13;
                int n15 = this.mTotalWidth;
                if ((n2 += n14) <= n15) continue;
                this.mTotalWidth = n11 = n2;
                continue;
            }
            if (!bl2) continue;
            bl2 = false;
            int n16 = row.verticalGap;
            n3 += n16;
            int n17 = row.defaultHeight;
            n3 += n17;
            ++n;
        }
    }

    private void parseKeyboardAttributes(Resources resources, XmlResourceParser xmlResourceParser) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        AttributeSet attributeSet = Xml.asAttributeSet(xmlResourceParser);
        int[] nArray = R.styleable.Keyboard;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        int n7 = this.mDisplayWidth;
        int n8 = this.mDisplayWidth / 10;
        this.mDefaultWidth = n6 = Keyboard.getDimensionOrFraction(typedArray, 0, n7, n8);
        int n9 = this.mDisplayHeight;
        this.mDefaultHeight = n5 = Keyboard.getDimensionOrFraction(typedArray, 1, n9, 50);
        int n10 = this.mDisplayWidth;
        this.mDefaultHorizontalGap = n4 = Keyboard.getDimensionOrFraction(typedArray, 2, n10, 0);
        int n11 = this.mDisplayHeight;
        this.mDefaultVerticalGap = n3 = Keyboard.getDimensionOrFraction(typedArray, 3, n11, 0);
        float f = this.mDefaultWidth;
        float f2 = SEARCH_DISTANCE;
        int n12 = this.mProximityThreshold = (n2 = (int)(f * f2));
        int n13 = this.mProximityThreshold;
        this.mProximityThreshold = n = n12 * n13;
        typedArray.recycle();
    }

    private void skipToEndOfRow(XmlResourceParser xmlResourceParser) throws XmlPullParserException, IOException {
        int n;
        do {
            if ((n = xmlResourceParser.next()) != 1) continue;
            return;
        } while (n != 3 || !xmlResourceParser.getName().equals(TAG_ROW));
    }

    protected Key createKeyFromXml(Resources resources, Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
        Resources resources2 = resources;
        Row row2 = row;
        int n3 = n;
        int n4 = n2;
        XmlResourceParser xmlResourceParser2 = xmlResourceParser;
        return new Key(resources2, row2, n3, n4, xmlResourceParser2);
    }

    protected Row createRowFromXml(Resources resources, XmlResourceParser xmlResourceParser) {
        return new Row(resources, this, xmlResourceParser);
    }

    public int getHeight() {
        return this.mTotalHeight;
    }

    protected int getHorizontalGap() {
        return this.mDefaultHorizontalGap;
    }

    protected int getKeyHeight() {
        return this.mDefaultHeight;
    }

    protected int getKeyWidth() {
        return this.mDefaultWidth;
    }

    public List<Key> getKeys() {
        return this.mKeys;
    }

    public int getMinWidth() {
        return this.mTotalWidth;
    }

    public List<Key> getModifierKeys() {
        return this.mModifierKeys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] getNearestKeys(int n, int n2) {
        if (this.mGridNeighbors == null) {
            this.computeNearestNeighbors();
        }
        if (n < 0) return new int[0];
        int n3 = this.getMinWidth();
        if (n >= n3) return new int[0];
        if (n2 < 0) return new int[0];
        int n4 = this.getHeight();
        if (n2 >= n4) return new int[0];
        int n5 = this.mCellHeight;
        int n6 = n2 / n5 * 10;
        int n7 = this.mCellWidth;
        int n8 = n / n7;
        int n9 = n6 + n8;
        if (n9 >= 50) return new int[0];
        return this.mGridNeighbors[n9];
    }

    public int getShiftKeyIndex() {
        return this.mShiftKeyIndex;
    }

    protected int getVerticalGap() {
        return this.mDefaultVerticalGap;
    }

    public boolean isShifted() {
        return this.mShifted;
    }

    protected void setHorizontalGap(int n) {
        this.mDefaultHorizontalGap = n;
    }

    protected void setKeyHeight(int n) {
        this.mDefaultHeight = n;
    }

    protected void setKeyWidth(int n) {
        this.mDefaultWidth = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setShifted(boolean bl) {
        if (this.mShiftKey != null) {
            this.mShiftKey.on = bl;
        }
        if (this.mShifted == bl) return false;
        this.mShifted = bl;
        return true;
    }

    protected void setVerticalGap(int n) {
        this.mDefaultVerticalGap = n;
    }

    public static class Key {
        private static final int[] KEY_STATE_NORMAL;
        private static final int[] KEY_STATE_NORMAL_OFF;
        private static final int[] KEY_STATE_NORMAL_ON;
        private static final int[] KEY_STATE_PRESSED;
        private static final int[] KEY_STATE_PRESSED_OFF;
        private static final int[] KEY_STATE_PRESSED_ON;
        public int[] codes;
        public int edgeFlags;
        public int gap;
        public int height;
        public Drawable icon;
        public Drawable iconPreview;
        private Keyboard keyboard;
        public CharSequence label;
        public boolean modifier;
        public boolean on;
        public CharSequence popupCharacters;
        public int popupResId;
        public boolean pressed;
        public boolean repeatable;
        public boolean sticky;
        public CharSequence text;
        public int width;
        public int x;
        public int y;

        static {
            KEY_STATE_NORMAL_ON = new int[]{16842911, 0x10100A0};
            KEY_STATE_PRESSED_ON = new int[]{16842919, 16842911, 0x10100A0};
            int[] nArray = new int[]{16842911};
            KEY_STATE_NORMAL_OFF = nArray;
            KEY_STATE_PRESSED_OFF = new int[]{16842919, 16842911};
            KEY_STATE_NORMAL = new int[0];
            int[] nArray2 = new int[]{16842919};
            KEY_STATE_PRESSED = nArray2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Key(Resources resources, Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
            this(row);
            CharSequence charSequence;
            CharSequence charSequence2;
            Drawable drawable2;
            int n3;
            int n4;
            boolean bl;
            boolean bl2;
            boolean bl3;
            int n5;
            CharSequence charSequence3;
            Drawable drawable3;
            int n6;
            int n7;
            int n8;
            int n9;
            this.x = n;
            this.y = n2;
            AttributeSet attributeSet = Xml.asAttributeSet(xmlResourceParser);
            int[] nArray = R.styleable.Keyboard;
            TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
            int n10 = this.keyboard.mDisplayWidth;
            int n11 = row.defaultWidth;
            this.width = n9 = Keyboard.getDimensionOrFraction(typedArray, 0, n10, n11);
            int n12 = this.keyboard.mDisplayHeight;
            int n13 = row.defaultHeight;
            this.height = n8 = Keyboard.getDimensionOrFraction(typedArray, 1, n12, n13);
            int n14 = this.keyboard.mDisplayWidth;
            int n15 = row.defaultHorizontalGap;
            this.gap = n7 = Keyboard.getDimensionOrFraction(typedArray, 2, n14, n15);
            typedArray.recycle();
            AttributeSet attributeSet2 = Xml.asAttributeSet(xmlResourceParser);
            int[] nArray2 = R.styleable.Keyboard_Key;
            TypedArray typedArray2 = resources.obtainAttributes(attributeSet2, nArray2);
            int n16 = this.x;
            int n17 = this.gap;
            this.x = n6 = n16 + n17;
            TypedValue typedValue = new TypedValue();
            boolean bl4 = typedArray2.getValue(0, typedValue);
            if (typedValue.type == 16 || typedValue.type == 17) {
                int n18 = typedValue.data;
                int[] nArray3 = new int[]{n18};
                this.codes = nArray3;
            } else if (typedValue.type == 3) {
                String string2 = ((Object)typedValue.string).toString();
                int[] nArray4 = this.parseCSV(string2);
                this.codes = nArray4;
            }
            this.iconPreview = drawable3 = typedArray2.getDrawable(7);
            if (this.iconPreview != null) {
                Drawable drawable4 = this.iconPreview;
                int n19 = this.iconPreview.getIntrinsicWidth();
                int n20 = this.iconPreview.getIntrinsicHeight();
                drawable4.setBounds(0, 0, n19, n20);
            }
            this.popupCharacters = charSequence3 = typedArray2.getText(2);
            this.popupResId = n5 = typedArray2.getResourceId(1, 0);
            this.repeatable = bl3 = typedArray2.getBoolean(6, false);
            this.modifier = bl2 = typedArray2.getBoolean(4, false);
            this.sticky = bl = typedArray2.getBoolean(5, false);
            int n21 = this.edgeFlags = (n4 = typedArray2.getInt(3, 0));
            int n22 = row.rowEdgeFlags;
            this.edgeFlags = n3 = n21 | n22;
            this.icon = drawable2 = typedArray2.getDrawable(10);
            if (this.icon != null) {
                Drawable drawable5 = this.icon;
                int n23 = this.icon.getIntrinsicWidth();
                int n24 = this.icon.getIntrinsicHeight();
                drawable5.setBounds(0, 0, n23, n24);
            }
            this.label = charSequence2 = typedArray2.getText(9);
            this.text = charSequence = typedArray2.getText(8);
            if (this.codes == null && !TextUtils.isEmpty(this.label)) {
                int[] nArray5 = new int[1];
                char c = this.label.charAt(0);
                nArray5[0] = c;
                this.codes = nArray5;
            }
            typedArray2.recycle();
        }

        public Key(Row row) {
            int n;
            int n2;
            int n3;
            int n4;
            Keyboard keyboard;
            this.keyboard = keyboard = row.parent;
            this.height = n4 = row.defaultHeight;
            this.width = n3 = row.defaultWidth;
            this.gap = n2 = row.defaultHorizontalGap;
            this.edgeFlags = n = row.rowEdgeFlags;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int[] getCurrentDrawableState() {
            int[] nArray = KEY_STATE_NORMAL;
            if (this.on) {
                if (!this.pressed) return KEY_STATE_NORMAL_ON;
                return KEY_STATE_PRESSED_ON;
            }
            if (this.sticky) {
                if (!this.pressed) return KEY_STATE_NORMAL_OFF;
                return KEY_STATE_PRESSED_OFF;
            }
            if (!this.pressed) return nArray;
            return KEY_STATE_PRESSED;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean isInside(int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            boolean bl = (this.edgeFlags & 1) > 0;
            boolean bl2 = (this.edgeFlags & 2) > 0;
            boolean bl3 = (this.edgeFlags & 4) > 0;
            boolean bl4 = (this.edgeFlags & 8) > 0;
            int n10 = this.x;
            if (n < n10) {
                if (!bl) return false;
                int n11 = this.x;
                int n12 = this.width;
                int n13 = n11 + n12;
                if (n > n13) return false;
            }
            if (n >= (n9 = (n8 = this.x) + (n7 = this.width))) {
                if (!bl2) return false;
                int n14 = this.x;
                if (n < n14) return false;
            }
            if (n2 < (n6 = this.y)) {
                if (!bl3) return false;
                int n15 = this.y;
                int n16 = this.height;
                int n17 = n15 + n16;
                if (n2 > n17) return false;
            }
            if (n2 < (n5 = (n4 = this.y) + (n3 = this.height))) return true;
            if (!bl4) return false;
            int n18 = this.y;
            if (n2 < n18) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onPressed() {
            boolean bl = !this.pressed;
            this.pressed = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onReleased(boolean bl) {
            boolean bl2 = !this.pressed;
            this.pressed = bl2;
            if (!this.sticky) {
                return;
            }
            boolean bl3 = !this.on;
            this.on = bl3;
        }

        int[] parseCSV(String string2) {
            int n = 0;
            int n2 = 0;
            if (string2.length() > 0) {
                int n3;
                n = 0 + 1;
                while ((n2 = string2.indexOf(",", n3 = n2 + 1)) > 0) {
                    ++n;
                }
            }
            int[] nArray = new int[n];
            int n4 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                int n5 = n4 + 1;
                try {
                    int n6;
                    nArray[n4] = n6 = Integer.parseInt(stringTokenizer.nextToken());
                    n4 = n5;
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = "Error parsing keycodes " + string2;
                    int n7 = Log.e("Keyboard", string3);
                    n4 = n5;
                }
            }
            return nArray;
        }

        public int squaredDistanceFrom(int n, int n2) {
            int n3 = this.x;
            int n4 = this.width / 2;
            int n5 = n3 + n4 - n;
            int n6 = this.y;
            int n7 = this.height / 2;
            int n8 = n6 + n7 - n2;
            int n9 = n5 * n5;
            int n10 = n8 * n8;
            return n9 + n10;
        }
    }

    public static class Row {
        public int defaultHeight;
        public int defaultHorizontalGap;
        public int defaultWidth;
        public int mode;
        private Keyboard parent;
        public int rowEdgeFlags;
        public int verticalGap;

        public Row(Resources resources, Keyboard keyboard, XmlResourceParser xmlResourceParser) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            this.parent = keyboard;
            AttributeSet attributeSet = Xml.asAttributeSet(xmlResourceParser);
            int[] nArray = R.styleable.Keyboard;
            TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
            int n7 = keyboard.mDisplayWidth;
            int n8 = keyboard.mDefaultWidth;
            this.defaultWidth = n6 = Keyboard.getDimensionOrFraction(typedArray, 0, n7, n8);
            int n9 = keyboard.mDisplayHeight;
            int n10 = keyboard.mDefaultHeight;
            this.defaultHeight = n5 = Keyboard.getDimensionOrFraction(typedArray, 1, n9, n10);
            int n11 = keyboard.mDisplayWidth;
            int n12 = keyboard.mDefaultHorizontalGap;
            this.defaultHorizontalGap = n4 = Keyboard.getDimensionOrFraction(typedArray, 2, n11, n12);
            int n13 = keyboard.mDisplayHeight;
            int n14 = keyboard.mDefaultVerticalGap;
            this.verticalGap = n3 = Keyboard.getDimensionOrFraction(typedArray, 3, n13, n14);
            typedArray.recycle();
            AttributeSet attributeSet2 = Xml.asAttributeSet(xmlResourceParser);
            int[] nArray2 = R.styleable.Keyboard_Row;
            TypedArray typedArray2 = resources.obtainAttributes(attributeSet2, nArray2);
            this.rowEdgeFlags = n2 = typedArray2.getInt(0, 0);
            this.mode = n = typedArray2.getResourceId(1, 0);
        }

        public Row(Keyboard keyboard) {
            this.parent = keyboard;
        }
    }
}

