/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyboardView
extends View
implements View.OnClickListener {
    private static final int DEBOUNCE_TIME = 70;
    private static final boolean DEBUG = false;
    private static final int DELAY_AFTER_PREVIEW = 70;
    private static final int DELAY_BEFORE_PREVIEW = 0;
    private static final int[] KEY_DELETE;
    private static final int LONGPRESS_TIMEOUT = 0;
    private static final int[] LONG_PRESSABLE_STATE_SET;
    private static int MAX_NEARBY_KEYS = 0;
    private static final int MSG_LONGPRESS = 4;
    private static final int MSG_REMOVE_PREVIEW = 2;
    private static final int MSG_REPEAT = 3;
    private static final int MSG_SHOW_PREVIEW = 1;
    private static final int MULTITAP_INTERVAL = 800;
    private static final int NOT_A_KEY = 255;
    private static final int REPEAT_INTERVAL = 50;
    private static final int REPEAT_START_DELAY = 400;
    private boolean mAbortKey;
    private float mBackgroundDimAmount;
    private Bitmap mBuffer;
    private Canvas mCanvas;
    private Rect mClipRegion;
    private int mCurrentKey = -1;
    private int mCurrentKeyIndex = -1;
    private long mCurrentKeyTime;
    private Rect mDirtyRect;
    private boolean mDisambiguateSwipe;
    private int[] mDistances;
    private int mDownKey = -1;
    private long mDownTime;
    private boolean mDrawPending;
    private GestureDetector mGestureDetector;
    Handler mHandler;
    private boolean mInMultiTap;
    private Keyboard.Key mInvalidatedKey;
    private Drawable mKeyBackground;
    private int[] mKeyIndices;
    private int mKeyTextColor;
    private int mKeyTextSize;
    private Keyboard mKeyboard;
    private OnKeyboardActionListener mKeyboardActionListener;
    private boolean mKeyboardChanged;
    private Keyboard.Key[] mKeys;
    private int mLabelTextSize;
    private int mLastCodeX;
    private int mLastCodeY;
    private int mLastKey;
    private long mLastKeyTime;
    private long mLastMoveTime;
    private int mLastSentIndex;
    private long mLastTapTime;
    private int mLastX;
    private int mLastY;
    private KeyboardView mMiniKeyboard;
    private Map<Keyboard.Key, View> mMiniKeyboardCache;
    private View mMiniKeyboardContainer;
    private int mMiniKeyboardOffsetX;
    private int mMiniKeyboardOffsetY;
    private boolean mMiniKeyboardOnScreen;
    private int[] mOffsetInWindow;
    private long mOldEventTime;
    private int mOldPointerCount;
    private float mOldPointerX;
    private float mOldPointerY;
    private Rect mPadding;
    private Paint mPaint;
    private PopupWindow mPopupKeyboard;
    private int mPopupLayout;
    private View mPopupParent;
    private int mPopupPreviewX;
    private int mPopupPreviewY;
    private int mPopupX;
    private int mPopupY;
    private boolean mPossiblePoly;
    private boolean mPreviewCentered = false;
    private int mPreviewHeight;
    private StringBuilder mPreviewLabel;
    private int mPreviewOffset;
    private PopupWindow mPreviewPopup;
    private TextView mPreviewText;
    private int mPreviewTextSizeLarge;
    private boolean mProximityCorrectOn;
    private int mProximityThreshold;
    private int mRepeatKeyIndex;
    private int mShadowColor;
    private float mShadowRadius;
    private boolean mShowPreview = true;
    private boolean mShowTouchPoints = true;
    private int mStartX;
    private int mStartY;
    private int mSwipeThreshold;
    private SwipeTracker mSwipeTracker;
    private int mTapCount;
    private boolean mUsedVelocity;
    private int mVerticalCorrection;
    private int[] mWindowOffset;
    private int mWindowY;

    static {
        int[] nArray = new int[]{-1};
        KEY_DELETE = nArray;
        int[] nArray2 = new int[]{16843324};
        LONG_PRESSABLE_STATE_SET = nArray2;
        LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
        MAX_NEARBY_KEYS = 12;
    }

    public KeyboardView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843481);
    }

    /*
     * Enabled aggressive block sorting
     */
    public KeyboardView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        boolean bl;
        int n2;
        Rect rect;
        Paint paint;
        PopupWindow popupWindow;
        PopupWindow popupWindow2;
        float f;
        Handler handler;
        Rect rect2;
        StringBuilder stringBuilder;
        SwipeTracker swipeTracker;
        Rect rect3;
        int[] nArray = new int[12];
        this.mKeyIndices = nArray;
        this.mRepeatKeyIndex = -1;
        this.mClipRegion = rect3 = new Rect(0, 0, 0, 0);
        this.mSwipeTracker = swipeTracker = new SwipeTracker();
        this.mOldPointerCount = 1;
        int[] nArray2 = new int[MAX_NEARBY_KEYS];
        this.mDistances = nArray2;
        this.mPreviewLabel = stringBuilder = new StringBuilder(1);
        this.mDirtyRect = rect2 = new Rect();
        this.mHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        KeyboardView keyboardView = KeyboardView.this;
                        int n = message.arg1;
                        keyboardView.showKey(n);
                        return;
                    }
                    case 2: {
                        KeyboardView.this.mPreviewText.setVisibility(4);
                        return;
                    }
                    case 3: {
                        if (!KeyboardView.this.repeatKey()) {
                            return;
                        }
                        Message message2 = Message.obtain((Handler)this, 3);
                        boolean bl = this.sendMessageDelayed(message2, 50L);
                        return;
                    }
                    case 4: 
                }
                KeyboardView keyboardView = KeyboardView.this;
                MotionEvent motionEvent = (MotionEvent)message.obj;
                boolean bl = keyboardView.openPopupIfRequired(motionEvent);
            }
        };
        int[] nArray3 = R.styleable.KeyboardView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray3, n, 0);
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        int n3 = 0;
        int n4 = typedArray.getIndexCount();
        block13: for (int i = 0; i < n4; ++i) {
            int n5 = typedArray.getIndex(i);
            switch (n5) {
                case 2: {
                    Drawable drawable2;
                    this.mKeyBackground = drawable2 = typedArray.getDrawable(n5);
                    continue block13;
                }
                case 9: {
                    int n6;
                    this.mVerticalCorrection = n6 = typedArray.getDimensionPixelOffset(n5, 0);
                    continue block13;
                }
                case 6: {
                    n3 = typedArray.getResourceId(n5, 0);
                    continue block13;
                }
                case 7: {
                    int n7;
                    this.mPreviewOffset = n7 = typedArray.getDimensionPixelOffset(n5, 0);
                    continue block13;
                }
                case 8: {
                    int n8;
                    this.mPreviewHeight = n8 = typedArray.getDimensionPixelSize(n5, 80);
                    continue block13;
                }
                case 3: {
                    int n9;
                    this.mKeyTextSize = n9 = typedArray.getDimensionPixelSize(n5, 18);
                    continue block13;
                }
                case 5: {
                    int n10;
                    this.mKeyTextColor = n10 = typedArray.getColor(n5, -16777216);
                    continue block13;
                }
                case 4: {
                    int n11;
                    this.mLabelTextSize = n11 = typedArray.getDimensionPixelSize(n5, 14);
                    continue block13;
                }
                case 10: {
                    int n12;
                    this.mPopupLayout = n12 = typedArray.getResourceId(n5, 0);
                    continue block13;
                }
                case 0: {
                    int n13;
                    this.mShadowColor = n13 = typedArray.getColor(n5, 0);
                    continue block13;
                }
                case 1: {
                    float f2;
                    this.mShadowRadius = f2 = typedArray.getFloat(n5, 0.0f);
                    continue block13;
                }
            }
        }
        Context context2 = this.mContext;
        int[] nArray4 = R.styleable.Theme;
        this.mBackgroundDimAmount = f = context2.obtainStyledAttributes(nArray4).getFloat(2, 0.5f);
        this.mPreviewPopup = popupWindow2 = new PopupWindow(context);
        if (n3 != 0) {
            int n14;
            TextView textView;
            this.mPreviewText = textView = (TextView)layoutInflater.inflate(n3, null);
            this.mPreviewTextSizeLarge = n14 = (int)this.mPreviewText.getTextSize();
            PopupWindow popupWindow3 = this.mPreviewPopup;
            TextView textView2 = this.mPreviewText;
            popupWindow3.setContentView(textView2);
            this.mPreviewPopup.setBackgroundDrawable(null);
        } else {
            this.mShowPreview = false;
        }
        this.mPreviewPopup.setTouchable(false);
        this.mPopupKeyboard = popupWindow = new PopupWindow(context);
        this.mPopupKeyboard.setBackgroundDrawable(null);
        this.mPopupParent = this;
        this.mPaint = paint = new Paint();
        this.mPaint.setAntiAlias(true);
        Paint paint2 = this.mPaint;
        float f3 = 0.0f;
        paint2.setTextSize(f3);
        Paint paint3 = this.mPaint;
        Paint.Align align = Paint.Align.CENTER;
        paint3.setTextAlign(align);
        this.mPaint.setAlpha(255);
        this.mPadding = rect = new Rect(0, 0, 0, 0);
        HashMap<Keyboard.Key, View> hashMap = new HashMap<Keyboard.Key, View>();
        this.mMiniKeyboardCache = hashMap;
        Drawable drawable3 = this.mKeyBackground;
        Rect rect4 = this.mPadding;
        boolean bl2 = drawable3.getPadding(rect4);
        float f4 = this.getResources().getDisplayMetrics().density;
        this.mSwipeThreshold = n2 = (int)(500.0f * f4);
        this.mDisambiguateSwipe = bl = this.getResources().getBoolean(17629198);
        this.resetMultiTap();
        this.initGestureDetector();
    }

    private CharSequence adjustCase(CharSequence charSequence) {
        if (this.mKeyboard.isShifted() && charSequence != null && charSequence.length() < 3 && Character.isLowerCase(charSequence.charAt(0))) {
            charSequence = ((Object)charSequence).toString().toUpperCase();
        }
        return charSequence;
    }

    private void checkMultiTap(long l, int n) {
        int n2;
        if (n == -1) {
            return;
        }
        Keyboard.Key key = this.mKeys[n];
        if (key.codes.length > 1) {
            int n3;
            this.mInMultiTap = true;
            long l2 = this.mLastTapTime + 800L;
            if (l < l2 && n != (n3 = this.mLastSentIndex)) {
                int n4;
                int n5 = this.mTapCount + 1;
                int n6 = key.codes.length;
                this.mTapCount = n4 = n5 % n6;
                return;
            }
            this.mTapCount = -1;
            return;
        }
        long l3 = this.mLastTapTime + 800L;
        if (l <= l3 && n != (n2 = this.mLastSentIndex)) {
            return;
        }
        this.resetMultiTap();
    }

    private void computeProximityThreshold(Keyboard keyboard) {
        int n;
        int n2;
        if (keyboard == null) {
            return;
        }
        Keyboard.Key[] keyArray = this.mKeys;
        if (keyArray == null) {
            return;
        }
        int n3 = keyArray.length;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            Keyboard.Key key = keyArray[i];
            int n5 = key.width;
            int n6 = key.height;
            int n7 = Math.min(n5, n6);
            int n8 = key.gap;
            int n9 = n7 + n8;
            n4 += n9;
        }
        if (n4 < 0) {
            return;
        }
        if (n3 == 0) {
            return;
        }
        float f = (float)n4 * 1.4f;
        float f2 = n3;
        int n10 = this.mProximityThreshold = (n2 = (int)(f / f2));
        int n11 = this.mProximityThreshold;
        this.mProximityThreshold = n = n10 * n11;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void detectAndSendKey(int n, int n2, int n3, long l) {
        if (n == -1) {
            return;
        }
        int n4 = this.mKeys.length;
        if (n >= n4) {
            return;
        }
        Keyboard.Key key = this.mKeys[n];
        if (key.text != null) {
            OnKeyboardActionListener onKeyboardActionListener = this.mKeyboardActionListener;
            CharSequence charSequence = key.text;
            onKeyboardActionListener.onText(charSequence);
            this.mKeyboardActionListener.onRelease(-1);
        } else {
            int n5 = key.codes[0];
            int[] nArray = new int[MAX_NEARBY_KEYS];
            Arrays.fill(nArray, -1);
            int n6 = this.getKeyIndices(n2, n3, nArray);
            if (this.mInMultiTap) {
                if (this.mTapCount != -1) {
                    OnKeyboardActionListener onKeyboardActionListener = this.mKeyboardActionListener;
                    int[] nArray2 = KEY_DELETE;
                    onKeyboardActionListener.onKey(-1, nArray2);
                } else {
                    this.mTapCount = 0;
                }
                int[] nArray3 = key.codes;
                int n7 = this.mTapCount;
                n5 = nArray3[n7];
            }
            this.mKeyboardActionListener.onKey(n5, nArray);
            this.mKeyboardActionListener.onRelease(n5);
        }
        this.mLastSentIndex = n;
        this.mLastTapTime = l;
    }

    private void dismissPopupKeyboard() {
        if (!this.mPopupKeyboard.isShowing()) {
            return;
        }
        this.mPopupKeyboard.dismiss();
        this.mMiniKeyboardOnScreen = false;
        this.invalidateAllKeys();
    }

    /*
     * Unable to fully structure code
     */
    private int getKeyIndices(int var1_1, int var2_2, int[] var3_3) {
        var4_4 = this.mKeys;
        var5_5 = 65535;
        var6_6 = -1;
        var7_7 = this.mProximityThreshold + 1;
        Arrays.fill(this.mDistances, 0x7FFFFFFF);
        var8_8 = this.mKeyboard;
        var9_9 = var1_1;
        var10_10 = var2_2;
        var11_11 = var8_8.getNearestKeys(var9_9, var10_10);
        var12_12 = var11_11.length;
        block0: for (var13_13 = 0; var13_13 < var12_12; ++var13_13) {
            block11: {
                block10: {
                    var14_14 = var11_11[var13_13];
                    var15_15 = var4_4[var14_14];
                    var16_16 = 0;
                    var17_17 = var15_15;
                    var18_18 = var1_1;
                    var19_19 = var2_2;
                    var20_20 = var17_17.isInside(var18_18, var19_19);
                    if (var20_20) {
                        var5_5 = var11_11[var13_13];
                    }
                    if ((!this.mProximityCorrectOn || (var25_25 = (var16_16 = (var21_21 = var15_15).squaredDistanceFrom(var22_22 = var1_1, var23_23 = var2_2))) >= (var26_26 = (var24_24 = this.mProximityThreshold))) && !var20_20 || (var27_27 = var15_15.codes[0]) <= (var28_28 = 32)) break block10;
                    var29_29 = var15_15.codes.length;
                    if (var16_16 < var7_7) {
                        var30_30 = var16_16;
                        var6_6 = var11_11[var13_13];
                    }
                    if (var3_3 != null) break block11;
                }
lbl28:
                // 3 sources

                continue block0;
            }
            var31_31 = 0;
            while (true) {
                if ((var33_33 = ++var31_31) >= (var34_34 = (var32_32 = this.mDistances.length))) ** GOTO lbl28
                var35_35 = this.mDistances[var31_31];
                var36_36 = var16_16;
                if (var35_35 <= var36_36) continue;
                var37_37 = this.mDistances;
                var38_38 = this.mDistances;
                var39_39 = var31_31 + var29_29;
                var40_40 = this.mDistances.length - var31_31 - var29_29;
                var41_41 = var37_37;
                var42_42 = var31_31;
                var43_43 = var38_38;
                var44_44 = var39_39;
                var45_45 = var40_40;
                System.arraycopy(var41_41, var42_42, var43_43, var44_44, var45_45);
                var46_46 = var31_31 + var29_29;
                var47_47 = var3_3.length - var31_31 - var29_29;
                var48_48 = var3_3;
                var49_49 = var31_31;
                var50_50 = var3_3;
                var51_51 = var46_46;
                var52_52 = var47_47;
                System.arraycopy(var48_48, var49_49, var50_50, var51_51, var52_52);
                var53_53 = 0;
                while (true) {
                    if (var53_53 < var29_29) ** break;
                    ** continue;
                    var54_54 = var31_31 + var53_53;
                    var3_3[var54_54] = var55_55 = var15_15.codes[var53_53];
                    var56_56 = this.mDistances;
                    var57_57 = var31_31 + var53_53;
                    var56_56[var57_57] = var16_16;
                    ++var53_53;
                }
            }
        }
        var58_58 = var5_5;
        var59_59 = 65535;
        if (var58_58 == var59_59) {
            var5_5 = var6_6;
        }
        return var5_5;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CharSequence getPreviewText(Keyboard.Key key) {
        if (!this.mInMultiTap) {
            CharSequence charSequence = key.label;
            return this.adjustCase(charSequence);
        }
        this.mPreviewLabel.setLength(0);
        StringBuilder stringBuilder = this.mPreviewLabel;
        int[] nArray = key.codes;
        int n = this.mTapCount < 0 ? 0 : this.mTapCount;
        char c = (char)nArray[n];
        StringBuilder stringBuilder2 = stringBuilder.append(c);
        StringBuilder stringBuilder3 = this.mPreviewLabel;
        return this.adjustCase(stringBuilder3);
    }

    private void initGestureDetector() {
        GestureDetector gestureDetector;
        Context context = this.getContext();
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
                block15: {
                    boolean bl;
                    block14: {
                        float f3;
                        float f4;
                        float f5;
                        float f6;
                        float f7;
                        float f8;
                        if (KeyboardView.this.mPossiblePoly) {
                            return false;
                        }
                        float f9 = Math.abs(f);
                        float f10 = Math.abs(f2);
                        float f11 = motionEvent2.getX();
                        float f12 = motionEvent.getX();
                        float f13 = f11 - f12;
                        float f14 = motionEvent2.getY();
                        float f15 = motionEvent.getY();
                        float f16 = f14 - f15;
                        int n = KeyboardView.this.getWidth() / 2;
                        int n2 = KeyboardView.this.getHeight() / 2;
                        KeyboardView.this.mSwipeTracker.computeCurrentVelocity(1000);
                        float f17 = KeyboardView.this.mSwipeTracker.getXVelocity();
                        float f18 = KeyboardView.this.mSwipeTracker.getYVelocity();
                        bl = false;
                        float f19 = KeyboardView.this.mSwipeThreshold;
                        if (f > f19 && f10 < f9 && f13 > (f8 = (float)n)) {
                            float f20;
                            if (KeyboardView.this.mDisambiguateSwipe && f17 < (f20 = f / 4.0f)) {
                                bl = true;
                                break block14;
                            } else {
                                KeyboardView.this.swipeRight();
                                return true;
                            }
                        }
                        float f21 = -KeyboardView.this.mSwipeThreshold;
                        if (f < f21 && f10 < f9 && f13 < (f7 = (float)(-n))) {
                            float f22;
                            if (KeyboardView.this.mDisambiguateSwipe && f17 > (f22 = f / 4.0f)) {
                                bl = true;
                                break block14;
                            } else {
                                KeyboardView.this.swipeLeft();
                                return true;
                            }
                        }
                        float f23 = -KeyboardView.this.mSwipeThreshold;
                        if (f2 < f23 && f9 < f10 && f16 < (f6 = (float)(-n2))) {
                            float f24;
                            if (KeyboardView.this.mDisambiguateSwipe && f18 > (f24 = f2 / 4.0f)) {
                                bl = true;
                                break block14;
                            } else {
                                KeyboardView.this.swipeUp();
                                return true;
                            }
                        }
                        float f25 = KeyboardView.this.mSwipeThreshold;
                        if (!(f2 > f25) || !(f9 < (f5 = f10 / 2.0f)) || !(f16 > (f4 = (float)n2))) break block14;
                        if (!KeyboardView.this.mDisambiguateSwipe || !(f18 < (f3 = f2 / 4.0f))) break block15;
                        bl = true;
                    }
                    if (!bl) return false;
                    KeyboardView keyboardView = KeyboardView.this;
                    int n = KeyboardView.this.mDownKey;
                    int n3 = KeyboardView.this.mStartX;
                    int n4 = KeyboardView.this.mStartY;
                    long l = motionEvent.getEventTime();
                    keyboardView.detectAndSendKey(n, n3, n4, l);
                    return false;
                }
                KeyboardView.this.swipeDown();
                return true;
            }
        };
        this.mGestureDetector = gestureDetector = new GestureDetector(context, simpleOnGestureListener);
        this.mGestureDetector.setIsLongpressEnabled(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onBufferDraw() {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        if (this.mBuffer == null || this.mKeyboardChanged) {
            boolean bl2;
            int n15;
            int n16;
            int n17;
            int n18;
            if (this.mBuffer == null || this.mKeyboardChanged && ((n18 = this.mBuffer.getWidth()) == (n17 = this.getWidth()) || (n16 = this.mBuffer.getHeight()) != (n15 = this.getHeight()))) {
                Canvas canvas;
                Bitmap bitmap;
                int n19 = this.getWidth();
                int n20 = Math.max(1, n19);
                int n21 = this.getHeight();
                int n22 = Math.max(1, n21);
                Bitmap.Config config = Bitmap.Config.ARGB_8888;
                int n23 = n20;
                int n24 = n22;
                Bitmap.Config config2 = config;
                Bitmap bitmap2 = this.mBuffer = (bitmap = Bitmap.createBitmap(n23, n24, config2));
                this.mCanvas = canvas = new Canvas(bitmap2);
            }
            this.invalidateAllKeys();
            this.mKeyboardChanged = bl2 = false;
        }
        Canvas canvas = this.mCanvas;
        Rect rect = this.mDirtyRect;
        Region.Op op = Region.Op.REPLACE;
        boolean bl3 = canvas.clipRect(rect, op);
        if (this.mKeyboard == null) {
            return;
        }
        Paint paint = this.mPaint;
        Drawable drawable2 = this.mKeyBackground;
        Rect rect2 = this.mClipRegion;
        Rect rect3 = this.mPadding;
        int n25 = this.mPaddingLeft;
        int n26 = this.mPaddingTop;
        Keyboard.Key[] keyArray = this.mKeys;
        Keyboard.Key key = this.mInvalidatedKey;
        int n27 = this.mKeyTextColor;
        paint.setColor(n27);
        boolean bl4 = false;
        if (key != null && canvas.getClipBounds(rect2) && (n14 = key.x + n25 - 1) <= (n13 = rect2.left) && (n12 = key.y + n26 - 1) <= (n11 = rect2.top) && (n10 = (n9 = key.x) + (n8 = key.width) + n25 + 1) >= (n7 = rect2.right) && (n6 = (n5 = key.y) + (n4 = key.height) + n26 + 1) >= (n3 = rect2.bottom)) {
            bl4 = true;
        }
        PorterDuff.Mode mode = PorterDuff.Mode.CLEAR;
        canvas.drawColor(0, mode);
        int n28 = keyArray.length;
        int n29 = 0;
        while ((n2 = ++n29) < (n = n28)) {
            int n30;
            int n31;
            String string2;
            Keyboard.Key key2;
            Keyboard.Key key3;
            Keyboard.Key key4 = keyArray[n29];
            if (bl4 && (key3 = key) != (key2 = key4)) continue;
            int[] nArray = key4.getCurrentDrawableState();
            Drawable drawable3 = drawable2;
            int[] nArray2 = nArray;
            boolean bl5 = drawable3.setState(nArray2);
            if (key4.label == null) {
                string2 = null;
            } else {
                CharSequence charSequence = key4.label;
                KeyboardView keyboardView = this;
                CharSequence charSequence2 = charSequence;
                string2 = ((Object)keyboardView.adjustCase(charSequence2)).toString();
            }
            Rect rect4 = drawable2.getBounds();
            int n32 = key4.width;
            int n33 = rect4.right;
            if (n32 == n33 || (n31 = key4.height) != (n30 = rect4.bottom)) {
                int n34 = key4.width;
                int n35 = key4.height;
                Drawable drawable4 = drawable2;
                int n36 = 0;
                int n37 = 0;
                int n38 = n34;
                int n39 = n35;
                drawable4.setBounds(n36, n37, n38, n39);
            }
            float f = key4.x + n25;
            float f2 = key4.y + n26;
            canvas.translate(f, f2);
            Drawable drawable5 = drawable2;
            Canvas canvas2 = canvas;
            drawable5.draw(canvas2);
            if (string2 != null) {
                if (string2.length() > 1 && key4.codes.length < 2) {
                    float f3 = this.mLabelTextSize;
                    paint.setTextSize(f3);
                    Typeface typeface = Typeface.DEFAULT_BOLD;
                    Typeface typeface2 = paint.setTypeface(typeface);
                } else {
                    float f4 = this.mKeyTextSize;
                    paint.setTextSize(f4);
                    Typeface typeface = Typeface.DEFAULT;
                    Typeface typeface3 = paint.setTypeface(typeface);
                }
                float f5 = this.mShadowRadius;
                int n40 = this.mShadowColor;
                paint.setShadowLayer(f5, 0.0f, 0.0f, n40);
                int n41 = key4.width;
                int n42 = rect3.left;
                int n43 = n41 - n42;
                int n44 = rect3.right;
                int n45 = (n43 - n44) / 2;
                int n46 = rect3.left;
                float f6 = n45 + n46;
                int n47 = key4.height;
                int n48 = rect3.top;
                int n49 = n47 - n48;
                int n50 = rect3.bottom;
                float f7 = (n49 - n50) / 2;
                float f8 = paint.getTextSize();
                float f9 = paint.descent();
                float f10 = (f8 - f9) / 2.0f;
                float f11 = f7 + f10;
                float f12 = rect3.top;
                float f13 = f11 + f12;
                Canvas canvas3 = canvas;
                String string3 = string2;
                float f14 = f6;
                float f15 = f13;
                Paint paint2 = paint;
                canvas3.drawText(string3, f14, f15, paint2);
                paint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            } else if (key4.icon != null) {
                int n51 = key4.width;
                int n52 = rect3.left;
                int n53 = n51 - n52;
                int n54 = rect3.right;
                int n55 = n53 - n54;
                int n56 = key4.icon.getIntrinsicWidth();
                int n57 = (n55 - n56) / 2;
                int n58 = rect3.left;
                int n59 = n57 + n58;
                int n60 = key4.height;
                int n61 = rect3.top;
                int n62 = n60 - n61;
                int n63 = rect3.bottom;
                int n64 = n62 - n63;
                int n65 = key4.icon.getIntrinsicHeight();
                int n66 = (n64 - n65) / 2;
                int n67 = rect3.top;
                int n68 = n66 + n67;
                float f16 = n59;
                float f17 = n68;
                canvas.translate(f16, f17);
                Drawable drawable6 = key4.icon;
                int n69 = key4.icon.getIntrinsicWidth();
                int n70 = key4.icon.getIntrinsicHeight();
                drawable6.setBounds(0, 0, n69, n70);
                key4.icon.draw(canvas);
                float f18 = -n59;
                float f19 = -n68;
                canvas.translate(f18, f19);
            }
            float f20 = -key4.x - n25;
            float f21 = -key4.y - n26;
            canvas.translate(f20, f21);
        }
        Object var133_133 = null;
        this.mInvalidatedKey = var133_133;
        if (this.mMiniKeyboardOnScreen) {
            int n71 = (int)(this.mBackgroundDimAmount * 255.0f) << 24;
            paint.setColor(n71);
            float f = this.getWidth();
            float f22 = this.getHeight();
            canvas.drawRect(0.0f, 0.0f, f, f22, paint);
        }
        this.mDrawPending = bl = false;
        this.mDirtyRect.setEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean onModifiedTouchEvent(MotionEvent motionEvent, boolean bl) {
        long l;
        int n = (int)motionEvent.getX();
        int n2 = this.mPaddingLeft;
        int n3 = n - n2;
        int n4 = (int)motionEvent.getY();
        int n5 = this.mVerticalCorrection;
        int n6 = n4 + n5;
        int n7 = this.mPaddingTop;
        int n8 = n6 - n7;
        int n9 = motionEvent.getAction();
        this.mOldEventTime = l = motionEvent.getEventTime();
        int n10 = this.getKeyIndices(n3, n8, null);
        this.mPossiblePoly = bl;
        if (n9 == 0) {
            this.mSwipeTracker.clear();
        }
        this.mSwipeTracker.addMovement(motionEvent);
        if (this.mAbortKey && n9 != 0 && n9 != 3) {
            return true;
        }
        if (this.mGestureDetector.onTouchEvent(motionEvent)) {
            this.showPreview(-1);
            this.mHandler.removeMessages(3);
            this.mHandler.removeMessages(4);
            return true;
        }
        if (this.mMiniKeyboardOnScreen && n9 != 3) {
            return true;
        }
        switch (n9) {
            case 0: {
                long l2;
                long l3;
                this.mAbortKey = false;
                this.mStartX = n3;
                this.mStartY = n8;
                this.mLastCodeX = n3;
                this.mLastCodeY = n8;
                this.mLastKeyTime = 0L;
                this.mCurrentKeyTime = 0L;
                this.mLastKey = -1;
                this.mCurrentKey = n10;
                this.mDownKey = n10;
                this.mLastMoveTime = l3 = (this.mDownTime = (l2 = motionEvent.getEventTime()));
                this.checkMultiTap(l, n10);
                OnKeyboardActionListener onKeyboardActionListener = this.mKeyboardActionListener;
                int n11 = n10 != -1 ? this.mKeys[n10].codes[0] : 0;
                onKeyboardActionListener.onPress(n11);
                if (this.mCurrentKey >= 0) {
                    Keyboard.Key[] keyArray = this.mKeys;
                    int n12 = this.mCurrentKey;
                    if (keyArray[n12].repeatable) {
                        int n13;
                        this.mRepeatKeyIndex = n13 = this.mCurrentKey;
                        Message message = this.mHandler.obtainMessage(3);
                        boolean bl2 = this.mHandler.sendMessageDelayed(message, 400L);
                        boolean bl3 = this.repeatKey();
                        if (this.mAbortKey) {
                            this.mRepeatKeyIndex = -1;
                            break;
                        }
                    }
                }
                if (this.mCurrentKey != -1) {
                    Message message = this.mHandler.obtainMessage(4, motionEvent);
                    Handler handler = this.mHandler;
                    long l4 = LONGPRESS_TIMEOUT;
                    boolean bl4 = handler.sendMessageDelayed(message, l4);
                }
                this.showPreview(n10);
                break;
            }
            case 2: {
                boolean bl5 = false;
                if (n10 != -1) {
                    if (this.mCurrentKey == -1) {
                        long l5;
                        this.mCurrentKey = n10;
                        long l6 = this.mDownTime;
                        this.mCurrentKeyTime = l5 = l - l6;
                    } else {
                        int n14 = this.mCurrentKey;
                        if (n10 != n14) {
                            long l7;
                            long l8 = this.mCurrentKeyTime;
                            long l9 = this.mLastMoveTime;
                            long l10 = l - l9;
                            this.mCurrentKeyTime = l7 = l8 + l10;
                            bl5 = true;
                        } else if (this.mRepeatKeyIndex == -1) {
                            long l11;
                            int n15;
                            int n16;
                            int n17;
                            this.resetMultiTap();
                            this.mLastKey = n17 = this.mCurrentKey;
                            this.mLastCodeX = n16 = this.mLastX;
                            this.mLastCodeY = n15 = this.mLastY;
                            long l12 = this.mCurrentKeyTime + l;
                            long l13 = this.mLastMoveTime;
                            this.mLastKeyTime = l11 = l12 - l13;
                            this.mCurrentKey = n10;
                            this.mCurrentKeyTime = 0L;
                        }
                    }
                }
                if (!bl5) {
                    this.mHandler.removeMessages(4);
                    if (n10 != -1) {
                        Message message = this.mHandler.obtainMessage(4, motionEvent);
                        Handler handler = this.mHandler;
                        long l14 = LONGPRESS_TIMEOUT;
                        boolean bl6 = handler.sendMessageDelayed(message, l14);
                    }
                }
                int n18 = this.mCurrentKey;
                this.showPreview(n18);
                this.mLastMoveTime = l;
                break;
            }
            case 1: {
                long l15;
                long l16;
                this.removeMessages();
                int n19 = this.mCurrentKey;
                if (n10 != n19) {
                    long l17;
                    long l18 = this.mCurrentKeyTime;
                    long l19 = this.mLastMoveTime;
                    long l20 = l - l19;
                    this.mCurrentKeyTime = l17 = l18 + l20;
                } else {
                    long l21;
                    int n20;
                    this.resetMultiTap();
                    this.mLastKey = n20 = this.mCurrentKey;
                    long l22 = this.mCurrentKeyTime + l;
                    long l23 = this.mLastMoveTime;
                    this.mLastKeyTime = l21 = l22 - l23;
                    this.mCurrentKey = n10;
                    this.mCurrentKeyTime = 0L;
                }
                if ((l16 = this.mCurrentKeyTime) < (l15 = this.mLastKeyTime) && this.mCurrentKeyTime < 70L && this.mLastKey != -1) {
                    int n21;
                    this.mCurrentKey = n21 = this.mLastKey;
                    n3 = this.mLastCodeX;
                    n8 = this.mLastCodeY;
                }
                this.showPreview(-1);
                Arrays.fill(this.mKeyIndices, -1);
                if (this.mRepeatKeyIndex == -1 && !this.mMiniKeyboardOnScreen && !this.mAbortKey) {
                    int n22 = this.mCurrentKey;
                    this.detectAndSendKey(n22, n3, n8, l);
                }
                this.invalidateKey(n10);
                this.mRepeatKeyIndex = -1;
                break;
            }
            case 3: {
                this.removeMessages();
                this.dismissPopupKeyboard();
                this.mAbortKey = true;
                this.showPreview(-1);
                int n23 = this.mCurrentKey;
                this.invalidateKey(n23);
                break;
            }
        }
        this.mLastX = n3;
        this.mLastY = n8;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean openPopupIfRequired(MotionEvent motionEvent) {
        if (this.mPopupLayout == 0) {
            return false;
        }
        if (this.mCurrentKey < 0) return false;
        int n = this.mCurrentKey;
        int n2 = this.mKeys.length;
        if (n >= n2) {
            return false;
        }
        Keyboard.Key[] keyArray = this.mKeys;
        int n3 = this.mCurrentKey;
        Keyboard.Key key = keyArray[n3];
        boolean bl = this.onLongPress(key);
        if (!bl) return bl;
        this.mAbortKey = true;
        this.showPreview(-1);
        return bl;
    }

    private void removeMessages() {
        this.mHandler.removeMessages(3);
        this.mHandler.removeMessages(4);
        this.mHandler.removeMessages(1);
    }

    private boolean repeatKey() {
        Keyboard.Key[] keyArray = this.mKeys;
        int n = this.mRepeatKeyIndex;
        Keyboard.Key key = keyArray[n];
        int n2 = this.mCurrentKey;
        int n3 = key.x;
        int n4 = key.y;
        long l = this.mLastTapTime;
        this.detectAndSendKey(n2, n3, n4, l);
        return true;
    }

    private void resetMultiTap() {
        this.mLastSentIndex = -1;
        this.mTapCount = 0;
        this.mLastTapTime = 65535L;
        this.mInMultiTap = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showKey(int n) {
        int n2;
        PopupWindow popupWindow = this.mPreviewPopup;
        Keyboard.Key[] keyArray = this.mKeys;
        if (n < 0) {
            return;
        }
        int n3 = this.mKeys.length;
        if (n >= n3) {
            return;
        }
        Keyboard.Key key = keyArray[n];
        if (key.icon != null) {
            TextView textView = this.mPreviewText;
            Drawable drawable2 = null;
            Drawable drawable3 = null;
            Drawable drawable4 = null;
            Drawable drawable5 = key.iconPreview != null ? key.iconPreview : key.icon;
            textView.setCompoundDrawables(drawable2, drawable3, drawable4, drawable5);
            this.mPreviewText.setText(null);
        } else {
            this.mPreviewText.setCompoundDrawables(null, null, null, null);
            TextView textView = this.mPreviewText;
            CharSequence charSequence = this.getPreviewText(key);
            textView.setText(charSequence);
            if (key.label.length() > 1 && key.codes.length < 2) {
                TextView textView2 = this.mPreviewText;
                float f = this.mKeyTextSize;
                textView2.setTextSize(0, f);
                TextView textView3 = this.mPreviewText;
                Typeface typeface = Typeface.DEFAULT_BOLD;
                textView3.setTypeface(typeface);
            } else {
                TextView textView4 = this.mPreviewText;
                float f = this.mPreviewTextSizeLarge;
                textView4.setTextSize(0, f);
                TextView textView5 = this.mPreviewText;
                Typeface typeface = Typeface.DEFAULT;
                textView5.setTypeface(typeface);
            }
        }
        TextView textView = this.mPreviewText;
        int n4 = View.MeasureSpec.makeMeasureSpec(0, 0);
        int n5 = View.MeasureSpec.makeMeasureSpec(0, 0);
        textView.measure(n4, n5);
        int n6 = this.mPreviewText.getMeasuredWidth();
        int n7 = key.width;
        int n8 = this.mPreviewText.getPaddingLeft();
        int n9 = n7 + n8;
        int n10 = this.mPreviewText.getPaddingRight();
        int n11 = n9 + n10;
        int n12 = Math.max(n6, n11);
        int n13 = this.mPreviewHeight;
        ViewGroup.LayoutParams layoutParams = this.mPreviewText.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.width = n12;
            layoutParams.height = n13;
        }
        if (!this.mPreviewCentered) {
            int n14;
            int n15;
            int n16 = key.x;
            int n17 = this.mPreviewText.getPaddingLeft();
            int n18 = n16 - n17;
            int n19 = this.mPaddingLeft;
            this.mPopupPreviewX = n15 = n18 + n19;
            int n20 = key.y - n13;
            int n21 = this.mPreviewOffset;
            this.mPopupPreviewY = n14 = n20 + n21;
        } else {
            int n22;
            int n23;
            int n24 = this.mPreviewText.getMeasuredWidth() / 2;
            this.mPopupPreviewX = n23 = 160 - n24;
            this.mPopupPreviewY = n22 = -this.mPreviewText.getMeasuredHeight();
        }
        this.mHandler.removeMessages(2);
        if (this.mOffsetInWindow == null) {
            int n25;
            int n26;
            int n27;
            int[] nArray = new int[2];
            int[] nArray2 = this.mOffsetInWindow = nArray;
            this.getLocationInWindow(nArray2);
            int[] nArray3 = this.mOffsetInWindow;
            int n28 = nArray3[0];
            int n29 = this.mMiniKeyboardOffsetX;
            nArray3[0] = n27 = n28 + n29;
            int[] nArray4 = this.mOffsetInWindow;
            int n30 = nArray4[1];
            int n31 = this.mMiniKeyboardOffsetY;
            nArray4[1] = n26 = n30 + n31;
            int[] nArray5 = new int[2];
            this.getLocationOnScreen(nArray5);
            this.mWindowY = n25 = nArray5[1];
        }
        Drawable drawable6 = this.mPreviewText.getBackground();
        int[] nArray = key.popupResId != 0 ? LONG_PRESSABLE_STATE_SET : EMPTY_STATE_SET;
        boolean bl = drawable6.setState(nArray);
        int n32 = this.mPopupPreviewX;
        int n33 = this.mOffsetInWindow[0];
        this.mPopupPreviewX = n2 = n32 + n33;
        int n34 = this.mPopupPreviewY;
        int n35 = this.mOffsetInWindow[1];
        int n36 = n34 + n35;
        this.mPopupPreviewY = n36;
        int n37 = this.mPopupPreviewY;
        int n38 = this.mWindowY;
        if (n37 + n38 < 0) {
            int n39;
            int n40 = key.x;
            int n41 = key.width;
            int n42 = n40 + n41;
            int n43 = this.getWidth() / 2;
            if (n42 <= n43) {
                int n44;
                int n45 = this.mPopupPreviewX;
                int n46 = (int)((double)key.width * 2.5);
                this.mPopupPreviewX = n44 = n45 + n46;
            } else {
                int n47;
                int n48 = this.mPopupPreviewX;
                int n49 = (int)((double)key.width * 2.5);
                this.mPopupPreviewX = n47 = n48 - n49;
            }
            this.mPopupPreviewY = n39 = this.mPopupPreviewY + n13;
        }
        if (popupWindow.isShowing()) {
            int n50 = this.mPopupPreviewX;
            int n51 = this.mPopupPreviewY;
            popupWindow.update(n50, n51, n12, n13);
        } else {
            popupWindow.setWidth(n12);
            popupWindow.setHeight(n13);
            View view = this.mPopupParent;
            int n52 = this.mPopupPreviewX;
            int n53 = this.mPopupPreviewY;
            popupWindow.showAtLocation(view, 0, n52, n53);
        }
        this.mPreviewText.setVisibility(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showPreview(int n) {
        int n2;
        int n3 = this.mCurrentKeyIndex;
        PopupWindow popupWindow = this.mPreviewPopup;
        this.mCurrentKeyIndex = n;
        Keyboard.Key[] keyArray = this.mKeys;
        int n4 = this.mCurrentKeyIndex;
        if (n3 != n4) {
            int n5;
            int n6;
            if (n3 != -1 && keyArray.length > n3) {
                Keyboard.Key key = keyArray[n3];
                boolean bl = this.mCurrentKeyIndex == -1;
                key.onReleased(bl);
                this.invalidateKey(n3);
            }
            if (this.mCurrentKeyIndex != -1 && (n6 = keyArray.length) > (n5 = this.mCurrentKeyIndex)) {
                int n7 = this.mCurrentKeyIndex;
                keyArray[n7].onPressed();
                int n8 = this.mCurrentKeyIndex;
                this.invalidateKey(n8);
            }
        }
        if (n3 != (n2 = this.mCurrentKeyIndex)) {
            return;
        }
        if (!this.mShowPreview) {
            return;
        }
        this.mHandler.removeMessages(1);
        if (popupWindow.isShowing() && n == -1) {
            Handler handler = this.mHandler;
            Message message = this.mHandler.obtainMessage(2);
            boolean bl = handler.sendMessageDelayed(message, 70L);
        }
        if (n == -1) {
            return;
        }
        if (popupWindow.isShowing() && this.mPreviewText.getVisibility() == 0) {
            this.showKey(n);
            return;
        }
        Handler handler = this.mHandler;
        Message message = this.mHandler.obtainMessage(1, n, 0);
        boolean bl = handler.sendMessageDelayed(message, 0L);
    }

    public void closing() {
        if (this.mPreviewPopup.isShowing()) {
            this.mPreviewPopup.dismiss();
        }
        this.removeMessages();
        this.dismissPopupKeyboard();
        this.mBuffer = null;
        this.mCanvas = null;
        this.mMiniKeyboardCache.clear();
    }

    public Keyboard getKeyboard() {
        return this.mKeyboard;
    }

    protected OnKeyboardActionListener getOnKeyboardActionListener() {
        return this.mKeyboardActionListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleBack() {
        if (!this.mPopupKeyboard.isShowing()) return false;
        this.dismissPopupKeyboard();
        return true;
    }

    public void invalidateAllKeys() {
        Rect rect = this.mDirtyRect;
        int n = this.getWidth();
        int n2 = this.getHeight();
        rect.union(0, 0, n, n2);
        this.mDrawPending = true;
        this.invalidate();
    }

    public void invalidateKey(int n) {
        Keyboard.Key key;
        if (this.mKeys == null) {
            return;
        }
        if (n < 0) {
            return;
        }
        int n2 = this.mKeys.length;
        if (n >= n2) {
            return;
        }
        this.mInvalidatedKey = key = this.mKeys[n];
        Rect rect = this.mDirtyRect;
        int n3 = key.x;
        int n4 = this.mPaddingLeft;
        int n5 = n3 + n4;
        int n6 = key.y;
        int n7 = this.mPaddingTop;
        int n8 = n6 + n7;
        int n9 = key.x;
        int n10 = key.width;
        int n11 = n9 + n10;
        int n12 = this.mPaddingLeft;
        int n13 = n11 + n12;
        int n14 = key.y;
        int n15 = key.height;
        int n16 = n14 + n15;
        int n17 = this.mPaddingTop;
        int n18 = n16 + n17;
        rect.union(n5, n8, n13, n18);
        this.onBufferDraw();
        int n19 = key.x;
        int n20 = this.mPaddingLeft;
        int n21 = n19 + n20;
        int n22 = key.y;
        int n23 = this.mPaddingTop;
        int n24 = n22 + n23;
        int n25 = key.x;
        int n26 = key.width;
        int n27 = n25 + n26;
        int n28 = this.mPaddingLeft;
        int n29 = n27 + n28;
        int n30 = key.y;
        int n31 = key.height;
        int n32 = n30 + n31;
        int n33 = this.mPaddingTop;
        int n34 = n32 + n33;
        this.invalidate(n21, n24, n29, n34);
    }

    public boolean isPreviewEnabled() {
        return this.mShowPreview;
    }

    public boolean isProximityCorrectionEnabled() {
        return this.mProximityCorrectOn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isShifted() {
        if (this.mKeyboard == null) return false;
        return this.mKeyboard.isShifted();
    }

    @Override
    public void onClick(View view) {
        this.dismissPopupKeyboard();
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.closing();
    }

    @Override
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawPending || this.mBuffer == null || this.mKeyboardChanged) {
            this.onBufferDraw();
        }
        Bitmap bitmap = this.mBuffer;
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean onLongPress(Keyboard.Key key) {
        int n;
        int n2;
        int n3;
        int n4;
        View view;
        int n5 = key.popupResId;
        if (n5 == 0) {
            return false;
        }
        this.mMiniKeyboardContainer = view = this.mMiniKeyboardCache.get(key);
        if (this.mMiniKeyboardContainer == null) {
            Keyboard keyboard;
            KeyboardView keyboardView;
            View view2;
            LayoutInflater layoutInflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
            int n6 = this.mPopupLayout;
            this.mMiniKeyboardContainer = view2 = layoutInflater.inflate(n6, null);
            this.mMiniKeyboard = keyboardView = (KeyboardView)this.mMiniKeyboardContainer.findViewById(16908326);
            View view3 = this.mMiniKeyboardContainer.findViewById(16908327);
            if (view3 != null) {
                view3.setOnClickListener(this);
            }
            KeyboardView keyboardView2 = this.mMiniKeyboard;
            OnKeyboardActionListener onKeyboardActionListener = new OnKeyboardActionListener(){

                @Override
                public void onKey(int n, int[] nArray) {
                    KeyboardView.this.mKeyboardActionListener.onKey(n, nArray);
                    KeyboardView.this.dismissPopupKeyboard();
                }

                @Override
                public void onPress(int n) {
                    KeyboardView.this.mKeyboardActionListener.onPress(n);
                }

                @Override
                public void onRelease(int n) {
                    KeyboardView.this.mKeyboardActionListener.onRelease(n);
                }

                @Override
                public void onText(CharSequence charSequence) {
                    KeyboardView.this.mKeyboardActionListener.onText(charSequence);
                    KeyboardView.this.dismissPopupKeyboard();
                }

                @Override
                public void swipeDown() {
                }

                @Override
                public void swipeLeft() {
                }

                @Override
                public void swipeRight() {
                }

                @Override
                public void swipeUp() {
                }
            };
            keyboardView2.setOnKeyboardActionListener(onKeyboardActionListener);
            if (key.popupCharacters != null) {
                Context context = this.getContext();
                CharSequence charSequence = key.popupCharacters;
                int n7 = this.getPaddingLeft();
                int n8 = this.getPaddingRight();
                int n9 = n7 + n8;
                keyboard = new Keyboard(context, n5, charSequence, -1, n9);
            } else {
                Context context = this.getContext();
                keyboard = new Keyboard(context, n5);
            }
            this.mMiniKeyboard.setKeyboard(keyboard);
            this.mMiniKeyboard.setPopupParent(this);
            View view4 = this.mMiniKeyboardContainer;
            int n10 = View.MeasureSpec.makeMeasureSpec(this.getWidth(), Integer.MIN_VALUE);
            int n11 = View.MeasureSpec.makeMeasureSpec(this.getHeight(), Integer.MIN_VALUE);
            view4.measure(n10, n11);
            Map<Keyboard.Key, View> map = this.mMiniKeyboardCache;
            View view5 = this.mMiniKeyboardContainer;
            View view6 = map.put(key, view5);
        } else {
            KeyboardView keyboardView;
            this.mMiniKeyboard = keyboardView = (KeyboardView)this.mMiniKeyboardContainer.findViewById(16908326);
        }
        if (this.mWindowOffset == null) {
            int[] nArray = new int[2];
            int[] nArray2 = this.mWindowOffset = nArray;
            this.getLocationInWindow(nArray2);
        }
        int n12 = key.x;
        int n13 = this.mPaddingLeft;
        this.mPopupX = n4 = n12 + n13;
        int n14 = key.y;
        int n15 = this.mPaddingTop;
        this.mPopupY = n3 = n14 + n15;
        int n16 = this.mPopupX;
        int n17 = key.width;
        int n18 = n16 + n17;
        int n19 = this.mMiniKeyboardContainer.getMeasuredWidth();
        this.mPopupX = n2 = n18 - n19;
        int n20 = this.mPopupY;
        int n21 = this.mMiniKeyboardContainer.getMeasuredHeight();
        this.mPopupY = n = n20 - n21;
        int n22 = this.mPopupX;
        int n23 = this.mMiniKeyboardContainer.getPaddingRight();
        int n24 = n22 + n23;
        int n25 = this.mWindowOffset[0];
        int n26 = n24 + n25;
        int n27 = this.mPopupY;
        int n28 = this.mMiniKeyboardContainer.getPaddingBottom();
        int n29 = n27 + n28;
        int n30 = this.mWindowOffset[1];
        int n31 = n29 + n30;
        KeyboardView keyboardView = this.mMiniKeyboard;
        int n32 = n26 < 0 ? 0 : n26;
        keyboardView.setPopupOffset(n32, n31);
        KeyboardView keyboardView3 = this.mMiniKeyboard;
        boolean bl = this.isShifted();
        boolean bl2 = keyboardView3.setShifted(bl);
        PopupWindow popupWindow = this.mPopupKeyboard;
        View view7 = this.mMiniKeyboardContainer;
        popupWindow.setContentView(view7);
        PopupWindow popupWindow2 = this.mPopupKeyboard;
        int n33 = this.mMiniKeyboardContainer.getMeasuredWidth();
        popupWindow2.setWidth(n33);
        PopupWindow popupWindow3 = this.mPopupKeyboard;
        int n34 = this.mMiniKeyboardContainer.getMeasuredHeight();
        popupWindow3.setHeight(n34);
        this.mPopupKeyboard.showAtLocation(this, 0, n26, n31);
        this.mMiniKeyboardOnScreen = true;
        this.invalidateAllKeys();
        return true;
    }

    @Override
    public void onMeasure(int n, int n2) {
        int n3;
        if (this.mKeyboard == null) {
            int n4 = this.mPaddingLeft;
            int n5 = this.mPaddingRight;
            int n6 = n4 + n5;
            int n7 = this.mPaddingTop;
            int n8 = this.mPaddingBottom;
            int n9 = n7 + n8;
            this.setMeasuredDimension(n6, n9);
            return;
        }
        int n10 = this.mKeyboard.getMinWidth();
        int n11 = this.mPaddingLeft;
        int n12 = n10 + n11;
        int n13 = this.mPaddingRight;
        int n14 = n12 + n13;
        int n15 = View.MeasureSpec.getSize(n);
        if (n15 < (n3 = n14 + 10)) {
            n14 = View.MeasureSpec.getSize(n);
        }
        int n16 = this.mKeyboard.getHeight();
        int n17 = this.mPaddingTop;
        int n18 = n16 + n17;
        int n19 = this.mPaddingBottom;
        int n20 = n18 + n19;
        this.setMeasuredDimension(n14, n20);
    }

    @Override
    public void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mBuffer = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl;
        int n;
        block6: {
            block5: {
                n = motionEvent.getPointerCount();
                int n2 = motionEvent.getAction();
                long l = motionEvent.getEventTime();
                int n3 = this.mOldPointerCount;
                if (n == n3) break block5;
                if (n == 1) {
                    float f = motionEvent.getX();
                    float f2 = motionEvent.getY();
                    int n4 = motionEvent.getMetaState();
                    long l2 = l;
                    MotionEvent motionEvent2 = MotionEvent.obtain(l, l2, 0, f, f2, n4);
                    bl = this.onModifiedTouchEvent(motionEvent2, false);
                    motionEvent2.recycle();
                    if (n2 == 1) {
                        bl = this.onModifiedTouchEvent(motionEvent, true);
                    }
                    break block6;
                } else {
                    float f = this.mOldPointerX;
                    float f3 = this.mOldPointerY;
                    int n5 = motionEvent.getMetaState();
                    long l3 = l;
                    int n6 = 1;
                    MotionEvent motionEvent3 = MotionEvent.obtain(l, l3, n6, f, f3, n5);
                    bl = this.onModifiedTouchEvent(motionEvent3, true);
                    motionEvent3.recycle();
                }
                break block6;
            }
            if (n == 1) {
                float f;
                float f4;
                bl = this.onModifiedTouchEvent(motionEvent, false);
                this.mOldPointerX = f4 = motionEvent.getX();
                this.mOldPointerY = f = motionEvent.getY();
            } else {
                bl = true;
            }
        }
        this.mOldPointerCount = n;
        return bl;
    }

    public void setKeyboard(Keyboard keyboard) {
        if (this.mKeyboard != null) {
            this.showPreview(-1);
        }
        this.removeMessages();
        this.mKeyboard = keyboard;
        List<Keyboard.Key> list = this.mKeyboard.getKeys();
        Keyboard.Key[] keyArray = new Keyboard.Key[list.size()];
        Keyboard.Key[] keyArray2 = list.toArray(keyArray);
        this.mKeys = keyArray2;
        this.requestLayout();
        this.mKeyboardChanged = true;
        this.invalidateAllKeys();
        this.computeProximityThreshold(keyboard);
        this.mMiniKeyboardCache.clear();
        this.mAbortKey = true;
    }

    public void setOnKeyboardActionListener(OnKeyboardActionListener onKeyboardActionListener) {
        this.mKeyboardActionListener = onKeyboardActionListener;
    }

    public void setPopupOffset(int n, int n2) {
        this.mMiniKeyboardOffsetX = n;
        this.mMiniKeyboardOffsetY = n2;
        if (!this.mPreviewPopup.isShowing()) {
            return;
        }
        this.mPreviewPopup.dismiss();
    }

    public void setPopupParent(View view) {
        this.mPopupParent = view;
    }

    public void setPreviewEnabled(boolean bl) {
        this.mShowPreview = bl;
    }

    public void setProximityCorrectionEnabled(boolean bl) {
        this.mProximityCorrectOn = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setShifted(boolean bl) {
        if (this.mKeyboard == null) return false;
        if (!this.mKeyboard.setShifted(bl)) return false;
        this.invalidateAllKeys();
        return true;
    }

    public void setVerticalCorrection(int n) {
    }

    protected void swipeDown() {
        this.mKeyboardActionListener.swipeDown();
    }

    protected void swipeLeft() {
        this.mKeyboardActionListener.swipeLeft();
    }

    protected void swipeRight() {
        this.mKeyboardActionListener.swipeRight();
    }

    protected void swipeUp() {
        this.mKeyboardActionListener.swipeUp();
    }

    private static class SwipeTracker {
        static final int LONGEST_PAST_TIME = 200;
        static final int NUM_PAST = 4;
        final long[] mPastTime;
        final float[] mPastX;
        final float[] mPastY;
        float mXVelocity;
        float mYVelocity;

        private SwipeTracker() {
            float[] fArray = new float[4];
            this.mPastX = fArray;
            float[] fArray2 = new float[4];
            this.mPastY = fArray2;
            Object var3_3 = null;
            this.mPastTime = var3_3;
        }

        private void addPoint(float f, float f2, long l) {
            int n = -1;
            long[] lArray = this.mPastTime;
            int n2 = 0;
            while (true) {
                if (n2 >= 4 || lArray[n2] == 0L) {
                    if (n2 == 4 && n < 0) {
                        n = 0;
                    }
                    if (n != n2) {
                        n += -1;
                    }
                    float[] fArray = this.mPastX;
                    float[] fArray2 = this.mPastY;
                    if (n >= 0) {
                        int n3 = n + 1;
                        int n4 = 4 - n - 1;
                        System.arraycopy(fArray, n3, fArray, 0, n4);
                        System.arraycopy(fArray2, n3, fArray2, 0, n4);
                        System.arraycopy(lArray, n3, lArray, 0, n4);
                        int n5 = n + 1;
                        n2 -= n5;
                    }
                    fArray[n2] = f;
                    fArray2[n2] = f2;
                    lArray[n2] = l;
                    int n6 = n2 + 1;
                    if (n6 >= 4) {
                        return;
                    }
                    lArray[n6] = 0L;
                    return;
                }
                long l2 = lArray[n2];
                long l3 = l - 200L;
                if (l2 < l3) {
                    n = n2;
                }
                ++n2;
            }
        }

        public void addMovement(MotionEvent motionEvent) {
            long l = motionEvent.getEventTime();
            int n = motionEvent.getHistorySize();
            for (int i = 0; i < n; ++i) {
                float f = motionEvent.getHistoricalX(i);
                float f2 = motionEvent.getHistoricalY(i);
                long l2 = motionEvent.getHistoricalEventTime(i);
                this.addPoint(f, f2, l2);
            }
            float f = motionEvent.getX();
            float f3 = motionEvent.getY();
            this.addPoint(f, f3, l);
        }

        public void clear() {
            this.mPastTime[0] = 0L;
        }

        public void computeCurrentVelocity(int n) {
            this.computeCurrentVelocity(n, Float.MAX_VALUE);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void computeCurrentVelocity(int n, float f) {
            float f2;
            float f3;
            float f4;
            float f5;
            int n2;
            int n3;
            float[] fArray = this.mPastX;
            float[] fArray2 = this.mPastY;
            long[] lArray = this.mPastTime;
            float f6 = fArray[0];
            float f7 = fArray2[0];
            long l = lArray[0];
            float f8 = 0.0f;
            float f9 = 0.0f;
            int n4 = 0;
            while ((n3 = ++n4) < (n2 = 4) && lArray[n4] != 0L) {
            }
            for (int i = 1; i < n4; ++i) {
                int n5 = (int)(lArray[i] - l);
                if (n5 == 0) continue;
                float f10 = fArray[i] - f6;
                float f11 = n5;
                float f12 = f10 / f11;
                float f13 = n;
                float f14 = f12 * f13;
                f8 = f8 == 0.0f ? f14 : (f8 + f14) * 0.5f;
                float f15 = fArray2[i] - f7;
                float f16 = n5;
                float f17 = f15 / f16;
                float f18 = n;
                float f19 = f17 * f18;
                f9 = f9 == 0.0f ? f19 : (f9 + f19) * 0.5f;
            }
            if (f8 < 0.0f) {
                float f20 = -f;
                float f21 = f8;
                float f22 = f20;
                f5 = Math.max(f21, f22);
            } else {
                float f23 = f8;
                float f24 = f;
                f5 = Math.min(f23, f24);
            }
            this.mXVelocity = f4 = f5;
            if (f9 < 0.0f) {
                float f25 = -f;
                float f26 = f9;
                float f27 = f25;
                f3 = Math.max(f26, f27);
            } else {
                float f28 = f9;
                float f29 = f;
                f3 = Math.min(f28, f29);
            }
            this.mYVelocity = f2 = f3;
        }

        public float getXVelocity() {
            return this.mXVelocity;
        }

        public float getYVelocity() {
            return this.mYVelocity;
        }
    }

    public static interface OnKeyboardActionListener {
        public void onKey(int var1, int[] var2);

        public void onPress(int var1);

        public void onRelease(int var1);

        public void onText(CharSequence var1);

        public void swipeDown();

        public void swipeLeft();

        public void swipeRight();

        public void swipeUp();
    }
}

