/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.app.Dialog;
import android.content.Context;
import android.os.IBinder;
import android.view.KeyEvent;
import android.view.WindowManager;

class SoftInputWindow
extends Dialog {
    final KeyEvent.DispatcherState mDispatcherState;

    public SoftInputWindow(Context context, int n, KeyEvent.DispatcherState dispatcherState) {
        super(context, n);
        this.mDispatcherState = dispatcherState;
        this.initDockWindow();
    }

    private void initDockWindow() {
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        layoutParams.type = 2011;
        layoutParams.setTitle("InputMethod");
        layoutParams.gravity = 80;
        layoutParams.width = -1;
        this.getWindow().setAttributes(layoutParams);
        this.getWindow().setFlags(264, 266);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSize() {
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        if (layoutParams.gravity == 48) return layoutParams.height;
        if (layoutParams.gravity != 80) return layoutParams.width;
        return layoutParams.height;
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        this.mDispatcherState.reset();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setGravity(int n) {
        int n2;
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        boolean bl = layoutParams.gravity == 48 || layoutParams.gravity == 80;
        layoutParams.gravity = n;
        boolean bl2 = layoutParams.gravity == 48 || layoutParams.gravity == 80;
        if (bl == bl2) {
            return;
        }
        int n3 = layoutParams.width;
        layoutParams.width = n2 = layoutParams.height;
        layoutParams.height = n3;
        this.getWindow().setAttributes(layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSize(int n) {
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        if (layoutParams.gravity == 48 || layoutParams.gravity == 80) {
            layoutParams.width = -1;
            layoutParams.height = n;
        } else {
            layoutParams.width = n;
            layoutParams.height = -1;
        }
        this.getWindow().setAttributes(layoutParams);
    }

    public void setToken(IBinder iBinder) {
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        layoutParams.token = iBinder;
        this.getWindow().setAttributes(layoutParams);
    }
}

