/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Address
implements Parcelable {
    public static final Parcelable.Creator<Address> CREATOR = new Parcelable.Creator<Address>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Address createFromParcel(Parcel parcel) {
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Locale locale = string3.length() > 0 ? new Locale(string2, string3) : new Locale(string2);
            Address address = new Address(locale);
            int n = parcel.readInt();
            if (n > 0) {
                HashMap hashMap = new HashMap(n);
                HashMap hashMap2 = Address.access$002(address, hashMap);
                for (int i = 0; i < n; ++i) {
                    int n2 = parcel.readInt();
                    String string4 = parcel.readString();
                    HashMap hashMap3 = address.mAddressLines;
                    Integer n3 = n2;
                    String string5 = hashMap3.put(n3, string4);
                    int n4 = Math.max(address.mMaxAddressLineIndex, n2);
                    int n5 = Address.access$102(address, n4);
                }
            } else {
                HashMap hashMap = Address.access$002(address, null);
                int n6 = Address.access$102(address, -1);
            }
            String string6 = parcel.readString();
            String string7 = Address.access$202(address, string6);
            String string8 = parcel.readString();
            String string9 = Address.access$302(address, string8);
            String string10 = parcel.readString();
            String string11 = Address.access$402(address, string10);
            String string12 = parcel.readString();
            String string13 = Address.access$502(address, string12);
            String string14 = parcel.readString();
            String string15 = Address.access$602(address, string14);
            String string16 = parcel.readString();
            String string17 = Address.access$702(address, string16);
            String string18 = parcel.readString();
            String string19 = Address.access$802(address, string18);
            String string20 = parcel.readString();
            String string21 = Address.access$902(address, string20);
            String string22 = parcel.readString();
            String string23 = Address.access$1002(address, string22);
            String string24 = parcel.readString();
            String string25 = Address.access$1102(address, string24);
            String string26 = parcel.readString();
            String string27 = Address.access$1202(address, string26);
            boolean bl = parcel.readInt() != 0;
            boolean bl2 = Address.access$1302(address, bl);
            if (address.mHasLatitude) {
                double d = parcel.readDouble();
                double d2 = Address.access$1402(address, d);
            }
            boolean bl3 = parcel.readInt() != 0;
            boolean bl4 = Address.access$1502(address, bl3);
            if (address.mHasLongitude) {
                double d = parcel.readDouble();
                double d3 = Address.access$1602(address, d);
            }
            String string28 = parcel.readString();
            String string29 = Address.access$1702(address, string28);
            String string30 = parcel.readString();
            String string31 = Address.access$1802(address, string30);
            Bundle bundle = parcel.readBundle();
            Bundle bundle2 = Address.access$1902(address, bundle);
            return address;
        }

        public Address[] newArray(int n) {
            return new Address[n];
        }
    };
    private HashMap<Integer, String> mAddressLines;
    private String mAdminArea;
    private String mCountryCode;
    private String mCountryName;
    private Bundle mExtras = null;
    private String mFeatureName;
    private boolean mHasLatitude = false;
    private boolean mHasLongitude = false;
    private double mLatitude;
    private Locale mLocale;
    private String mLocality;
    private double mLongitude;
    private int mMaxAddressLineIndex = -1;
    private String mPhone;
    private String mPostalCode;
    private String mPremises;
    private String mSubAdminArea;
    private String mSubLocality;
    private String mSubThoroughfare;
    private String mThoroughfare;
    private String mUrl;

    public Address(Locale locale) {
        this.mLocale = locale;
    }

    static /* synthetic */ HashMap access$002(Address address, HashMap hashMap) {
        address.mAddressLines = hashMap;
        return hashMap;
    }

    static /* synthetic */ String access$1002(Address address, String string2) {
        address.mPostalCode = string2;
        return string2;
    }

    static /* synthetic */ int access$102(Address address, int n) {
        address.mMaxAddressLineIndex = n;
        return n;
    }

    static /* synthetic */ String access$1102(Address address, String string2) {
        address.mCountryCode = string2;
        return string2;
    }

    static /* synthetic */ String access$1202(Address address, String string2) {
        address.mCountryName = string2;
        return string2;
    }

    static /* synthetic */ boolean access$1302(Address address, boolean bl) {
        address.mHasLatitude = bl;
        return bl;
    }

    static /* synthetic */ double access$1402(Address address, double d) {
        address.mLatitude = d;
        return d;
    }

    static /* synthetic */ boolean access$1502(Address address, boolean bl) {
        address.mHasLongitude = bl;
        return bl;
    }

    static /* synthetic */ double access$1602(Address address, double d) {
        address.mLongitude = d;
        return d;
    }

    static /* synthetic */ String access$1702(Address address, String string2) {
        address.mPhone = string2;
        return string2;
    }

    static /* synthetic */ String access$1802(Address address, String string2) {
        address.mUrl = string2;
        return string2;
    }

    static /* synthetic */ Bundle access$1902(Address address, Bundle bundle) {
        address.mExtras = bundle;
        return bundle;
    }

    static /* synthetic */ String access$202(Address address, String string2) {
        address.mFeatureName = string2;
        return string2;
    }

    static /* synthetic */ String access$302(Address address, String string2) {
        address.mAdminArea = string2;
        return string2;
    }

    static /* synthetic */ String access$402(Address address, String string2) {
        address.mSubAdminArea = string2;
        return string2;
    }

    static /* synthetic */ String access$502(Address address, String string2) {
        address.mLocality = string2;
        return string2;
    }

    static /* synthetic */ String access$602(Address address, String string2) {
        address.mSubLocality = string2;
        return string2;
    }

    static /* synthetic */ String access$702(Address address, String string2) {
        address.mThoroughfare = string2;
        return string2;
    }

    static /* synthetic */ String access$802(Address address, String string2) {
        address.mSubThoroughfare = string2;
        return string2;
    }

    static /* synthetic */ String access$902(Address address, String string2) {
        address.mPremises = string2;
        return string2;
    }

    public void clearLatitude() {
        this.mHasLatitude = false;
    }

    public void clearLongitude() {
        this.mHasLongitude = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int describeContents() {
        if (this.mExtras == null) return 0;
        return this.mExtras.describeContents();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAddressLine(int n) {
        if (n < 0) {
            String string2 = "index = " + n + " < 0";
            throw new IllegalArgumentException(string2);
        }
        if (this.mAddressLines == null) {
            return null;
        }
        HashMap<Integer, String> hashMap = this.mAddressLines;
        Integer n2 = n;
        return hashMap.get(n2);
    }

    public String getAdminArea() {
        return this.mAdminArea;
    }

    public String getCountryCode() {
        return this.mCountryCode;
    }

    public String getCountryName() {
        return this.mCountryName;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public String getFeatureName() {
        return this.mFeatureName;
    }

    public double getLatitude() {
        if (this.mHasLatitude) {
            return this.mLatitude;
        }
        throw new IllegalStateException();
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public String getLocality() {
        return this.mLocality;
    }

    public double getLongitude() {
        if (this.mHasLongitude) {
            return this.mLongitude;
        }
        throw new IllegalStateException();
    }

    public int getMaxAddressLineIndex() {
        return this.mMaxAddressLineIndex;
    }

    public String getPhone() {
        return this.mPhone;
    }

    public String getPostalCode() {
        return this.mPostalCode;
    }

    public String getPremises() {
        return this.mPremises;
    }

    public String getSubAdminArea() {
        return this.mSubAdminArea;
    }

    public String getSubLocality() {
        return this.mSubLocality;
    }

    public String getSubThoroughfare() {
        return this.mSubThoroughfare;
    }

    public String getThoroughfare() {
        return this.mThoroughfare;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public boolean hasLatitude() {
        return this.mHasLatitude;
    }

    public boolean hasLongitude() {
        return this.mHasLongitude;
    }

    public void setAddressLine(int n, String string2) {
        int n2;
        if (n < 0) {
            String string3 = "index = " + n + " < 0";
            throw new IllegalArgumentException(string3);
        }
        if (this.mAddressLines == null) {
            HashMap hashMap = new HashMap();
            this.mAddressLines = hashMap;
        }
        HashMap<Integer, String> hashMap = this.mAddressLines;
        Integer n3 = n;
        String string4 = hashMap.put(n3, string2);
        if (string2 == null) {
            this.mMaxAddressLineIndex = -1;
            Iterator<Integer> iterator = this.mAddressLines.keySet().iterator();
            while (true) {
                int n4;
                if (!iterator.hasNext()) {
                    return;
                }
                Integer n5 = iterator.next();
                int n6 = this.mMaxAddressLineIndex;
                int n7 = n5;
                this.mMaxAddressLineIndex = n4 = Math.max(n6, n7);
            }
        }
        this.mMaxAddressLineIndex = n2 = Math.max(this.mMaxAddressLineIndex, n);
    }

    public void setAdminArea(String string2) {
        this.mAdminArea = string2;
    }

    public void setCountryCode(String string2) {
        this.mCountryCode = string2;
    }

    public void setCountryName(String string2) {
        this.mCountryName = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExtras(Bundle bundle) {
        Bundle bundle2 = bundle == null ? null : new Bundle(bundle);
        this.mExtras = bundle2;
    }

    public void setFeatureName(String string2) {
        this.mFeatureName = string2;
    }

    public void setLatitude(double d) {
        this.mLatitude = d;
        this.mHasLatitude = true;
    }

    public void setLocality(String string2) {
        this.mLocality = string2;
    }

    public void setLongitude(double d) {
        this.mLongitude = d;
        this.mHasLongitude = true;
    }

    public void setPhone(String string2) {
        this.mPhone = string2;
    }

    public void setPostalCode(String string2) {
        this.mPostalCode = string2;
    }

    public void setPremises(String string2) {
        this.mPremises = string2;
    }

    public void setSubAdminArea(String string2) {
        this.mSubAdminArea = string2;
    }

    public void setSubLocality(String string2) {
        this.mSubLocality = string2;
    }

    public void setSubThoroughfare(String string2) {
        this.mSubThoroughfare = string2;
    }

    public void setThoroughfare(String string2) {
        this.mThoroughfare = string2;
    }

    public void setUrl(String string2) {
        this.mUrl = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Address[addressLines=[");
        int n = 0;
        while (true) {
            int n2;
            if (n > (n2 = this.mMaxAddressLineIndex)) {
                StringBuilder stringBuilder3 = stringBuilder.append(']');
                StringBuilder stringBuilder4 = stringBuilder.append(",feature=");
                String string2 = this.mFeatureName;
                StringBuilder stringBuilder5 = stringBuilder.append(string2);
                StringBuilder stringBuilder6 = stringBuilder.append(",admin=");
                String string3 = this.mAdminArea;
                StringBuilder stringBuilder7 = stringBuilder.append(string3);
                StringBuilder stringBuilder8 = stringBuilder.append(",sub-admin=");
                String string4 = this.mSubAdminArea;
                StringBuilder stringBuilder9 = stringBuilder.append(string4);
                StringBuilder stringBuilder10 = stringBuilder.append(",locality=");
                String string5 = this.mLocality;
                StringBuilder stringBuilder11 = stringBuilder.append(string5);
                StringBuilder stringBuilder12 = stringBuilder.append(",thoroughfare=");
                String string6 = this.mThoroughfare;
                StringBuilder stringBuilder13 = stringBuilder.append(string6);
                StringBuilder stringBuilder14 = stringBuilder.append(",postalCode=");
                String string7 = this.mPostalCode;
                StringBuilder stringBuilder15 = stringBuilder.append(string7);
                StringBuilder stringBuilder16 = stringBuilder.append(",countryCode=");
                String string8 = this.mCountryCode;
                StringBuilder stringBuilder17 = stringBuilder.append(string8);
                StringBuilder stringBuilder18 = stringBuilder.append(",countryName=");
                String string9 = this.mCountryName;
                StringBuilder stringBuilder19 = stringBuilder.append(string9);
                StringBuilder stringBuilder20 = stringBuilder.append(",hasLatitude=");
                boolean bl = this.mHasLatitude;
                StringBuilder stringBuilder21 = stringBuilder.append(bl);
                StringBuilder stringBuilder22 = stringBuilder.append(",latitude=");
                double d = this.mLatitude;
                StringBuilder stringBuilder23 = stringBuilder.append(d);
                StringBuilder stringBuilder24 = stringBuilder.append(",hasLongitude=");
                boolean bl2 = this.mHasLongitude;
                StringBuilder stringBuilder25 = stringBuilder.append(bl2);
                StringBuilder stringBuilder26 = stringBuilder.append(",longitude=");
                double d2 = this.mLongitude;
                StringBuilder stringBuilder27 = stringBuilder.append(d2);
                StringBuilder stringBuilder28 = stringBuilder.append(",phone=");
                String string10 = this.mPhone;
                StringBuilder stringBuilder29 = stringBuilder.append(string10);
                StringBuilder stringBuilder30 = stringBuilder.append(",url=");
                String string11 = this.mUrl;
                StringBuilder stringBuilder31 = stringBuilder.append(string11);
                StringBuilder stringBuilder32 = stringBuilder.append(",extras=");
                Bundle bundle = this.mExtras;
                StringBuilder stringBuilder33 = stringBuilder.append(bundle);
                StringBuilder stringBuilder34 = stringBuilder.append(']');
                return stringBuilder.toString();
            }
            if (n > 0) {
                StringBuilder stringBuilder35 = stringBuilder.append(',');
            }
            StringBuilder stringBuilder36 = stringBuilder.append(n);
            StringBuilder stringBuilder37 = stringBuilder.append(':');
            HashMap<Integer, String> hashMap = this.mAddressLines;
            Integer n3 = n;
            String string12 = hashMap.get(n3);
            if (string12 == null) {
                StringBuilder stringBuilder38 = stringBuilder.append("null");
            } else {
                StringBuilder stringBuilder39 = stringBuilder.append('\"');
                StringBuilder stringBuilder40 = stringBuilder.append(string12);
                StringBuilder stringBuilder41 = stringBuilder.append('\"');
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        String string2 = this.mLocale.getLanguage();
        parcel.writeString(string2);
        String string3 = this.mLocale.getCountry();
        parcel.writeString(string3);
        if (this.mAddressLines == null) {
            parcel.writeInt(0);
        } else {
            Set<Map.Entry<Integer, String>> set = this.mAddressLines.entrySet();
            int n2 = set.size();
            parcel.writeInt(n2);
            for (Map.Entry<Integer, String> entry : set) {
                int n3 = entry.getKey();
                parcel.writeInt(n3);
                String string4 = entry.getValue();
                parcel.writeString(string4);
            }
        }
        String string5 = this.mFeatureName;
        parcel.writeString(string5);
        String string6 = this.mAdminArea;
        parcel.writeString(string6);
        String string7 = this.mSubAdminArea;
        parcel.writeString(string7);
        String string8 = this.mLocality;
        parcel.writeString(string8);
        String string9 = this.mSubLocality;
        parcel.writeString(string9);
        String string10 = this.mThoroughfare;
        parcel.writeString(string10);
        String string11 = this.mSubThoroughfare;
        parcel.writeString(string11);
        String string12 = this.mPremises;
        parcel.writeString(string12);
        String string13 = this.mPostalCode;
        parcel.writeString(string13);
        String string14 = this.mCountryCode;
        parcel.writeString(string14);
        String string15 = this.mCountryName;
        parcel.writeString(string15);
        int n4 = this.mHasLatitude ? 1 : 0;
        parcel.writeInt(n4);
        if (this.mHasLatitude) {
            double d = this.mLatitude;
            parcel.writeDouble(d);
        }
        int n5 = this.mHasLongitude ? 1 : 0;
        parcel.writeInt(n5);
        if (this.mHasLongitude) {
            double d = this.mLongitude;
            parcel.writeDouble(d);
        }
        String string16 = this.mPhone;
        parcel.writeString(string16);
        String string17 = this.mUrl;
        parcel.writeString(string17);
        Bundle bundle = this.mExtras;
        parcel.writeBundle(bundle);
    }
}

