/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.content.Context;
import android.location.Address;
import android.location.GeocoderParams;
import android.location.ILocationManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class Geocoder {
    private static final String TAG = "Geocoder";
    private GeocoderParams mParams;
    private ILocationManager mService;

    public Geocoder(Context context) {
        Locale locale = Locale.getDefault();
        this(context, locale);
    }

    public Geocoder(Context context, Locale locale) {
        ILocationManager iLocationManager;
        GeocoderParams geocoderParams;
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        this.mParams = geocoderParams = new GeocoderParams(context, locale);
        this.mService = iLocationManager = ILocationManager.Stub.asInterface(ServiceManager.getService("location"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPresent() {
        ILocationManager iLocationManager = ILocationManager.Stub.asInterface(ServiceManager.getService("location"));
        try {
            boolean bl = iLocationManager.geocoderIsPresent();
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "isPresent: got RemoteException", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Address> getFromLocation(double d, double d2, int n) throws IOException {
        if (d < -90.0 || d > 90.0) {
            String string2 = "latitude == " + d;
            throw new IllegalArgumentException(string2);
        }
        if (d2 < -180.0 || d2 > 180.0) {
            String string3 = "longitude == " + d2;
            throw new IllegalArgumentException(string3);
        }
        try {
            ArrayList<Address> arrayList = new ArrayList<Address>();
            ILocationManager iLocationManager = this.mService;
            GeocoderParams geocoderParams = this.mParams;
            double d3 = d;
            double d4 = d2;
            int n2 = n;
            String string4 = iLocationManager.getFromLocation(d3, d4, n2, geocoderParams, arrayList);
            if (string4 == null) return arrayList;
            throw new IOException(string4);
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "getFromLocation: got RemoteException", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Address> getFromLocationName(String string2, int n) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("locationName == null");
        }
        try {
            ArrayList<Address> arrayList = new ArrayList<Address>();
            ILocationManager iLocationManager = this.mService;
            GeocoderParams geocoderParams = this.mParams;
            String string3 = string2;
            int n2 = n;
            String string4 = iLocationManager.getFromLocationName(string3, 0.0, 0.0, 0.0, 0.0, n2, geocoderParams, arrayList);
            if (string4 == null) return arrayList;
            throw new IOException(string4);
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "getFromLocationName: got RemoteException", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Address> getFromLocationName(String string2, int n, double d, double d2, double d3, double d4) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("locationName == null");
        }
        if (d < -90.0 || d > 90.0) {
            StringBuilder stringBuilder = new StringBuilder().append("lowerLeftLatitude == ");
            double d5 = d;
            String string3 = stringBuilder.append(d5).toString();
            throw new IllegalArgumentException(string3);
        }
        if (d2 < -180.0 || d2 > 180.0) {
            StringBuilder stringBuilder = new StringBuilder().append("lowerLeftLongitude == ");
            double d6 = d2;
            String string4 = stringBuilder.append(d6).toString();
            throw new IllegalArgumentException(string4);
        }
        if (d3 < -90.0 || d3 > 90.0) {
            StringBuilder stringBuilder = new StringBuilder().append("upperRightLatitude == ");
            double d7 = d3;
            String string5 = stringBuilder.append(d7).toString();
            throw new IllegalArgumentException(string5);
        }
        if (d4 < -180.0 || d4 > 180.0) {
            StringBuilder stringBuilder = new StringBuilder().append("upperRightLongitude == ");
            double d8 = d4;
            String string6 = stringBuilder.append(d8).toString();
            throw new IllegalArgumentException(string6);
        }
        try {
            IOException iOException;
            ArrayList<Address> arrayList = new ArrayList<Address>();
            ILocationManager iLocationManager = this.mService;
            GeocoderParams geocoderParams = this.mParams;
            String string7 = string2;
            double d9 = d;
            double d10 = d2;
            double d11 = d3;
            double d12 = d4;
            int n2 = n;
            String string8 = iLocationManager.getFromLocationName(string7, d9, d10, d11, d12, n2, geocoderParams, arrayList);
            if (string8 == null) return arrayList;
            IOException iOException2 = iOException;
            String string9 = string8;
            iOException2(string9);
            throw iOException;
        }
        catch (RemoteException remoteException) {
            String string10 = TAG;
            String string11 = "getFromLocationName: got RemoteException";
            RemoteException remoteException2 = remoteException;
            int n3 = Log.e(string10, string11, remoteException2);
            return null;
        }
    }
}

