/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.GpsSatellite;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class GpsStatus {
    public static final int GPS_EVENT_FIRST_FIX = 3;
    public static final int GPS_EVENT_SATELLITE_STATUS = 4;
    public static final int GPS_EVENT_STARTED = 1;
    public static final int GPS_EVENT_STOPPED = 2;
    private static final int NUM_SATELLITES = 255;
    private Iterable<GpsSatellite> mSatelliteList;
    private GpsSatellite[] mSatellites;
    private int mTimeToFirstFix;

    GpsStatus() {
        Iterable<GpsSatellite> iterable;
        GpsSatellite[] gpsSatelliteArray = new GpsSatellite[255];
        this.mSatellites = gpsSatelliteArray;
        this.mSatelliteList = iterable = new Iterable<GpsSatellite>(){

            @Override
            public Iterator<GpsSatellite> iterator() {
                GpsStatus gpsStatus = GpsStatus.this;
                GpsSatellite[] gpsSatelliteArray = GpsStatus.this.mSatellites;
                return gpsStatus.new SatelliteIterator(gpsSatelliteArray);
            }
        };
        int n = 0;
        int n2;
        while (n < (n2 = this.mSatellites.length)) {
            GpsSatellite gpsSatellite;
            GpsSatellite[] gpsSatelliteArray2 = this.mSatellites;
            int n3 = n + 1;
            gpsSatelliteArray2[n] = gpsSatellite = new GpsSatellite(n3);
            ++n;
        }
        return;
    }

    public int getMaxSatellites() {
        return 255;
    }

    public Iterable<GpsSatellite> getSatellites() {
        return this.mSatelliteList;
    }

    public int getTimeToFirstFix() {
        return this.mTimeToFirstFix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setStatus(int n, int[] nArray, float[] fArray, float[] fArray2, float[] fArray3, int n2, int n3, int n4) {
        synchronized (this) {
            int n5;
            int n6;
            for (n6 = 0; n6 < (n5 = this.mSatellites.length); ++n6) {
                this.mSatellites[n6].mValid = false;
            }
            n6 = 0;
            while (n6 < n) {
                int n7;
                int n8 = nArray[n6] - 1;
                int n9 = 1 << n8;
                if (n8 >= 0 && n8 < (n7 = this.mSatellites.length)) {
                    float f;
                    float f2;
                    float f3;
                    GpsSatellite gpsSatellite = this.mSatellites[n8];
                    gpsSatellite.mValid = true;
                    gpsSatellite.mSnr = f3 = fArray[n6];
                    gpsSatellite.mElevation = f2 = fArray2[n6];
                    gpsSatellite.mAzimuth = f = fArray3[n6];
                    boolean bl = (n2 & n9) != 0;
                    gpsSatellite.mHasEphemeris = bl;
                    bl = (n3 & n9) != 0;
                    gpsSatellite.mHasAlmanac = bl;
                    bl = (n4 & n9) != 0;
                    gpsSatellite.mUsedInFix = bl;
                }
                ++n6;
            }
            return;
        }
    }

    void setStatus(GpsStatus gpsStatus) {
        int n;
        this.mTimeToFirstFix = n = gpsStatus.getTimeToFirstFix();
        int n2 = 0;
        int n3;
        while (n2 < (n3 = this.mSatellites.length)) {
            GpsSatellite gpsSatellite = this.mSatellites[n2];
            GpsSatellite gpsSatellite2 = gpsStatus.mSatellites[n2];
            gpsSatellite.setStatus(gpsSatellite2);
            ++n2;
        }
        return;
    }

    void setTimeToFirstFix(int n) {
        this.mTimeToFirstFix = n;
    }

    public static interface NmeaListener {
        public void onNmeaReceived(long var1, String var3);
    }

    public static interface Listener {
        public void onGpsStatusChanged(int var1);
    }

    private final class SatelliteIterator
    implements Iterator<GpsSatellite> {
        int mIndex = 0;
        private GpsSatellite[] mSatellites;

        SatelliteIterator(GpsSatellite[] gpsSatelliteArray) {
            this.mSatellites = gpsSatelliteArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasNext() {
            int n;
            int n2 = this.mIndex;
            while (n2 < (n = this.mSatellites.length)) {
                if (this.mSatellites[n2].mValid) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public GpsSatellite next() {
            int n;
            int n2;
            while ((n2 = this.mIndex) < (n = this.mSatellites.length)) {
                int n3;
                GpsSatellite[] gpsSatelliteArray = this.mSatellites;
                int n4 = this.mIndex;
                this.mIndex = n3 = n4 + 1;
                GpsSatellite gpsSatellite = gpsSatelliteArray[n4];
                if (!gpsSatellite.mValid) continue;
                return gpsSatellite;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

