/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.app.PendingIntent;
import android.location.Address;
import android.location.Criteria;
import android.location.GeocoderParams;
import android.location.IGpsStatusListener;
import android.location.ILocationListener;
import android.location.Location;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ILocationManager
extends IInterface {
    public boolean addGpsStatusListener(IGpsStatusListener var1) throws RemoteException;

    public void addProximityAlert(double var1, double var3, float var5, long var6, PendingIntent var8) throws RemoteException;

    public void addTestProvider(String var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, int var9, int var10) throws RemoteException;

    public void clearTestProviderEnabled(String var1) throws RemoteException;

    public void clearTestProviderLocation(String var1) throws RemoteException;

    public void clearTestProviderStatus(String var1) throws RemoteException;

    public boolean geocoderIsPresent() throws RemoteException;

    public List<String> getAllProviders() throws RemoteException;

    public String getBestProvider(Criteria var1, boolean var2) throws RemoteException;

    public String getFromLocation(double var1, double var3, int var5, GeocoderParams var6, List<Address> var7) throws RemoteException;

    public String getFromLocationName(String var1, double var2, double var4, double var6, double var8, int var10, GeocoderParams var11, List<Address> var12) throws RemoteException;

    public Location getLastKnownLocation(String var1) throws RemoteException;

    public Bundle getProviderInfo(String var1) throws RemoteException;

    public List<String> getProviders(Criteria var1, boolean var2) throws RemoteException;

    public boolean isProviderEnabled(String var1) throws RemoteException;

    public void locationCallbackFinished(ILocationListener var1) throws RemoteException;

    public boolean providerMeetsCriteria(String var1, Criteria var2) throws RemoteException;

    public void removeGpsStatusListener(IGpsStatusListener var1) throws RemoteException;

    public void removeProximityAlert(PendingIntent var1) throws RemoteException;

    public void removeTestProvider(String var1) throws RemoteException;

    public void removeUpdates(ILocationListener var1) throws RemoteException;

    public void removeUpdatesPI(PendingIntent var1) throws RemoteException;

    public void reportLocation(Location var1, boolean var2) throws RemoteException;

    public void requestLocationUpdates(String var1, Criteria var2, long var3, float var5, boolean var6, ILocationListener var7) throws RemoteException;

    public void requestLocationUpdatesPI(String var1, Criteria var2, long var3, float var5, boolean var6, PendingIntent var7) throws RemoteException;

    public boolean sendExtraCommand(String var1, String var2, Bundle var3) throws RemoteException;

    public boolean sendNiResponse(int var1, int var2) throws RemoteException;

    public void setTestProviderEnabled(String var1, boolean var2) throws RemoteException;

    public void setTestProviderLocation(String var1, Location var2) throws RemoteException;

    public void setTestProviderStatus(String var1, int var2, Bundle var3, long var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILocationManager {
        private static final String DESCRIPTOR = "android.location.ILocationManager";
        static final int TRANSACTION_addGpsStatusListener = 9;
        static final int TRANSACTION_addProximityAlert = 13;
        static final int TRANSACTION_addTestProvider = 22;
        static final int TRANSACTION_clearTestProviderEnabled = 27;
        static final int TRANSACTION_clearTestProviderLocation = 25;
        static final int TRANSACTION_clearTestProviderStatus = 29;
        static final int TRANSACTION_geocoderIsPresent = 19;
        static final int TRANSACTION_getAllProviders = 1;
        static final int TRANSACTION_getBestProvider = 3;
        static final int TRANSACTION_getFromLocation = 20;
        static final int TRANSACTION_getFromLocationName = 21;
        static final int TRANSACTION_getLastKnownLocation = 17;
        static final int TRANSACTION_getProviderInfo = 15;
        static final int TRANSACTION_getProviders = 2;
        static final int TRANSACTION_isProviderEnabled = 16;
        static final int TRANSACTION_locationCallbackFinished = 11;
        static final int TRANSACTION_providerMeetsCriteria = 4;
        static final int TRANSACTION_removeGpsStatusListener = 10;
        static final int TRANSACTION_removeProximityAlert = 14;
        static final int TRANSACTION_removeTestProvider = 23;
        static final int TRANSACTION_removeUpdates = 7;
        static final int TRANSACTION_removeUpdatesPI = 8;
        static final int TRANSACTION_reportLocation = 18;
        static final int TRANSACTION_requestLocationUpdates = 5;
        static final int TRANSACTION_requestLocationUpdatesPI = 6;
        static final int TRANSACTION_sendExtraCommand = 12;
        static final int TRANSACTION_sendNiResponse = 30;
        static final int TRANSACTION_setTestProviderEnabled = 26;
        static final int TRANSACTION_setTestProviderLocation = 24;
        static final int TRANSACTION_setTestProviderStatus = 28;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ILocationManager asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ILocationManager) {
                ILocationManager iLocationManager = (ILocationManager)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    Parcel parcel3 = parcel2;
                    String string2 = DESCRIPTOR;
                    parcel3.writeString(string2);
                    return true;
                }
                case 1: {
                    Parcel parcel4 = parcel;
                    String string3 = DESCRIPTOR;
                    parcel4.enforceInterface(string3);
                    List<String> list = this.getAllProviders();
                    parcel2.writeNoException();
                    Parcel parcel5 = parcel2;
                    List<String> list2 = list;
                    parcel5.writeStringList(list2);
                    return true;
                }
                case 2: {
                    void var18_32;
                    Criteria criteria;
                    Parcel parcel6 = parcel;
                    String string4 = DESCRIPTOR;
                    parcel6.enforceInterface(string4);
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Criteria> creator = Criteria.CREATOR;
                        Parcel parcel7 = parcel;
                        criteria = creator.createFromParcel(parcel7);
                    } else {
                        criteria = null;
                    }
                    if (parcel.readInt() != 0) {
                        Object var18_31 = null;
                    } else {
                        Object var18_33 = null;
                    }
                    Stub stub = this;
                    Criteria criteria2 = criteria;
                    void var21_62 = var18_32;
                    List<String> list = stub.getProviders(criteria2, (boolean)var21_62);
                    parcel2.writeNoException();
                    Parcel parcel8 = parcel2;
                    List<String> list3 = list;
                    parcel8.writeStringList(list3);
                    return true;
                }
                case 3: {
                    void var18_35;
                    Criteria criteria;
                    Parcel parcel9 = parcel;
                    String string5 = DESCRIPTOR;
                    parcel9.enforceInterface(string5);
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Criteria> creator = Criteria.CREATOR;
                        Parcel parcel10 = parcel;
                        criteria = creator.createFromParcel(parcel10);
                    } else {
                        criteria = null;
                    }
                    if (parcel.readInt() != 0) {
                        Object var18_34 = null;
                    } else {
                        Object var18_36 = null;
                    }
                    Stub stub = this;
                    Criteria criteria3 = criteria;
                    void var31_72 = var18_35;
                    String string6 = stub.getBestProvider(criteria3, (boolean)var31_72);
                    parcel2.writeNoException();
                    Parcel parcel11 = parcel2;
                    String string7 = string6;
                    parcel11.writeString(string7);
                    return true;
                }
                case 4: {
                    void var18_38;
                    Parcel parcel12 = parcel;
                    String string8 = DESCRIPTOR;
                    parcel12.enforceInterface(string8);
                    String string9 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Criteria> creator = Criteria.CREATOR;
                        Parcel parcel13 = parcel;
                        Criteria criteria = creator.createFromParcel(parcel13);
                    } else {
                        Object var18_39 = null;
                    }
                    Stub stub = this;
                    String string10 = string9;
                    void var41_82 = var18_38;
                    boolean bl = stub.providerMeetsCriteria(string10, (Criteria)var41_82);
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    Parcel parcel14 = parcel2;
                    int n4 = n3;
                    parcel14.writeInt(n4);
                    return true;
                }
                case 5: {
                    void var53_110;
                    void var18_41;
                    boolean bl;
                    Parcel parcel15 = parcel;
                    String string11 = DESCRIPTOR;
                    parcel15.enforceInterface(string11);
                    String string12 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Criteria> creator = Criteria.CREATOR;
                        Parcel parcel16 = parcel;
                        Criteria criteria = creator.createFromParcel(parcel16);
                    } else {
                        Object var18_42 = null;
                    }
                    long l = parcel.readLong();
                    float f = parcel.readFloat();
                    if (parcel.readInt() != 0) {
                        bl = null;
                    } else {
                        Object var53_111 = null;
                    }
                    ILocationListener iLocationListener = ILocationListener.Stub.asInterface(parcel.readStrongBinder());
                    this.requestLocationUpdates(string12, (Criteria)var18_41, l, f, (boolean)var53_110, iLocationListener);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    void var53_113;
                    void var18_44;
                    PendingIntent pendingIntent;
                    Parcel parcel17 = parcel;
                    String string13 = DESCRIPTOR;
                    parcel17.enforceInterface(string13);
                    String string14 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Criteria> creator = Criteria.CREATOR;
                        Parcel parcel18 = parcel;
                        Criteria criteria = creator.createFromParcel(parcel18);
                    } else {
                        Object var18_45 = null;
                    }
                    long l = parcel.readLong();
                    float f = parcel.readFloat();
                    if (parcel.readInt() != 0) {
                        Object var53_112 = null;
                    } else {
                        Object var53_114 = null;
                    }
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<PendingIntent> creator = PendingIntent.CREATOR;
                        Parcel parcel19 = parcel;
                        pendingIntent = creator.createFromParcel(parcel19);
                    } else {
                        pendingIntent = null;
                    }
                    this.requestLocationUpdatesPI(string14, (Criteria)var18_44, l, f, (boolean)var53_113, pendingIntent);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    Parcel parcel20 = parcel;
                    String string15 = DESCRIPTOR;
                    parcel20.enforceInterface(string15);
                    ILocationListener iLocationListener = ILocationListener.Stub.asInterface(parcel.readStrongBinder());
                    Stub stub = this;
                    ILocationListener iLocationListener2 = iLocationListener;
                    stub.removeUpdates(iLocationListener2);
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    PendingIntent pendingIntent;
                    Parcel parcel21 = parcel;
                    String string16 = DESCRIPTOR;
                    parcel21.enforceInterface(string16);
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<PendingIntent> creator = PendingIntent.CREATOR;
                        Parcel parcel22 = parcel;
                        pendingIntent = creator.createFromParcel(parcel22);
                    } else {
                        pendingIntent = null;
                    }
                    Stub stub = this;
                    PendingIntent pendingIntent2 = pendingIntent;
                    stub.removeUpdatesPI(pendingIntent2);
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    Parcel parcel23 = parcel;
                    String string17 = DESCRIPTOR;
                    parcel23.enforceInterface(string17);
                    IGpsStatusListener iGpsStatusListener = IGpsStatusListener.Stub.asInterface(parcel.readStrongBinder());
                    Stub stub = this;
                    IGpsStatusListener iGpsStatusListener2 = iGpsStatusListener;
                    boolean bl = stub.addGpsStatusListener(iGpsStatusListener2);
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    Parcel parcel24 = parcel2;
                    int n6 = n5;
                    parcel24.writeInt(n6);
                    return true;
                }
                case 10: {
                    Parcel parcel25 = parcel;
                    String string18 = DESCRIPTOR;
                    parcel25.enforceInterface(string18);
                    IGpsStatusListener iGpsStatusListener = IGpsStatusListener.Stub.asInterface(parcel.readStrongBinder());
                    Stub stub = this;
                    IGpsStatusListener iGpsStatusListener3 = iGpsStatusListener;
                    stub.removeGpsStatusListener(iGpsStatusListener3);
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    Parcel parcel26 = parcel;
                    String string19 = DESCRIPTOR;
                    parcel26.enforceInterface(string19);
                    ILocationListener iLocationListener = ILocationListener.Stub.asInterface(parcel.readStrongBinder());
                    Stub stub = this;
                    ILocationListener iLocationListener3 = iLocationListener;
                    stub.locationCallbackFinished(iLocationListener3);
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    void var50_94;
                    Parcel parcel27 = parcel;
                    String string20 = DESCRIPTOR;
                    parcel27.enforceInterface(string20);
                    String string21 = parcel.readString();
                    String string22 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Bundle> creator = Bundle.CREATOR;
                        Parcel parcel28 = parcel;
                        Bundle bundle = creator.createFromParcel(parcel28);
                    } else {
                        Object var50_95 = null;
                    }
                    Stub stub = this;
                    String string23 = string21;
                    String string24 = string22;
                    void var99_168 = var50_94;
                    boolean bl = stub.sendExtraCommand(string23, string24, (Bundle)var99_168);
                    parcel2.writeNoException();
                    int n7 = bl ? 1 : 0;
                    Parcel parcel29 = parcel2;
                    int n8 = n7;
                    parcel29.writeInt(n8);
                    if (var50_94 != null) {
                        Parcel parcel30 = parcel2;
                        int n9 = 1;
                        parcel30.writeInt(n9);
                        void var106_175 = var50_94;
                        Parcel parcel31 = parcel2;
                        int n10 = 1;
                        var106_175.writeToParcel(parcel31, n10);
                        return true;
                    } else {
                        Parcel parcel32 = parcel2;
                        int n11 = 0;
                        parcel32.writeInt(n11);
                    }
                    return true;
                }
                case 13: {
                    void var53_116;
                    Parcel parcel33 = parcel;
                    String string25 = DESCRIPTOR;
                    parcel33.enforceInterface(string25);
                    double d = parcel.readDouble();
                    double d2 = parcel.readDouble();
                    float f = parcel.readFloat();
                    long l = parcel.readLong();
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<PendingIntent> creator = PendingIntent.CREATOR;
                        Parcel parcel34 = parcel;
                        PendingIntent pendingIntent = creator.createFromParcel(parcel34);
                    } else {
                        Object var53_117 = null;
                    }
                    Stub stub = this;
                    float f2 = f;
                    void var123_193 = var53_116;
                    stub.addProximityAlert(d, d2, f2, l, (PendingIntent)var123_193);
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    PendingIntent pendingIntent;
                    Parcel parcel35 = parcel;
                    String string26 = DESCRIPTOR;
                    parcel35.enforceInterface(string26);
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<PendingIntent> creator = PendingIntent.CREATOR;
                        Parcel parcel36 = parcel;
                        pendingIntent = creator.createFromParcel(parcel36);
                    } else {
                        pendingIntent = null;
                    }
                    Stub stub = this;
                    PendingIntent pendingIntent3 = pendingIntent;
                    stub.removeProximityAlert(pendingIntent3);
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    Parcel parcel37 = parcel;
                    String string27 = DESCRIPTOR;
                    parcel37.enforceInterface(string27);
                    String string28 = parcel.readString();
                    Stub stub = this;
                    String string29 = string28;
                    Bundle bundle = stub.getProviderInfo(string29);
                    parcel2.writeNoException();
                    if (bundle != null) {
                        Parcel parcel38 = parcel2;
                        int n12 = 1;
                        parcel38.writeInt(n12);
                        Bundle bundle2 = bundle;
                        Parcel parcel39 = parcel2;
                        int n13 = 1;
                        bundle2.writeToParcel(parcel39, n13);
                        return true;
                    } else {
                        Parcel parcel40 = parcel2;
                        int n14 = 0;
                        parcel40.writeInt(n14);
                    }
                    return true;
                }
                case 16: {
                    Parcel parcel41 = parcel;
                    String string30 = DESCRIPTOR;
                    parcel41.enforceInterface(string30);
                    String string31 = parcel.readString();
                    Stub stub = this;
                    String string32 = string31;
                    boolean bl = stub.isProviderEnabled(string32);
                    parcel2.writeNoException();
                    int n15 = bl ? 1 : 0;
                    Parcel parcel42 = parcel2;
                    int n16 = n15;
                    parcel42.writeInt(n16);
                    return true;
                }
                case 17: {
                    Parcel parcel43 = parcel;
                    String string33 = DESCRIPTOR;
                    parcel43.enforceInterface(string33);
                    String string34 = parcel.readString();
                    Stub stub = this;
                    String string35 = string34;
                    Location location = stub.getLastKnownLocation(string35);
                    parcel2.writeNoException();
                    if (location != null) {
                        Parcel parcel44 = parcel2;
                        int n17 = 1;
                        parcel44.writeInt(n17);
                        Location location2 = location;
                        Parcel parcel45 = parcel2;
                        int n18 = 1;
                        location2.writeToParcel(parcel45, n18);
                        return true;
                    } else {
                        Parcel parcel46 = parcel2;
                        int n19 = 0;
                        parcel46.writeInt(n19);
                    }
                    return true;
                }
                case 18: {
                    void var18_48;
                    Location location;
                    Parcel parcel47 = parcel;
                    String string36 = DESCRIPTOR;
                    parcel47.enforceInterface(string36);
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Location> creator = Location.CREATOR;
                        Parcel parcel48 = parcel;
                        location = creator.createFromParcel(parcel48);
                    } else {
                        location = null;
                    }
                    if (parcel.readInt() != 0) {
                        Object var18_47 = null;
                    } else {
                        Object var18_49 = null;
                    }
                    Stub stub = this;
                    Location location3 = location;
                    void var170_241 = var18_48;
                    stub.reportLocation(location3, (boolean)var170_241);
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    Parcel parcel49 = parcel;
                    String string37 = DESCRIPTOR;
                    parcel49.enforceInterface(string37);
                    boolean bl = this.geocoderIsPresent();
                    parcel2.writeNoException();
                    int n20 = bl ? 1 : 0;
                    Parcel parcel50 = parcel2;
                    int n21 = n20;
                    parcel50.writeInt(n21);
                    return true;
                }
                case 20: {
                    GeocoderParams geocoderParams;
                    Parcel parcel51 = parcel;
                    String string38 = DESCRIPTOR;
                    parcel51.enforceInterface(string38);
                    double d = parcel.readDouble();
                    double d3 = parcel.readDouble();
                    int n22 = parcel.readInt();
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<GeocoderParams> creator = GeocoderParams.CREATOR;
                        Parcel parcel52 = parcel;
                        geocoderParams = creator.createFromParcel(parcel52);
                    } else {
                        geocoderParams = null;
                    }
                    ArrayList<Address> arrayList = new ArrayList<Address>();
                    Stub stub = this;
                    double d4 = d;
                    double d5 = d3;
                    int n23 = n22;
                    GeocoderParams geocoderParams2 = geocoderParams;
                    String string39 = stub.getFromLocation(d4, d5, n23, geocoderParams2, arrayList);
                    parcel2.writeNoException();
                    Parcel parcel53 = parcel2;
                    String string40 = string39;
                    parcel53.writeString(string40);
                    Parcel parcel54 = parcel2;
                    ArrayList<Address> arrayList2 = arrayList;
                    parcel54.writeTypedList(arrayList2);
                    return true;
                }
                case 21: {
                    GeocoderParams geocoderParams;
                    Parcel parcel55 = parcel;
                    String string41 = DESCRIPTOR;
                    parcel55.enforceInterface(string41);
                    String string42 = parcel.readString();
                    double d = parcel.readDouble();
                    double d6 = parcel.readDouble();
                    double d7 = parcel.readDouble();
                    double d8 = parcel.readDouble();
                    int n24 = parcel.readInt();
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<GeocoderParams> creator = GeocoderParams.CREATOR;
                        Parcel parcel56 = parcel;
                        geocoderParams = creator.createFromParcel(parcel56);
                    } else {
                        geocoderParams = null;
                    }
                    ArrayList<Address> arrayList = new ArrayList<Address>();
                    Stub stub = this;
                    String string43 = string42;
                    double d9 = d;
                    double d10 = d6;
                    double d11 = d7;
                    int n25 = n24;
                    String string44 = stub.getFromLocationName(string43, d9, d10, d11, d8, n25, geocoderParams, arrayList);
                    parcel2.writeNoException();
                    Parcel parcel57 = parcel2;
                    String string45 = string44;
                    parcel57.writeString(string45);
                    Parcel parcel58 = parcel2;
                    ArrayList<Address> arrayList3 = arrayList;
                    parcel58.writeTypedList(arrayList3);
                    return true;
                }
                case 22: {
                    void var50_100;
                    void var18_51;
                    GeocoderParams geocoderParams;
                    PendingIntent pendingIntent;
                    boolean bl;
                    float f;
                    Parcel parcel59 = parcel;
                    String string46 = DESCRIPTOR;
                    parcel59.enforceInterface(string46);
                    String string47 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Object var18_50 = null;
                    } else {
                        Object var18_52 = null;
                    }
                    if (parcel.readInt() != 0) {
                        Object var50_99 = null;
                    } else {
                        Object var50_101 = null;
                    }
                    if (parcel.readInt() != 0) {
                        float f3 = Float.MIN_VALUE;
                    } else {
                        boolean bl2 = false;
                    }
                    if (parcel.readInt() != 0) {
                        Object var53_118 = null;
                    } else {
                        boolean bl3 = false;
                    }
                    if (parcel.readInt() != 0) {
                        Object var61_129 = null;
                    } else {
                        boolean bl4 = false;
                    }
                    if (parcel.readInt() != 0) {
                        Object var200_269 = null;
                    } else {
                        boolean bl5 = false;
                    }
                    boolean bl6 = parcel.readInt() != 0;
                    int n26 = parcel.readInt();
                    int n27 = parcel.readInt();
                    Stub stub = this;
                    String string48 = string47;
                    void var223_290 = var18_51;
                    void var224_291 = var50_100;
                    float f4 = f;
                    boolean bl7 = bl;
                    PendingIntent pendingIntent4 = pendingIntent;
                    GeocoderParams geocoderParams3 = geocoderParams;
                    stub.addTestProvider(string48, (boolean)var223_290, (boolean)var224_291, (boolean)f4, bl7, (boolean)pendingIntent4, (boolean)geocoderParams3, bl6, n26, n27);
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    Parcel parcel60 = parcel;
                    String string49 = DESCRIPTOR;
                    parcel60.enforceInterface(string49);
                    String string50 = parcel.readString();
                    Stub stub = this;
                    String string51 = string50;
                    stub.removeTestProvider(string51);
                    parcel2.writeNoException();
                    return true;
                }
                case 24: {
                    void var18_54;
                    Parcel parcel61 = parcel;
                    String string52 = DESCRIPTOR;
                    parcel61.enforceInterface(string52);
                    String string53 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Location> creator = Location.CREATOR;
                        Parcel parcel62 = parcel;
                        Location location = creator.createFromParcel(parcel62);
                    } else {
                        Object var18_55 = null;
                    }
                    Stub stub = this;
                    String string54 = string53;
                    void var240_307 = var18_54;
                    stub.setTestProviderLocation(string54, (Location)var240_307);
                    parcel2.writeNoException();
                    return true;
                }
                case 25: {
                    Parcel parcel63 = parcel;
                    String string55 = DESCRIPTOR;
                    parcel63.enforceInterface(string55);
                    String string56 = parcel.readString();
                    Stub stub = this;
                    String string57 = string56;
                    stub.clearTestProviderLocation(string57);
                    parcel2.writeNoException();
                    return true;
                }
                case 26: {
                    void var18_57;
                    Parcel parcel64 = parcel;
                    String string58 = DESCRIPTOR;
                    parcel64.enforceInterface(string58);
                    String string59 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        boolean bl = true;
                    } else {
                        boolean bl = false;
                    }
                    Stub stub = this;
                    String string60 = string59;
                    void var250_317 = var18_57;
                    stub.setTestProviderEnabled(string60, (boolean)var250_317);
                    parcel2.writeNoException();
                    return true;
                }
                case 27: {
                    Parcel parcel65 = parcel;
                    String string61 = DESCRIPTOR;
                    parcel65.enforceInterface(string61);
                    String string62 = parcel.readString();
                    Stub stub = this;
                    String string63 = string62;
                    stub.clearTestProviderEnabled(string63);
                    parcel2.writeNoException();
                    return true;
                }
                case 28: {
                    long l;
                    Parcel parcel66 = parcel;
                    String string64 = DESCRIPTOR;
                    parcel66.enforceInterface(string64);
                    String string65 = parcel.readString();
                    int n28 = parcel.readInt();
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Bundle> creator = Bundle.CREATOR;
                        Parcel parcel67 = parcel;
                        Bundle bundle = creator.createFromParcel(parcel67);
                    } else {
                        Object var50_103 = null;
                    }
                    long l2 = parcel.readLong();
                    Stub stub = this;
                    String string66 = string65;
                    int n29 = n28;
                    long l3 = l;
                    long l4 = l2;
                    stub.setTestProviderStatus(string66, n29, (Bundle)l3, l4);
                    parcel2.writeNoException();
                    return true;
                }
                case 29: {
                    Parcel parcel68 = parcel;
                    String string67 = DESCRIPTOR;
                    parcel68.enforceInterface(string67);
                    String string68 = parcel.readString();
                    Stub stub = this;
                    String string69 = string68;
                    stub.clearTestProviderStatus(string69);
                    parcel2.writeNoException();
                    return true;
                }
                case 30: 
            }
            Parcel parcel69 = parcel;
            String string70 = DESCRIPTOR;
            parcel69.enforceInterface(string70);
            int n30 = parcel.readInt();
            int n31 = parcel.readInt();
            Stub stub = this;
            int n32 = n30;
            int n33 = n31;
            boolean bl = stub.sendNiResponse(n32, n33);
            parcel2.writeNoException();
            int n34 = bl ? 1 : 0;
            Parcel parcel70 = parcel2;
            int n35 = n34;
            parcel70.writeInt(n35);
            return true;
        }

        private static class Proxy
        implements ILocationManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean addGpsStatusListener(IGpsStatusListener iGpsStatusListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iGpsStatusListener != null ? iGpsStatusListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addProximityAlert(double d, double d2, float f, long l, PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeDouble(d);
                    parcel.writeDouble(d2);
                    parcel.writeFloat(f);
                    parcel.writeLong(l);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addTestProvider(String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n3 = bl ? 1 : 0;
                    parcel.writeInt(n3);
                    n3 = bl2 ? 1 : 0;
                    parcel.writeInt(n3);
                    n3 = bl3 ? 1 : 0;
                    parcel.writeInt(n3);
                    n3 = bl4 ? 1 : 0;
                    parcel.writeInt(n3);
                    n3 = bl5 ? 1 : 0;
                    parcel.writeInt(n3);
                    n3 = bl6 ? 1 : 0;
                    parcel.writeInt(n3);
                    n3 = bl7 ? 1 : 0;
                    parcel.writeInt(n3);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    boolean bl8 = this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void clearTestProviderEnabled(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearTestProviderLocation(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearTestProviderStatus(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean geocoderIsPresent() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<String> getAllProviders() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    ArrayList<String> arrayList;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<String> arrayList2 = arrayList = parcel2.createStringArrayList();
                    parcel2.recycle();
                    parcel.recycle();
                    return arrayList2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getBestProvider(Criteria criteria, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    String string2;
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (criteria != null) {
                        parcel.writeInt(1);
                        criteria.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = string2 = parcel2.readString();
                    parcel2.recycle();
                    parcel.recycle();
                    return string3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getFromLocation(double d, double d2, int n, GeocoderParams geocoderParams, List<Address> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeDouble(d);
                    parcel.writeDouble(d2);
                    parcel.writeInt(n);
                    if (geocoderParams != null) {
                        parcel.writeInt(1);
                        geocoderParams.writeToParcel(parcel, 0);
                    } else {
                        int n2 = 0;
                        parcel.writeInt(n2);
                    }
                    boolean bl = this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    Parcelable.Creator<Address> creator = Address.CREATOR;
                    parcel2.readTypedList(list, creator);
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getFromLocationName(String string2, double d, double d2, double d3, double d4, int n, GeocoderParams geocoderParams, List<Address> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeDouble(d);
                    parcel.writeDouble(d2);
                    Parcel parcel3 = parcel;
                    double d5 = d3;
                    parcel3.writeDouble(d5);
                    Parcel parcel4 = parcel;
                    double d6 = d4;
                    parcel4.writeDouble(d6);
                    Parcel parcel5 = parcel;
                    int n2 = n;
                    parcel5.writeInt(n2);
                    if (geocoderParams != null) {
                        parcel.writeInt(1);
                        GeocoderParams geocoderParams2 = geocoderParams;
                        Parcel parcel6 = parcel;
                        int n3 = 0;
                        geocoderParams2.writeToParcel(parcel6, n3);
                    } else {
                        int n4 = 0;
                        parcel.writeInt(n4);
                    }
                    boolean bl = this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    Parcelable.Creator<Address> creator = Address.CREATOR;
                    Parcel parcel7 = parcel2;
                    List<Address> list2 = list;
                    Parcelable.Creator<Address> creator2 = creator;
                    parcel7.readTypedList(list2, creator2);
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Location getLastKnownLocation(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    Location location = parcel2.readInt() != 0 ? Location.CREATOR.createFromParcel(parcel2) : null;
                    return location;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Bundle getProviderInfo(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    Bundle bundle = parcel2.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel2) : null;
                    return bundle;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<String> getProviders(Criteria criteria, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    ArrayList<String> arrayList;
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (criteria != null) {
                        parcel.writeInt(1);
                        criteria.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<String> arrayList2 = arrayList = parcel2.createStringArrayList();
                    parcel2.recycle();
                    parcel.recycle();
                    return arrayList2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isProviderEnabled(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void locationCallbackFinished(ILocationListener iLocationListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iLocationListener != null ? iLocationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean providerMeetsCriteria(String string2, Criteria criteria) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (criteria != null) {
                        parcel.writeInt(1);
                        criteria.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl2 = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    bl = n != 0;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeGpsStatusListener(IGpsStatusListener iGpsStatusListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iGpsStatusListener != null ? iGpsStatusListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeProximityAlert(PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeTestProvider(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeUpdates(ILocationListener iLocationListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iLocationListener != null ? iLocationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeUpdatesPI(PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void reportLocation(Location location, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (location != null) {
                        parcel.writeInt(1);
                        location.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void requestLocationUpdates(String string2, Criteria criteria, long l, float f, boolean bl, ILocationListener iLocationListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    IBinder iBinder;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (criteria != null) {
                        parcel.writeInt(1);
                        criteria.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    parcel.writeLong(l);
                    parcel.writeFloat(f);
                    iBinder = bl ? null : null;
                    parcel.writeInt((int)iBinder);
                    iBinder = iLocationListener != null ? iLocationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl2 = this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void requestLocationUpdatesPI(String string2, Criteria criteria, long l, float f, boolean bl, PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (criteria != null) {
                        parcel.writeInt(1);
                        criteria.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeLong(l);
                    parcel.writeFloat(f);
                    n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl2 = this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean sendExtraCommand(String string2, String string3, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    boolean bl2 = parcel2.readInt() != 0;
                    if (parcel2.readInt() != 0) {
                        bundle.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean sendNiResponse(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    boolean bl = this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    boolean bl2 = n3 != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setTestProviderEnabled(String string2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setTestProviderLocation(String string2, Location location) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (location != null) {
                        parcel.writeInt(1);
                        location.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setTestProviderStatus(String string2, int n, Bundle bundle, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        int n2 = 0;
                        parcel.writeInt(n2);
                    }
                    parcel.writeLong(l);
                    boolean bl = this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

