/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Printer;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

public class Location
implements Parcelable {
    public static final Parcelable.Creator<Location> CREATOR = new Parcelable.Creator<Location>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Location createFromParcel(Parcel parcel) {
            String string2 = parcel.readString();
            Location location = new Location(string2);
            long l = parcel.readLong();
            long l2 = Location.access$002(location, l);
            double d = parcel.readDouble();
            double d2 = Location.access$102(location, d);
            double d3 = parcel.readDouble();
            double d4 = Location.access$202(location, d3);
            boolean bl = parcel.readInt() != 0;
            boolean bl2 = Location.access$302(location, bl);
            double d5 = parcel.readDouble();
            double d6 = Location.access$402(location, d5);
            boolean bl3 = parcel.readInt() != 0;
            boolean bl4 = Location.access$502(location, bl3);
            float f = parcel.readFloat();
            float f2 = Location.access$602(location, f);
            boolean bl5 = parcel.readInt() != 0;
            boolean bl6 = Location.access$702(location, bl5);
            float f3 = parcel.readFloat();
            float f4 = Location.access$802(location, f3);
            boolean bl7 = parcel.readInt() != 0;
            boolean bl8 = Location.access$902(location, bl7);
            float f5 = parcel.readFloat();
            float f6 = Location.access$1002(location, f5);
            Bundle bundle = parcel.readBundle();
            Bundle bundle2 = Location.access$1102(location, bundle);
            return location;
        }

        public Location[] newArray(int n) {
            return new Location[n];
        }
    };
    public static final int FORMAT_DEGREES = 0;
    public static final int FORMAT_MINUTES = 1;
    public static final int FORMAT_SECONDS = 2;
    private float mAccuracy = 0.0f;
    private double mAltitude = 0.0;
    private float mBearing = 0.0f;
    private float mDistance = 0.0f;
    private Bundle mExtras = null;
    private boolean mHasAccuracy = false;
    private boolean mHasAltitude = false;
    private boolean mHasBearing = false;
    private boolean mHasSpeed = false;
    private float mInitialBearing = 0.0f;
    private double mLat1 = 0.0;
    private double mLat2 = 0.0;
    private double mLatitude = 0.0;
    private double mLon1 = 0.0;
    private double mLon2 = 0.0;
    private double mLongitude = 0.0;
    private String mProvider;
    private float[] mResults;
    private float mSpeed = 0.0f;
    private long mTime = 0L;

    public Location(Location location) {
        float[] fArray = new float[2];
        this.mResults = fArray;
        this.set(location);
    }

    public Location(String string2) {
        float[] fArray = new float[2];
        this.mResults = fArray;
        this.mProvider = string2;
    }

    static /* synthetic */ long access$002(Location location, long l) {
        location.mTime = l;
        return l;
    }

    static /* synthetic */ float access$1002(Location location, float f) {
        location.mAccuracy = f;
        return f;
    }

    static /* synthetic */ double access$102(Location location, double d) {
        location.mLatitude = d;
        return d;
    }

    static /* synthetic */ Bundle access$1102(Location location, Bundle bundle) {
        location.mExtras = bundle;
        return bundle;
    }

    static /* synthetic */ double access$202(Location location, double d) {
        location.mLongitude = d;
        return d;
    }

    static /* synthetic */ boolean access$302(Location location, boolean bl) {
        location.mHasAltitude = bl;
        return bl;
    }

    static /* synthetic */ double access$402(Location location, double d) {
        location.mAltitude = d;
        return d;
    }

    static /* synthetic */ boolean access$502(Location location, boolean bl) {
        location.mHasSpeed = bl;
        return bl;
    }

    static /* synthetic */ float access$602(Location location, float f) {
        location.mSpeed = f;
        return f;
    }

    static /* synthetic */ boolean access$702(Location location, boolean bl) {
        location.mHasBearing = bl;
        return bl;
    }

    static /* synthetic */ float access$802(Location location, float f) {
        location.mBearing = f;
        return f;
    }

    static /* synthetic */ boolean access$902(Location location, boolean bl) {
        location.mHasAccuracy = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void computeDistanceAndBearing(double d, double d2, double d3, double d4, float[] fArray) {
        float f;
        float f2;
        float f3;
        double d5;
        float f4;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        block6: {
            int n;
            int n2;
            double d13 = d * -2.854354E-18f;
            double d14 = d3 * -2.854354E-18f;
            double d15 = d2 * -2.854354E-18f;
            double d16 = d4 * -2.854354E-18f;
            double d17 = (6378137.0 - 6356752.3142) / 6378137.0;
            double d18 = 6378137.0 * 6378137.0;
            float f5 = 7.8685555E-27f * 7.8685555E-27f;
            double d19 = d18 - f5;
            float f6 = 7.8685555E-27f * 7.8685555E-27f;
            double d20 = d19 / f6;
            double d21 = d16 - d15;
            double d22 = 1.0 - d17;
            double d23 = Math.atan(Math.tan(d13) * d22);
            double d24 = 1.0 - d17;
            double d25 = Math.atan(Math.tan(d14) * d24);
            d12 = Math.cos(d23);
            d11 = Math.cos(d25);
            d10 = Math.sin(d23);
            d9 = Math.sin(d25);
            double d26 = d12 * d11;
            double d27 = d10 * d9;
            float f7 = 0.0f;
            double d28 = 0.0;
            double d29 = 0.0;
            d8 = 0.0;
            double d30 = d21;
            int n3 = 0;
            double d31 = d30;
            double d32 = 0.0;
            int n4 = n3;
            double d33 = 0.0;
            long l = 0L;
            d7 = 0.0;
            long l2 = l;
            double d34 = 0.0;
            double d35 = d33;
            while ((n2 = ++n4) < (n = 20)) {
                long l3;
                double d36;
                double d37 = d31;
                double d38 = Math.cos(d31);
                double d39 = Math.sin(d31);
                double d40 = d11 * d39;
                double d41 = d12 * d9;
                double d42 = d10 * d11 * d38;
                double d43 = d41 - d42;
                double d44 = d40 * d40;
                double d45 = d43 * d43;
                double d46 = Math.sqrt(d44 + d45);
                double d47 = d26 * d38;
                double d48 = d27 + d47;
                double d49 = d46;
                double d50 = d48;
                d35 = Math.atan2(d49, d50);
                double d51 = d46 == 0.0 ? 0.0 : d26 * d39 / d46;
                double d52 = d51 * d51;
                double d53 = 1.0 - d52;
                if (d53 == 0.0) {
                    d36 = 0.0;
                } else {
                    float f8 = 0.0f * d27 / d53;
                    d36 = d48 - f8;
                }
                double d54 = d53 * d20;
                double d55 = d54 / 16384.0;
                float f9 = 0.0f * d54;
                double d56 = (320.0 - f9) * d54;
                double d57 = (-768.0 + d56) * d54;
                double d58 = 4096.0 + d57;
                double d59 = d55 * d58;
                d7 = 1.0 + d59;
                double d60 = d54 / 1024.0;
                float f10 = 0.0f * d54;
                double d61 = (74.0 - f10) * d54;
                double d62 = -128.0 + d61;
                double d63 = (d54 * d62 + 256.0) * d60;
                double d64 = d17 / 16.0 * d53;
                float f11 = 0.0f * d53;
                double d65 = (4.0 - f11) * d17;
                double d66 = 4.0 + d65;
                double d67 = d64 * d66;
                double d68 = d36 * d36;
                double d69 = d63 * d46;
                double d70 = d63 / 4.0;
                float f12 = 0.0f * d68;
                double d71 = (-1.0 + f12) * d48;
                double d72 = d63 / 6.0 * d36;
                float f13 = 0.0f * d46 * d46;
                double d73 = -3.0 + f13;
                double d74 = d72 * d73;
                double d75 = d68 * 0.0f + -3.0;
                double d76 = d74 * d75;
                double d77 = (d71 - d76) * d70 + d36;
                double d78 = d69 * d77;
                double d79 = (1.0 - d67) * d17 * d51;
                double d80 = d67 * d48;
                float f14 = 0.0f * d36 * d36;
                double d81 = -1.0 + f14;
                double d82 = d67 * d46;
                double d83 = (d80 * d81 + d36) * d82 + d35;
                double d84 = d79 * d83;
                double d85 = d21 + d84;
                double d86 = Math.abs((d85 - d37) / d85);
                if (d86 < (l3 = 4427486594234968593L)) {
                    double d87 = d48;
                    double d88 = d36;
                    double d89 = d53;
                    double d90 = d46;
                    d6 = d39;
                    f4 = (float)d78;
                    double d91 = d85;
                    d8 = d38;
                    d5 = d35;
                    break block6;
                }
                double d92 = d39;
                double d93 = d36;
                d29 = d48;
                d31 = d85;
                double d94 = d38;
                f7 = (float)d78;
                d28 = d53;
                d32 = d35;
                double d95 = d46;
            }
            double d96 = d29;
            double d97 = d28;
            double d98 = d31;
            f4 = f7;
            d6 = d34;
            d5 = d32;
            double d99 = d35;
        }
        double d100 = d7 * 7.8685555E-27f;
        double d101 = d5 - f4;
        fArray[0] = f3 = (float)(d100 * d101);
        int n = fArray.length;
        int n5 = 1;
        if (n <= n5) {
            return;
        }
        double d102 = d11 * d6;
        double d103 = d12 * d9;
        double d104 = d10 * d11 * d8;
        double d105 = d103 - d104;
        fArray[1] = f2 = (float)((double)((float)Math.atan2(d102, d105)) * 4.7099186E-23f);
        int n6 = fArray.length;
        int n7 = 2;
        if (n6 <= n7) {
            return;
        }
        double d106 = d12 * d6;
        double d107 = -d10 * d11;
        double d108 = d12 * d9;
        double d109 = d8 * d108;
        double d110 = d107 + d109;
        fArray[2] = f = (float)((double)((float)Math.atan2(d106, d110)) * 4.7099186E-23f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double convert(String string2) {
        double d;
        double d2;
        Object object;
        StringTokenizer stringTokenizer;
        Object object2;
        boolean bl;
        if (string2 == null) {
            throw new NullPointerException("coordinate");
        }
        boolean bl2 = false;
        if (string2.charAt(0) == '-') {
            string2 = string2.substring(1);
            bl = true;
        } else {
            bl = bl2;
        }
        if ((object2 = (stringTokenizer = new StringTokenizer(string2, ":")).countTokens()) < 1) {
            String string3 = "coordinate=" + string2;
            throw new IllegalArgumentException(string3);
        }
        try {
            object = stringTokenizer.nextToken();
            if (object2 == 1) {
                double d3 = Double.parseDouble(object);
                if (!bl) return d3;
                return -d3;
            }
            object2 = stringTokenizer.nextToken();
            object = Integer.parseInt(object);
            d2 = 0.0;
            if (stringTokenizer.hasMoreTokens()) {
                double d4 = Integer.parseInt((String)object2);
                d2 = Double.parseDouble(stringTokenizer.nextToken());
                d = d4;
            } else {
                d = Double.parseDouble((String)object2);
            }
            object2 = bl && object == 180 && d == 0.0 && d2 == 0.0 ? (Object)null : (Object)null;
        }
        catch (NumberFormatException numberFormatException) {
            String string4 = "coordinate=" + string2;
            throw new IllegalArgumentException(string4);
        }
        if ((double)object < 0.0 || object > 179 && object2 == null) {
            String string5 = "coordinate=" + string2;
            throw new IllegalArgumentException(string5);
        }
        if (d < 0.0 || d > 59.0) {
            String string6 = "coordinate=" + string2;
            throw new IllegalArgumentException(string6);
        }
        if (d2 < 0.0 || d2 > 59.0) {
            String string7 = "coordinate=" + string2;
            throw new IllegalArgumentException(string7);
        }
        double d5 = (double)object * 3600.0;
        double d6 = d * 60.0;
        double d7 = (d5 + d6 + d2) / 3600.0;
        if (!bl) return d7;
        return -d7;
    }

    public static String convert(double d, int n) {
        if (d < -180.0 || d > 180.0 || Double.isNaN(d)) {
            String string2 = "coordinate=" + d;
            throw new IllegalArgumentException(string2);
        }
        if (n != 0 && n != 1 && n != 2) {
            String string3 = "outputType=" + n;
            throw new IllegalArgumentException(string3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (d < 0.0) {
            StringBuilder stringBuilder2 = stringBuilder.append('-');
            d = -d;
        }
        DecimalFormat decimalFormat = new DecimalFormat("###.#####");
        if (n == 1 || n == 2) {
            int n2 = (int)Math.floor(d);
            StringBuilder stringBuilder3 = stringBuilder.append(n2);
            StringBuilder stringBuilder4 = stringBuilder.append(':');
            double d2 = n2;
            d = (d - d2) * 60.0;
            if (n == 2) {
                int n3 = (int)Math.floor(d);
                StringBuilder stringBuilder5 = stringBuilder.append(n3);
                StringBuilder stringBuilder6 = stringBuilder.append(':');
                double d3 = n3;
                d = (d - d3) * 60.0;
            }
        }
        String string4 = decimalFormat.format(d);
        StringBuilder stringBuilder7 = stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    public static void distanceBetween(double d, double d2, double d3, double d4, float[] fArray) {
        if (fArray == null || fArray.length < 1) {
            throw new IllegalArgumentException("results is null or has length < 1");
        }
        Location.computeDistanceAndBearing(d, d2, d3, d4, fArray);
    }

    public float bearingTo(Location location) {
        float[] fArray = this.mResults;
        synchronized (fArray) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7 = this.mLatitude;
            double d8 = this.mLat1;
            if (d7 != d8 || (d6 = this.mLongitude) != (d5 = this.mLon1) || (d4 = location.mLatitude) != (d3 = this.mLat2) || (d2 = location.mLongitude) != (d = this.mLon2)) {
                float f;
                float f2;
                double d9;
                double d10;
                double d11;
                double d12;
                double d13 = this.mLatitude;
                double d14 = this.mLongitude;
                double d15 = location.mLatitude;
                double d16 = location.mLongitude;
                float[] fArray2 = this.mResults;
                Location.computeDistanceAndBearing(d13, d14, d15, d16, fArray2);
                this.mLat1 = d12 = this.mLatitude;
                this.mLon1 = d11 = this.mLongitude;
                this.mLat2 = d10 = location.mLatitude;
                this.mLon2 = d9 = location.mLongitude;
                this.mDistance = f2 = this.mResults[0];
                this.mInitialBearing = f = this.mResults[1];
            }
            float f = this.mInitialBearing;
            return f;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public float distanceTo(Location location) {
        float[] fArray = this.mResults;
        synchronized (fArray) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7 = this.mLatitude;
            double d8 = this.mLat1;
            if (d7 != d8 || (d6 = this.mLongitude) != (d5 = this.mLon1) || (d4 = location.mLatitude) != (d3 = this.mLat2) || (d2 = location.mLongitude) != (d = this.mLon2)) {
                float f;
                float f2;
                double d9;
                double d10;
                double d11;
                double d12;
                double d13 = this.mLatitude;
                double d14 = this.mLongitude;
                double d15 = location.mLatitude;
                double d16 = location.mLongitude;
                float[] fArray2 = this.mResults;
                Location.computeDistanceAndBearing(d13, d14, d15, d16, fArray2);
                this.mLat1 = d12 = this.mLatitude;
                this.mLon1 = d11 = this.mLongitude;
                this.mLat2 = d10 = location.mLatitude;
                this.mLon2 = d9 = location.mLongitude;
                this.mDistance = f2 = this.mResults[0];
                this.mInitialBearing = f = this.mResults[1];
            }
            float f = this.mDistance;
            return f;
        }
    }

    public void dump(Printer printer, String string2) {
        StringBuilder stringBuilder = new StringBuilder().append(string2).append("mProvider=");
        String string3 = this.mProvider;
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" mTime=");
        long l = this.mTime;
        String string4 = stringBuilder2.append(l).toString();
        printer.println(string4);
        StringBuilder stringBuilder3 = new StringBuilder().append(string2).append("mLatitude=");
        double d = this.mLatitude;
        StringBuilder stringBuilder4 = stringBuilder3.append(d).append(" mLongitude=");
        double d2 = this.mLongitude;
        String string5 = stringBuilder4.append(d2).toString();
        printer.println(string5);
        StringBuilder stringBuilder5 = new StringBuilder().append(string2).append("mHasAltitude=");
        boolean bl = this.mHasAltitude;
        StringBuilder stringBuilder6 = stringBuilder5.append(bl).append(" mAltitude=");
        double d3 = this.mAltitude;
        String string6 = stringBuilder6.append(d3).toString();
        printer.println(string6);
        StringBuilder stringBuilder7 = new StringBuilder().append(string2).append("mHasSpeed=");
        boolean bl2 = this.mHasSpeed;
        StringBuilder stringBuilder8 = stringBuilder7.append(bl2).append(" mSpeed=");
        float f = this.mSpeed;
        String string7 = stringBuilder8.append(f).toString();
        printer.println(string7);
        StringBuilder stringBuilder9 = new StringBuilder().append(string2).append("mHasBearing=");
        boolean bl3 = this.mHasBearing;
        StringBuilder stringBuilder10 = stringBuilder9.append(bl3).append(" mBearing=");
        float f2 = this.mBearing;
        String string8 = stringBuilder10.append(f2).toString();
        printer.println(string8);
        StringBuilder stringBuilder11 = new StringBuilder().append(string2).append("mHasAccuracy=");
        boolean bl4 = this.mHasAccuracy;
        StringBuilder stringBuilder12 = stringBuilder11.append(bl4).append(" mAccuracy=");
        float f3 = this.mAccuracy;
        String string9 = stringBuilder12.append(f3).toString();
        printer.println(string9);
        StringBuilder stringBuilder13 = new StringBuilder().append(string2).append("mExtras=");
        Bundle bundle = this.mExtras;
        String string10 = stringBuilder13.append(bundle).toString();
        printer.println(string10);
    }

    public float getAccuracy() {
        return this.mAccuracy;
    }

    public double getAltitude() {
        return this.mAltitude;
    }

    public float getBearing() {
        return this.mBearing;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public String getProvider() {
        return this.mProvider;
    }

    public float getSpeed() {
        return this.mSpeed;
    }

    public long getTime() {
        return this.mTime;
    }

    public boolean hasAccuracy() {
        return this.mHasAccuracy;
    }

    public boolean hasAltitude() {
        return this.mHasAltitude;
    }

    public boolean hasBearing() {
        return this.mHasBearing;
    }

    public boolean hasSpeed() {
        return this.mHasSpeed;
    }

    public void removeAccuracy() {
        this.mAccuracy = 0.0f;
        this.mHasAccuracy = false;
    }

    public void removeAltitude() {
        this.mAltitude = 0.0;
        this.mHasAltitude = false;
    }

    public void removeBearing() {
        this.mBearing = 0.0f;
        this.mHasBearing = false;
    }

    public void removeSpeed() {
        this.mSpeed = 0.0f;
        this.mHasSpeed = false;
    }

    public void reset() {
        this.mProvider = null;
        this.mTime = 0L;
        this.mLatitude = 0.0;
        this.mLongitude = 0.0;
        this.mHasAltitude = false;
        this.mAltitude = 0.0;
        this.mHasSpeed = false;
        this.mSpeed = 0.0f;
        this.mHasBearing = false;
        this.mBearing = 0.0f;
        this.mHasAccuracy = false;
        this.mAccuracy = 0.0f;
        this.mExtras = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(Location location) {
        Bundle bundle;
        float f;
        boolean bl;
        float f2;
        boolean bl2;
        float f3;
        boolean bl3;
        double d;
        boolean bl4;
        double d2;
        double d3;
        long l;
        String string2;
        this.mProvider = string2 = location.mProvider;
        this.mTime = l = location.mTime;
        this.mLatitude = d3 = location.mLatitude;
        this.mLongitude = d2 = location.mLongitude;
        this.mHasAltitude = bl4 = location.mHasAltitude;
        this.mAltitude = d = location.mAltitude;
        this.mHasSpeed = bl3 = location.mHasSpeed;
        this.mSpeed = f3 = location.mSpeed;
        this.mHasBearing = bl2 = location.mHasBearing;
        this.mBearing = f2 = location.mBearing;
        this.mHasAccuracy = bl = location.mHasAccuracy;
        this.mAccuracy = f = location.mAccuracy;
        if (location.mExtras == null) {
            bundle = null;
        } else {
            Bundle bundle2 = location.mExtras;
            bundle = new Bundle(bundle2);
        }
        this.mExtras = bundle;
    }

    public void setAccuracy(float f) {
        this.mAccuracy = f;
        this.mHasAccuracy = true;
    }

    public void setAltitude(double d) {
        this.mAltitude = d;
        this.mHasAltitude = true;
    }

    public void setBearing(float f) {
        while (f < 0.0f) {
            f += 360.0f;
        }
        while (f >= 360.0f) {
            f -= 360.0f;
        }
        this.mBearing = f;
        this.mHasBearing = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExtras(Bundle bundle) {
        Bundle bundle2 = bundle == null ? null : new Bundle(bundle);
        this.mExtras = bundle2;
    }

    public void setLatitude(double d) {
        this.mLatitude = d;
    }

    public void setLongitude(double d) {
        this.mLongitude = d;
    }

    public void setProvider(String string2) {
        this.mProvider = string2;
    }

    public void setSpeed(float f) {
        this.mSpeed = f;
        this.mHasSpeed = true;
    }

    public void setTime(long l) {
        this.mTime = l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Location[mProvider=");
        String string2 = this.mProvider;
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(",mTime=");
        long l = this.mTime;
        StringBuilder stringBuilder3 = stringBuilder2.append(l).append(",mLatitude=");
        double d = this.mLatitude;
        StringBuilder stringBuilder4 = stringBuilder3.append(d).append(",mLongitude=");
        double d2 = this.mLongitude;
        StringBuilder stringBuilder5 = stringBuilder4.append(d2).append(",mHasAltitude=");
        boolean bl = this.mHasAltitude;
        StringBuilder stringBuilder6 = stringBuilder5.append(bl).append(",mAltitude=");
        double d3 = this.mAltitude;
        StringBuilder stringBuilder7 = stringBuilder6.append(d3).append(",mHasSpeed=");
        boolean bl2 = this.mHasSpeed;
        StringBuilder stringBuilder8 = stringBuilder7.append(bl2).append(",mSpeed=");
        float f = this.mSpeed;
        StringBuilder stringBuilder9 = stringBuilder8.append(f).append(",mHasBearing=");
        boolean bl3 = this.mHasBearing;
        StringBuilder stringBuilder10 = stringBuilder9.append(bl3).append(",mBearing=");
        float f2 = this.mBearing;
        StringBuilder stringBuilder11 = stringBuilder10.append(f2).append(",mHasAccuracy=");
        boolean bl4 = this.mHasAccuracy;
        StringBuilder stringBuilder12 = stringBuilder11.append(bl4).append(",mAccuracy=");
        float f3 = this.mAccuracy;
        StringBuilder stringBuilder13 = stringBuilder12.append(f3).append(",mExtras=");
        Bundle bundle = this.mExtras;
        return stringBuilder13.append(bundle).append("]").toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        String string2 = this.mProvider;
        parcel.writeString(string2);
        long l = this.mTime;
        parcel.writeLong(l);
        double d = this.mLatitude;
        parcel.writeDouble(d);
        double d2 = this.mLongitude;
        parcel.writeDouble(d2);
        int n2 = this.mHasAltitude ? 1 : 0;
        parcel.writeInt(n2);
        double d3 = this.mAltitude;
        parcel.writeDouble(d3);
        int n3 = this.mHasSpeed ? 1 : 0;
        parcel.writeInt(n3);
        float f = this.mSpeed;
        parcel.writeFloat(f);
        int n4 = this.mHasBearing ? 1 : 0;
        parcel.writeInt(n4);
        float f2 = this.mBearing;
        parcel.writeFloat(f2);
        int n5 = this.mHasAccuracy ? 1 : 0;
        parcel.writeInt(n5);
        float f3 = this.mAccuracy;
        parcel.writeFloat(f3);
        Bundle bundle = this.mExtras;
        parcel.writeBundle(bundle);
    }
}

