/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.app.PendingIntent;
import android.location.Criteria;
import android.location.GpsStatus;
import android.location.IGpsStatusListener;
import android.location.ILocationListener;
import android.location.ILocationManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationProvider;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.location.DummyLocationProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LocationManager {
    public static final String EXTRA_GPS_ENABLED = "enabled";
    public static final String GPS_ENABLED_CHANGE_ACTION = "android.location.GPS_ENABLED_CHANGE";
    public static final String GPS_FIX_CHANGE_ACTION = "android.location.GPS_FIX_CHANGE";
    public static final String GPS_PROVIDER = "gps";
    public static final String KEY_LOCATION_CHANGED = "location";
    public static final String KEY_PROVIDER_ENABLED = "providerEnabled";
    public static final String KEY_PROXIMITY_ENTERING = "entering";
    public static final String KEY_STATUS_CHANGED = "status";
    public static final String NETWORK_PROVIDER = "network";
    public static final String PASSIVE_PROVIDER = "passive";
    public static final String PROVIDERS_CHANGED_ACTION = "android.location.PROVIDERS_CHANGED";
    private static final String TAG = "LocationManager";
    private final GpsStatus mGpsStatus;
    private final HashMap<GpsStatus.Listener, GpsStatusListenerTransport> mGpsStatusListeners;
    private HashMap<LocationListener, ListenerTransport> mListeners;
    private final HashMap<GpsStatus.NmeaListener, GpsStatusListenerTransport> mNmeaListeners;
    private ILocationManager mService;

    public LocationManager(ILocationManager iLocationManager) {
        GpsStatus gpsStatus;
        HashMap hashMap = new HashMap();
        this.mGpsStatusListeners = hashMap;
        HashMap hashMap2 = new HashMap();
        this.mNmeaListeners = hashMap2;
        this.mGpsStatus = gpsStatus = new GpsStatus();
        HashMap hashMap3 = new HashMap();
        this.mListeners = hashMap3;
        this.mService = iLocationManager;
    }

    private void _requestLocationUpdates(String string2, Criteria criteria, long l, float f, boolean bl, PendingIntent pendingIntent) {
        if (l < 0L) {
            l = 0L;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        try {
            ILocationManager iLocationManager = this.mService;
            String string3 = string2;
            Criteria criteria2 = criteria;
            long l2 = l;
            float f2 = f;
            boolean bl2 = bl;
            PendingIntent pendingIntent2 = pendingIntent;
            iLocationManager.requestLocationUpdatesPI(string3, criteria2, l2, f2, bl2, pendingIntent2);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "requestLocationUpdates: RemoteException", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _requestLocationUpdates(String string2, Criteria criteria, long l, float f, boolean bl, LocationListener locationListener, Looper looper) {
        Looper looper2;
        LocationListener locationListener2;
        LocationManager locationManager;
        ListenerTransport listenerTransport;
        ListenerTransport listenerTransport2;
        if (l < 0L) {
            l = 0L;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        try {
            HashMap<LocationListener, ListenerTransport> hashMap = this.mListeners;
            synchronized (hashMap) {
                HashMap<LocationListener, ListenerTransport> hashMap2 = this.mListeners;
                LocationListener locationListener3 = locationListener;
                listenerTransport2 = hashMap2.get(locationListener3);
                if (listenerTransport2 != null) break block7;
                listenerTransport = listenerTransport2;
                locationManager = this;
                locationListener2 = locationListener;
                looper2 = looper;
            }
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "requestLocationUpdates: DeadObjectException", remoteException);
            return;
        }
        {
            block7: {
                listenerTransport(locationListener2, looper2);
            }
            HashMap<LocationListener, ListenerTransport> hashMap = this.mListeners;
            LocationListener locationListener4 = locationListener;
            ListenerTransport listenerTransport3 = listenerTransport2;
            ListenerTransport listenerTransport4 = hashMap.put(locationListener4, listenerTransport3);
            ILocationManager iLocationManager = this.mService;
            String string3 = string2;
            Criteria criteria2 = criteria;
            long l2 = l;
            float f2 = f;
            boolean bl2 = bl;
            iLocationManager.requestLocationUpdates(string3, criteria2, l2, f2, bl2, listenerTransport2);
            return;
        }
    }

    private LocationProvider createProvider(String string2, Bundle bundle) {
        ILocationManager iLocationManager = this.mService;
        DummyLocationProvider dummyLocationProvider = new DummyLocationProvider(string2, iLocationManager);
        boolean bl = bundle.getBoolean(NETWORK_PROVIDER);
        dummyLocationProvider.setRequiresNetwork(bl);
        boolean bl2 = bundle.getBoolean("satellite");
        dummyLocationProvider.setRequiresSatellite(bl2);
        boolean bl3 = bundle.getBoolean("cell");
        dummyLocationProvider.setRequiresCell(bl3);
        boolean bl4 = bundle.getBoolean("cost");
        dummyLocationProvider.setHasMonetaryCost(bl4);
        boolean bl5 = bundle.getBoolean("altitude");
        dummyLocationProvider.setSupportsAltitude(bl5);
        boolean bl6 = bundle.getBoolean("speed");
        dummyLocationProvider.setSupportsSpeed(bl6);
        boolean bl7 = bundle.getBoolean("bearing");
        dummyLocationProvider.setSupportsBearing(bl7);
        int n = bundle.getInt("power");
        dummyLocationProvider.setPowerRequirement(n);
        int n2 = bundle.getInt("accuracy");
        dummyLocationProvider.setAccuracy(n2);
        return dummyLocationProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addGpsStatusListener(GpsStatus.Listener listener) {
        if (this.mGpsStatusListeners.get(listener) != null) {
            return true;
        }
        try {
            GpsStatusListenerTransport gpsStatusListenerTransport = new GpsStatusListenerTransport(listener);
            boolean bl = this.mService.addGpsStatusListener(gpsStatusListenerTransport);
            if (!bl) return bl;
            GpsStatusListenerTransport gpsStatusListenerTransport2 = this.mGpsStatusListeners.put(listener, gpsStatusListenerTransport);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in registerGpsStatusListener: ", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addNmeaListener(GpsStatus.NmeaListener nmeaListener) {
        if (this.mNmeaListeners.get(nmeaListener) != null) {
            return true;
        }
        try {
            GpsStatusListenerTransport gpsStatusListenerTransport = new GpsStatusListenerTransport(nmeaListener);
            boolean bl = this.mService.addGpsStatusListener(gpsStatusListenerTransport);
            if (!bl) return bl;
            GpsStatusListenerTransport gpsStatusListenerTransport2 = this.mNmeaListeners.put(nmeaListener, gpsStatusListenerTransport);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in registerGpsStatusListener: ", remoteException);
            return false;
        }
    }

    public void addProximityAlert(double d, double d2, float f, long l, PendingIntent pendingIntent) {
        try {
            ILocationManager iLocationManager = this.mService;
            double d3 = d;
            double d4 = d2;
            float f2 = f;
            long l2 = l;
            PendingIntent pendingIntent2 = pendingIntent;
            iLocationManager.addProximityAlert(d3, d4, f2, l2, pendingIntent2);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "addProximityAlert: RemoteException", remoteException);
            return;
        }
    }

    public void addTestProvider(String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2) {
        try {
            ILocationManager iLocationManager = this.mService;
            String string3 = string2;
            boolean bl8 = bl;
            boolean bl9 = bl2;
            boolean bl10 = bl3;
            boolean bl11 = bl4;
            boolean bl12 = bl5;
            boolean bl13 = bl6;
            boolean bl14 = bl7;
            int n3 = n;
            int n4 = n2;
            iLocationManager.addTestProvider(string3, bl8, bl9, bl10, bl11, bl12, bl13, bl14, n3, n4);
            return;
        }
        catch (RemoteException remoteException) {
            int n5 = Log.e(TAG, "addTestProvider: RemoteException", remoteException);
            return;
        }
    }

    public void clearTestProviderEnabled(String string2) {
        try {
            this.mService.clearTestProviderEnabled(string2);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "clearTestProviderEnabled: RemoteException", remoteException);
            return;
        }
    }

    public void clearTestProviderLocation(String string2) {
        try {
            this.mService.clearTestProviderLocation(string2);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "clearTestProviderLocation: RemoteException", remoteException);
            return;
        }
    }

    public void clearTestProviderStatus(String string2) {
        try {
            this.mService.clearTestProviderStatus(string2);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "clearTestProviderStatus: RemoteException", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getAllProviders() {
        try {
            List<String> list = this.mService.getAllProviders();
            return list;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "getAllProviders: RemoteException", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getBestProvider(Criteria criteria, boolean bl) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        try {
            String string2 = this.mService.getBestProvider(criteria, bl);
            return string2;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "getBestProvider: RemoteException", remoteException);
            return null;
        }
    }

    public GpsStatus getGpsStatus(GpsStatus gpsStatus) {
        if (gpsStatus == null) {
            gpsStatus = new GpsStatus();
        }
        GpsStatus gpsStatus2 = this.mGpsStatus;
        gpsStatus.setStatus(gpsStatus2);
        return gpsStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Location getLastKnownLocation(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("provider==null");
        }
        try {
            Location location = this.mService.getLastKnownLocation(string2);
            return location;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "getLastKnowLocation: RemoteException", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LocationProvider getProvider(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("name==null");
        }
        try {
            Bundle bundle = this.mService.getProviderInfo(string2);
            LocationProvider locationProvider = this.createProvider(string2, bundle);
            if (bundle != null) return locationProvider;
            return null;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "getProvider: RemoteException", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getProviders(Criteria criteria, boolean bl) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        try {
            List<String> list = this.mService.getProviders(criteria, bl);
            return list;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "getProviders: RemoteException", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getProviders(boolean bl) {
        try {
            List<String> list = this.mService.getProviders(null, bl);
            return list;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "getProviders: RemoteException", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isProviderEnabled(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("provider==null");
        }
        try {
            boolean bl = this.mService.isProviderEnabled(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "isProviderEnabled: RemoteException", remoteException);
            return false;
        }
    }

    public void removeGpsStatusListener(GpsStatus.Listener listener) {
        try {
            GpsStatusListenerTransport gpsStatusListenerTransport = this.mGpsStatusListeners.remove(listener);
            if (gpsStatusListenerTransport == null) {
                return;
            }
            this.mService.removeGpsStatusListener(gpsStatusListenerTransport);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in unregisterGpsStatusListener: ", remoteException);
            return;
        }
    }

    public void removeNmeaListener(GpsStatus.NmeaListener nmeaListener) {
        try {
            GpsStatusListenerTransport gpsStatusListenerTransport = this.mNmeaListeners.remove(nmeaListener);
            if (gpsStatusListenerTransport == null) {
                return;
            }
            this.mService.removeGpsStatusListener(gpsStatusListenerTransport);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in unregisterGpsStatusListener: ", remoteException);
            return;
        }
    }

    public void removeProximityAlert(PendingIntent pendingIntent) {
        try {
            this.mService.removeProximityAlert(pendingIntent);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "removeProximityAlert: RemoteException", remoteException);
            return;
        }
    }

    public void removeTestProvider(String string2) {
        try {
            this.mService.removeTestProvider(string2);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "removeTestProvider: RemoteException", remoteException);
            return;
        }
    }

    public void removeUpdates(PendingIntent pendingIntent) {
        if (pendingIntent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        try {
            this.mService.removeUpdatesPI(pendingIntent);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "removeUpdates: RemoteException", remoteException);
            return;
        }
    }

    public void removeUpdates(LocationListener locationListener) {
        if (locationListener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        try {
            ListenerTransport listenerTransport = this.mListeners.remove(locationListener);
            if (listenerTransport == null) {
                return;
            }
            this.mService.removeUpdates(listenerTransport);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "removeUpdates: DeadObjectException", remoteException);
            return;
        }
    }

    public void requestLocationUpdates(long l, float f, Criteria criteria, PendingIntent pendingIntent) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        if (pendingIntent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        LocationManager locationManager = this;
        Criteria criteria2 = criteria;
        long l2 = l;
        float f2 = f;
        PendingIntent pendingIntent2 = pendingIntent;
        locationManager._requestLocationUpdates(null, criteria2, l2, f2, false, pendingIntent2);
    }

    public void requestLocationUpdates(long l, float f, Criteria criteria, LocationListener locationListener, Looper looper) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        if (locationListener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        LocationManager locationManager = this;
        Criteria criteria2 = criteria;
        long l2 = l;
        float f2 = f;
        LocationListener locationListener2 = locationListener;
        Looper looper2 = looper;
        locationManager._requestLocationUpdates(null, criteria2, l2, f2, false, locationListener2, looper2);
    }

    public void requestLocationUpdates(String string2, long l, float f, PendingIntent pendingIntent) {
        if (string2 == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (pendingIntent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        LocationManager locationManager = this;
        String string3 = string2;
        long l2 = l;
        float f2 = f;
        PendingIntent pendingIntent2 = pendingIntent;
        locationManager._requestLocationUpdates(string3, null, l2, f2, false, pendingIntent2);
    }

    public void requestLocationUpdates(String string2, long l, float f, LocationListener locationListener) {
        if (string2 == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (locationListener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        LocationManager locationManager = this;
        String string3 = string2;
        long l2 = l;
        float f2 = f;
        LocationListener locationListener2 = locationListener;
        Looper looper = null;
        locationManager._requestLocationUpdates(string3, null, l2, f2, false, locationListener2, looper);
    }

    public void requestLocationUpdates(String string2, long l, float f, LocationListener locationListener, Looper looper) {
        if (string2 == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (locationListener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        LocationManager locationManager = this;
        String string3 = string2;
        long l2 = l;
        float f2 = f;
        LocationListener locationListener2 = locationListener;
        Looper looper2 = looper;
        locationManager._requestLocationUpdates(string3, null, l2, f2, false, locationListener2, looper2);
    }

    public void requestSingleUpdate(Criteria criteria, PendingIntent pendingIntent) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        if (pendingIntent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        LocationManager locationManager = this;
        Criteria criteria2 = criteria;
        PendingIntent pendingIntent2 = pendingIntent;
        locationManager._requestLocationUpdates(null, criteria2, 0L, 0.0f, true, pendingIntent2);
    }

    public void requestSingleUpdate(Criteria criteria, LocationListener locationListener, Looper looper) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        if (locationListener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        LocationManager locationManager = this;
        Criteria criteria2 = criteria;
        LocationListener locationListener2 = locationListener;
        Looper looper2 = looper;
        locationManager._requestLocationUpdates(null, criteria2, 0L, 0.0f, true, locationListener2, looper2);
    }

    public void requestSingleUpdate(String string2, PendingIntent pendingIntent) {
        if (string2 == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (pendingIntent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        LocationManager locationManager = this;
        String string3 = string2;
        PendingIntent pendingIntent2 = pendingIntent;
        locationManager._requestLocationUpdates(string3, null, 0L, 0.0f, true, pendingIntent2);
    }

    public void requestSingleUpdate(String string2, LocationListener locationListener, Looper looper) {
        if (string2 == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (locationListener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        LocationManager locationManager = this;
        String string3 = string2;
        LocationListener locationListener2 = locationListener;
        Looper looper2 = looper;
        locationManager._requestLocationUpdates(string3, null, 0L, 0.0f, true, locationListener2, looper2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sendExtraCommand(String string2, String string3, Bundle bundle) {
        try {
            boolean bl = this.mService.sendExtraCommand(string2, string3, bundle);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in sendExtraCommand: ", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sendNiResponse(int n, int n2) {
        try {
            boolean bl = this.mService.sendNiResponse(n, n2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "RemoteException in sendNiResponse: ", remoteException);
            return false;
        }
    }

    public void setTestProviderEnabled(String string2, boolean bl) {
        try {
            this.mService.setTestProviderEnabled(string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "setTestProviderEnabled: RemoteException", remoteException);
            return;
        }
    }

    public void setTestProviderLocation(String string2, Location location) {
        try {
            this.mService.setTestProviderLocation(string2, location);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "setTestProviderLocation: RemoteException", remoteException);
            return;
        }
    }

    public void setTestProviderStatus(String string2, int n, Bundle bundle, long l) {
        try {
            ILocationManager iLocationManager = this.mService;
            String string3 = string2;
            int n2 = n;
            Bundle bundle2 = bundle;
            long l2 = l;
            iLocationManager.setTestProviderStatus(string3, n2, bundle2, l2);
            return;
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "setTestProviderStatus: RemoteException", remoteException);
            return;
        }
    }

    private class GpsStatusListenerTransport
    extends IGpsStatusListener.Stub {
        private static final int NMEA_RECEIVED = 1000;
        private final Handler mGpsHandler;
        private final GpsStatus.Listener mListener;
        private ArrayList<Nmea> mNmeaBuffer;
        private final GpsStatus.NmeaListener mNmeaListener;

        GpsStatusListenerTransport(GpsStatus.Listener listener) {
            Handler handler;
            this.mGpsHandler = handler = new Handler(){

                @Override
                public void handleMessage(Message message) {
                    if (message.what == 1000) {
                        ArrayList arrayList = GpsStatusListenerTransport.this.mNmeaBuffer;
                        synchronized (arrayList) {
                            int n = GpsStatusListenerTransport.this.mNmeaBuffer.size();
                            for (int i = 0; i < n; ++i) {
                                Nmea nmea = (Nmea)GpsStatusListenerTransport.this.mNmeaBuffer.get(i);
                                GpsStatus.NmeaListener nmeaListener = GpsStatusListenerTransport.this.mNmeaListener;
                                long l = nmea.mTimestamp;
                                String string2 = nmea.mNmea;
                                nmeaListener.onNmeaReceived(l, string2);
                            }
                            GpsStatusListenerTransport.this.mNmeaBuffer.clear();
                            return;
                        }
                    }
                    GpsStatus gpsStatus = LocationManager.this.mGpsStatus;
                    synchronized (gpsStatus) {
                        GpsStatus.Listener listener = GpsStatusListenerTransport.this.mListener;
                        int n = message.what;
                        listener.onGpsStatusChanged(n);
                        return;
                    }
                }
            };
            this.mListener = listener;
            this.mNmeaListener = null;
        }

        GpsStatusListenerTransport(GpsStatus.NmeaListener nmeaListener) {
            Handler handler;
            this.mGpsHandler = handler = new /* invalid duplicate definition of identical inner class */;
            this.mNmeaListener = nmeaListener;
            this.mListener = null;
            ArrayList arrayList = new ArrayList();
            this.mNmeaBuffer = arrayList;
        }

        @Override
        public void onFirstFix(int n) {
            if (this.mListener == null) {
                return;
            }
            LocationManager.this.mGpsStatus.setTimeToFirstFix(n);
            Message message = Message.obtain();
            message.what = 3;
            boolean bl = this.mGpsHandler.sendMessage(message);
        }

        @Override
        public void onGpsStarted() {
            if (this.mListener == null) {
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            boolean bl = this.mGpsHandler.sendMessage(message);
        }

        @Override
        public void onGpsStopped() {
            if (this.mListener == null) {
                return;
            }
            Message message = Message.obtain();
            message.what = 2;
            boolean bl = this.mGpsHandler.sendMessage(message);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onNmeaReceived(long l, String string2) {
            if (this.mNmeaListener == null) {
                return;
            }
            ArrayList<Nmea> arrayList = this.mNmeaBuffer;
            synchronized (arrayList) {
                ArrayList<Nmea> arrayList2 = this.mNmeaBuffer;
                Nmea nmea = new Nmea(l, string2);
                boolean bl = arrayList2.add(nmea);
            }
            Message message = Message.obtain();
            message.what = 1000;
            this.mGpsHandler.removeMessages(1000);
            boolean bl = this.mGpsHandler.sendMessage(message);
        }

        @Override
        public void onSvStatusChanged(int n, int[] nArray, float[] fArray, float[] fArray2, float[] fArray3, int n2, int n3, int n4) {
            if (this.mListener == null) {
                return;
            }
            GpsStatus gpsStatus = LocationManager.this.mGpsStatus;
            int n5 = n;
            int[] nArray2 = nArray;
            float[] fArray4 = fArray;
            float[] fArray5 = fArray2;
            float[] fArray6 = fArray3;
            int n6 = n2;
            int n7 = n3;
            int n8 = n4;
            gpsStatus.setStatus(n5, nArray2, fArray4, fArray5, fArray6, n6, n7, n8);
            Message message = Message.obtain();
            message.what = 4;
            this.mGpsHandler.removeMessages(4);
            boolean bl = this.mGpsHandler.sendMessage(message);
        }

        private class Nmea {
            String mNmea;
            long mTimestamp;

            Nmea(long l, String string2) {
                this.mTimestamp = l;
                this.mNmea = string2;
            }
        }
    }

    private class ListenerTransport
    extends ILocationListener.Stub {
        private static final int TYPE_LOCATION_CHANGED = 1;
        private static final int TYPE_PROVIDER_DISABLED = 4;
        private static final int TYPE_PROVIDER_ENABLED = 3;
        private static final int TYPE_STATUS_CHANGED = 2;
        private LocationListener mListener;
        private final Handler mListenerHandler;

        ListenerTransport(LocationListener locationListener, Looper looper) {
            Handler handler;
            this.mListener = locationListener;
            if (looper == null) {
                Handler handler2;
                this.mListenerHandler = handler2 = new Handler(){

                    @Override
                    public void handleMessage(Message message) {
                        ListenerTransport.this._handleMessage(message);
                    }
                };
                return;
            }
            this.mListenerHandler = handler = new Handler(looper){

                @Override
                public void handleMessage(Message message) {
                    ListenerTransport.this._handleMessage(message);
                }
            };
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void _handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Location location = (Location)message.obj;
                    Location location2 = new Location(location);
                    this.mListener.onLocationChanged(location2);
                    break;
                }
                case 2: {
                    Bundle bundle = (Bundle)message.obj;
                    String string2 = bundle.getString("provider");
                    int n = bundle.getInt(LocationManager.KEY_STATUS_CHANGED);
                    Bundle bundle2 = bundle.getBundle("extras");
                    this.mListener.onStatusChanged(string2, n, bundle2);
                    break;
                }
                case 3: {
                    LocationListener locationListener = this.mListener;
                    String string3 = (String)message.obj;
                    locationListener.onProviderEnabled(string3);
                    break;
                }
                case 4: {
                    LocationListener locationListener = this.mListener;
                    String string4 = (String)message.obj;
                    locationListener.onProviderDisabled(string4);
                    break;
                }
            }
            try {
                LocationManager.this.mService.locationCallbackFinished(this);
                return;
            }
            catch (RemoteException remoteException) {
                int n = Log.e(LocationManager.TAG, "locationCallbackFinished: RemoteException", remoteException);
                return;
            }
        }

        @Override
        public void onLocationChanged(Location location) {
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            boolean bl = this.mListenerHandler.sendMessage(message);
        }

        @Override
        public void onProviderDisabled(String string2) {
            Message message = Message.obtain();
            message.what = 4;
            message.obj = string2;
            boolean bl = this.mListenerHandler.sendMessage(message);
        }

        @Override
        public void onProviderEnabled(String string2) {
            Message message = Message.obtain();
            message.what = 3;
            message.obj = string2;
            boolean bl = this.mListenerHandler.sendMessage(message);
        }

        @Override
        public void onStatusChanged(String string2, int n, Bundle bundle) {
            Message message = Message.obtain();
            message.what = 2;
            Bundle bundle2 = new Bundle();
            bundle2.putString("provider", string2);
            bundle2.putInt(LocationManager.KEY_STATUS_CHANGED, n);
            if (bundle != null) {
                bundle2.putBundle("extras", bundle);
            }
            message.obj = bundle2;
            boolean bl = this.mListenerHandler.sendMessage(message);
        }
    }
}

