/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.Criteria;
import android.location.ILocationManager;
import android.os.RemoteException;
import android.util.Log;

public abstract class LocationProvider {
    public static final int AVAILABLE = 2;
    static final String BAD_CHARS_REGEX = "[^a-zA-Z0-9]";
    public static final int OUT_OF_SERVICE = 0;
    private static final String TAG = "LocationProvider";
    public static final int TEMPORARILY_UNAVAILABLE = 1;
    private final String mName;
    private final ILocationManager mService;

    public LocationProvider(String string2, ILocationManager iLocationManager) {
        if (string2.matches(BAD_CHARS_REGEX)) {
            String string3 = "name " + string2 + " contains an illegal character";
            throw new IllegalArgumentException(string3);
        }
        this.mName = string2;
        this.mService = iLocationManager;
    }

    public abstract int getAccuracy();

    public String getName() {
        return this.mName;
    }

    public abstract int getPowerRequirement();

    public abstract boolean hasMonetaryCost();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean meetsCriteria(Criteria criteria) {
        try {
            ILocationManager iLocationManager = this.mService;
            String string2 = this.mName;
            boolean bl = iLocationManager.providerMeetsCriteria(string2, criteria);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "meetsCriteria: RemoteException", remoteException);
            return false;
        }
    }

    public abstract boolean requiresCell();

    public abstract boolean requiresNetwork();

    public abstract boolean requiresSatellite();

    public abstract boolean supportsAltitude();

    public abstract boolean supportsBearing();

    public abstract boolean supportsSpeed();
}

