/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.io.IOException;
import java.io.InputStream;

public final class AmrInputStream
extends InputStream {
    private static final int SAMPLES_PER_FRAME = 160;
    private static final String TAG = "AmrInputStream";
    private byte[] mBuf;
    private int mBufIn;
    private int mBufOut;
    private int mGae;
    private InputStream mInputStream;
    private byte[] mOneByte;

    static {
        System.loadLibrary("media_jni");
    }

    public AmrInputStream(InputStream inputStream) {
        int n;
        byte[] byArray = new byte[320];
        this.mBuf = byArray;
        this.mBufIn = 0;
        this.mBufOut = 0;
        byte[] byArray2 = new byte[1];
        this.mOneByte = byArray2;
        this.mInputStream = inputStream;
        this.mGae = n = AmrInputStream.GsmAmrEncoderNew();
        AmrInputStream.GsmAmrEncoderInitialize(this.mGae);
    }

    private static native void GsmAmrEncoderCleanup(int var0);

    private static native void GsmAmrEncoderDelete(int var0);

    private static native int GsmAmrEncoderEncode(int var0, byte[] var1, int var2, byte[] var3, int var4) throws IOException;

    private static native void GsmAmrEncoderInitialize(int var0);

    private static native int GsmAmrEncoderNew();

    @Override
    public void close() throws IOException {
        block23: {
            try {
                if (this.mInputStream != null) {
                    this.mInputStream.close();
                }
                this.mInputStream = null;
            }
            catch (Throwable throwable) {
                block24: {
                    this.mInputStream = null;
                    try {
                        if (this.mGae == 0) break block24;
                        AmrInputStream.GsmAmrEncoderCleanup(this.mGae);
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (this.mGae != 0) {
                                AmrInputStream.GsmAmrEncoderDelete(this.mGae);
                            }
                            throw throwable2;
                        }
                        finally {
                            this.mGae = 0;
                        }
                    }
                }
                try {
                    if (this.mGae != 0) {
                        AmrInputStream.GsmAmrEncoderDelete(this.mGae);
                    }
                    throw throwable;
                }
                finally {
                    this.mGae = 0;
                }
            }
            try {
                if (this.mGae == 0) break block23;
                AmrInputStream.GsmAmrEncoderCleanup(this.mGae);
            }
            catch (Throwable throwable) {
                try {
                    if (this.mGae != 0) {
                        AmrInputStream.GsmAmrEncoderDelete(this.mGae);
                    }
                    throw throwable;
                }
                finally {
                    this.mGae = 0;
                }
            }
        }
        try {
            if (this.mGae != 0) {
                AmrInputStream.GsmAmrEncoderDelete(this.mGae);
            }
            return;
        }
        finally {
            this.mGae = 0;
        }
    }

    protected void finalize() throws Throwable {
        if (this.mGae == 0) {
            return;
        }
        this.close();
        throw new IllegalStateException("someone forgot to close AmrInputStream");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        byte[] byArray = this.mOneByte;
        if (this.read(byArray, 0, 1) != 1) return -1;
        return this.mOneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = byArray.length;
        return this.read(byArray, 0, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.mGae == 0) {
            throw new IllegalStateException("not open");
        }
        int n7 = this.mBufOut;
        int n8 = this.mBufIn;
        if (n7 >= n8) {
            int n9;
            int n10;
            this.mBufOut = 0;
            this.mBufIn = 0;
            for (int i = 0; i < 320; i += n10) {
                InputStream inputStream = this.mInputStream;
                byte[] byArray2 = this.mBuf;
                int n11 = 320 - i;
                n10 = inputStream.read(byArray2, i, n11);
                if (n10 != -1) continue;
                return -1;
            }
            int n12 = this.mGae;
            byte[] byArray3 = this.mBuf;
            byte[] byArray4 = this.mBuf;
            this.mBufIn = n9 = AmrInputStream.GsmAmrEncoderEncode(n12, byArray3, 0, byArray4, 0);
        }
        if (n2 > (n6 = (n5 = this.mBufIn) - (n4 = this.mBufOut))) {
            int n13 = this.mBufIn;
            int n14 = this.mBufOut;
            n2 = n13 - n14;
        }
        byte[] byArray5 = this.mBuf;
        int n15 = this.mBufOut;
        System.arraycopy(byArray5, n15, byArray, n, n2);
        this.mBufOut = n3 = this.mBufOut + n2;
        return n2;
    }
}

