/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import java.util.LinkedList;

public class AsyncPlayer {
    private static final int PLAY = 1;
    private static final int STOP = 2;
    private static final boolean mDebug;
    private LinkedList<Command> mCmdQueue;
    private MediaPlayer mPlayer;
    private int mState;
    private String mTag;
    private Thread mThread;
    private PowerManager.WakeLock mWakeLock;

    public AsyncPlayer(String string2) {
        LinkedList linkedList = new LinkedList();
        this.mCmdQueue = linkedList;
        this.mState = 2;
        if (string2 != null) {
            this.mTag = string2;
            return;
        }
        this.mTag = "AsyncPlayer";
    }

    static /* synthetic */ MediaPlayer access$302(AsyncPlayer asyncPlayer, MediaPlayer mediaPlayer) {
        asyncPlayer.mPlayer = mediaPlayer;
        return mediaPlayer;
    }

    static /* synthetic */ Thread access$402(AsyncPlayer asyncPlayer, Thread thread) {
        asyncPlayer.mThread = thread;
        return thread;
    }

    private void acquireWakeLock() {
        if (this.mWakeLock == null) {
            return;
        }
        this.mWakeLock.acquire();
    }

    private void enqueueLocked(Command command) {
        Thread thread;
        boolean bl = this.mCmdQueue.add(command);
        if (this.mThread != null) {
            return;
        }
        this.acquireWakeLock();
        this.mThread = thread = new Thread();
        this.mThread.start();
    }

    private void releaseWakeLock() {
        if (this.mWakeLock == null) {
            return;
        }
        this.mWakeLock.release();
    }

    private void startSound(Command command) {
        try {
            long l;
            MediaPlayer mediaPlayer = new MediaPlayer();
            int n = command.stream;
            mediaPlayer.setAudioStreamType(n);
            Context context = command.context;
            Uri uri = command.uri;
            mediaPlayer.setDataSource(context, uri);
            boolean bl = command.looping;
            mediaPlayer.setLooping(bl);
            mediaPlayer.prepare();
            mediaPlayer.start();
            if (this.mPlayer != null) {
                this.mPlayer.release();
            }
            this.mPlayer = mediaPlayer;
            long l2 = SystemClock.uptimeMillis();
            long l3 = l2 - (l = command.requestTime);
            if (l3 <= 1000L) {
                return;
            }
            String string2 = this.mTag;
            String string3 = "Notification sound delayed by " + l3 + "msecs";
            int n2 = Log.w(string2, string3);
            return;
        }
        catch (Exception exception) {
            String string4 = this.mTag;
            StringBuilder stringBuilder = new StringBuilder().append("error loading sound for ");
            Uri uri = command.uri;
            String string5 = stringBuilder.append(uri).toString();
            int n = Log.w(string4, string5, exception);
            return;
        }
    }

    public void play(Context context, Uri uri, boolean bl, int n) {
        long l;
        Command command = new Command();
        command.requestTime = l = SystemClock.uptimeMillis();
        command.code = 1;
        command.context = context;
        command.uri = uri;
        command.looping = bl;
        command.stream = n;
        LinkedList<Command> linkedList = this.mCmdQueue;
        synchronized (linkedList) {
            this.enqueueLocked(command);
            this.mState = 1;
            return;
        }
    }

    public void setUsesWakeLock(Context context) {
        PowerManager.WakeLock wakeLock;
        if (this.mWakeLock != null || this.mThread != null) {
            StringBuilder stringBuilder = new StringBuilder().append("assertion failed mWakeLock=");
            PowerManager.WakeLock wakeLock2 = this.mWakeLock;
            StringBuilder stringBuilder2 = stringBuilder.append(wakeLock2).append(" mThread=");
            Thread thread = this.mThread;
            String string2 = stringBuilder2.append(thread).toString();
            throw new RuntimeException(string2);
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        String string3 = this.mTag;
        this.mWakeLock = wakeLock = powerManager.newWakeLock(1, string3);
    }

    public void stop() {
        LinkedList<Command> linkedList = this.mCmdQueue;
        synchronized (linkedList) {
            if (this.mState != 2) {
                long l;
                Command command = new Command();
                command.requestTime = l = SystemClock.uptimeMillis();
                command.code = 2;
                this.enqueueLocked(command);
                this.mState = 2;
            }
            return;
        }
    }

    private final class Thread
    extends java.lang.Thread {
        Thread() {
            StringBuilder stringBuilder = new StringBuilder().append("AsyncPlayer-");
            String string2 = AsyncPlayer.this.mTag;
            String string3 = stringBuilder.append(string2).toString();
            super(string3);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                Command command;
                LinkedList linkedList = AsyncPlayer.this.mCmdQueue;
                synchronized (linkedList) {
                    command = (Command)AsyncPlayer.this.mCmdQueue.removeFirst();
                }
                switch (command.code) {
                    case 1: {
                        AsyncPlayer.this.startSound(command);
                        break;
                    }
                    case 2: {
                        if (AsyncPlayer.this.mPlayer != null) {
                            long l;
                            long l2 = SystemClock.uptimeMillis();
                            long l3 = l2 - (l = command.requestTime);
                            if (l3 > 1000L) {
                                String string2 = AsyncPlayer.this.mTag;
                                String string3 = "Notification stop delayed by " + l3 + "msecs";
                                int n = Log.w(string2, string3);
                            }
                            AsyncPlayer.this.mPlayer.stop();
                            AsyncPlayer.this.mPlayer.release();
                            MediaPlayer mediaPlayer = AsyncPlayer.access$302(AsyncPlayer.this, null);
                            break;
                        }
                        int n = Log.w(AsyncPlayer.this.mTag, "STOP command without a player");
                    }
                }
                LinkedList linkedList2 = AsyncPlayer.this.mCmdQueue;
                synchronized (linkedList2) {
                    if (AsyncPlayer.this.mCmdQueue.size() == 0) {
                        Thread thread = AsyncPlayer.access$402(AsyncPlayer.this, null);
                        AsyncPlayer.this.releaseWakeLock();
                        return;
                    }
                }
            }
        }
    }

    private static final class Command {
        int code;
        Context context;
        boolean looping;
        long requestTime;
        int stream;
        Uri uri;

        private Command() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("{ code=");
            int n = this.code;
            StringBuilder stringBuilder2 = stringBuilder.append(n).append(" looping=");
            boolean bl = this.looping;
            StringBuilder stringBuilder3 = stringBuilder2.append(bl).append(" stream=");
            int n2 = this.stream;
            StringBuilder stringBuilder4 = stringBuilder3.append(n2).append(" uri=");
            Uri uri = this.uri;
            return stringBuilder4.append(uri).append(" }").toString();
        }
    }
}

