/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ComponentName;
import android.content.Context;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioService;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Log;
import java.util.HashMap;

public class AudioManager {
    public static final String ACTION_AUDIO_BECOMING_NOISY = "android.media.AUDIO_BECOMING_NOISY";
    public static final String ACTION_SCO_AUDIO_STATE_CHANGED = "android.media.SCO_AUDIO_STATE_CHANGED";
    public static final int ADJUST_LOWER = 255;
    public static final int ADJUST_RAISE = 1;
    public static final int ADJUST_SAME = 0;
    public static final int AUDIOFOCUS_GAIN = 1;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT = 2;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK = 3;
    public static final int AUDIOFOCUS_LOSS = 255;
    public static final int AUDIOFOCUS_LOSS_TRANSIENT = 254;
    public static final int AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK = 253;
    public static final int AUDIOFOCUS_REQUEST_FAILED = 0;
    public static final int AUDIOFOCUS_REQUEST_GRANTED = 1;
    private static boolean DEBUG = false;
    public static final int[] DEFAULT_STREAM_VOLUME;
    public static final String EXTRA_PREV_VOLUME_STREAM_VALUE = "android.media.EXTRA_PREV_VOLUME_STREAM_VALUE";
    public static final String EXTRA_RINGER_MODE = "android.media.EXTRA_RINGER_MODE";
    public static final String EXTRA_SCO_AUDIO_STATE = "android.media.extra.SCO_AUDIO_STATE";
    public static final String EXTRA_VIBRATE_SETTING = "android.media.EXTRA_VIBRATE_SETTING";
    public static final String EXTRA_VIBRATE_TYPE = "android.media.EXTRA_VIBRATE_TYPE";
    public static final String EXTRA_VOLUME_STREAM_TYPE = "android.media.EXTRA_VOLUME_STREAM_TYPE";
    public static final String EXTRA_VOLUME_STREAM_VALUE = "android.media.EXTRA_VOLUME_STREAM_VALUE";
    public static final int FLAG_ALLOW_RINGER_MODES = 2;
    public static final int FLAG_PLAY_SOUND = 4;
    public static final int FLAG_REMOVE_SOUND_AND_VIBRATE = 8;
    public static final int FLAG_SHOW_UI = 1;
    public static final int FLAG_VIBRATE = 16;
    public static final int FX_FOCUS_NAVIGATION_DOWN = 2;
    public static final int FX_FOCUS_NAVIGATION_LEFT = 3;
    public static final int FX_FOCUS_NAVIGATION_RIGHT = 4;
    public static final int FX_FOCUS_NAVIGATION_UP = 1;
    public static final int FX_KEYPRESS_DELETE = 7;
    public static final int FX_KEYPRESS_RETURN = 8;
    public static final int FX_KEYPRESS_SPACEBAR = 6;
    public static final int FX_KEYPRESS_STANDARD = 5;
    public static final int FX_KEY_CLICK = 0;
    public static final int MODE_CURRENT = 255;
    public static final int MODE_INVALID = 254;
    public static final int MODE_IN_CALL = 2;
    public static final int MODE_IN_COMMUNICATION = 3;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_RINGTONE = 1;
    public static final int NUM_SOUND_EFFECTS = 9;
    @Deprecated
    public static final int NUM_STREAMS = 5;
    public static final String RINGER_MODE_CHANGED_ACTION = "android.media.RINGER_MODE_CHANGED";
    public static final int RINGER_MODE_NORMAL = 2;
    public static final int RINGER_MODE_SILENT = 0;
    public static final int RINGER_MODE_VIBRATE = 1;
    @Deprecated
    public static final int ROUTE_ALL = 255;
    @Deprecated
    public static final int ROUTE_BLUETOOTH = 4;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_A2DP = 16;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_SCO = 4;
    @Deprecated
    public static final int ROUTE_EARPIECE = 1;
    @Deprecated
    public static final int ROUTE_HEADSET = 8;
    @Deprecated
    public static final int ROUTE_SPEAKER = 2;
    public static final int SCO_AUDIO_STATE_CONNECTED = 1;
    public static final int SCO_AUDIO_STATE_DISCONNECTED = 0;
    public static final int SCO_AUDIO_STATE_ERROR = 255;
    public static final int STREAM_ALARM = 4;
    public static final int STREAM_BLUETOOTH_SCO = 6;
    public static final int STREAM_DTMF = 8;
    public static final int STREAM_MUSIC = 3;
    public static final int STREAM_NOTIFICATION = 5;
    public static final int STREAM_RING = 2;
    public static final int STREAM_SYSTEM = 1;
    public static final int STREAM_SYSTEM_ENFORCED = 7;
    public static final int STREAM_TTS = 9;
    public static final int STREAM_VOICE_CALL = 0;
    private static String TAG;
    public static final int USE_DEFAULT_STREAM_TYPE = Integer.MIN_VALUE;
    public static final String VIBRATE_SETTING_CHANGED_ACTION = "android.media.VIBRATE_SETTING_CHANGED";
    public static final int VIBRATE_SETTING_OFF = 0;
    public static final int VIBRATE_SETTING_ON = 1;
    public static final int VIBRATE_SETTING_ONLY_SILENT = 2;
    public static final int VIBRATE_TYPE_NOTIFICATION = 1;
    public static final int VIBRATE_TYPE_RINGER = 0;
    public static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    private static boolean localLOGV;
    private static IAudioService sService;
    private IAudioFocusDispatcher mAudioFocusDispatcher;
    private FocusEventHandlerDelegate mAudioFocusEventHandlerDelegate;
    private HashMap<String, OnAudioFocusChangeListener> mAudioFocusIdListenerMap;
    private final Context mContext;
    private final Object mFocusListenerLock;
    private final Handler mHandler;
    private IBinder mICallBack;

    /*
     * Enabled aggressive block sorting
     */
    static {
        TAG = "AudioManager";
        DEBUG = false;
        boolean bl = DEBUG;
        localLOGV = bl;
        DEFAULT_STREAM_VOLUME = new int[]{4, 7, 5, 11, 6, 5, 7, 7, 11, 11};
    }

    public AudioManager(Context context) {
        Handler handler;
        FocusEventHandlerDelegate focusEventHandlerDelegate;
        Object object;
        HashMap hashMap = new HashMap();
        this.mAudioFocusIdListenerMap = hashMap;
        this.mFocusListenerLock = object = new Object();
        this.mAudioFocusEventHandlerDelegate = focusEventHandlerDelegate = new FocusEventHandlerDelegate();
        IAudioFocusDispatcher.Stub stub = new IAudioFocusDispatcher.Stub(){

            @Override
            public void dispatchAudioFocusChange(int n, String string2) {
                Message message = AudioManager.this.mAudioFocusEventHandlerDelegate.getHandler().obtainMessage(n, string2);
                boolean bl = AudioManager.this.mAudioFocusEventHandlerDelegate.getHandler().sendMessage(message);
            }
        };
        this.mAudioFocusDispatcher = stub;
        Binder binder = new Binder();
        this.mICallBack = binder;
        this.mContext = context;
        Looper looper = context.getMainLooper();
        this.mHandler = handler = new Handler(looper);
    }

    private OnAudioFocusChangeListener findFocusListener(String string2) {
        return this.mAudioFocusIdListenerMap.get(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getIdForAudioFocusListener(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        if (onAudioFocusChangeListener == null) {
            String string2 = this.toString();
            return new String(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = this.toString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        String string4 = onAudioFocusChangeListener.toString();
        String string5 = stringBuilder2.append(string4).toString();
        return new String(string5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IAudioService getService() {
        if (sService == null) return sService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
        return sService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean querySoundEffectsEnabled() {
        if (Settings.System.getInt(this.mContext.getContentResolver(), "sound_effects_enabled", 0) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int abandonAudioFocus(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        int n = 0;
        this.unregisterAudioFocusListener(onAudioFocusChangeListener);
        IAudioService iAudioService = AudioManager.getService();
        try {
            IAudioFocusDispatcher iAudioFocusDispatcher = this.mAudioFocusDispatcher;
            String string2 = this.getIdForAudioFocusListener(onAudioFocusChangeListener);
            int n2 = iAudioService.abandonAudioFocus(iAudioFocusDispatcher, string2);
            return n2;
        }
        catch (RemoteException remoteException) {
            String string3 = TAG;
            String string4 = "Can't call abandonAudioFocus() from AudioService due to " + remoteException;
            int n3 = Log.e(string3, string4);
            return n;
        }
    }

    public void adjustStreamVolume(int n, int n2, int n3) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.adjustStreamVolume(n, n2, n3);
            return;
        }
        catch (RemoteException remoteException) {
            int n4 = Log.e(TAG, "Dead object in adjustStreamVolume", remoteException);
            return;
        }
    }

    public void adjustSuggestedStreamVolume(int n, int n2, int n3) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.adjustSuggestedStreamVolume(n, n2, n3);
            return;
        }
        catch (RemoteException remoteException) {
            int n4 = Log.e(TAG, "Dead object in adjustVolume", remoteException);
            return;
        }
    }

    public void adjustVolume(int n, int n2) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.adjustVolume(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "Dead object in adjustVolume", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMode() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n = iAudioService.getMode();
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Dead object in getMode", remoteException);
            return -1;
        }
    }

    public String getParameters(String string2) {
        return AudioSystem.getParameters(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRingerMode() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n = iAudioService.getRingerMode();
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Dead object in getRingerMode", remoteException);
            return 2;
        }
    }

    @Deprecated
    public int getRouting(int n) {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getStreamMaxVolume(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n2 = iAudioService.getStreamMaxVolume(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "Dead object in getStreamMaxVolume", remoteException);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getStreamVolume(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n2 = iAudioService.getStreamVolume(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "Dead object in getStreamVolume", remoteException);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getVibrateSetting(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n2 = iAudioService.getVibrateSetting(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "Dead object in getVibrateSetting", remoteException);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBluetoothA2dpOn() {
        if (AudioSystem.getDeviceConnectionState(128, "") != 0) return true;
        return false;
    }

    public boolean isBluetoothScoAvailableOffCall() {
        return this.mContext.getResources().getBoolean(0x10D0011);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBluetoothScoOn() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            boolean bl = iAudioService.isBluetoothScoOn();
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Dead object in isBluetoothScoOn", remoteException);
            return false;
        }
    }

    public boolean isMicrophoneMute() {
        return AudioSystem.isMicrophoneMuted();
    }

    public boolean isMusicActive() {
        return AudioSystem.isStreamActive(3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSpeakerphoneOn() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            boolean bl = iAudioService.isSpeakerphoneOn();
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Dead object in isSpeakerphoneOn", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWiredHeadsetOn() {
        if (AudioSystem.getDeviceConnectionState(4, "") != 0) return true;
        if (AudioSystem.getDeviceConnectionState(8, "") != 0) return true;
        return false;
    }

    public void loadSoundEffects() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            boolean bl = iAudioService.loadSoundEffects();
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = TAG;
            String string3 = "Dead object in loadSoundEffects" + remoteException;
            int n = Log.e(string2, string3);
            return;
        }
    }

    public void playSoundEffect(int n) {
        if (n < 0) {
            return;
        }
        if (n >= 9) {
            return;
        }
        if (!this.querySoundEffectsEnabled()) {
            return;
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.playSoundEffect(n);
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = TAG;
            String string3 = "Dead object in playSoundEffect" + remoteException;
            int n2 = Log.e(string2, string3);
            return;
        }
    }

    public void playSoundEffect(int n, float f) {
        if (n < 0) {
            return;
        }
        if (n >= 9) {
            return;
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.playSoundEffectVolume(n, f);
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = TAG;
            String string3 = "Dead object in playSoundEffect" + remoteException;
            int n2 = Log.e(string2, string3);
            return;
        }
    }

    public void registerAudioFocusListener(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        Object object = this.mFocusListenerLock;
        synchronized (object) {
            HashMap<String, OnAudioFocusChangeListener> hashMap = this.mAudioFocusIdListenerMap;
            String string2 = this.getIdForAudioFocusListener(onAudioFocusChangeListener);
            if (hashMap.containsKey(string2)) {
                return;
            }
            HashMap<String, OnAudioFocusChangeListener> hashMap2 = this.mAudioFocusIdListenerMap;
            String string3 = this.getIdForAudioFocusListener(onAudioFocusChangeListener);
            OnAudioFocusChangeListener onAudioFocusChangeListener2 = hashMap2.put(string3, onAudioFocusChangeListener);
            return;
        }
    }

    public void registerMediaButtonEventReceiver(ComponentName componentName) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.registerMediaButtonEventReceiver(componentName);
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = TAG;
            String string3 = "Dead object in registerMediaButtonEventReceiver" + remoteException;
            int n = Log.e(string2, string3);
            return;
        }
    }

    public void reloadAudioSettings() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.reloadAudioSettings();
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = TAG;
            String string3 = "Dead object in reloadAudioSettings" + remoteException;
            int n = Log.e(string2, string3);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int requestAudioFocus(OnAudioFocusChangeListener onAudioFocusChangeListener, int n, int n2) {
        int n3 = 0;
        if (n2 < 1 || n2 > 3) {
            int n4 = Log.e(TAG, "Invalid duration hint, audio focus request denied");
            return 0;
        }
        this.registerAudioFocusListener(onAudioFocusChangeListener);
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n5;
            IBinder iBinder = this.mICallBack;
            IAudioFocusDispatcher iAudioFocusDispatcher = this.mAudioFocusDispatcher;
            String string2 = this.getIdForAudioFocusListener(onAudioFocusChangeListener);
            int n6 = n;
            int n7 = n2;
            n3 = n5 = iAudioService.requestAudioFocus(n6, n7, iBinder, iAudioFocusDispatcher, string2);
            return n3;
        }
        catch (RemoteException remoteException) {
            String string3 = TAG;
            String string4 = "Can't call requestAudioFocus() from AudioService due to " + remoteException;
            int n8 = Log.e(string3, string4);
            return n3;
        }
    }

    @Deprecated
    public void setBluetoothA2dpOn(boolean bl) {
    }

    public void setBluetoothScoOn(boolean bl) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setBluetoothScoOn(bl);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Dead object in setBluetoothScoOn", remoteException);
            return;
        }
    }

    public void setMicrophoneMute(boolean bl) {
        int n = AudioSystem.muteMicrophone(bl);
    }

    public void setMode(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            IBinder iBinder = this.mICallBack;
            iAudioService.setMode(n, iBinder);
            return;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "Dead object in setMode", remoteException);
            return;
        }
    }

    @Deprecated
    public void setParameter(String string2, String string3) {
        String string4 = string2 + "=" + string3;
        this.setParameters(string4);
    }

    public void setParameters(String string2) {
        int n = AudioSystem.setParameters(string2);
    }

    public void setRingerMode(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setRingerMode(n);
            return;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "Dead object in setRingerMode", remoteException);
            return;
        }
    }

    @Deprecated
    public void setRouting(int n, int n2, int n3) {
    }

    public void setSpeakerphoneOn(boolean bl) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setSpeakerphoneOn(bl);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Dead object in setSpeakerphoneOn", remoteException);
            return;
        }
    }

    public void setStreamMute(int n, boolean bl) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            IBinder iBinder = this.mICallBack;
            iAudioService.setStreamMute(n, bl, iBinder);
            return;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "Dead object in setStreamMute", remoteException);
            return;
        }
    }

    public void setStreamSolo(int n, boolean bl) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            IBinder iBinder = this.mICallBack;
            iAudioService.setStreamSolo(n, bl, iBinder);
            return;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "Dead object in setStreamSolo", remoteException);
            return;
        }
    }

    public void setStreamVolume(int n, int n2, int n3) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setStreamVolume(n, n2, n3);
            return;
        }
        catch (RemoteException remoteException) {
            int n4 = Log.e(TAG, "Dead object in setStreamVolume", remoteException);
            return;
        }
    }

    public void setVibrateSetting(int n, int n2) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setVibrateSetting(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "Dead object in setVibrateSetting", remoteException);
            return;
        }
    }

    @Deprecated
    public void setWiredHeadsetOn(boolean bl) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldVibrate(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            boolean bl = iAudioService.shouldVibrate(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "Dead object in shouldVibrate", remoteException);
            return false;
        }
    }

    public void startBluetoothSco() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            IBinder iBinder = this.mICallBack;
            iAudioService.startBluetoothSco(iBinder);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Dead object in startBluetoothSco", remoteException);
            return;
        }
    }

    public void stopBluetoothSco() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            IBinder iBinder = this.mICallBack;
            iAudioService.stopBluetoothSco(iBinder);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Dead object in stopBluetoothSco", remoteException);
            return;
        }
    }

    public void unloadSoundEffects() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.unloadSoundEffects();
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = TAG;
            String string3 = "Dead object in unloadSoundEffects" + remoteException;
            int n = Log.e(string2, string3);
            return;
        }
    }

    public void unregisterAudioFocusListener(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        Object object = this.mFocusListenerLock;
        synchronized (object) {
            HashMap<String, OnAudioFocusChangeListener> hashMap = this.mAudioFocusIdListenerMap;
            String string2 = this.getIdForAudioFocusListener(onAudioFocusChangeListener);
            OnAudioFocusChangeListener onAudioFocusChangeListener2 = hashMap.remove(string2);
            return;
        }
    }

    public void unregisterMediaButtonEventReceiver(ComponentName componentName) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.unregisterMediaButtonEventReceiver(componentName);
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = TAG;
            String string3 = "Dead object in unregisterMediaButtonEventReceiver" + remoteException;
            int n = Log.e(string2, string3);
            return;
        }
    }

    private class FocusEventHandlerDelegate {
        private final Handler mHandler;

        FocusEventHandlerDelegate() {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                looper = Looper.getMainLooper();
            }
            if (looper != null) {
                Handler handler;
                this.mHandler = handler = new Handler(looper){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void handleMessage(Message message) {
                        Object object = AudioManager.this.mFocusListenerLock;
                        // MONITORENTER : object
                        AudioManager audioManager = AudioManager.this;
                        String string2 = (String)message.obj;
                        OnAudioFocusChangeListener onAudioFocusChangeListener = audioManager.findFocusListener(string2);
                        // MONITOREXIT : object
                        if (onAudioFocusChangeListener == null) {
                            return;
                        }
                        int n = message.what;
                        onAudioFocusChangeListener.onAudioFocusChange(n);
                    }
                };
                return;
            }
            this.mHandler = null;
        }

        Handler getHandler() {
            return this.mHandler;
        }
    }

    public static interface OnAudioFocusChangeListener {
        public void onAudioFocusChange(int var1);
    }
}

