/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public class AudioRecord {
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDCHANNELMASK = 239;
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDFORMAT = 238;
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDSOURCE = 237;
    private static final int AUDIORECORD_ERROR_SETUP_NATIVEINITFAILED = 236;
    private static final int AUDIORECORD_ERROR_SETUP_ZEROFRAMECOUNT = 240;
    public static final int ERROR = 255;
    public static final int ERROR_BAD_VALUE = 254;
    public static final int ERROR_INVALID_OPERATION = 253;
    private static final int NATIVE_EVENT_MARKER = 2;
    private static final int NATIVE_EVENT_NEW_POS = 3;
    public static final int RECORDSTATE_RECORDING = 3;
    public static final int RECORDSTATE_STOPPED = 1;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int SUCCESS = 0;
    private static final String TAG = "AudioRecord-Java";
    private int mAudioFormat = 2;
    private int mChannelConfiguration = 16;
    private int mChannelCount = 1;
    private int mChannels = 16;
    private NativeEventHandler mEventHandler;
    private Looper mInitializationLooper;
    private int mNativeBufferSizeInBytes;
    private int mNativeCallbackCookie;
    private int mNativeRecorderInJavaObj;
    private OnRecordPositionUpdateListener mPositionListener;
    private final Object mPositionListenerLock;
    private int mRecordSource = 0;
    private int mRecordingState = 1;
    private Object mRecordingStateLock;
    private int mSampleRate = 22050;
    private int mState = 0;

    public AudioRecord(int n, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        Looper looper;
        Object object;
        Object object2;
        this.mRecordingStateLock = object2 = new Object();
        this.mPositionListener = null;
        this.mPositionListenerLock = object = new Object();
        this.mEventHandler = null;
        this.mInitializationLooper = null;
        this.mNativeBufferSizeInBytes = 0;
        this.mState = 0;
        this.mRecordingState = 1;
        this.mInitializationLooper = looper = Looper.myLooper();
        if (looper == null) {
            Looper looper2;
            this.mInitializationLooper = looper2 = Looper.getMainLooper();
        }
        this.audioParamCheck(n, n2, n3, n4);
        this.audioBuffSizeCheck(n5);
        WeakReference<AudioRecord> weakReference = new WeakReference<AudioRecord>(this);
        int n6 = this.mRecordSource;
        int n7 = this.mSampleRate;
        int n8 = this.mChannels;
        int n9 = this.mAudioFormat;
        int n10 = this.mNativeBufferSizeInBytes;
        int n11 = this.native_setup(weakReference, n6, n7, n8, n9, n10);
        if (n11 != 0) {
            AudioRecord.loge("Error code " + n11 + " when initializing native AudioRecord object.");
            return;
        }
        this.mState = 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void audioBuffSizeCheck(int n) {
        int n2 = this.mChannelCount;
        int n3 = this.mAudioFormat == 3 ? 1 : 2;
        int n4 = n2 * n3;
        if (n % n4 == 0 && n >= 1) {
            this.mNativeBufferSizeInBytes = n;
            return;
        }
        throw new IllegalArgumentException("Invalid audio buffer size.");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void audioParamCheck(int n, int n2, int n3, int n4) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("Invalid audio source.");
        }
        this.mRecordSource = n;
        if (n2 < 4000 || n2 > 48000) {
            String string2 = n2 + "Hz is not a supported sample rate.";
            throw new IllegalArgumentException(string2);
        }
        this.mSampleRate = n2;
        this.mChannelConfiguration = n3;
        switch (n3) {
            default: {
                this.mChannelCount = 0;
                this.mChannels = 0;
                this.mChannelConfiguration = 0;
                throw new IllegalArgumentException("Unsupported channel configuration.");
            }
            case 1: 
            case 2: 
            case 16: {
                this.mChannelCount = 1;
                this.mChannels = 16;
                break;
            }
            case 3: 
            case 12: {
                this.mChannelCount = 2;
                this.mChannels = 12;
            }
        }
        switch (n4) {
            default: {
                this.mAudioFormat = 0;
                throw new IllegalArgumentException("Unsupported sample encoding. Should be ENCODING_PCM_8BIT or ENCODING_PCM_16BIT.");
            }
            case 1: {
                this.mAudioFormat = 2;
                return;
            }
            case 2: 
            case 3: 
        }
        this.mAudioFormat = n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getMinBufferSize(int n, int n2, int n3) {
        int n4;
        switch (n2) {
            default: {
                AudioRecord.loge("getMinBufferSize(): Invalid channel configuration.");
                return -1;
            }
            case 1: 
            case 2: 
            case 16: {
                n4 = 1;
                break;
            }
            case 3: 
            case 12: {
                n4 = 2;
            }
        }
        if (n3 != 2) {
            AudioRecord.loge("getMinBufferSize(): Invalid audio format.");
            return -1;
        }
        int n5 = AudioRecord.native_get_min_buff_size(n, n4, n3);
        if (n5 == 0) {
            return -1;
        }
        if (n5 != -1) return n5;
        return -1;
    }

    private static void logd(String string2) {
        String string3 = "[ android.media.AudioRecord ] " + string2;
        int n = Log.d(TAG, string3);
    }

    private static void loge(String string2) {
        String string3 = "[ android.media.AudioRecord ] " + string2;
        int n = Log.e(TAG, string3);
    }

    private final native void native_finalize();

    private final native int native_get_marker_pos();

    private static final native int native_get_min_buff_size(int var0, int var1, int var2);

    private final native int native_get_pos_update_period();

    private final native int native_read_in_byte_array(byte[] var1, int var2, int var3);

    private final native int native_read_in_direct_buffer(Object var1, int var2);

    private final native int native_read_in_short_array(short[] var1, int var2, int var3);

    private final native void native_release();

    private final native int native_set_marker_pos(int var1);

    private final native int native_set_pos_update_period(int var1);

    private final native int native_setup(Object var1, int var2, int var3, int var4, int var5, int var6);

    private final native int native_start();

    private final native void native_stop();

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        AudioRecord audioRecord = (AudioRecord)((WeakReference)object).get();
        if (audioRecord == null) {
            return;
        }
        if (audioRecord.mEventHandler == null) {
            return;
        }
        Message message = audioRecord.mEventHandler.obtainMessage(n, n2, n3, object2);
        boolean bl = audioRecord.mEventHandler.sendMessage(message);
    }

    protected void finalize() {
        this.native_finalize();
    }

    public int getAudioFormat() {
        return this.mAudioFormat;
    }

    public int getAudioSource() {
        return this.mRecordSource;
    }

    public int getChannelConfiguration() {
        return this.mChannelConfiguration;
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    public int getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    public int getRecordingState() {
        return this.mRecordingState;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getState() {
        return this.mState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(ByteBuffer byteBuffer, int n) {
        if (this.mState != 1) {
            return -1;
        }
        if (byteBuffer == null) return -1;
        if (n >= 0) return this.native_read_in_direct_buffer(byteBuffer, n);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(byte[] byArray, int n, int n2) {
        if (this.mState != 1) {
            return -1;
        }
        if (byArray == null) return -1;
        if (n < 0) return -1;
        if (n2 < 0) return -1;
        int n3 = n + n2;
        int n4 = byArray.length;
        if (n3 <= n4) return this.native_read_in_byte_array(byArray, n, n2);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(short[] sArray, int n, int n2) {
        if (this.mState != 1) {
            return -1;
        }
        if (sArray == null) return -1;
        if (n < 0) return -1;
        if (n2 < 0) return -1;
        int n3 = n + n2;
        int n4 = sArray.length;
        if (n3 <= n4) return this.native_read_in_short_array(sArray, n, n2);
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {}
        this.native_release();
        this.mState = 0;
    }

    public int setNotificationMarkerPosition(int n) {
        return this.native_set_marker_pos(n);
    }

    public int setPositionNotificationPeriod(int n) {
        return this.native_set_pos_update_period(n);
    }

    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener onRecordPositionUpdateListener) {
        this.setRecordPositionUpdateListener(onRecordPositionUpdateListener, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener onRecordPositionUpdateListener, Handler handler) {
        Object object = this.mPositionListenerLock;
        synchronized (object) {
            this.mPositionListener = onRecordPositionUpdateListener;
            if (onRecordPositionUpdateListener != null) {
                if (handler != null) {
                    NativeEventHandler nativeEventHandler;
                    Looper looper = handler.getLooper();
                    this.mEventHandler = nativeEventHandler = new NativeEventHandler(this, looper);
                } else {
                    NativeEventHandler nativeEventHandler;
                    Looper looper = this.mInitializationLooper;
                    this.mEventHandler = nativeEventHandler = new NativeEventHandler(this, looper);
                }
            } else {
                Object var9_8 = null;
                this.mEventHandler = var9_8;
            }
            return;
        }
    }

    public void startRecording() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("startRecording() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            if (this.native_start() == 0) {
                this.mRecordingState = 3;
            }
            return;
        }
    }

    public void stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            this.native_stop();
            this.mRecordingState = 1;
            return;
        }
    }

    private class NativeEventHandler
    extends Handler {
        private final AudioRecord mAudioRecord;

        NativeEventHandler(AudioRecord audioRecord2, Looper looper) {
            super(looper);
            this.mAudioRecord = audioRecord2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            OnRecordPositionUpdateListener onRecordPositionUpdateListener;
            Object object = AudioRecord.this.mPositionListenerLock;
            synchronized (object) {
                onRecordPositionUpdateListener = this.mAudioRecord.mPositionListener;
            }
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("[ android.media.AudioRecord.NativeEventHandler ] Unknown event type: ");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    int n2 = Log.e(AudioRecord.TAG, string2);
                    return;
                }
                case 2: {
                    if (onRecordPositionUpdateListener == null) {
                        return;
                    }
                    AudioRecord audioRecord = this.mAudioRecord;
                    onRecordPositionUpdateListener.onMarkerReached(audioRecord);
                    return;
                }
                case 3: 
            }
            if (onRecordPositionUpdateListener == null) {
                return;
            }
            AudioRecord audioRecord = this.mAudioRecord;
            onRecordPositionUpdateListener.onPeriodicNotification(audioRecord);
        }
    }

    public static interface OnRecordPositionUpdateListener {
        public void onMarkerReached(AudioRecord var1);

        public void onPeriodicNotification(AudioRecord var1);
    }
}

