/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManagerNative;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioService;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.VolumePanel;
import com.android.internal.telephony.ITelephony;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;

public class AudioService
extends IAudioService.Stub {
    private static final int BTA2DP_DOCK_TIMEOUT_MILLIS = 8000;
    private static final String IN_VOICE_COMM_FOCUS_ID = "AudioFocus_For_Phone_Ring_And_Calls";
    private static final int MSG_BTA2DP_DOCK_TIMEOUT = 8;
    private static final int MSG_MEDIA_SERVER_DIED = 5;
    private static final int MSG_MEDIA_SERVER_STARTED = 6;
    private static final int MSG_PERSIST_RINGER_MODE = 3;
    private static final int MSG_PERSIST_VIBRATE_SETTING = 4;
    private static final int MSG_PERSIST_VOLUME = 1;
    private static final int MSG_PLAY_SOUND_EFFECT = 7;
    private static final int MSG_SET_SYSTEM_VOLUME = 0;
    private static final int NUM_SOUNDPOOL_CHANNELS = 4;
    private static final int PERSIST_DELAY = 3000;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final int SENDMSG_REPLACE = 0;
    private static final int SHARED_MSG = 255;
    private static final String SOUND_EFFECTS_PATH = "/media/audio/ui/";
    private static final String[] SOUND_EFFECT_FILES;
    private static final int SOUND_EFFECT_VOLUME = 1000;
    private static final String TAG = "AudioService";
    private static final Object mAudioFocusLock;
    private static final Object mRingingLock;
    private int[] MAX_STREAM_VOLUME;
    private int[][] SOUND_EFFECT_FILES_MAP;
    private int[] STREAM_VOLUME_ALIAS;
    private AudioHandler mAudioHandler;
    private AudioSystem.ErrorCallback mAudioSystemCallback;
    private AudioSystemThread mAudioSystemThread;
    private BluetoothHeadset mBluetoothHeadset;
    private boolean mBluetoothHeadsetConnected;
    private BluetoothHeadset.ServiceListener mBluetoothHeadsetServiceListener;
    private HashMap<Integer, String> mConnectedDevices;
    private ContentResolver mContentResolver;
    private Context mContext;
    private String mDockAddress;
    private Stack<FocusStackEntry> mFocusStack;
    private int mForcedUseForComm;
    private boolean mIsRinging;
    private final BroadcastReceiver mMediaButtonReceiver;
    private boolean mMediaServerOk;
    private int mMode;
    private int mMuteAffectedStreams;
    private int mNotificationsUseRingVolume;
    private PhoneStateListener mPhoneStateListener;
    private Stack<RemoteControlStackEntry> mRCStack;
    private final BroadcastReceiver mReceiver;
    private int mRingerMode;
    private int mRingerModeAffectedStreams;
    private int mRingerModeMutedStreams;
    private ArrayList<ScoClient> mScoClients;
    private ArrayList<SetModeDeathHandler> mSetModeDeathHandlers;
    private Object mSettingsLock;
    private SettingsObserver mSettingsObserver;
    private Object mSoundEffectsLock;
    private SoundPool mSoundPool;
    private VolumeStreamState[] mStreamStates;
    private int mVibrateSetting;
    private VolumePanel mVolumePanel;

    static {
        String[] stringArray = new String[]{"Effect_Tick.ogg", "KeypressStandard.ogg", "KeypressSpacebar.ogg", "KeypressDelete.ogg", "KeypressReturn.ogg"};
        SOUND_EFFECT_FILES = stringArray;
        mAudioFocusLock = new Object();
        mRingingLock = new Object();
    }

    public AudioService(Context context) {
        BluetoothHeadset bluetoothHeadset;
        SettingsObserver settingsObserver;
        VolumePanel volumePanel;
        int n;
        ContentResolver contentResolver;
        PhoneStateListener phoneStateListener;
        BluetoothHeadset.ServiceListener serviceListener;
        AudioSystem.ErrorCallback errorCallback;
        Object object;
        Object object2;
        this.mSettingsLock = object2 = new Object();
        this.mSoundEffectsLock = object = new Object();
        int[] nArray = new int[9];
        int[] nArray2 = new int[]{0, -1};
        nArray[0] = (int)nArray2;
        int[] nArray3 = new int[]{0, -1};
        nArray[1] = (int)nArray3;
        int[] nArray4 = new int[]{0, -1};
        nArray[2] = (int)nArray4;
        int[] nArray5 = new int[]{0, -1};
        nArray[3] = (int)nArray5;
        int[] nArray6 = new int[]{0, -1};
        nArray[4] = (int)nArray6;
        int[] nArray7 = new int[]{1, -1};
        nArray[5] = (int)nArray7;
        int[] nArray8 = new int[]{2, -1};
        nArray[6] = (int)nArray8;
        int[] nArray9 = new int[]{3, -1};
        nArray[7] = (int)nArray9;
        int[] nArray10 = new int[]{4, -1};
        nArray[8] = (int)nArray10;
        this.SOUND_EFFECT_FILES_MAP = (int[][])nArray;
        int[] nArray11 = new int[]{5, 7, 7, 15, 7, 7, 15, 7, 15, 15};
        this.MAX_STREAM_VOLUME = nArray11;
        int[] nArray12 = new int[]{0, 1, 2, 3, 4, 5, 6, 1, 0, 3};
        this.STREAM_VOLUME_ALIAS = nArray12;
        this.mAudioSystemCallback = errorCallback = new AudioSystem.ErrorCallback(){

            @Override
            public void onError(int n) {
                switch (n) {
                    default: {
                        return;
                    }
                    case 100: {
                        if (!AudioService.this.mMediaServerOk) {
                            return;
                        }
                        AudioHandler audioHandler = AudioService.this.mAudioHandler;
                        int n2 = 0;
                        AudioService.sendMsg(audioHandler, 5, -1, 1, 0, n2, null, 1500);
                        boolean bl = AudioService.access$002(AudioService.this, false);
                        return;
                    }
                    case 0: 
                }
                if (AudioService.this.mMediaServerOk) {
                    return;
                }
                AudioHandler audioHandler = AudioService.this.mAudioHandler;
                int n3 = 0;
                int n4 = 0;
                AudioService.sendMsg(audioHandler, 6, -1, 1, 0, n3, null, n4);
                boolean bl = AudioService.access$002(AudioService.this, true);
            }
        };
        AudioServiceBroadcastReceiver audioServiceBroadcastReceiver = new AudioServiceBroadcastReceiver();
        this.mReceiver = audioServiceBroadcastReceiver;
        MediaButtonBroadcastReceiver mediaButtonBroadcastReceiver = new MediaButtonBroadcastReceiver();
        this.mMediaButtonReceiver = mediaButtonBroadcastReceiver;
        this.mIsRinging = false;
        HashMap hashMap = new HashMap();
        this.mConnectedDevices = hashMap;
        ArrayList arrayList = new ArrayList();
        this.mSetModeDeathHandlers = arrayList;
        ArrayList arrayList2 = new ArrayList();
        this.mScoClients = arrayList2;
        this.mBluetoothHeadsetServiceListener = serviceListener = new BluetoothHeadset.ServiceListener(){

            @Override
            public void onServiceConnected() {
                if (AudioService.this.mBluetoothHeadset == null) {
                    return;
                }
                BluetoothDevice bluetoothDevice = AudioService.this.mBluetoothHeadset.getCurrentHeadset();
                if (AudioService.this.mBluetoothHeadset.getState(bluetoothDevice) != 2) {
                    return;
                }
                boolean bl = AudioService.access$1502(AudioService.this, true);
            }

            @Override
            public void onServiceDisconnected() {
                if (AudioService.this.mBluetoothHeadset == null) {
                    return;
                }
                BluetoothDevice bluetoothDevice = AudioService.this.mBluetoothHeadset.getCurrentHeadset();
                if (AudioService.this.mBluetoothHeadset.getState(bluetoothDevice) != 0) {
                    return;
                }
                boolean bl = AudioService.access$1502(AudioService.this, false);
                AudioService.this.clearAllScoClients();
            }
        };
        this.mPhoneStateListener = phoneStateListener = new PhoneStateListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void onCallStateChanged(int n, String string2) {
                Object var3_3 = null;
                if (n == 1) {
                    Object object = mRingingLock;
                    // MONITORENTER : object
                    boolean bl = AudioService.access$5102(AudioService.this, true);
                    // MONITOREXIT : object
                    if (AudioService.this.getStreamVolume(2) <= 0) {
                        return;
                    }
                    AudioService audioService = AudioService.this;
                    int n2 = 2;
                    IAudioFocusDispatcher iAudioFocusDispatcher = null;
                    int n3 = audioService.requestAudioFocus(2, n2, null, iAudioFocusDispatcher, AudioService.IN_VOICE_COMM_FOCUS_ID);
                    return;
                }
                if (n == 2) {
                    Object object = mRingingLock;
                    // MONITORENTER : object
                    boolean bl = AudioService.access$5102(AudioService.this, false);
                    // MONITOREXIT : object
                    AudioService audioService = AudioService.this;
                    int n4 = 2;
                    IAudioFocusDispatcher iAudioFocusDispatcher = null;
                    int n5 = audioService.requestAudioFocus(2, n4, null, iAudioFocusDispatcher, AudioService.IN_VOICE_COMM_FOCUS_ID);
                    return;
                }
                if (n != 0) {
                    return;
                }
                Object object = mRingingLock;
                // MONITORENTER : object
                boolean bl = AudioService.access$5102(AudioService.this, false);
                // MONITOREXIT : object
                int n6 = AudioService.this.abandonAudioFocus(null, AudioService.IN_VOICE_COMM_FOCUS_ID);
            }
        };
        Stack stack = new Stack();
        this.mFocusStack = stack;
        Stack stack2 = new Stack();
        this.mRCStack = stack2;
        this.mContext = context;
        this.mContentResolver = contentResolver = context.getContentResolver();
        int[] nArray13 = this.MAX_STREAM_VOLUME;
        int n2 = this.MAX_STREAM_VOLUME[0];
        nArray13[0] = n = SystemProperties.getInt("ro.config.vc_call_vol_steps", n2);
        this.mVolumePanel = volumePanel = new VolumePanel(context, this);
        this.mSettingsObserver = settingsObserver = new SettingsObserver();
        this.mForcedUseForComm = 0;
        this.createAudioSystemThread();
        this.readPersistedSettings();
        this.createStreamStates();
        this.mMode = -1;
        this.setMode(0, null);
        this.mMediaServerOk = true;
        this.mRingerModeMutedStreams = 0;
        int n3 = this.getRingerMode();
        this.setRingerModeInt(n3, false);
        AudioSystem.setErrorCallback(this.mAudioSystemCallback);
        boolean bl = this.loadSoundEffects();
        this.mBluetoothHeadsetConnected = false;
        BluetoothHeadset.ServiceListener serviceListener2 = this.mBluetoothHeadsetServiceListener;
        this.mBluetoothHeadset = bluetoothHeadset = new BluetoothHeadset(context, serviceListener2);
        IntentFilter intentFilter = new IntentFilter("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.action.STATE_CHANGED");
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        intentFilter.addAction("android.bluetooth.headset.action.AUDIO_STATE_CHANGED");
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        Intent intent = context.registerReceiver(broadcastReceiver, intentFilter);
        IntentFilter intentFilter2 = new IntentFilter("android.intent.action.MEDIA_BUTTON");
        intentFilter2.setPriority(1000);
        BroadcastReceiver broadcastReceiver2 = this.mMediaButtonReceiver;
        Intent intent2 = context.registerReceiver(broadcastReceiver2, intentFilter2);
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        PhoneStateListener phoneStateListener2 = this.mPhoneStateListener;
        telephonyManager.listen(phoneStateListener2, 32);
    }

    static /* synthetic */ boolean access$002(AudioService audioService, boolean bl) {
        audioService.mMediaServerOk = bl;
        return bl;
    }

    static /* synthetic */ AudioHandler access$102(AudioService audioService, AudioHandler audioHandler) {
        audioService.mAudioHandler = audioHandler;
        return audioHandler;
    }

    static /* synthetic */ int access$1102(AudioService audioService, int n) {
        audioService.mMode = n;
        return n;
    }

    static /* synthetic */ boolean access$1502(AudioService audioService, boolean bl) {
        audioService.mBluetoothHeadsetConnected = bl;
        return bl;
    }

    static /* synthetic */ int access$4202(AudioService audioService, int n) {
        audioService.mRingerModeAffectedStreams = n;
        return n;
    }

    static /* synthetic */ int access$4302(AudioService audioService, int n) {
        audioService.mNotificationsUseRingVolume = n;
        return n;
    }

    static /* synthetic */ String access$4602(AudioService audioService, String string2) {
        audioService.mDockAddress = string2;
        return string2;
    }

    static /* synthetic */ boolean access$5102(AudioService audioService, boolean bl) {
        audioService.mIsRinging = bl;
        return bl;
    }

    private void broadcastRingerMode() {
        Intent intent = new Intent("android.media.RINGER_MODE_CHANGED");
        int n = this.mRingerMode;
        Intent intent2 = intent.putExtra("android.media.EXTRA_RINGER_MODE", n);
        Intent intent3 = intent.addFlags(0x30000000);
        long l = Binder.clearCallingIdentity();
        this.mContext.sendStickyBroadcast(intent);
        Binder.restoreCallingIdentity(l);
    }

    private void broadcastVibrateSetting(int n) {
        if (!ActivityManagerNative.isSystemReady()) {
            return;
        }
        Intent intent = new Intent("android.media.VIBRATE_SETTING_CHANGED");
        Intent intent2 = intent.putExtra("android.media.EXTRA_VIBRATE_TYPE", n);
        int n2 = this.getVibrateSetting(n);
        Intent intent3 = intent.putExtra("android.media.EXTRA_VIBRATE_SETTING", n2);
        this.mContext.sendBroadcast(intent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canReassignAudioFocus() {
        if (this.mFocusStack.isEmpty()) return true;
        String string2 = this.mFocusStack.peek().mClientId;
        if (!IN_VOICE_COMM_FOCUS_ID.equals(string2)) return true;
        return false;
    }

    private void cancelA2dpDeviceTimeout() {
        this.mAudioHandler.removeMessages(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkForRingerModeChange(int n, int n2) {
        int n3;
        boolean bl = true;
        int n4 = this.mRingerMode;
        if (this.mRingerMode == 2) {
            if (n2 == -1 && (n + 5) / 10 == 1) {
                n4 = Settings.System.getInt(this.mContentResolver, "vibrate_in_silent", 1) == 1 ? 1 : 0;
            }
        } else if (n2 == 1) {
            n4 = 2;
        } else {
            bl = false;
        }
        if (n4 == (n3 = this.mRingerMode)) return bl;
        this.setRingerMode(n4);
        return false;
    }

    private void createAudioSystemThread() {
        AudioSystemThread audioSystemThread;
        this.mAudioSystemThread = audioSystemThread = new AudioSystemThread();
        this.mAudioSystemThread.start();
        this.waitForAudioHandlerCreation();
    }

    private void createStreamStates() {
        int n = AudioSystem.getNumStreamTypes();
        VolumeStreamState[] volumeStreamStateArray = new VolumeStreamState[n];
        this.mStreamStates = volumeStreamStateArray;
        for (int i = 0; i < n; ++i) {
            VolumeStreamState volumeStreamState;
            String[] stringArray = Settings.System.VOLUME_SETTINGS;
            int n2 = this.STREAM_VOLUME_ALIAS[i];
            String string2 = stringArray[n2];
            volumeStreamStateArray[i] = volumeStreamState = new VolumeStreamState(string2, i);
        }
        int n3 = 0;
        while (n3 < n) {
            if (this.STREAM_VOLUME_ALIAS[n3] != n3) {
                int n4 = volumeStreamStateArray[n3].mIndex;
                int n5 = this.STREAM_VOLUME_ALIAS[n3];
                int n6 = this.rescaleIndex(n4, n5, n3);
                VolumeStreamState volumeStreamState = volumeStreamStateArray[n3];
                int n7 = volumeStreamStateArray[n3].getValidIndex(n6);
                int n8 = VolumeStreamState.access$602(volumeStreamState, n7);
                this.setStreamVolumeIndex(n3, n6);
                int n9 = volumeStreamStateArray[n3].mLastAudibleIndex;
                int n10 = this.STREAM_VOLUME_ALIAS[n3];
                int n11 = this.rescaleIndex(n9, n10, n3);
                VolumeStreamState volumeStreamState2 = volumeStreamStateArray[n3];
                int n12 = volumeStreamStateArray[n3].getValidIndex(n11);
                int n13 = VolumeStreamState.access$802(volumeStreamState2, n12);
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpFocusStack(PrintWriter printWriter) {
        printWriter.println("\nAudio Focus stack entries:");
        Object object = mAudioFocusLock;
        synchronized (object) {
            Iterator iterator = this.mFocusStack.iterator();
            while (iterator.hasNext()) {
                FocusStackEntry focusStackEntry = (FocusStackEntry)iterator.next();
                StringBuilder stringBuilder = new StringBuilder().append("     source:");
                IBinder iBinder = focusStackEntry.mSourceRef;
                StringBuilder stringBuilder2 = stringBuilder.append(iBinder).append(" -- client: ");
                String string2 = focusStackEntry.mClientId;
                StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(" -- duration: ");
                int n = focusStackEntry.mFocusChangeType;
                String string3 = stringBuilder3.append(n).toString();
                printWriter.println(string3);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpRCStack(PrintWriter printWriter) {
        printWriter.println("\nRemote Control stack entries:");
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            Iterator iterator = this.mRCStack.iterator();
            while (iterator.hasNext()) {
                RemoteControlStackEntry remoteControlStackEntry = (RemoteControlStackEntry)iterator.next();
                StringBuilder stringBuilder = new StringBuilder().append("     receiver:");
                ComponentName componentName = remoteControlStackEntry.mReceiverComponent;
                String string2 = stringBuilder.append(componentName).toString();
                printWriter.println(string2);
            }
            return;
        }
    }

    private void ensureValidDirection(int n) {
        if (n >= -1 && n <= 1) {
            return;
        }
        String string2 = "Bad direction " + n;
        throw new IllegalArgumentException(string2);
    }

    private void ensureValidStreamType(int n) {
        int n2;
        if (n >= 0 && n < (n2 = this.mStreamStates.length)) {
            return;
        }
        String string2 = "Bad stream type " + n;
        throw new IllegalArgumentException(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getActiveStreamType(int n) {
        boolean bl = false;
        try {
            ITelephony iTelephony = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
            if (iTelephony != null) {
                boolean bl2;
                bl = bl2 = iTelephony.isOffhook();
            }
        }
        catch (RemoteException remoteException) {
            int n2 = Log.w(TAG, "Couldn't connect to phone service", remoteException);
        }
        if (AudioSystem.getForceUse(0) == 3) {
            return 6;
        }
        if (bl) return 0;
        if (AudioSystem.isStreamActive(0)) {
            return 0;
        }
        if (AudioSystem.isStreamActive(3)) {
            return 3;
        }
        if (n != Integer.MIN_VALUE) return n;
        return 2;
    }

    private static int getMsg(int n, int n2) {
        int n3 = 0xFFFF & n;
        int n4 = n2 << 16;
        return n3 | n4;
    }

    private static int getMsgBase(int n) {
        return 0xFFFF & n;
    }

    public static int getValueForVibrateSetting(int n, int n2, int n3) {
        int n4 = n2 * 2;
        int n5 = ~(3 << n4);
        int n6 = n & n5;
        int n7 = n3 & 3;
        int n8 = n2 * 2;
        int n9 = n7 << n8;
        return n6 | n9;
    }

    private boolean hasScheduledA2dpDockTimeout() {
        return this.mAudioHandler.hasMessages(8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStreamMutedByRingerMode(int n) {
        int n2 = this.mRingerModeMutedStreams;
        int n3 = 1 << n;
        if ((n2 & n3) == 0) return false;
        return true;
    }

    private void makeA2dpDeviceAvailable(String string2) {
        int n = AudioSystem.setDeviceConnectionState(128, 1, string2);
        int n2 = AudioSystem.setParameters("A2dpSuspended=false");
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        Integer n3 = new Integer(128);
        String string3 = hashMap.put(n3, string2);
    }

    private void makeA2dpDeviceUnavailableLater(String string2) {
        int n = AudioSystem.setParameters("A2dpSuspended=true");
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        Integer n2 = 128;
        String string3 = hashMap.remove(n2);
        Message message = this.mAudioHandler.obtainMessage(8, string2);
        boolean bl = this.mAudioHandler.sendMessageDelayed(message, 8000L);
    }

    private void makeA2dpDeviceUnavailableNow(String string2) {
        Intent intent = new Intent("android.media.AUDIO_BECOMING_NOISY");
        this.mContext.sendBroadcast(intent);
        int n = AudioSystem.setDeviceConnectionState(128, 0, string2);
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        Integer n2 = 128;
        String string3 = hashMap.remove(n2);
    }

    private void notifyTopOfAudioFocusStack() {
        if (this.mFocusStack.empty()) {
            return;
        }
        if (this.mFocusStack.peek().mFocusDispatcher == null) {
            return;
        }
        if (!this.canReassignAudioFocus()) {
            return;
        }
        try {
            IAudioFocusDispatcher iAudioFocusDispatcher = this.mFocusStack.peek().mFocusDispatcher;
            String string2 = this.mFocusStack.peek().mClientId;
            iAudioFocusDispatcher.dispatchAudioFocusChange(1, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = "Failure to signal gain of audio control focus due to " + remoteException;
            int n = Log.e(TAG, string3);
            remoteException.printStackTrace();
            return;
        }
    }

    private void pushMediaButtonReceiver(ComponentName componentName) {
        if (!this.mRCStack.empty() && this.mRCStack.peek().mReceiverComponent.equals(componentName)) {
            return;
        }
        for (RemoteControlStackEntry remoteControlStackEntry : this.mRCStack) {
            if (!remoteControlStackEntry.mReceiverComponent.equals(componentName)) continue;
            boolean bl = this.mRCStack.remove(remoteControlStackEntry);
            break;
        }
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        RemoteControlStackEntry remoteControlStackEntry = new RemoteControlStackEntry(componentName);
        RemoteControlStackEntry remoteControlStackEntry2 = stack.push(remoteControlStackEntry);
    }

    private void readPersistedSettings() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        ContentResolver contentResolver = this.mContentResolver;
        this.mRingerMode = n5 = Settings.System.getInt(contentResolver, "mode_ringer", 2);
        this.mVibrateSetting = n4 = Settings.System.getInt(contentResolver, "vibrate_on", 0);
        this.mRingerModeAffectedStreams = n3 = Settings.System.getInt(contentResolver, "mode_ringer_streams_affected", 166);
        this.mMuteAffectedStreams = n2 = Settings.System.getInt(contentResolver, "mute_streams_affected", 14);
        this.mNotificationsUseRingVolume = n = Settings.System.getInt(contentResolver, "notifications_use_ring_volume", 1);
        if (this.mNotificationsUseRingVolume == 1) {
            this.STREAM_VOLUME_ALIAS[5] = 2;
        }
        this.broadcastRingerMode();
        this.broadcastVibrateSetting(0);
        this.broadcastVibrateSetting(1);
    }

    private void removeFocusStackEntry(String string2, boolean bl) {
        if (!this.mFocusStack.empty() && this.mFocusStack.peek().mClientId.equals(string2)) {
            FocusStackEntry focusStackEntry = this.mFocusStack.pop();
            if (!bl) {
                return;
            }
            this.notifyTopOfAudioFocusStack();
            return;
        }
        Iterator iterator = this.mFocusStack.iterator();
        while (iterator.hasNext()) {
            FocusStackEntry focusStackEntry = (FocusStackEntry)iterator.next();
            if (!focusStackEntry.mClientId.equals(string2)) continue;
            StringBuilder stringBuilder = new StringBuilder().append(" AudioFocus  abandonAudioFocus(): removing entry for ");
            String string3 = focusStackEntry.mClientId;
            String string4 = stringBuilder.append(string3).toString();
            int n = Log.i(TAG, string4);
            boolean bl2 = this.mFocusStack.remove(focusStackEntry);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeFocusStackEntryForClient(IBinder iBinder) {
        boolean bl = !this.mFocusStack.isEmpty() && this.mFocusStack.peek().mSourceRef.equals(iBinder);
        for (FocusStackEntry focusStackEntry : this.mFocusStack) {
            if (!focusStackEntry.mSourceRef.equals(iBinder)) continue;
            StringBuilder stringBuilder = new StringBuilder().append(" AudioFocus  abandonAudioFocus(): removing entry for ");
            String string2 = focusStackEntry.mClientId;
            String string3 = stringBuilder.append(string2).toString();
            int n = Log.i(TAG, string3);
            boolean bl2 = this.mFocusStack.remove(focusStackEntry);
        }
        if (!bl) {
            return;
        }
        this.notifyTopOfAudioFocusStack();
    }

    private void removeMediaButtonReceiver(ComponentName componentName) {
        RemoteControlStackEntry remoteControlStackEntry;
        Iterator iterator = this.mRCStack.iterator();
        do {
            if (!iterator.hasNext()) {
                return;
            }
            remoteControlStackEntry = (RemoteControlStackEntry)iterator.next();
        } while (!remoteControlStackEntry.mReceiverComponent.equals(componentName));
        boolean bl = this.mRCStack.remove(remoteControlStackEntry);
    }

    private int rescaleIndex(int n, int n2, int n3) {
        int n4 = this.mStreamStates[n3].getMaxIndex() * n;
        int n5 = this.mStreamStates[n2].getMaxIndex() / 2;
        int n6 = n4 + n5;
        int n7 = this.mStreamStates[n2].getMaxIndex();
        return n6 / n7;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void sendMsg(Handler handler, int n, int n2, int n3, int n4, int n5, Object object, int n6) {
        int n7 = n2 == -1 ? n : AudioService.getMsg(n, n2);
        if (n3 == 0) {
            handler.removeMessages(n7);
        } else if (n3 == 1 && handler.hasMessages(n7)) {
            return;
        }
        Message message = handler.obtainMessage(n7, n4, n5, object);
        long l = n6;
        boolean bl = handler.sendMessageDelayed(message, l);
    }

    private void sendVolumeUpdate(int n, int n2, int n3) {
        int n4 = (n2 + 5) / 10;
        int n5 = (n3 + 5) / 10;
        Intent intent = new Intent("android.media.VOLUME_CHANGED_ACTION");
        Intent intent2 = intent.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", n);
        Intent intent3 = intent.putExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", n5);
        Intent intent4 = intent.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", n4);
        this.mContext.sendBroadcast(intent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setRingerModeInt(int n, boolean bl) {
        this.mRingerMode = n;
        for (int i = AudioSystem.getNumStreamTypes() - 1; i >= 0; i += -1) {
            int n2;
            if (this.isStreamMutedByRingerMode(i)) {
                int n3;
                if (this.isStreamAffectedByRingerMode(i) && this.mRingerMode != 2) continue;
                this.mStreamStates[i].mute(null, false);
                int n4 = this.mRingerModeMutedStreams;
                int n5 = ~(1 << i);
                this.mRingerModeMutedStreams = n3 = n4 & n5;
                continue;
            }
            if (!this.isStreamAffectedByRingerMode(i) || this.mRingerMode == 2) continue;
            this.mStreamStates[i].mute(null, true);
            int n6 = this.mRingerModeMutedStreams;
            int n7 = 1 << i;
            this.mRingerModeMutedStreams = n2 = n6 | n7;
        }
        if (!bl) {
            return;
        }
        AudioHandler audioHandler = this.mAudioHandler;
        int n8 = 0;
        int n9 = 0;
        AudioService.sendMsg(audioHandler, 3, -1, 0, n8, n9, null, 3000);
    }

    private void setStreamVolumeIndex(int n, int n2) {
        int n3 = (n2 + 5) / 10;
        int n4 = AudioSystem.setStreamVolumeIndex(n, n3);
    }

    private void setStreamVolumeInt(int n, int n2, boolean bl, boolean bl2) {
        VolumeStreamState volumeStreamState = this.mStreamStates[n];
        if (volumeStreamState.muteCount() != 0) {
            if (n2 == 0) {
                return;
            }
            volumeStreamState.setLastAudibleIndex(n2);
            AudioHandler audioHandler = this.mAudioHandler;
            int n3 = n;
            AudioService.sendMsg(audioHandler, 1, n3, 0, 0, 1, volumeStreamState, 3000);
            return;
        }
        if (!volumeStreamState.setIndex(n2, bl2) && !bl) {
            return;
        }
        AudioHandler audioHandler = this.mAudioHandler;
        int n4 = n;
        AudioService.sendMsg(audioHandler, 0, n4, 1, 0, 0, volumeStreamState, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForAudioHandlerCreation() {
        synchronized (this) {
            AudioHandler audioHandler;
            while ((audioHandler = this.mAudioHandler) == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    int n = Log.e(TAG, "Interrupted while waiting on volume handler.");
                    continue;
                }
                break;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int abandonAudioFocus(IAudioFocusDispatcher iAudioFocusDispatcher, String string2) {
        boolean bl;
        String string3 = " AudioFocus  abandonAudioFocus() from " + string2;
        int n = Log.i(TAG, string3);
        try {
            Object object = mAudioFocusLock;
            synchronized (object) {
                bl = true;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            String string4 = "FATAL EXCEPTION AudioFocus  abandonAudioFocus() caused " + concurrentModificationException;
            int n2 = Log.e(TAG, string4);
            concurrentModificationException.printStackTrace();
            return 1;
        }
        {
            this.removeFocusStackEntry(string2, bl);
            return 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void adjustStreamVolume(int n, int n2, int n3) {
        int n4;
        this.ensureValidDirection(n2);
        this.ensureValidStreamType(n);
        VolumeStreamState[] volumeStreamStateArray = this.mStreamStates;
        int n5 = this.STREAM_VOLUME_ALIAS[n];
        VolumeStreamState volumeStreamState = volumeStreamStateArray[n5];
        int n6 = volumeStreamState.muteCount() != 0 ? volumeStreamState.mLastAudibleIndex : volumeStreamState.mIndex;
        boolean bl = true;
        if ((n3 & 2) != 0 || n == 2) {
            bl = this.checkForRingerModeChange(n6, n2);
        }
        if (volumeStreamState.muteCount() != 0) {
            if (bl) {
                volumeStreamState.adjustLastAudibleIndex(n2);
                AudioHandler audioHandler = this.mAudioHandler;
                int n7 = n;
                AudioService.sendMsg(audioHandler, 1, n7, 0, 0, 1, volumeStreamState, 3000);
            }
            n4 = volumeStreamState.mLastAudibleIndex;
        } else {
            if (bl && volumeStreamState.adjustIndex(n2)) {
                AudioHandler audioHandler = this.mAudioHandler;
                int n8 = this.STREAM_VOLUME_ALIAS[n];
                AudioService.sendMsg(audioHandler, 0, n8, 1, 0, 0, volumeStreamState, 0);
            }
            n4 = volumeStreamState.mIndex;
        }
        this.mVolumePanel.postVolumeChanged(n, n3);
        this.sendVolumeUpdate(n, n6, n4);
    }

    @Override
    public void adjustSuggestedStreamVolume(int n, int n2, int n3) {
        int n4 = this.getActiveStreamType(n2);
        if (n4 != 2 && (n3 & 4) != 0) {
            n3 &= 0xFFFFFFFB;
        }
        this.adjustStreamVolume(n4, n, n3);
    }

    @Override
    public void adjustVolume(int n, int n2) {
        this.adjustSuggestedStreamVolume(n, Integer.MIN_VALUE, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean checkAudioSettingsPermission(String string2) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Audio Settings Permission Denial: ").append(string2).append(" from pid=");
        int n = Binder.getCallingPid();
        StringBuilder stringBuilder2 = stringBuilder.append(n).append(", uid=");
        int n2 = Binder.getCallingUid();
        String string3 = stringBuilder2.append(n2).toString();
        int n3 = Log.w(TAG, string3);
        return false;
    }

    public void clearAllScoClients() {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            int n = this.mScoClients.size();
            for (int i = 0; i < n; ++i) {
                this.mScoClients.get(i).clearCount(false);
            }
            return;
        }
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        this.dumpFocusStack(printWriter);
        this.dumpRCStack(printWriter);
    }

    @Override
    public int getMode() {
        return this.mMode;
    }

    @Override
    public int getRingerMode() {
        return this.mRingerMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScoClient getScoClient(IBinder iBinder) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            int n = this.mScoClients.size();
            for (int i = 0; i < n; ++i) {
                ScoClient scoClient = this.mScoClients.get(i);
                if (scoClient.getBinder() != iBinder) continue;
                return scoClient;
            }
            ScoClient scoClient = new ScoClient(iBinder);
            boolean bl = this.mScoClients.add(scoClient);
            return scoClient;
        }
    }

    @Override
    public int getStreamMaxVolume(int n) {
        this.ensureValidStreamType(n);
        return (this.mStreamStates[n].getMaxIndex() + 5) / 10;
    }

    @Override
    public int getStreamVolume(int n) {
        this.ensureValidStreamType(n);
        return (this.mStreamStates[n].mIndex + 5) / 10;
    }

    @Override
    public int getVibrateSetting(int n) {
        int n2 = this.mVibrateSetting;
        int n3 = n * 2;
        return n2 >> n3 & 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isBluetoothScoOn() {
        if (this.mForcedUseForComm != 3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSpeakerphoneOn() {
        if (this.mForcedUseForComm != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isStreamAffectedByMute(int n) {
        int n2 = this.mMuteAffectedStreams;
        int n3 = 1 << n;
        if ((n2 & n3) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isStreamAffectedByRingerMode(int n) {
        int n2 = this.mRingerModeAffectedStreams;
        int n3 = 1 << n;
        if ((n2 & n3) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadSoundEffects() {
        Object object = this.mSoundEffectsLock;
        synchronized (object) {
            int n;
            SoundPool soundPool;
            if (this.mSoundPool != null) {
                return (boolean)null;
            }
            this.mSoundPool = soundPool = new SoundPool(4, 1, 0);
            if (this.mSoundPool == null) {
                return (boolean)null;
            }
            int[] nArray = new int[SOUND_EFFECT_FILES.length];
            for (int i = 0; i < (n = SOUND_EFFECT_FILES.length); ++i) {
                nArray[i] = -1;
            }
            int n2 = 0;
            while (n2 < 9) {
                if (this.SOUND_EFFECT_FILES_MAP[n2][1] != 0) {
                    int n3 = this.SOUND_EFFECT_FILES_MAP[n2][0];
                    if (nArray[n3] == -1) {
                        int n4;
                        StringBuilder stringBuilder = new StringBuilder();
                        File file = Environment.getRootDirectory();
                        StringBuilder stringBuilder2 = stringBuilder.append(file).append(SOUND_EFFECTS_PATH);
                        String[] stringArray = SOUND_EFFECT_FILES;
                        int n5 = this.SOUND_EFFECT_FILES_MAP[n2][0];
                        String string2 = stringArray[n5];
                        String string3 = stringBuilder2.append(string2).toString();
                        this.SOUND_EFFECT_FILES_MAP[n2][1] = n4 = this.mSoundPool.load(string3, 0);
                        int n6 = this.SOUND_EFFECT_FILES_MAP[n2][0];
                        nArray[n6] = n4;
                        if (n4 <= 0) {
                            String string4 = "Soundpool could not load file: " + string3;
                            int n7 = Log.w(TAG, string4);
                        }
                    } else {
                        int n8;
                        int[] nArray2 = this.SOUND_EFFECT_FILES_MAP[n2];
                        int n9 = this.SOUND_EFFECT_FILES_MAP[n2][0];
                        nArray2[1] = n8 = nArray[n9];
                    }
                }
                ++n2;
            }
            return (boolean)null;
        }
    }

    @Override
    public void playSoundEffect(int n) {
        AudioHandler audioHandler = this.mAudioHandler;
        int n2 = n;
        int n3 = -1;
        AudioService.sendMsg(audioHandler, 7, -1, 1, n2, n3, null, 0);
    }

    @Override
    public void playSoundEffectVolume(int n, float f) {
        boolean bl = this.loadSoundEffects();
        AudioHandler audioHandler = this.mAudioHandler;
        int n2 = (int)(1000.0f * f);
        int n3 = n;
        AudioService.sendMsg(audioHandler, 7, -1, 1, n3, n2, null, 0);
    }

    @Override
    public void registerMediaButtonEventReceiver(ComponentName componentName) {
        String string2 = "  Remote Control   registerMediaButtonEventReceiver() for " + componentName;
        int n = Log.i(TAG, string2);
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            this.pushMediaButtonReceiver(componentName);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reloadAudioSettings() {
        this.readPersistedSettings();
        int n = AudioSystem.getNumStreamTypes();
        int n2 = 0;
        while (true) {
            int n3;
            int n4;
            if (n2 >= n) {
                int n5 = this.getRingerMode();
                this.setRingerModeInt(n5, false);
                return;
            }
            VolumeStreamState volumeStreamState = this.mStreamStates[n2];
            String[] stringArray = Settings.System.VOLUME_SETTINGS;
            int n6 = this.STREAM_VOLUME_ALIAS[n2];
            String string2 = stringArray[n6];
            String string3 = string2 + "_last_audible";
            ContentResolver contentResolver = this.mContentResolver;
            int n7 = AudioManager.DEFAULT_STREAM_VOLUME[n2];
            int n8 = Settings.System.getInt(contentResolver, string2, n7);
            if (this.STREAM_VOLUME_ALIAS[n2] != n2) {
                int n9 = n8 * 10;
                int n10 = this.STREAM_VOLUME_ALIAS[n2];
                n4 = this.rescaleIndex(n9, n10, n2);
            } else {
                n4 = n8 * 10;
            }
            int n11 = volumeStreamState.getValidIndex(n4);
            int n12 = VolumeStreamState.access$602(volumeStreamState, n11);
            int n13 = (n4 + 5) / 10;
            ContentResolver contentResolver2 = this.mContentResolver;
            int n14 = n13 > 0 ? n13 : AudioManager.DEFAULT_STREAM_VOLUME[n2];
            int n15 = Settings.System.getInt(contentResolver2, string3, n14);
            if (this.STREAM_VOLUME_ALIAS[n2] != n2) {
                int n16 = n15 * 10;
                int n17 = this.STREAM_VOLUME_ALIAS[n2];
                n3 = this.rescaleIndex(n16, n17, n2);
            } else {
                n3 = n15 * 10;
            }
            int n18 = volumeStreamState.getValidIndex(n3);
            int n19 = VolumeStreamState.access$802(volumeStreamState, n18);
            if (volumeStreamState.muteCount() != 0 && !this.isStreamAffectedByMute(n2)) {
                int n20 = volumeStreamState.mDeathHandlers.size();
                for (int i = 0; i < n20; ++i) {
                    int n21 = VolumeStreamState.VolumeDeathHandler.access$1302((VolumeStreamState.VolumeDeathHandler)volumeStreamState.mDeathHandlers.get(i), 1);
                    ((VolumeStreamState.VolumeDeathHandler)volumeStreamState.mDeathHandlers.get(i)).mute(false);
                }
            }
            if (volumeStreamState.muteCount() == 0) {
                int n22 = volumeStreamState.mIndex;
                this.setStreamVolumeIndex(n2, n22);
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int requestAudioFocus(int n, int n2, IBinder iBinder, IAudioFocusDispatcher iAudioFocusDispatcher, String string2) {
        String string3 = " AudioFocus  requestAudioFocus() from " + string2;
        int n3 = Log.i(TAG, string3);
        if (!(IN_VOICE_COMM_FOCUS_ID.equals(string2) || iBinder != null && iBinder.pingBinder())) {
            int n4 = Log.i(TAG, " AudioFocus  DOA client for requestAudioFocus(), exiting");
            return 0;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            IAudioFocusDispatcher iAudioFocusDispatcher2;
            if (!this.canReassignAudioFocus()) {
                return 0;
            }
            if (!this.mFocusStack.empty() && this.mFocusStack.peek().mClientId.equals(string2)) {
                if (this.mFocusStack.peek().mFocusChangeType != n2) {
                    return 1;
                }
                FocusStackEntry focusStackEntry = this.mFocusStack.pop();
            }
            if (!this.mFocusStack.empty() && (iAudioFocusDispatcher2 = this.mFocusStack.peek().mFocusDispatcher) != null) {
                try {
                    IAudioFocusDispatcher iAudioFocusDispatcher3 = this.mFocusStack.peek().mFocusDispatcher;
                    int n5 = n2 * -1;
                    String string4 = this.mFocusStack.peek().mClientId;
                    iAudioFocusDispatcher3.dispatchAudioFocusChange(n5, string4);
                }
                catch (RemoteException remoteException) {
                    String string5 = " Failure to signal loss of focus due to " + remoteException;
                    int n6 = Log.e(TAG, string5);
                    remoteException.printStackTrace();
                }
            }
            iAudioFocusDispatcher2 = null;
            this.removeFocusStackEntry(string2, (boolean)iAudioFocusDispatcher2);
            Stack<FocusStackEntry> stack = this.mFocusStack;
            int n7 = n;
            int n8 = n2;
            IAudioFocusDispatcher iAudioFocusDispatcher4 = iAudioFocusDispatcher;
            IBinder iBinder2 = iBinder;
            String string6 = string2;
            FocusStackEntry focusStackEntry = new FocusStackEntry(n7, n8, false, iAudioFocusDispatcher4, iBinder2, string6);
            FocusStackEntry focusStackEntry2 = stack.push(focusStackEntry);
        }
        if (IN_VOICE_COMM_FOCUS_ID.equals(string2)) return 1;
        object = new AudioFocusDeathHandler(iBinder);
        int n9 = 0;
        try {
            iBinder.linkToDeath((IBinder.DeathRecipient)object, n9);
            return 1;
        }
        catch (RemoteException remoteException) {
            String string7 = "AudioFocus  requestAudioFocus() could not link to " + iBinder + " binder death";
            int n10 = Log.w(TAG, string7);
        }
        return 1;
    }

    @Override
    public void setBluetoothScoOn(boolean bl) {
        if (!this.checkAudioSettingsPermission("setBluetoothScoOn()")) {
            return;
        }
        if (bl) {
            int n = AudioSystem.setForceUse(0, 3);
            int n2 = AudioSystem.setForceUse(2, 3);
            this.mForcedUseForComm = 3;
            return;
        }
        int n = AudioSystem.setForceUse(0, 0);
        int n3 = AudioSystem.setForceUse(2, 0);
        this.mForcedUseForComm = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void setMode(int n, IBinder iBinder) {
        block20: {
            SetModeDeathHandler setModeDeathHandler;
            block19: {
                SetModeDeathHandler setModeDeathHandler2;
                block21: {
                    int n2;
                    block18: {
                        int n3;
                        ArrayList<SetModeDeathHandler> arrayList = null;
                        if (!this.checkAudioSettingsPermission("setMode()")) {
                            return;
                        }
                        if (n < -1) {
                            return;
                        }
                        if (n >= 4) {
                            return;
                        }
                        Object object = this.mSettingsLock;
                        // MONITORENTER : object
                        if (n == -1) {
                            n = this.mMode;
                        }
                        if (n == (n3 = this.mMode) || AudioSystem.setPhoneState(n) != 0) break block20;
                        this.mMode = n;
                        arrayList = this.mSetModeDeathHandlers;
                        // MONITORENTER : arrayList
                        setModeDeathHandler = null;
                        Iterator<SetModeDeathHandler> iterator = this.mSetModeDeathHandlers.iterator();
                        while (iterator.hasNext()) {
                            SetModeDeathHandler setModeDeathHandler3 = iterator.next();
                            if (setModeDeathHandler3.getBinder() != iBinder) continue;
                            setModeDeathHandler = setModeDeathHandler3;
                            iterator.remove();
                            setModeDeathHandler2 = setModeDeathHandler;
                            break block18;
                        }
                        setModeDeathHandler2 = setModeDeathHandler;
                    }
                    if (setModeDeathHandler2 != null) break block21;
                    try {
                        setModeDeathHandler = new SetModeDeathHandler(iBinder);
                        if (iBinder == null) break block19;
                        n2 = null;
                    }
                    catch (Throwable throwable) {
                        SetModeDeathHandler setModeDeathHandler4 = setModeDeathHandler2;
                        throw throwable;
                    }
                    try {
                        iBinder.linkToDeath(setModeDeathHandler, n2);
                    }
                    catch (RemoteException remoteException) {
                        String string2 = "setMode() could not link to " + iBinder + " binder death";
                        int n4 = Log.w(TAG, string2);
                    }
                    break block19;
                }
                setModeDeathHandler = setModeDeathHandler2;
            }
            this.mSetModeDeathHandlers.add(0, setModeDeathHandler);
            setModeDeathHandler.setMode(n);
            // MONITOREXIT : arrayList
            if (n != 0) {
                this.clearAllScoClients();
            }
        }
        int n5 = this.getActiveStreamType(Integer.MIN_VALUE);
        VolumeStreamState[] volumeStreamStateArray = this.mStreamStates;
        int n6 = this.STREAM_VOLUME_ALIAS[n5];
        int n7 = volumeStreamStateArray[n6].mIndex;
        int n8 = this.STREAM_VOLUME_ALIAS[n5];
        this.setStreamVolumeInt(n8, n7, true, false);
        // MONITOREXIT : object
    }

    @Override
    public void setRingerMode(int n) {
        Object object = this.mSettingsLock;
        synchronized (object) {
            int n2 = this.mRingerMode;
            if (n != n2) {
                this.setRingerModeInt(n, true);
                this.broadcastRingerMode();
            }
            return;
        }
    }

    @Override
    public void setSpeakerphoneOn(boolean bl) {
        if (!this.checkAudioSettingsPermission("setSpeakerphoneOn()")) {
            return;
        }
        if (bl) {
            int n = AudioSystem.setForceUse(0, 1);
            this.mForcedUseForComm = 1;
            return;
        }
        int n = AudioSystem.setForceUse(0, 0);
        this.mForcedUseForComm = 0;
    }

    @Override
    public void setStreamMute(int n, boolean bl, IBinder iBinder) {
        if (!this.isStreamAffectedByMute(n)) {
            return;
        }
        this.mStreamStates[n].mute(iBinder, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setStreamSolo(int n, boolean bl, IBinder iBinder) {
        int n2 = 0;
        int n3;
        while (n2 < (n3 = this.mStreamStates.length)) {
            if (this.isStreamAffectedByMute(n2) && n2 == n) {
                this.mStreamStates[n2].mute(iBinder, bl);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setStreamVolume(int n, int n2, int n3) {
        this.ensureValidStreamType(n);
        VolumeStreamState[] volumeStreamStateArray = this.mStreamStates;
        int n4 = this.STREAM_VOLUME_ALIAS[n];
        VolumeStreamState volumeStreamState = volumeStreamStateArray[n4];
        int n5 = volumeStreamState.muteCount() != 0 ? volumeStreamState.mLastAudibleIndex : volumeStreamState.mIndex;
        int n6 = n2 * 10;
        int n7 = this.STREAM_VOLUME_ALIAS[n];
        int n8 = this.rescaleIndex(n6, n, n7);
        int n9 = this.STREAM_VOLUME_ALIAS[n];
        this.setStreamVolumeInt(n9, n8, false, true);
        int n10 = volumeStreamState.muteCount() != 0 ? volumeStreamState.mLastAudibleIndex : volumeStreamState.mIndex;
        this.mVolumePanel.postVolumeChanged(n, n3);
        this.sendVolumeUpdate(n, n5, n10);
    }

    @Override
    public void setVibrateSetting(int n, int n2) {
        int n3;
        this.mVibrateSetting = n3 = AudioService.getValueForVibrateSetting(this.mVibrateSetting, n, n2);
        this.broadcastVibrateSetting(n);
        AudioHandler audioHandler = this.mAudioHandler;
        int n4 = 0;
        int n5 = 0;
        AudioService.sendMsg(audioHandler, 4, -1, 1, 0, n4, null, n5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldVibrate(int n) {
        switch (this.getVibrateSetting(n)) {
            default: {
                return false;
            }
            case 1: {
                if (this.mRingerMode == 0) return false;
                return true;
            }
            case 2: {
                if (this.mRingerMode != 1) return false;
                return true;
            }
            case 0: 
        }
        return false;
    }

    @Override
    public void startBluetoothSco(IBinder iBinder) {
        if (!this.checkAudioSettingsPermission("startBluetoothSco()")) {
            return;
        }
        this.getScoClient(iBinder).incCount();
    }

    @Override
    public void stopBluetoothSco(IBinder iBinder) {
        if (!this.checkAudioSettingsPermission("stopBluetoothSco()")) {
            return;
        }
        this.getScoClient(iBinder).decCount();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unloadSoundEffects() {
        Object object = this.mSoundEffectsLock;
        synchronized (object) {
            int n;
            if (this.mSoundPool == null) {
                return;
            }
            int[] nArray = new int[SOUND_EFFECT_FILES.length];
            for (int i = 0; i < (n = SOUND_EFFECT_FILES.length); ++i) {
                nArray[i] = 0;
            }
            int n2 = 0;
            while (true) {
                int n3;
                if (n2 >= 9) {
                    Object var12_11 = null;
                    this.mSoundPool = var12_11;
                    return;
                }
                if (this.SOUND_EFFECT_FILES_MAP[n2][1] > 0 && nArray[n3 = this.SOUND_EFFECT_FILES_MAP[n2][0]] == 0) {
                    SoundPool soundPool = this.mSoundPool;
                    int n4 = this.SOUND_EFFECT_FILES_MAP[n2][1];
                    boolean bl = soundPool.unload(n4);
                    this.SOUND_EFFECT_FILES_MAP[n2][1] = -1;
                    int n5 = this.SOUND_EFFECT_FILES_MAP[n2][0];
                    nArray[n5] = -1;
                }
                ++n2;
            }
        }
    }

    @Override
    public void unregisterAudioFocusClient(String string2) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            this.removeFocusStackEntry(string2, false);
            return;
        }
    }

    @Override
    public void unregisterMediaButtonEventReceiver(ComponentName componentName) {
        String string2 = "  Remote Control   unregisterMediaButtonEventReceiver() for " + componentName;
        int n = Log.i(TAG, string2);
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            this.removeMediaButtonReceiver(componentName);
            return;
        }
    }

    private static class RemoteControlStackEntry {
        public ComponentName mReceiverComponent;

        public RemoteControlStackEntry() {
        }

        public RemoteControlStackEntry(ComponentName componentName) {
            this.mReceiverComponent = componentName;
        }
    }

    private class MediaButtonBroadcastReceiver
    extends BroadcastReceiver {
        private MediaButtonBroadcastReceiver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if (!"android.intent.action.MEDIA_BUTTON".equals(string2)) {
                return;
            }
            if ((KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT") == null) {
                return;
            }
            Object object = mRingingLock;
            synchronized (object) {
                if (AudioService.this.mIsRinging || AudioService.this.getMode() == 2 || AudioService.this.getMode() == 3 || AudioService.this.getMode() == 1) {
                    return;
                }
            }
            Stack stack = AudioService.this.mRCStack;
            synchronized (stack) {
                if (!AudioService.this.mRCStack.empty()) {
                    Intent intent2 = new Intent("android.intent.action.MEDIA_BUTTON");
                    Bundle bundle = intent.getExtras();
                    Intent intent3 = intent2.putExtras(bundle);
                    ComponentName componentName = ((RemoteControlStackEntry)((AudioService)AudioService.this).mRCStack.peek()).mReceiverComponent;
                    Intent intent4 = intent2.setComponent(componentName);
                    this.abortBroadcast();
                    context.sendBroadcast(intent2, null);
                }
                return;
            }
        }
    }

    private class AudioFocusDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        AudioFocusDeathHandler(IBinder iBinder) {
            this.mCb = iBinder;
        }

        @Override
        public void binderDied() {
            Object object = mAudioFocusLock;
            synchronized (object) {
                int n = Log.w(AudioService.TAG, "  AudioFocus   audio focus client died");
                AudioService audioService = AudioService.this;
                IBinder iBinder = this.mCb;
                audioService.removeFocusStackEntryForClient(iBinder);
                return;
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private static class FocusStackEntry {
        public String mClientId;
        public int mFocusChangeType;
        public IAudioFocusDispatcher mFocusDispatcher = null;
        public boolean mIsTransportControlReceiver = false;
        public IBinder mSourceRef = null;
        public int mStreamType = -1;

        public FocusStackEntry() {
        }

        public FocusStackEntry(int n, int n2, boolean bl, IAudioFocusDispatcher iAudioFocusDispatcher, IBinder iBinder, String string2) {
            this.mStreamType = n;
            this.mIsTransportControlReceiver = bl;
            this.mFocusDispatcher = iAudioFocusDispatcher;
            this.mSourceRef = iBinder;
            this.mClientId = string2;
            this.mFocusChangeType = n2;
        }
    }

    private class AudioServiceBroadcastReceiver
    extends BroadcastReceiver {
        private AudioServiceBroadcastReceiver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if (string2.equals("android.intent.action.DOCK_EVENT")) {
                int n;
                Intent intent2 = intent;
                String string3 = "android.intent.extra.DOCK_STATE";
                int n2 = 0;
                switch (intent2.getIntExtra(string3, n2)) {
                    default: {
                        n = 0;
                        break;
                    }
                    case 1: {
                        n = 7;
                        break;
                    }
                    case 2: {
                        n = 6;
                    }
                }
                int n3 = AudioSystem.setForceUse(3, n);
                return;
            }
            if (string2.equals("android.bluetooth.a2dp.action.SINK_STATE_CHANGED")) {
                String string4;
                Integer n;
                HashMap hashMap;
                String string5;
                Integer n4;
                Intent intent3 = intent;
                String string6 = "android.bluetooth.a2dp.extra.SINK_STATE";
                int n5 = 0;
                int n6 = intent3.getIntExtra(string6, n5);
                Intent intent4 = intent;
                String string7 = "android.bluetooth.device.extra.DEVICE";
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent4.getParcelableExtra(string7);
                String string8 = bluetoothDevice.getAddress();
                HashMap hashMap2 = AudioService.this.mConnectedDevices;
                boolean bl = hashMap2.containsKey(n4 = Integer.valueOf(128)) && (string5 = (String)(hashMap = AudioService.this.mConnectedDevices).get(n = Integer.valueOf(128))).equals(string4 = string8);
                if (bl && n6 != 2 && n6 != 4) {
                    if (!bluetoothDevice.isBluetoothDock()) {
                        AudioService.this.makeA2dpDeviceUnavailableNow(string8);
                        return;
                    }
                    if (n6 != 0) {
                        return;
                    }
                    AudioService.this.makeA2dpDeviceUnavailableLater(string8);
                    return;
                }
                if (bl) {
                    return;
                }
                if (n6 != 2 && n6 != 4) {
                    return;
                }
                if (bluetoothDevice.isBluetoothDock()) {
                    AudioService.this.cancelA2dpDeviceTimeout();
                    String string9 = AudioService.access$4602(AudioService.this, string8);
                } else if (AudioService.this.hasScheduledA2dpDockTimeout()) {
                    AudioService.this.cancelA2dpDeviceTimeout();
                    AudioService audioService = AudioService.this;
                    String string10 = AudioService.this.mDockAddress;
                    audioService.makeA2dpDeviceUnavailableNow(string10);
                }
                AudioService.this.makeA2dpDeviceAvailable(string8);
                return;
            }
            if (string2.equals("android.bluetooth.headset.action.STATE_CHANGED")) {
                String string11;
                Integer n;
                HashMap hashMap;
                String string12;
                Integer n7;
                HashMap hashMap3;
                boolean bl;
                Intent intent5 = intent;
                String string13 = "android.bluetooth.headset.extra.STATE";
                int n8 = -1;
                int n9 = intent5.getIntExtra(string13, n8);
                int n10 = 16;
                Intent intent6 = intent;
                String string14 = "android.bluetooth.device.extra.DEVICE";
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent6.getParcelableExtra(string14);
                String string15 = null;
                if (bluetoothDevice != null) {
                    string15 = bluetoothDevice.getAddress();
                    BluetoothClass bluetoothClass = bluetoothDevice.getBluetoothClass();
                    if (bluetoothClass != null) {
                        switch (bluetoothClass.getDeviceClass()) {
                            case 1028: 
                            case 1032: {
                                n10 = 32;
                                break;
                            }
                            case 1056: {
                                n10 = 64;
                            }
                        }
                    }
                }
                if ((bl = (hashMap3 = AudioService.this.mConnectedDevices).containsKey(n7 = Integer.valueOf(n10)) && (string12 = (String)(hashMap = AudioService.this.mConnectedDevices).get(n = Integer.valueOf(n10))).equals(string11 = string15)) && n9 != 2) {
                    int n11 = AudioSystem.setDeviceConnectionState(n10, 0, string15);
                    HashMap hashMap4 = AudioService.this.mConnectedDevices;
                    Integer n12 = n10;
                    Object v = hashMap4.remove(n12);
                    boolean bl2 = AudioService.access$1502(AudioService.this, false);
                    AudioService.this.clearAllScoClients();
                    return;
                }
                if (bl) {
                    return;
                }
                if (n9 != 2) {
                    return;
                }
                int n13 = AudioSystem.setDeviceConnectionState(n10, 1, string15);
                HashMap hashMap5 = AudioService.this.mConnectedDevices;
                Integer n14 = new Integer(n10);
                String string16 = hashMap5.put(n14, string15);
                boolean bl3 = AudioService.access$1502(AudioService.this, true);
                return;
            }
            if (string2.equals("android.intent.action.HEADSET_PLUG")) {
                Intent intent7 = intent;
                String string17 = "state";
                int n = 0;
                int n15 = intent7.getIntExtra(string17, n);
                Intent intent8 = intent;
                String string18 = "microphone";
                int n16 = 0;
                if (intent8.getIntExtra(string18, n16) != 0) {
                    HashMap hashMap = AudioService.this.mConnectedDevices;
                    Integer n17 = 4;
                    boolean bl = hashMap.containsKey(n17);
                    if (n15 == 0 && bl) {
                        int n18 = AudioSystem.setDeviceConnectionState(4, 0, "");
                        HashMap hashMap6 = AudioService.this.mConnectedDevices;
                        Integer n19 = 4;
                        Object v = hashMap6.remove(n19);
                        return;
                    }
                    if (n15 != 1) {
                        return;
                    }
                    if (bl) {
                        return;
                    }
                    int n20 = AudioSystem.setDeviceConnectionState(4, 1, "");
                    HashMap hashMap7 = AudioService.this.mConnectedDevices;
                    Integer n21 = new Integer(4);
                    String string19 = hashMap7.put(n21, "");
                    return;
                }
                HashMap hashMap = AudioService.this.mConnectedDevices;
                Integer n22 = 8;
                boolean bl = hashMap.containsKey(n22);
                if (n15 == 0 && bl) {
                    int n23 = AudioSystem.setDeviceConnectionState(8, 0, "");
                    HashMap hashMap8 = AudioService.this.mConnectedDevices;
                    Integer n24 = 8;
                    Object v = hashMap8.remove(n24);
                    return;
                }
                if (n15 != 1) {
                    return;
                }
                if (bl) {
                    return;
                }
                int n25 = AudioSystem.setDeviceConnectionState(8, 1, "");
                HashMap hashMap9 = AudioService.this.mConnectedDevices;
                Integer n26 = new Integer(8);
                String string20 = hashMap9.put(n26, "");
                return;
            }
            if (!string2.equals("android.bluetooth.headset.action.AUDIO_STATE_CHANGED")) {
                return;
            }
            Intent intent9 = intent;
            String string21 = "android.bluetooth.headset.extra.AUDIO_STATE";
            int n = -1;
            int n27 = intent9.getIntExtra(string21, n);
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int n28;
                if (AudioService.this.mScoClients.isEmpty()) return;
                switch (n27) {
                    default: {
                        return;
                    }
                    case 1: {
                        n28 = 1;
                        break;
                    }
                    case 0: {
                        n28 = 0;
                    }
                }
                if (n28 == -1) return;
                Intent intent10 = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
                Intent intent11 = intent10.putExtra("android.media.extra.SCO_AUDIO_STATE", n28);
                AudioService.this.mContext.sendStickyBroadcast(intent10);
                return;
            }
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        SettingsObserver() {
            Handler handler = new Handler();
            super(handler);
            ContentResolver contentResolver = AudioService.this.mContentResolver;
            Uri uri = Settings.System.getUriFor("mode_ringer_streams_affected");
            contentResolver.registerContentObserver(uri, false, this);
            ContentResolver contentResolver2 = AudioService.this.mContentResolver;
            Uri uri2 = Settings.System.getUriFor("notifications_use_ring_volume");
            contentResolver2.registerContentObserver(uri2, false, this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onChange(boolean bl) {
            super.onChange(bl);
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                int n;
                int n2;
                int n3 = Settings.System.getInt(AudioService.this.mContentResolver, "mode_ringer_streams_affected", 0);
                int n4 = AudioService.this.mRingerModeAffectedStreams;
                if (n3 != n4) {
                    int n5 = AudioService.access$4202(AudioService.this, n3);
                    AudioService audioService = AudioService.this;
                    int n6 = AudioService.this.getRingerMode();
                    audioService.setRingerModeInt(n6, false);
                }
                if ((n2 = Settings.System.getInt(AudioService.this.mContentResolver, "notifications_use_ring_volume", 1)) != (n = AudioService.this.mNotificationsUseRingVolume)) {
                    int n7 = AudioService.access$4302(AudioService.this, n2);
                    if (AudioService.this.mNotificationsUseRingVolume == 1) {
                        ((AudioService)AudioService.this).STREAM_VOLUME_ALIAS[5] = 2;
                        VolumeStreamState volumeStreamState = AudioService.this.mStreamStates[5];
                        String string2 = Settings.System.VOLUME_SETTINGS[2];
                        volumeStreamState.setVolumeIndexSettingName(string2);
                    } else {
                        ((AudioService)AudioService.this).STREAM_VOLUME_ALIAS[5] = 5;
                        VolumeStreamState volumeStreamState = AudioService.this.mStreamStates[5];
                        String string3 = Settings.System.VOLUME_SETTINGS[5];
                        volumeStreamState.setVolumeIndexSettingName(string3);
                        AudioHandler audioHandler = AudioService.this.mAudioHandler;
                        VolumeStreamState volumeStreamState2 = AudioService.this.mStreamStates[5];
                        AudioService.sendMsg(audioHandler, 1, 5, 0, 1, 1, volumeStreamState2, 0);
                    }
                }
                return;
            }
        }
    }

    private class AudioHandler
    extends Handler {
        private AudioHandler() {
        }

        private void cleanupPlayer(MediaPlayer mediaPlayer) {
            if (mediaPlayer == null) {
                return;
            }
            try {
                mediaPlayer.stop();
                mediaPlayer.release();
                return;
            }
            catch (IllegalStateException illegalStateException) {
                String string2 = "MediaPlayer IllegalStateException: " + illegalStateException;
                int n = Log.w(AudioService.TAG, string2);
                return;
            }
        }

        private void persistRingerMode() {
            ContentResolver contentResolver = AudioService.this.mContentResolver;
            int n = AudioService.this.mRingerMode;
            boolean bl = Settings.System.putInt(contentResolver, "mode_ringer", n);
        }

        private void persistVibrateSetting() {
            ContentResolver contentResolver = AudioService.this.mContentResolver;
            int n = AudioService.this.mVibrateSetting;
            boolean bl = Settings.System.putInt(contentResolver, "vibrate_on", n);
        }

        private void persistVolume(VolumeStreamState volumeStreamState, boolean bl, boolean bl2) {
            if (bl) {
                ContentResolver contentResolver = AudioService.this.mContentResolver;
                String string2 = volumeStreamState.mVolumeIndexSettingName;
                int n = (volumeStreamState.mIndex + 5) / 10;
                boolean bl3 = Settings.System.putInt(contentResolver, string2, n);
            }
            if (!bl2) {
                return;
            }
            ContentResolver contentResolver = AudioService.this.mContentResolver;
            String string3 = volumeStreamState.mLastAudibleVolumeIndexSettingName;
            int n = (volumeStreamState.mLastAudibleIndex + 5) / 10;
            boolean bl4 = Settings.System.putInt(contentResolver, string3, n);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void playSoundEffect(int n, int n2) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                float f;
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                if (n2 < 0) {
                    double d = AudioService.this.MAX_STREAM_VOLUME[3];
                    float f2 = (float)(50.0 / d);
                    int n3 = (AudioService.this.mStreamStates[3].mIndex + 5) / 10;
                    int n4 = AudioService.this.MAX_STREAM_VOLUME[3];
                    float f3 = n3 - n4;
                    double d2 = (f2 * f3 - 3.0f) / 20.0f;
                    f = (float)Math.pow(10.0, d2);
                } else {
                    f = (float)n2 / 1000.0f;
                }
                if (AudioService.this.SOUND_EFFECT_FILES_MAP[n][1] > 0) {
                    SoundPool soundPool = AudioService.this.mSoundPool;
                    int n5 = AudioService.this.SOUND_EFFECT_FILES_MAP[n][1];
                    float f4 = f;
                    int n6 = soundPool.play(n5, f, f4, 0, 0, 1.0f);
                } else {
                    MediaPlayer mediaPlayer = new MediaPlayer();
                    if (mediaPlayer != null) {
                        try {
                            StringBuilder stringBuilder = new StringBuilder();
                            File file = Environment.getRootDirectory();
                            StringBuilder stringBuilder2 = stringBuilder.append(file).append(AudioService.SOUND_EFFECTS_PATH);
                            String[] stringArray = SOUND_EFFECT_FILES;
                            int n7 = AudioService.this.SOUND_EFFECT_FILES_MAP[n][0];
                            String string2 = stringArray[n7];
                            String string3 = stringBuilder2.append(string2).toString();
                            mediaPlayer.setDataSource(string3);
                            mediaPlayer.setAudioStreamType(1);
                            mediaPlayer.prepare();
                            mediaPlayer.setVolume(f, f);
                            MediaPlayer.OnCompletionListener onCompletionListener = new MediaPlayer.OnCompletionListener(){

                                @Override
                                public void onCompletion(MediaPlayer mediaPlayer) {
                                    AudioHandler.this.cleanupPlayer(mediaPlayer);
                                }
                            };
                            mediaPlayer.setOnCompletionListener(onCompletionListener);
                            MediaPlayer.OnErrorListener onErrorListener = new MediaPlayer.OnErrorListener(){

                                @Override
                                public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                                    AudioHandler.this.cleanupPlayer(mediaPlayer);
                                    return true;
                                }
                            };
                            mediaPlayer.setOnErrorListener(onErrorListener);
                            mediaPlayer.start();
                        }
                        catch (IOException iOException) {
                            String string4 = "MediaPlayer IOException: " + iOException;
                            int n8 = Log.w(AudioService.TAG, string4);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            String string5 = "MediaPlayer IllegalArgumentException: " + illegalArgumentException;
                            int n9 = Log.w(AudioService.TAG, string5);
                        }
                        catch (IllegalStateException illegalStateException) {
                            String string6 = "MediaPlayer IllegalStateException: " + illegalStateException;
                            int n10 = Log.w(AudioService.TAG, string6);
                        }
                    }
                }
                return;
            }
        }

        private void setSystemVolume(VolumeStreamState volumeStreamState) {
            AudioService audioService = AudioService.this;
            int n = volumeStreamState.mStreamType;
            int n2 = volumeStreamState.mIndex;
            audioService.setStreamVolumeIndex(n, n2);
            for (int i = AudioSystem.getNumStreamTypes() - 1; i >= 0; i += -1) {
                int n3;
                int n4;
                int n5 = volumeStreamState.mStreamType;
                if (i == n5 || (n4 = AudioService.this.STREAM_VOLUME_ALIAS[i]) == (n3 = volumeStreamState.mStreamType)) continue;
                AudioService audioService2 = AudioService.this;
                int n6 = AudioService.this.mStreamStates[i].mIndex;
                audioService2.setStreamVolumeIndex(i, n6);
            }
            AudioHandler audioHandler = AudioService.this.mAudioHandler;
            int n7 = volumeStreamState.mStreamType;
            int n8 = 1;
            int n9 = 1;
            VolumeStreamState volumeStreamState2 = volumeStreamState;
            AudioService.sendMsg(audioHandler, 1, n7, 0, n8, n9, volumeStreamState2, 3000);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            switch (AudioService.getMsgBase(message.what)) {
                default: {
                    return;
                }
                case 0: {
                    VolumeStreamState volumeStreamState = (VolumeStreamState)message.obj;
                    this.setSystemVolume(volumeStreamState);
                    return;
                }
                case 1: {
                    VolumeStreamState volumeStreamState = (VolumeStreamState)message.obj;
                    boolean bl = message.arg1 != 0;
                    boolean bl2 = message.arg2 != 0;
                    AudioHandler audioHandler = this;
                    VolumeStreamState volumeStreamState2 = volumeStreamState;
                    boolean bl3 = bl;
                    boolean bl4 = bl2;
                    audioHandler.persistVolume(volumeStreamState2, bl3, bl4);
                    return;
                }
                case 3: {
                    this.persistRingerMode();
                    return;
                }
                case 4: {
                    this.persistVibrateSetting();
                    return;
                }
                case 5: {
                    if (AudioService.this.mMediaServerOk) {
                        return;
                    }
                    int n = Log.e(AudioService.TAG, "Media server died.");
                    boolean bl = AudioSystem.isStreamActive(3);
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 5, -1, 1, 0, 0, null, 500);
                    return;
                }
                case 6: {
                    int n = Log.e(AudioService.TAG, "Media server started.");
                    int n2 = AudioSystem.setParameters("restarting=true");
                    for (Map.Entry entry : AudioService.this.mConnectedDevices.entrySet()) {
                        int n3 = (Integer)entry.getKey();
                        String string2 = (String)entry.getValue();
                        int n4 = n3;
                        int n5 = 1;
                        String string3 = string2;
                        int n6 = AudioSystem.setDeviceConnectionState(n4, n5, string3);
                    }
                    int n7 = AudioSystem.setPhoneState(AudioService.this.mMode);
                    int n8 = AudioService.this.mForcedUseForComm;
                    int n9 = AudioSystem.setForceUse(0, n8);
                    int n10 = AudioService.this.mForcedUseForComm;
                    int n11 = AudioSystem.setForceUse(2, n10);
                    int n12 = AudioSystem.getNumStreamTypes() - 1;
                    while (true) {
                        if (n12 < 0) {
                            AudioService audioService = AudioService.this;
                            int n13 = AudioService.this.getRingerMode();
                            audioService.setRingerModeInt(n13, false);
                            int n14 = AudioSystem.setParameters("restarting=false");
                            return;
                        }
                        VolumeStreamState volumeStreamState = AudioService.this.mStreamStates[n12];
                        int n15 = (volumeStreamState.mIndexMax + 5) / 10;
                        int n16 = n12;
                        int n17 = 0;
                        int n18 = n15;
                        int n19 = AudioSystem.initStreamVolume(n16, n17, n18);
                        int n20 = volumeStreamState.muteCount() == 0 ? volumeStreamState.mIndex : 0;
                        AudioService audioService = AudioService.this;
                        int n21 = n12;
                        int n22 = n20;
                        audioService.setStreamVolumeIndex(n21, n22);
                        n12 += -1;
                    }
                }
                case 7: {
                    int n = message.arg1;
                    int n23 = message.arg2;
                    AudioHandler audioHandler = this;
                    int n24 = n;
                    int n25 = n23;
                    audioHandler.playSoundEffect(n24, n25);
                    return;
                }
                case 8: 
            }
            AudioService audioService = AudioService.this;
            String string4 = (String)message.obj;
            AudioService audioService2 = audioService;
            String string5 = string4;
            audioService2.makeA2dpDeviceUnavailableNow(string5);
        }
    }

    private class AudioSystemThread
    extends Thread {
        AudioSystemThread() {
            super(AudioService.TAG);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Looper.prepare();
            AudioService audioService = AudioService.this;
            synchronized (audioService) {
                AudioService audioService2 = AudioService.this;
                AudioService audioService3 = AudioService.this;
                AudioHandler audioHandler = audioService3.new AudioHandler();
                AudioHandler audioHandler2 = AudioService.access$102(audioService2, audioHandler);
                AudioService.this.notify();
            }
            Looper.loop();
        }
    }

    public class VolumeStreamState {
        private ArrayList<VolumeDeathHandler> mDeathHandlers;
        private int mIndex;
        private int mIndexMax;
        private int mLastAudibleIndex;
        private String mLastAudibleVolumeIndexSettingName;
        private final int mStreamType;
        private String mVolumeIndexSettingName;

        /*
         * Enabled aggressive block sorting
         */
        private VolumeStreamState(String string2, int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            this.setVolumeIndexSettingName(string2);
            this.mStreamType = n;
            ContentResolver contentResolver = AudioService.this.mContentResolver;
            this.mIndexMax = n7 = AudioService.this.MAX_STREAM_VOLUME[n];
            String string3 = this.mVolumeIndexSettingName;
            int n8 = AudioManager.DEFAULT_STREAM_VOLUME[n];
            this.mIndex = n6 = Settings.System.getInt(contentResolver, string3, n8);
            String string4 = this.mLastAudibleVolumeIndexSettingName;
            int n9 = this.mIndex > 0 ? this.mIndex : AudioManager.DEFAULT_STREAM_VOLUME[n];
            this.mLastAudibleIndex = n5 = Settings.System.getInt(contentResolver, string4, n9);
            int n10 = this.mIndexMax;
            int n11 = AudioSystem.initStreamVolume(n, 0, n10);
            this.mIndexMax = n4 = this.mIndexMax * 10;
            int n12 = this.mIndex * 10;
            this.mIndex = n3 = this.getValidIndex(n12);
            int n13 = this.mLastAudibleIndex * 10;
            this.mLastAudibleIndex = n2 = this.getValidIndex(n13);
            int n14 = this.mIndex;
            AudioService.this.setStreamVolumeIndex(n, n14);
            ArrayList arrayList = new ArrayList();
            this.mDeathHandlers = arrayList;
        }

        static /* synthetic */ int access$602(VolumeStreamState volumeStreamState, int n) {
            volumeStreamState.mIndex = n;
            return n;
        }

        static /* synthetic */ int access$802(VolumeStreamState volumeStreamState, int n) {
            volumeStreamState.mLastAudibleIndex = n;
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private VolumeDeathHandler getDeathHandler(IBinder iBinder, boolean bl) {
            ArrayList<VolumeDeathHandler> arrayList = this.mDeathHandlers;
            synchronized (arrayList) {
                VolumeDeathHandler volumeDeathHandler;
                int n = this.mDeathHandlers.size();
                for (int i = 0; i < n; ++i) {
                    volumeDeathHandler = this.mDeathHandlers.get(i);
                    IBinder iBinder2 = volumeDeathHandler.mICallback;
                    if (iBinder != iBinder2) continue;
                    return volumeDeathHandler;
                }
                if (bl) {
                    volumeDeathHandler = new VolumeDeathHandler(iBinder);
                    return volumeDeathHandler;
                }
                int n2 = Log.w(AudioService.TAG, "stream was not muted by this client");
                return null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int getValidIndex(int n) {
            if (n < 0) {
                return 0;
            }
            int n2 = this.mIndexMax;
            if (n <= n2) return n;
            return this.mIndexMax;
        }

        private int muteCount() {
            int n = 0;
            int n2 = this.mDeathHandlers.size();
            for (int i = 0; i < n2; ++i) {
                int n3 = this.mDeathHandlers.get(i).mMuteCount;
                n += n3;
            }
            return n;
        }

        public boolean adjustIndex(int n) {
            int n2 = this.mIndex;
            int n3 = n * 10;
            int n4 = n2 + n3;
            return this.setIndex(n4, true);
        }

        public void adjustLastAudibleIndex(int n) {
            int n2 = this.mLastAudibleIndex;
            int n3 = n * 10;
            int n4 = n2 + n3;
            this.setLastAudibleIndex(n4);
        }

        public int getMaxIndex() {
            return this.mIndexMax;
        }

        public void mute(IBinder iBinder, boolean bl) {
            VolumeDeathHandler volumeDeathHandler = this.getDeathHandler(iBinder, bl);
            if (volumeDeathHandler == null) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not get client death handler for stream: ");
                int n = this.mStreamType;
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.e(AudioService.TAG, string2);
                return;
            }
            volumeDeathHandler.mute(bl);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean setIndex(int n, boolean bl) {
            int n2 = this.mIndex;
            int n3 = this.getValidIndex(n);
            this.mIndex = n3;
            int n4 = this.mIndex;
            if (n2 == n4) return false;
            if (bl) {
                int n5;
                this.mLastAudibleIndex = n5 = this.mIndex;
            }
            int n6 = AudioSystem.getNumStreamTypes() - 1;
            while (n6 >= 0) {
                int n7;
                int n8;
                int n9 = this.mStreamType;
                if (n6 != n9 && (n8 = AudioService.this.STREAM_VOLUME_ALIAS[n6]) != (n7 = this.mStreamType)) {
                    VolumeStreamState volumeStreamState = AudioService.this.mStreamStates[n6];
                    AudioService audioService = AudioService.this;
                    int n10 = this.mIndex;
                    int n11 = this.mStreamType;
                    int n12 = audioService.rescaleIndex(n10, n11, n6);
                    boolean bl2 = volumeStreamState.setIndex(n12, bl);
                }
                n6 += -1;
            }
            return true;
        }

        public void setLastAudibleIndex(int n) {
            int n2;
            this.mLastAudibleIndex = n2 = this.getValidIndex(n);
        }

        public void setVolumeIndexSettingName(String string2) {
            String string3;
            this.mVolumeIndexSettingName = string2;
            this.mLastAudibleVolumeIndexSettingName = string3 = string2 + "_last_audible";
        }

        private class VolumeDeathHandler
        implements IBinder.DeathRecipient {
            private IBinder mICallback;
            private int mMuteCount;

            VolumeDeathHandler(IBinder iBinder) {
                this.mICallback = iBinder;
            }

            static /* synthetic */ int access$1302(VolumeDeathHandler volumeDeathHandler, int n) {
                volumeDeathHandler.mMuteCount = n;
                return n;
            }

            @Override
            public void binderDied() {
                StringBuilder stringBuilder = new StringBuilder().append("Volume service client died for stream: ");
                int n = VolumeStreamState.this.mStreamType;
                String string2 = stringBuilder.append(n).toString();
                int n2 = Log.w(AudioService.TAG, string2);
                if (this.mMuteCount == 0) {
                    return;
                }
                this.mMuteCount = 1;
                this.mute(false);
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void mute(boolean var1_1) {
                var2_2 = VolumeStreamState.access$1200(VolumeStreamState.this);
                synchronized (var2_2) {
                    if (var1_1) {
                        var3_3 = this.mMuteCount;
                        if (var3_3 == 0) {
                            try {
                                if (this.mICallback != null) {
                                    this.mICallback.linkToDeath(this, 0);
                                }
                                var4_4 = VolumeStreamState.access$1200(VolumeStreamState.this).add(this);
                                if (VolumeStreamState.access$900(VolumeStreamState.this) != 0) ** GOTO lbl25
                                var5_5 = VolumeStreamState.this.setIndex(0, false);
                                var6_6 = AudioService.access$100(AudioService.this);
                                var7_7 = VolumeStreamState.access$2300(VolumeStreamState.this);
                                var8_8 = VolumeStreamState.this;
                                AudioService.access$200(var6_6, 0, var7_7, 1, 0, 0, var8_8, 0);
                            }
                            catch (RemoteException var10_10) {
                                this.binderDied();
                                VolumeStreamState.access$1200(VolumeStreamState.this).notify();
                                return;
                            }
                        } else {
                            var12_11 = new StringBuilder().append("stream: ");
                            var13_12 = VolumeStreamState.access$2300(VolumeStreamState.this);
                            var14_13 = var12_11.append(var13_12).append(" was already muted by this client").toString();
                            var15_14 = Log.w("AudioService", var14_13);
                        }
lbl25:
                        // 3 sources

                        this.mMuteCount = var9_9 = this.mMuteCount + 1;
                    } else if (this.mMuteCount == 0) {
                        var16_15 = new StringBuilder().append("unexpected unmute for stream: ");
                        var17_16 = VolumeStreamState.access$2300(VolumeStreamState.this);
                        var18_17 = var16_15.append(var17_16).toString();
                        var19_18 = Log.e("AudioService", var18_17);
                    } else {
                        this.mMuteCount = var20_19 = this.mMuteCount - 1;
                        if (this.mMuteCount == 0) {
                            var21_20 = VolumeStreamState.access$1200(VolumeStreamState.this).remove(this);
                            if (this.mICallback != null) {
                                var22_21 = this.mICallback.unlinkToDeath(this, 0);
                            }
                            if (!(VolumeStreamState.access$900(VolumeStreamState.this) != 0 || (var23_22 = AudioService.this).isStreamAffectedByRingerMode(var24_23 = VolumeStreamState.access$2300(VolumeStreamState.this)) && AudioService.access$2400(AudioService.this) != 2)) {
                                var25_24 = VolumeStreamState.this;
                                var26_25 = VolumeStreamState.access$800(VolumeStreamState.this);
                                var27_26 = var25_24.setIndex(var26_25, false);
                                var28_27 = AudioService.access$100(AudioService.this);
                                var29_28 = VolumeStreamState.access$2300(VolumeStreamState.this);
                                var30_29 = VolumeStreamState.this;
                                AudioService.access$200(var28_27, 0, var29_28, 1, 0, 0, var30_29, 0);
                            }
                        }
                    }
                    VolumeStreamState.access$1200(VolumeStreamState.this).notify();
                    return;
                }
            }
        }
    }

    private class ScoClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mStartcount;

        ScoClient(IBinder iBinder) {
            this.mCb = iBinder;
            this.mStartcount = 0;
        }

        private void requestScoState(int n) {
            if (this.totalCount() != 0) {
                return;
            }
            if (!AudioService.this.mBluetoothHeadsetConnected) {
                return;
            }
            if (AudioService.this.mMode != 0) {
                return;
            }
            if (n == 1) {
                boolean bl = AudioService.this.mBluetoothHeadset.startVoiceRecognition();
                return;
            }
            boolean bl = AudioService.this.mBluetoothHeadset.stopVoiceRecognition();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int n = Log.w(AudioService.TAG, "SCO client died");
                if (AudioService.this.mScoClients.indexOf(this) < 0) {
                    int n2 = Log.w(AudioService.TAG, "unregistered SCO client died");
                } else {
                    this.clearCount(true);
                    boolean bl = AudioService.this.mScoClients.remove(this);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void clearCount(boolean bl) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int n = this.mStartcount;
                if (n != 0) {
                    try {
                        boolean bl2 = this.mCb.unlinkToDeath(this, 0);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        StringBuilder stringBuilder = new StringBuilder().append("clearCount() mStartcount: ");
                        int n2 = this.mStartcount;
                        String string2 = stringBuilder.append(n2).append(" != 0 but not registered to binder").toString();
                        int n3 = Log.w(AudioService.TAG, string2);
                    }
                }
                this.mStartcount = n = 0;
                if (bl) {
                    this.requestScoState(0);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void decCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount == 0) {
                    int n = Log.w(AudioService.TAG, "ScoClient.decCount() already 0");
                } else {
                    int n = this.mStartcount - 1;
                    this.mStartcount = n;
                    int n2 = this.mStartcount;
                    if (n2 == 0) {
                        try {
                            boolean bl = this.mCb.unlinkToDeath(this, 0);
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            int n3 = Log.w(AudioService.TAG, "decCount() going to 0 but not registered to binder");
                        }
                    }
                    n2 = 0;
                    this.requestScoState(n2);
                }
                return;
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }

        public int getCount() {
            return this.mStartcount;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void incCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int n;
                this.requestScoState(1);
                int n2 = this.mStartcount;
                if (n2 == 0) {
                    try {
                        this.mCb.linkToDeath(this, 0);
                    }
                    catch (RemoteException remoteException) {
                        StringBuilder stringBuilder = new StringBuilder().append("ScoClient  incCount() could not link to ");
                        IBinder iBinder = this.mCb;
                        String string2 = stringBuilder.append(iBinder).append(" binder death").toString();
                        int n3 = Log.w(AudioService.TAG, string2);
                    }
                }
                this.mStartcount = n = this.mStartcount + 1;
                return;
            }
        }

        public int totalCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int n = 0;
                int n2 = AudioService.this.mScoClients.size();
                for (int i = 0; i < n2; ++i) {
                    int n3 = ((ScoClient)AudioService.this.mScoClients.get(i)).getCount();
                    n += n3;
                }
                return n;
            }
        }
    }

    private class SetModeDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mMode = 0;

        SetModeDeathHandler(IBinder iBinder) {
            this.mCb = iBinder;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
            synchronized (arrayList) {
                int n = Log.w(AudioService.TAG, "setMode() client died");
                int n2 = AudioService.this.mSetModeDeathHandlers.indexOf(this);
                if (n2 < 0) {
                    int n3 = Log.w(AudioService.TAG, "unregistered setMode() client died");
                } else {
                    boolean bl = AudioService.this.mSetModeDeathHandlers.remove(this);
                    if (n2 == 0) {
                        int n4 = ((SetModeDeathHandler)AudioService.this.mSetModeDeathHandlers.get(0)).getMode();
                        if (AudioService.this.mMode != n4 && AudioSystem.setPhoneState(n4) == 0) {
                            int n5 = AudioService.access$1102(AudioService.this, n4);
                        }
                    }
                }
                return;
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }

        public int getMode() {
            return this.mMode;
        }

        public void setMode(int n) {
            this.mMode = n;
        }
    }
}

