/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;

public class AudioTrack {
    public static final int ERROR = 255;
    public static final int ERROR_BAD_VALUE = 254;
    public static final int ERROR_INVALID_OPERATION = 253;
    private static final int ERROR_NATIVESETUP_AUDIOSYSTEM = 240;
    private static final int ERROR_NATIVESETUP_INVALIDCHANNELMASK = 239;
    private static final int ERROR_NATIVESETUP_INVALIDFORMAT = 238;
    private static final int ERROR_NATIVESETUP_INVALIDSTREAMTYPE = 237;
    private static final int ERROR_NATIVESETUP_NATIVEINITFAILED = 236;
    public static final int MODE_STATIC = 0;
    public static final int MODE_STREAM = 1;
    private static final int NATIVE_EVENT_MARKER = 3;
    private static final int NATIVE_EVENT_NEW_POS = 4;
    public static final int PLAYSTATE_PAUSED = 2;
    public static final int PLAYSTATE_PLAYING = 3;
    public static final int PLAYSTATE_STOPPED = 1;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_NO_STATIC_DATA = 2;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int SUCCESS = 0;
    private static final String TAG = "AudioTrack-Java";
    private static final float VOLUME_MAX = 1.0f;
    private static final float VOLUME_MIN;
    private int mAudioFormat;
    private int mChannelConfiguration;
    private int mChannelCount;
    private int mChannels;
    private int mDataLoadMode;
    private NativeEventHandlerDelegate mEventHandlerDelegate;
    private Looper mInitializationLooper;
    private int mJniData;
    private int mNativeBufferSizeInBytes;
    private int mNativeTrackInJavaObj;
    private int mPlayState;
    private final Object mPlayStateLock;
    private OnPlaybackPositionUpdateListener mPositionListener;
    private final Object mPositionListenerLock;
    private int mSampleRate;
    private int mSessionId;
    private int mState;
    private int mStreamType;

    public AudioTrack(int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        AudioTrack audioTrack = this;
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        audioTrack(n7, n8, n9, n10, n11, n12, 0);
    }

    public AudioTrack(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalArgumentException {
        int n8;
        Looper looper;
        Object object;
        Object object2;
        this.mState = 0;
        this.mPlayState = 1;
        this.mPlayStateLock = object2 = new Object();
        this.mPositionListener = null;
        this.mPositionListenerLock = object = new Object();
        this.mNativeBufferSizeInBytes = 0;
        this.mEventHandlerDelegate = null;
        this.mInitializationLooper = null;
        this.mSampleRate = 22050;
        this.mChannelCount = 1;
        this.mChannels = 4;
        this.mStreamType = 3;
        this.mDataLoadMode = 1;
        this.mChannelConfiguration = 4;
        this.mAudioFormat = 2;
        this.mSessionId = 0;
        this.mState = 0;
        this.mInitializationLooper = looper = Looper.myLooper();
        if (looper == null) {
            Looper looper2;
            this.mInitializationLooper = looper2 = Looper.getMainLooper();
        }
        AudioTrack audioTrack = this;
        int n9 = n;
        int n10 = n2;
        int n11 = n3;
        int n12 = n4;
        int n13 = n6;
        audioTrack.audioParamCheck(n9, n10, n11, n12, n13);
        AudioTrack audioTrack2 = this;
        int n14 = n5;
        audioTrack2.audioBuffSizeCheck(n14);
        if (n7 < 0) {
            StringBuilder stringBuilder = new StringBuilder().append("Invalid audio session ID: ");
            int n15 = n7;
            String string2 = stringBuilder.append(n15).toString();
            throw new IllegalArgumentException(string2);
        }
        int[] nArray = new int[]{n7};
        WeakReference<AudioTrack> weakReference = new WeakReference<AudioTrack>(this);
        int n16 = this.mStreamType;
        int n17 = this.mSampleRate;
        int n18 = this.mChannels;
        int n19 = this.mAudioFormat;
        int n20 = this.mNativeBufferSizeInBytes;
        int n21 = this.mDataLoadMode;
        int n22 = this.native_setup(weakReference, n16, n17, n18, n19, n20, n21, nArray);
        if (n22 != 0) {
            AudioTrack.loge("Error code " + n22 + " when initializing AudioTrack.");
            return;
        }
        this.mSessionId = n8 = nArray[0];
        if (this.mDataLoadMode == 0) {
            this.mState = 2;
            return;
        }
        this.mState = 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void audioBuffSizeCheck(int n) {
        int n2 = this.mChannelCount;
        int n3 = this.mAudioFormat == 3 ? 1 : 2;
        int n4 = n2 * n3;
        if (n % n4 == 0 && n >= 1) {
            this.mNativeBufferSizeInBytes = n;
            return;
        }
        throw new IllegalArgumentException("Invalid audio buffer size.");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void audioParamCheck(int n, int n2, int n3, int n4, int n5) {
        if (n != 4 && n != 3 && n != 2 && n != 1 && n != 0 && n != 5 && n != 6 && n != 8) {
            throw new IllegalArgumentException("Invalid stream type.");
        }
        this.mStreamType = n;
        if (n2 < 4000 || n2 > 48000) {
            String string2 = n2 + "Hz is not a supported sample rate.";
            throw new IllegalArgumentException(string2);
        }
        this.mSampleRate = n2;
        this.mChannelConfiguration = n3;
        switch (n3) {
            default: {
                this.mChannelCount = 0;
                this.mChannels = 0;
                this.mChannelConfiguration = 0;
                throw new IllegalArgumentException("Unsupported channel configuration.");
            }
            case 1: 
            case 2: 
            case 4: {
                this.mChannelCount = 1;
                this.mChannels = 4;
                break;
            }
            case 3: 
            case 12: {
                this.mChannelCount = 2;
                this.mChannels = 12;
            }
        }
        switch (n4) {
            default: {
                this.mAudioFormat = 0;
                throw new IllegalArgumentException("Unsupported sample encoding. Should be ENCODING_PCM_8BIT or ENCODING_PCM_16BIT.");
            }
            case 1: {
                this.mAudioFormat = 2;
                break;
            }
            case 2: 
            case 3: {
                this.mAudioFormat = n4;
            }
        }
        if (n5 != 1 && n5 != 0) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        this.mDataLoadMode = n5;
    }

    public static float getMaxVolume() {
        return 1.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getMinBufferSize(int n, int n2, int n3) {
        int n4;
        switch (n2) {
            default: {
                AudioTrack.loge("getMinBufferSize(): Invalid channel configuration.");
                return -1;
            }
            case 2: 
            case 4: {
                n4 = 1;
                break;
            }
            case 3: 
            case 12: {
                n4 = 2;
            }
        }
        if (n3 != 2 && n3 != 3) {
            AudioTrack.loge("getMinBufferSize(): Invalid audio format.");
            return -1;
        }
        if (n < 4000 || n > 48000) {
            AudioTrack.loge("getMinBufferSize(): " + n + "Hz is not a supported sample rate.");
            return -1;
        }
        int n5 = AudioTrack.native_get_min_buff_size(n, n4, n3);
        if (n5 != -1 && n5 != 0) {
            return n5;
        }
        AudioTrack.loge("getMinBufferSize(): error querying hardware");
        return -1;
    }

    public static float getMinVolume() {
        return 0.0f;
    }

    public static int getNativeOutputSampleRate(int n) {
        return AudioTrack.native_get_output_sample_rate(n);
    }

    private static void logd(String string2) {
        String string3 = "[ android.media.AudioTrack ] " + string2;
        int n = Log.d(TAG, string3);
    }

    private static void loge(String string2) {
        String string3 = "[ android.media.AudioTrack ] " + string2;
        int n = Log.e(TAG, string3);
    }

    private final native int native_attachAuxEffect(int var1);

    private final native void native_finalize();

    private final native void native_flush();

    private final native int native_get_marker_pos();

    private static final native int native_get_min_buff_size(int var0, int var1, int var2);

    private final native int native_get_native_frame_count();

    private static final native int native_get_output_sample_rate(int var0);

    private final native int native_get_playback_rate();

    private final native int native_get_pos_update_period();

    private final native int native_get_position();

    private final native int native_get_session_id();

    private final native void native_pause();

    private final native void native_release();

    private final native int native_reload_static();

    private final native void native_setAuxEffectSendLevel(float var1);

    private final native void native_setVolume(float var1, float var2);

    private final native int native_set_loop(int var1, int var2, int var3);

    private final native int native_set_marker_pos(int var1);

    private final native int native_set_playback_rate(int var1);

    private final native int native_set_pos_update_period(int var1);

    private final native int native_set_position(int var1);

    private final native int native_setup(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int[] var8);

    private final native void native_start();

    private final native void native_stop();

    private final native int native_write_byte(byte[] var1, int var2, int var3, int var4);

    private final native int native_write_short(short[] var1, int var2, int var3, int var4);

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        AudioTrack audioTrack = (AudioTrack)((WeakReference)object).get();
        if (audioTrack == null) {
            return;
        }
        if (audioTrack.mEventHandlerDelegate == null) {
            return;
        }
        Message message = audioTrack.mEventHandlerDelegate.getHandler().obtainMessage(n, n2, n3, object2);
        boolean bl = audioTrack.mEventHandlerDelegate.getHandler().sendMessage(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int attachAuxEffect(int n) {
        if (this.mState == 1) return this.native_attachAuxEffect(n);
        return -1;
    }

    protected void finalize() {
        this.native_finalize();
    }

    public void flush() {
        if (this.mState != 1) {
            return;
        }
        this.native_flush();
    }

    public int getAudioFormat() {
        return this.mAudioFormat;
    }

    public int getAudioSessionId() {
        return this.mSessionId;
    }

    public int getChannelConfiguration() {
        return this.mChannelConfiguration;
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    protected int getNativeFrameCount() {
        return this.native_get_native_frame_count();
    }

    public int getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    public int getPlayState() {
        return this.mPlayState;
    }

    public int getPlaybackHeadPosition() {
        return this.native_get_position();
    }

    public int getPlaybackRate() {
        return this.native_get_playback_rate();
    }

    public int getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getState() {
        return this.mState;
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    public void pause() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("pause() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_pause();
            this.mPlayState = 2;
            return;
        }
    }

    public void play() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("play() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_start();
            this.mPlayState = 3;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {}
        this.native_release();
        this.mState = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int reloadStaticData() {
        if (this.mDataLoadMode != 1) return this.native_reload_static();
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setAuxEffectSendLevel(float f) {
        float f2;
        if (this.mState != 1) {
            return -1;
        }
        float f3 = AudioTrack.getMinVolume();
        if (f < f3) {
            f = AudioTrack.getMinVolume();
        }
        if (f > (f2 = AudioTrack.getMaxVolume())) {
            f = AudioTrack.getMaxVolume();
        }
        this.native_setAuxEffectSendLevel(f);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setLoopPoints(int n, int n2, int n3) {
        if (this.mDataLoadMode != 1) return this.native_set_loop(n, n2, n3);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setNotificationMarkerPosition(int n) {
        if (this.mState == 1) return this.native_set_marker_pos(n);
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setPlaybackHeadPosition(int n) {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            void var2_4;
            if (this.mPlayState == 1 || this.mPlayState == 2) {
                int n2 = this.native_set_position(n);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                int n3 = n2;
                return (int)var2_4;
            }
            return (int)var2_4;
        }
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener) {
        this.setPlaybackPositionUpdateListener(onPlaybackPositionUpdateListener, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener, Handler handler) {
        NativeEventHandlerDelegate nativeEventHandlerDelegate;
        Object object = this.mPositionListenerLock;
        // MONITORENTER : object
        this.mPositionListener = onPlaybackPositionUpdateListener;
        // MONITOREXIT : object
        if (onPlaybackPositionUpdateListener == null) {
            return;
        }
        this.mEventHandlerDelegate = nativeEventHandlerDelegate = new NativeEventHandlerDelegate(this, handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setPlaybackRate(int n) {
        if (this.mState != 1) {
            return -1;
        }
        if (n > 0) return this.native_set_playback_rate(n);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setPositionNotificationPeriod(int n) {
        if (this.mState == 1) return this.native_set_pos_update_period(n);
        return -1;
    }

    protected void setState(int n) {
        this.mState = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setStereoVolume(float f, float f2) {
        float f3;
        float f4;
        float f5;
        if (this.mState != 1) {
            return -1;
        }
        float f6 = AudioTrack.getMinVolume();
        if (f < f6) {
            f = AudioTrack.getMinVolume();
        }
        if (f > (f5 = AudioTrack.getMaxVolume())) {
            f = AudioTrack.getMaxVolume();
        }
        if (f2 < (f4 = AudioTrack.getMinVolume())) {
            f2 = AudioTrack.getMinVolume();
        }
        if (f2 > (f3 = AudioTrack.getMaxVolume())) {
            f2 = AudioTrack.getMaxVolume();
        }
        this.native_setVolume(f, f2);
        return 0;
    }

    public void stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_stop();
            this.mPlayState = 1;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int write(byte[] byArray, int n, int n2) {
        if (this.mDataLoadMode == 0 && this.mState == 2 && n2 > 0) {
            this.mState = 1;
        }
        if (this.mState != 1) {
            return -1;
        }
        if (byArray == null) return -1;
        if (n < 0) return -1;
        if (n2 < 0) return -1;
        int n3 = n + n2;
        int n4 = byArray.length;
        if (n3 > n4) {
            return -1;
        }
        int n5 = this.mAudioFormat;
        return this.native_write_byte(byArray, n, n2, n5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int write(short[] sArray, int n, int n2) {
        if (this.mDataLoadMode == 0 && this.mState == 2 && n2 > 0) {
            this.mState = 1;
        }
        if (this.mState != 1) {
            return -1;
        }
        if (sArray == null) return -1;
        if (n < 0) return -1;
        if (n2 < 0) return -1;
        int n3 = n + n2;
        int n4 = sArray.length;
        if (n3 > n4) {
            return -1;
        }
        int n5 = this.mAudioFormat;
        return this.native_write_short(sArray, n, n2, n5);
    }

    private class NativeEventHandlerDelegate {
        private final AudioTrack mAudioTrack;
        private final Handler mHandler;

        /*
         * Enabled aggressive block sorting
         */
        NativeEventHandlerDelegate(AudioTrack audioTrack2, Handler handler) {
            this.mAudioTrack = audioTrack2;
            Looper looper = handler != null ? handler.getLooper() : AudioTrack.this.mInitializationLooper;
            if (looper != null) {
                Handler handler2;
                this.mHandler = handler2 = new Handler(looper){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void handleMessage(Message message) {
                        OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener;
                        if (NativeEventHandlerDelegate.this.mAudioTrack == null) {
                            return;
                        }
                        Object object = AudioTrack.this.mPositionListenerLock;
                        synchronized (object) {
                            onPlaybackPositionUpdateListener = NativeEventHandlerDelegate.this.mAudioTrack.mPositionListener;
                        }
                        switch (message.what) {
                            default: {
                                StringBuilder stringBuilder = new StringBuilder().append("[ android.media.AudioTrack.NativeEventHandler ] Unknown event type: ");
                                int n = message.what;
                                String string2 = stringBuilder.append(n).toString();
                                int n2 = Log.e(AudioTrack.TAG, string2);
                                return;
                            }
                            case 3: {
                                if (onPlaybackPositionUpdateListener == null) {
                                    return;
                                }
                                AudioTrack audioTrack = NativeEventHandlerDelegate.this.mAudioTrack;
                                onPlaybackPositionUpdateListener.onMarkerReached(audioTrack);
                                return;
                            }
                            case 4: 
                        }
                        if (onPlaybackPositionUpdateListener == null) {
                            return;
                        }
                        AudioTrack audioTrack = NativeEventHandlerDelegate.this.mAudioTrack;
                        onPlaybackPositionUpdateListener.onPeriodicNotification(audioTrack);
                    }
                };
                return;
            }
            this.mHandler = null;
        }

        Handler getHandler() {
            return this.mHandler;
        }
    }

    public static interface OnPlaybackPositionUpdateListener {
        public void onMarkerReached(AudioTrack var1);

        public void onPeriodicNotification(AudioTrack var1);
    }
}

