/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.hardware.Camera;
import java.util.Arrays;
import java.util.HashMap;

public class CameraProfile {
    public static final int QUALITY_HIGH = 2;
    public static final int QUALITY_LOW = 0;
    public static final int QUALITY_MEDIUM = 1;
    private static final HashMap<Integer, int[]> sCache = new HashMap();

    static {
        System.loadLibrary("media_jni");
        CameraProfile.native_init();
    }

    private static int[] getImageEncodingQualityLevels(int n) {
        int n2 = CameraProfile.native_get_num_image_encoding_quality_levels(n);
        if (n2 != 3) {
            String string2 = "Unexpected Jpeg encoding quality levels " + n2;
            throw new RuntimeException(string2);
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            nArray[i] = n3 = CameraProfile.native_get_image_encoding_quality_level(n, i);
        }
        Arrays.sort(nArray);
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getJpegEncodingQualityParameter(int n) {
        int n2 = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int n3 = 0;
        while (n3 < n2) {
            Camera.getCameraInfo(n3, cameraInfo);
            if (cameraInfo.facing == 0) {
                return CameraProfile.getJpegEncodingQualityParameter(n3, n);
            }
            ++n3;
        }
        return 0;
    }

    public static int getJpegEncodingQualityParameter(int n, int n2) {
        if (n2 < 0 || n2 > 2) {
            String string2 = "Unsupported quality level: " + n2;
            throw new IllegalArgumentException(string2);
        }
        HashMap<Integer, int[]> hashMap = sCache;
        synchronized (hashMap) {
            HashMap<Integer, int[]> hashMap2 = sCache;
            Integer n3 = n;
            int[] nArray = hashMap2.get(n3);
            if (nArray == null) {
                nArray = CameraProfile.getImageEncodingQualityLevels(n);
                HashMap<Integer, int[]> hashMap3 = sCache;
                Integer n4 = n;
                int[] nArray2 = hashMap3.put(n4, nArray);
            }
            int n5 = nArray[n2];
            return n5;
        }
    }

    private static final native int native_get_image_encoding_quality_level(int var0, int var1);

    private static final native int native_get_num_image_encoding_quality_levels(int var0);

    private static final native void native_init();
}

