/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class ExifInterface {
    public static final int ORIENTATION_FLIP_HORIZONTAL = 2;
    public static final int ORIENTATION_FLIP_VERTICAL = 4;
    public static final int ORIENTATION_NORMAL = 1;
    public static final int ORIENTATION_ROTATE_180 = 3;
    public static final int ORIENTATION_ROTATE_270 = 8;
    public static final int ORIENTATION_ROTATE_90 = 6;
    public static final int ORIENTATION_TRANSPOSE = 5;
    public static final int ORIENTATION_TRANSVERSE = 7;
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final String TAG_DATETIME = "DateTime";
    public static final String TAG_FLASH = "Flash";
    public static final String TAG_FOCAL_LENGTH = "FocalLength";
    public static final String TAG_GPS_ALTITUDE = "GPSAltitude";
    public static final String TAG_GPS_ALTITUDE_REF = "GPSAltitudeRef";
    public static final String TAG_GPS_DATESTAMP = "GPSDateStamp";
    public static final String TAG_GPS_LATITUDE = "GPSLatitude";
    public static final String TAG_GPS_LATITUDE_REF = "GPSLatitudeRef";
    public static final String TAG_GPS_LONGITUDE = "GPSLongitude";
    public static final String TAG_GPS_LONGITUDE_REF = "GPSLongitudeRef";
    public static final String TAG_GPS_PROCESSING_METHOD = "GPSProcessingMethod";
    public static final String TAG_GPS_TIMESTAMP = "GPSTimeStamp";
    public static final String TAG_IMAGE_LENGTH = "ImageLength";
    public static final String TAG_IMAGE_WIDTH = "ImageWidth";
    public static final String TAG_MAKE = "Make";
    public static final String TAG_MODEL = "Model";
    public static final String TAG_ORIENTATION = "Orientation";
    public static final String TAG_WHITE_BALANCE = "WhiteBalance";
    public static final int WHITEBALANCE_AUTO = 0;
    public static final int WHITEBALANCE_MANUAL = 1;
    private static SimpleDateFormat sFormatter;
    private static Object sLock;
    private HashMap<String, String> mAttributes;
    private String mFilename;
    private boolean mHasThumbnail;

    static {
        System.loadLibrary("exif");
        SimpleDateFormat simpleDateFormat = sFormatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        simpleDateFormat.setTimeZone(timeZone);
        sLock = new Object();
    }

    public ExifInterface(String string2) throws IOException {
        this.mFilename = string2;
        this.loadAttributes();
    }

    private native boolean appendThumbnailNative(String var1, String var2);

    private native void commitChangesNative(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float convertRationalLatLonToFloat(String string2, String string3) {
        double d;
        try {
            String[] stringArray = string2.split(",");
            String[] stringArray2 = stringArray[0].split("/");
            float f = Float.parseFloat(stringArray2[0].trim());
            float f2 = Float.parseFloat(stringArray2[1].trim());
            int n = (int)(f / f2);
            String[] stringArray3 = stringArray[1].split("/");
            float f3 = Float.parseFloat(stringArray3[0].trim());
            float f4 = Float.parseFloat(stringArray3[1].trim());
            int n2 = (int)(f3 / f4);
            String[] stringArray4 = stringArray[2].split("/");
            double d2 = Double.parseDouble(stringArray4[0].trim());
            double d3 = Double.parseDouble(stringArray4[1].trim());
            double d4 = d2 / d3;
            double d5 = n;
            double d6 = (double)n2 / 60.0;
            double d7 = d5 + d6;
            d = d4 / 3600.0 + d7;
            if (string3.equals("S")) return (float)(-d);
            boolean bl = string3.equals("W");
            if (!bl) return (float)d;
        }
        catch (RuntimeException runtimeException) {
            return 0.0f;
        }
        return (float)(-d);
    }

    private native String getAttributesNative(String var1);

    private native byte[] getThumbnailNative(String var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAttributes() throws IOException {
        String string2;
        HashMap hashMap = new HashMap();
        this.mAttributes = hashMap;
        Object object = sLock;
        synchronized (object) {
            String string3 = this.mFilename;
            string2 = this.getAttributesNative(string3);
        }
        int n = string2.indexOf(32);
        int n2 = Integer.parseInt(string2.substring(0, n));
        int n3 = n + 1;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = string2.indexOf(61, n3);
            String string4 = string2.substring(n3, n5);
            int n6 = n5 + 1;
            int n7 = string2.indexOf(32, n6);
            int n8 = Integer.parseInt(string2.substring(n6, n7));
            int n9 = n7 + 1;
            int n10 = n9 + n8;
            String string5 = string2.substring(n9, n10);
            n3 = n9 + n8;
            if (string4.equals("hasThumbnail")) {
                boolean bl;
                this.mHasThumbnail = bl = string5.equalsIgnoreCase("true");
            } else {
                String string6 = this.mAttributes.put(string4, string5);
            }
            ++n4;
        }
        return;
    }

    private native void saveAttributesNative(String var1, String var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getAltitude(double d) {
        int n;
        double d2 = this.getAttributeDouble(TAG_GPS_ALTITUDE, -1.0);
        int n2 = this.getAttributeInt(TAG_GPS_ALTITUDE_REF, -1);
        if (!(d2 >= 0.0)) return d;
        if (n2 < 0) return d;
        if (n2 == 1) {
            n = -1;
            return (double)n * d2;
        }
        n = 1;
        return (double)n * d2;
    }

    public String getAttribute(String string2) {
        return this.mAttributes.get(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getAttributeDouble(String string2, double d) {
        String string3 = this.mAttributes.get(string2);
        if (string3 == null) {
            return d;
        }
        try {
            int n = string3.indexOf("/");
            if (n == -1) {
                return d;
            }
            int n2 = n + 1;
            double d2 = Double.parseDouble(string3.substring(n2));
            if (d2 == 0.0) {
                return d;
            }
            double d3 = Double.parseDouble(string3.substring(0, n));
            return d3 / d2;
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAttributeInt(String string2, int n) {
        String string3 = this.mAttributes.get(string2);
        if (string3 == null) {
            return n;
        }
        try {
            int n2 = Integer.valueOf(string3);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getDateTime() {
        String string2 = this.mAttributes.get(TAG_DATETIME);
        if (string2 == null) {
            return 65535L;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        try {
            Date date = sFormatter.parse(string2, parsePosition);
            long l = date.getTime();
            if (date != null) return l;
            return 65535L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 65535L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getGpsDateTime() {
        String string2 = this.mAttributes.get(TAG_GPS_DATESTAMP);
        String string3 = this.mAttributes.get(TAG_GPS_TIMESTAMP);
        if (string2 == null) return 65535L;
        if (string3 == null) {
            return 65535L;
        }
        String string4 = string2 + ' ' + string3;
        if (string4 == null) {
            return 65535L;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        try {
            Date date = sFormatter.parse(string4, parsePosition);
            long l = date.getTime();
            if (date != null) return l;
            return 65535L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 65535L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getLatLong(float[] fArray) {
        float f;
        float f2;
        String string2 = this.mAttributes.get(TAG_GPS_LATITUDE);
        String string3 = this.mAttributes.get(TAG_GPS_LATITUDE_REF);
        String string4 = this.mAttributes.get(TAG_GPS_LONGITUDE);
        String string5 = this.mAttributes.get(TAG_GPS_LONGITUDE_REF);
        if (string2 == null) return false;
        if (string3 == null) return false;
        if (string4 == null) return false;
        if (string5 == null) return false;
        fArray[0] = f2 = ExifInterface.convertRationalLatLonToFloat(string2, string3);
        fArray[1] = f = ExifInterface.convertRationalLatLonToFloat(string4, string5);
        return true;
    }

    public byte[] getThumbnail() {
        Object object = sLock;
        synchronized (object) {
            String string2 = this.mFilename;
            byte[] byArray = this.getThumbnailNative(string2);
            return byArray;
        }
    }

    public boolean hasThumbnail() {
        return this.mHasThumbnail;
    }

    public void saveAttributes() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.mAttributes.size();
        if (this.mAttributes.containsKey("hasThumbnail")) {
            n += -1;
        }
        String string2 = n + " ";
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        for (Map.Entry<String, String> entry : this.mAttributes.entrySet()) {
            String string3 = entry.getKey();
            if (string3.equals("hasThumbnail")) continue;
            String string4 = entry.getValue();
            String string5 = string3 + "=";
            StringBuilder stringBuilder3 = stringBuilder.append(string5);
            StringBuilder stringBuilder4 = new StringBuilder();
            int n2 = string4.length();
            String string6 = stringBuilder4.append(n2).append(" ").toString();
            StringBuilder stringBuilder5 = stringBuilder.append(string6);
            StringBuilder stringBuilder6 = stringBuilder.append(string4);
        }
        String string7 = stringBuilder.toString();
        Object object = sLock;
        synchronized (object) {
            String string8 = this.mFilename;
            this.saveAttributesNative(string8, string7);
            String string9 = this.mFilename;
            this.commitChangesNative(string9);
            return;
        }
    }

    public void setAttribute(String string2, String string3) {
        String string4 = this.mAttributes.put(string2, string3);
    }
}

