/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.util.Log;

public class FaceDetector {
    private static boolean sInitialized = false;
    private byte[] mBWBuffer;
    private int mDCR;
    private int mFD;
    private int mHeight;
    private int mMaxFaces;
    private int mSDK;
    private int mWidth;

    static {
        try {
            System.loadLibrary("FFTEm");
            FaceDetector.nativeClassInit();
            sInitialized = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            int n = Log.d("FFTEm", "face detection library not found!");
        }
    }

    public FaceDetector(int n, int n2, int n3) {
        if (!sInitialized) {
            return;
        }
        int n4 = this.fft_initialize(n, n2, n3);
        this.mWidth = n;
        this.mHeight = n2;
        this.mMaxFaces = n3;
        byte[] byArray = new byte[n * n2];
        this.mBWBuffer = byArray;
    }

    private native void fft_destroy();

    private native int fft_detect(Bitmap var1);

    private native void fft_get_face(Face var1, int var2);

    private native int fft_initialize(int var1, int var2, int var3);

    private static native void nativeClassInit();

    protected void finalize() throws Throwable {
        this.fft_destroy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int findFaces(Bitmap bitmap, Face[] faceArray) {
        int n;
        int n2;
        int n3;
        if (!sInitialized) {
            return 0;
        }
        int n4 = bitmap.getWidth();
        if (n4 == (n3 = this.mWidth)) throw new IllegalArgumentException("bitmap size doesn't match initialization");
        int n5 = bitmap.getHeight();
        if (n5 != (n2 = this.mHeight)) {
            throw new IllegalArgumentException("bitmap size doesn't match initialization");
        }
        int n6 = faceArray.length;
        int n7 = this.mMaxFaces;
        if (n6 < n7) {
            throw new IllegalArgumentException("faces[] smaller than maxFaces");
        }
        int n8 = this.fft_detect(bitmap);
        if (n8 >= (n = this.mMaxFaces)) {
            n8 = this.mMaxFaces;
        }
        int n9 = 0;
        while (n9 < n8) {
            if (faceArray[n9] == null) {
                Face face;
                faceArray[n9] = face = new Face();
            }
            Face face = faceArray[n9];
            this.fft_get_face(face, n9);
            ++n9;
        }
        return n8;
    }

    public class Face {
        public static final float CONFIDENCE_THRESHOLD = 0.4f;
        public static final int EULER_X = 0;
        public static final int EULER_Y = 1;
        public static final int EULER_Z = 2;
        private float mConfidence;
        private float mEyesDist;
        private float mMidPointX;
        private float mMidPointY;
        private float mPoseEulerX;
        private float mPoseEulerY;
        private float mPoseEulerZ;

        private Face() {
        }

        public float confidence() {
            return this.mConfidence;
        }

        public float eyesDistance() {
            return this.mEyesDist;
        }

        public void getMidPoint(PointF pointF) {
            float f = this.mMidPointX;
            float f2 = this.mMidPointY;
            pointF.set(f, f2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public float pose(int n) {
            if (n == 0) {
                return this.mPoseEulerX;
            }
            if (n == 1) {
                return this.mPoseEulerY;
            }
            if (n != 2) throw new IllegalArgumentException();
            return this.mPoseEulerZ;
        }
    }
}

