/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ComponentName;
import android.media.IAudioFocusDispatcher;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IAudioService
extends IInterface {
    public int abandonAudioFocus(IAudioFocusDispatcher var1, String var2) throws RemoteException;

    public void adjustStreamVolume(int var1, int var2, int var3) throws RemoteException;

    public void adjustSuggestedStreamVolume(int var1, int var2, int var3) throws RemoteException;

    public void adjustVolume(int var1, int var2) throws RemoteException;

    public int getMode() throws RemoteException;

    public int getRingerMode() throws RemoteException;

    public int getStreamMaxVolume(int var1) throws RemoteException;

    public int getStreamVolume(int var1) throws RemoteException;

    public int getVibrateSetting(int var1) throws RemoteException;

    public boolean isBluetoothScoOn() throws RemoteException;

    public boolean isSpeakerphoneOn() throws RemoteException;

    public boolean loadSoundEffects() throws RemoteException;

    public void playSoundEffect(int var1) throws RemoteException;

    public void playSoundEffectVolume(int var1, float var2) throws RemoteException;

    public void registerMediaButtonEventReceiver(ComponentName var1) throws RemoteException;

    public void reloadAudioSettings() throws RemoteException;

    public int requestAudioFocus(int var1, int var2, IBinder var3, IAudioFocusDispatcher var4, String var5) throws RemoteException;

    public void setBluetoothScoOn(boolean var1) throws RemoteException;

    public void setMode(int var1, IBinder var2) throws RemoteException;

    public void setRingerMode(int var1) throws RemoteException;

    public void setSpeakerphoneOn(boolean var1) throws RemoteException;

    public void setStreamMute(int var1, boolean var2, IBinder var3) throws RemoteException;

    public void setStreamSolo(int var1, boolean var2, IBinder var3) throws RemoteException;

    public void setStreamVolume(int var1, int var2, int var3) throws RemoteException;

    public void setVibrateSetting(int var1, int var2) throws RemoteException;

    public boolean shouldVibrate(int var1) throws RemoteException;

    public void startBluetoothSco(IBinder var1) throws RemoteException;

    public void stopBluetoothSco(IBinder var1) throws RemoteException;

    public void unloadSoundEffects() throws RemoteException;

    public void unregisterAudioFocusClient(String var1) throws RemoteException;

    public void unregisterMediaButtonEventReceiver(ComponentName var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAudioService {
        private static final String DESCRIPTOR = "android.media.IAudioService";
        static final int TRANSACTION_abandonAudioFocus = 26;
        static final int TRANSACTION_adjustStreamVolume = 3;
        static final int TRANSACTION_adjustSuggestedStreamVolume = 2;
        static final int TRANSACTION_adjustVolume = 1;
        static final int TRANSACTION_getMode = 15;
        static final int TRANSACTION_getRingerMode = 10;
        static final int TRANSACTION_getStreamMaxVolume = 8;
        static final int TRANSACTION_getStreamVolume = 7;
        static final int TRANSACTION_getVibrateSetting = 12;
        static final int TRANSACTION_isBluetoothScoOn = 24;
        static final int TRANSACTION_isSpeakerphoneOn = 22;
        static final int TRANSACTION_loadSoundEffects = 18;
        static final int TRANSACTION_playSoundEffect = 16;
        static final int TRANSACTION_playSoundEffectVolume = 17;
        static final int TRANSACTION_registerMediaButtonEventReceiver = 28;
        static final int TRANSACTION_reloadAudioSettings = 20;
        static final int TRANSACTION_requestAudioFocus = 25;
        static final int TRANSACTION_setBluetoothScoOn = 23;
        static final int TRANSACTION_setMode = 14;
        static final int TRANSACTION_setRingerMode = 9;
        static final int TRANSACTION_setSpeakerphoneOn = 21;
        static final int TRANSACTION_setStreamMute = 6;
        static final int TRANSACTION_setStreamSolo = 5;
        static final int TRANSACTION_setStreamVolume = 4;
        static final int TRANSACTION_setVibrateSetting = 11;
        static final int TRANSACTION_shouldVibrate = 13;
        static final int TRANSACTION_startBluetoothSco = 30;
        static final int TRANSACTION_stopBluetoothSco = 31;
        static final int TRANSACTION_unloadSoundEffects = 19;
        static final int TRANSACTION_unregisterAudioFocusClient = 27;
        static final int TRANSACTION_unregisterMediaButtonEventReceiver = 29;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IAudioService asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IAudioService) {
                IAudioService iAudioService = (IAudioService)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    int n4 = parcel.readInt();
                    this.adjustVolume(n3, n4);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n5 = parcel.readInt();
                    int n6 = parcel.readInt();
                    int n7 = parcel.readInt();
                    this.adjustSuggestedStreamVolume(n5, n6, n7);
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n8 = parcel.readInt();
                    int n9 = parcel.readInt();
                    int n10 = parcel.readInt();
                    this.adjustStreamVolume(n8, n9, n10);
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n11 = parcel.readInt();
                    int n12 = parcel.readInt();
                    int n13 = parcel.readInt();
                    this.setStreamVolume(n11, n12, n13);
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n14 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    IBinder iBinder = parcel.readStrongBinder();
                    this.setStreamSolo(n14, bl, iBinder);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n15 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    IBinder iBinder = parcel.readStrongBinder();
                    this.setStreamMute(n15, bl, iBinder);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n16 = parcel.readInt();
                    int n17 = this.getStreamVolume(n16);
                    parcel2.writeNoException();
                    parcel2.writeInt(n17);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n18 = parcel.readInt();
                    int n19 = this.getStreamMaxVolume(n18);
                    parcel2.writeNoException();
                    parcel2.writeInt(n19);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n20 = parcel.readInt();
                    this.setRingerMode(n20);
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n21 = this.getRingerMode();
                    parcel2.writeNoException();
                    parcel2.writeInt(n21);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n22 = parcel.readInt();
                    int n23 = parcel.readInt();
                    this.setVibrateSetting(n22, n23);
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n24 = parcel.readInt();
                    int n25 = this.getVibrateSetting(n24);
                    parcel2.writeNoException();
                    parcel2.writeInt(n25);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n26 = parcel.readInt();
                    boolean bl = this.shouldVibrate(n26);
                    parcel2.writeNoException();
                    int n27 = bl ? 1 : 0;
                    parcel2.writeInt(n27);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n28 = parcel.readInt();
                    IBinder iBinder = parcel.readStrongBinder();
                    this.setMode(n28, iBinder);
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n29 = this.getMode();
                    parcel2.writeNoException();
                    parcel2.writeInt(n29);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n30 = parcel.readInt();
                    this.playSoundEffect(n30);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n31 = parcel.readInt();
                    float f = parcel.readFloat();
                    this.playSoundEffectVolume(n31, f);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.loadSoundEffects();
                    parcel2.writeNoException();
                    int n32 = bl ? 1 : 0;
                    parcel2.writeInt(n32);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unloadSoundEffects();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.reloadAudioSettings();
                    return true;
                }
                case 21: {
                    void var17_20;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Object var17_19 = null;
                    } else {
                        Object var17_21 = null;
                    }
                    this.setSpeakerphoneOn((boolean)var17_20);
                    parcel2.writeNoException();
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isSpeakerphoneOn();
                    parcel2.writeNoException();
                    int n33 = bl ? 1 : 0;
                    parcel2.writeInt(n33);
                    return true;
                }
                case 23: {
                    void var17_23;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Object var17_22 = null;
                    } else {
                        Object var17_24 = null;
                    }
                    this.setBluetoothScoOn((boolean)var17_23);
                    parcel2.writeNoException();
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isBluetoothScoOn();
                    parcel2.writeNoException();
                    int n34 = bl ? 1 : 0;
                    parcel2.writeInt(n34);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n35 = parcel.readInt();
                    int n36 = parcel.readInt();
                    IBinder iBinder = parcel.readStrongBinder();
                    IAudioFocusDispatcher iAudioFocusDispatcher = IAudioFocusDispatcher.Stub.asInterface(parcel.readStrongBinder());
                    String string2 = parcel.readString();
                    int n37 = this.requestAudioFocus(n35, n36, iBinder, iAudioFocusDispatcher, string2);
                    parcel2.writeNoException();
                    parcel2.writeInt(n37);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IAudioFocusDispatcher iAudioFocusDispatcher = IAudioFocusDispatcher.Stub.asInterface(parcel.readStrongBinder());
                    String string3 = parcel.readString();
                    int n38 = this.abandonAudioFocus(iAudioFocusDispatcher, string3);
                    parcel2.writeNoException();
                    parcel2.writeInt(n38);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    this.unregisterAudioFocusClient(string4);
                    parcel2.writeNoException();
                    return true;
                }
                case 28: {
                    void var17_26;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        ComponentName componentName = ComponentName.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var17_27 = null;
                    }
                    this.registerMediaButtonEventReceiver((ComponentName)var17_26);
                    parcel2.writeNoException();
                    return true;
                }
                case 29: {
                    int n14;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        ComponentName componentName = ComponentName.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var17_29 = null;
                    }
                    this.unregisterMediaButtonEventReceiver((ComponentName)n14);
                    parcel2.writeNoException();
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    this.startBluetoothSco(iBinder);
                    parcel2.writeNoException();
                    return true;
                }
                case 31: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            IBinder iBinder = parcel.readStrongBinder();
            this.stopBluetoothSco(iBinder);
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements IAudioService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int abandonAudioFocus(IAudioFocusDispatcher iAudioFocusDispatcher, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAudioFocusDispatcher != null ? iAudioFocusDispatcher.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void adjustStreamVolume(int n, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void adjustSuggestedStreamVolume(int n, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void adjustVolume(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public int getMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getRingerMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getStreamMaxVolume(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n2;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = n2 = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getStreamVolume(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n2;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = n2 = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getVibrateSetting(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n2;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = n2 = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isBluetoothScoOn() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isSpeakerphoneOn() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean loadSoundEffects() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void playSoundEffect(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(16, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void playSoundEffectVolume(int n, float f) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeFloat(f);
                    boolean bl = this.mRemote.transact(17, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerMediaButtonEventReceiver(ComponentName componentName) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void reloadAudioSettings() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(20, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int requestAudioFocus(int n, int n2, IBinder iBinder, IAudioFocusDispatcher iAudioFocusDispatcher, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n3;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeStrongBinder(iBinder);
                    IBinder iBinder2 = iAudioFocusDispatcher != null ? iAudioFocusDispatcher.asBinder() : null;
                    parcel.writeStrongBinder(iBinder2);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = n3 = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n4;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setBluetoothScoOn(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setMode(int n, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setRingerMode(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setSpeakerphoneOn(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setStreamMute(int n, boolean bl, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    int n2 = bl ? 1 : 0;
                    parcel.writeInt(n2);
                    parcel.writeStrongBinder(iBinder);
                    boolean bl2 = this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setStreamSolo(int n, boolean bl, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    int n2 = bl ? 1 : 0;
                    parcel.writeInt(n2);
                    parcel.writeStrongBinder(iBinder);
                    boolean bl2 = this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setStreamVolume(int n, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    boolean bl = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setVibrateSetting(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    boolean bl = this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean shouldVibrate(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl2 = n2 != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void startBluetoothSco(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void stopBluetoothSco(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void unloadSoundEffects() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(19, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void unregisterAudioFocusClient(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterMediaButtonEventReceiver(ComponentName componentName) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

