/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.res.AssetFileDescriptor;
import android.media.AudioTrack;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AndroidRuntimeException;
import android.util.Log;
import java.io.FileDescriptor;
import java.lang.ref.WeakReference;

public class JetPlayer {
    private static final int JET_EVENT = 1;
    private static final int JET_EVENT_CHAN_MASK = 245760;
    private static final int JET_EVENT_CHAN_SHIFT = 14;
    private static final int JET_EVENT_CTRL_MASK = 16256;
    private static final int JET_EVENT_CTRL_SHIFT = 7;
    private static final int JET_EVENT_SEG_MASK = -16777216;
    private static final int JET_EVENT_SEG_SHIFT = 24;
    private static final int JET_EVENT_TRACK_MASK = 0xFC0000;
    private static final int JET_EVENT_TRACK_SHIFT = 18;
    private static final int JET_EVENT_VAL_MASK = 127;
    private static final int JET_NUMQUEUEDSEGMENT_UPDATE = 3;
    private static final int JET_OUTPUT_CHANNEL_CONFIG = 12;
    private static final int JET_OUTPUT_RATE = 22050;
    private static final int JET_PAUSE_UPDATE = 4;
    private static final int JET_USERID_UPDATE = 2;
    private static int MAXTRACKS = 0;
    private static final String TAG = "JetPlayer-J";
    private static JetPlayer singletonRef;
    private NativeEventHandler mEventHandler = null;
    private final Object mEventListenerLock;
    private Looper mInitializationLooper = null;
    private OnJetEventListener mJetEventListener;
    private int mNativePlayerInJavaObj;

    static {
        MAXTRACKS = 32;
    }

    private JetPlayer() {
        int n;
        Looper looper;
        Object object;
        this.mEventListenerLock = object = new Object();
        this.mJetEventListener = null;
        this.mInitializationLooper = looper = Looper.myLooper();
        if (looper == null) {
            Looper looper2;
            this.mInitializationLooper = looper2 = Looper.getMainLooper();
        }
        if ((n = AudioTrack.getMinBufferSize(22050, 12, 2)) == -1) {
            return;
        }
        if (n == -1) {
            return;
        }
        WeakReference<JetPlayer> weakReference = new WeakReference<JetPlayer>(this);
        int n2 = JetPlayer.getMaxTracks();
        int n3 = n / 4;
        int n4 = Math.max(1200, n3);
        boolean bl = this.native_setup(weakReference, n2, n4);
    }

    public static JetPlayer getJetPlayer() {
        if (singletonRef == null) {
            singletonRef = new JetPlayer();
        }
        return singletonRef;
    }

    public static int getMaxTracks() {
        return MAXTRACKS;
    }

    private static void logd(String string2) {
        String string3 = "[ android.media.JetPlayer ] " + string2;
        int n = Log.d(TAG, string3);
    }

    private static void loge(String string2) {
        String string3 = "[ android.media.JetPlayer ] " + string2;
        int n = Log.e(TAG, string3);
    }

    private final native boolean native_clearQueue();

    private final native boolean native_closeJetFile();

    private final native void native_finalize();

    private final native boolean native_loadJetFromFile(String var1);

    private final native boolean native_loadJetFromFileD(FileDescriptor var1, long var2, long var4);

    private final native boolean native_pauseJet();

    private final native boolean native_playJet();

    private final native boolean native_queueJetSegment(int var1, int var2, int var3, int var4, int var5, byte var6);

    private final native boolean native_queueJetSegmentMuteArray(int var1, int var2, int var3, int var4, boolean[] var5, byte var6);

    private final native void native_release();

    private final native boolean native_setMuteArray(boolean[] var1, boolean var2);

    private final native boolean native_setMuteFlag(int var1, boolean var2, boolean var3);

    private final native boolean native_setMuteFlags(int var1, boolean var2);

    private final native boolean native_setup(Object var1, int var2, int var3);

    private final native boolean native_triggerClip(int var1);

    private static void postEventFromNative(Object object, int n, int n2, int n3) {
        JetPlayer jetPlayer = (JetPlayer)((WeakReference)object).get();
        if (jetPlayer == null) {
            return;
        }
        if (jetPlayer.mEventHandler == null) {
            return;
        }
        Message message = jetPlayer.mEventHandler.obtainMessage(n, n2, n3, null);
        boolean bl = jetPlayer.mEventHandler.sendMessage(message);
    }

    public boolean clearQueue() {
        return this.native_clearQueue();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean closeJetFile() {
        return this.native_closeJetFile();
    }

    protected void finalize() {
        this.native_finalize();
    }

    public boolean loadJetFile(AssetFileDescriptor assetFileDescriptor) {
        long l = assetFileDescriptor.getLength();
        if (l < 0L) {
            throw new AndroidRuntimeException("no length for fd");
        }
        FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
        long l2 = assetFileDescriptor.getStartOffset();
        return this.native_loadJetFromFileD(fileDescriptor, l2, l);
    }

    public boolean loadJetFile(String string2) {
        return this.native_loadJetFromFile(string2);
    }

    public boolean pause() {
        return this.native_pauseJet();
    }

    public boolean play() {
        return this.native_playJet();
    }

    public boolean queueJetSegment(int n, int n2, int n3, int n4, int n5, byte by) {
        return this.native_queueJetSegment(n, n2, n3, n4, n5, by);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean queueJetSegmentMuteArray(int n, int n2, int n3, int n4, boolean[] blArray, byte by) {
        int n5 = blArray.length;
        int n6 = JetPlayer.getMaxTracks();
        if (n5 == n6) return this.native_queueJetSegmentMuteArray(n, n2, n3, n4, blArray, by);
        return false;
    }

    public void release() {
        this.native_release();
        singletonRef = null;
    }

    public void setEventListener(OnJetEventListener onJetEventListener) {
        this.setEventListener(onJetEventListener, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEventListener(OnJetEventListener onJetEventListener, Handler handler) {
        Object object = this.mEventListenerLock;
        synchronized (object) {
            this.mJetEventListener = onJetEventListener;
            if (onJetEventListener != null) {
                if (handler != null) {
                    NativeEventHandler nativeEventHandler;
                    Looper looper = handler.getLooper();
                    this.mEventHandler = nativeEventHandler = new NativeEventHandler(this, looper);
                } else {
                    NativeEventHandler nativeEventHandler;
                    Looper looper = this.mInitializationLooper;
                    this.mEventHandler = nativeEventHandler = new NativeEventHandler(this, looper);
                }
            } else {
                Object var9_8 = null;
                this.mEventHandler = var9_8;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setMuteArray(boolean[] blArray, boolean bl) {
        int n = blArray.length;
        int n2 = JetPlayer.getMaxTracks();
        if (n == n2) return this.native_setMuteArray(blArray, bl);
        return false;
    }

    public boolean setMuteFlag(int n, boolean bl, boolean bl2) {
        return this.native_setMuteFlag(n, bl, bl2);
    }

    public boolean setMuteFlags(int n, boolean bl) {
        return this.native_setMuteFlags(n, bl);
    }

    public boolean triggerClip(int n) {
        return this.native_triggerClip(n);
    }

    public static interface OnJetEventListener {
        public void onJetEvent(JetPlayer var1, short var2, byte var3, byte var4, byte var5, byte var6);

        public void onJetNumQueuedSegmentUpdate(JetPlayer var1, int var2);

        public void onJetPauseUpdate(JetPlayer var1, int var2);

        public void onJetUserIdUpdate(JetPlayer var1, int var2, int var3);
    }

    private class NativeEventHandler
    extends Handler {
        private JetPlayer mJet;

        public NativeEventHandler(JetPlayer jetPlayer2, Looper looper) {
            super(looper);
            this.mJet = jetPlayer2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            OnJetEventListener onJetEventListener;
            Object object = JetPlayer.this.mEventListenerLock;
            synchronized (object) {
                onJetEventListener = this.mJet.mJetEventListener;
            }
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown message type ");
                    int n = message.what;
                    JetPlayer.loge(stringBuilder.append(n).toString());
                    return;
                }
                case 1: {
                    if (onJetEventListener == null) {
                        return;
                    }
                    OnJetEventListener onJetEventListener2 = JetPlayer.this.mJetEventListener;
                    JetPlayer jetPlayer = this.mJet;
                    short s = (short)((message.arg1 & 0xFF000000) >> 24);
                    byte by = (byte)((message.arg1 & 0xFC0000) >> 18);
                    byte by2 = (byte)(((message.arg1 & 0x3C000) >> 14) + 1);
                    byte by3 = (byte)((message.arg1 & 0x3F80) >> 7);
                    byte by4 = (byte)(message.arg1 & 0x7F);
                    onJetEventListener2.onJetEvent(jetPlayer, s, by, by2, by3, by4);
                    return;
                }
                case 2: {
                    if (onJetEventListener == null) {
                        return;
                    }
                    JetPlayer jetPlayer = this.mJet;
                    int n = message.arg1;
                    int n2 = message.arg2;
                    onJetEventListener.onJetUserIdUpdate(jetPlayer, n, n2);
                    return;
                }
                case 3: {
                    if (onJetEventListener == null) {
                        return;
                    }
                    JetPlayer jetPlayer = this.mJet;
                    int n = message.arg1;
                    onJetEventListener.onJetNumQueuedSegmentUpdate(jetPlayer, n);
                    return;
                }
                case 4: 
            }
            if (onJetEventListener == null) {
                return;
            }
            JetPlayer jetPlayer = this.mJet;
            int n = message.arg1;
            onJetEventListener.onJetPauseUpdate(jetPlayer, n);
        }
    }
}

