/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.DecoderCapabilities;
import java.util.HashMap;
import java.util.Iterator;

public class MediaFile {
    public static final int FILE_TYPE_3GPP = 23;
    public static final int FILE_TYPE_3GPP2 = 24;
    public static final int FILE_TYPE_AAC = 8;
    public static final int FILE_TYPE_AMR = 4;
    public static final int FILE_TYPE_ASF = 26;
    public static final int FILE_TYPE_AWB = 5;
    public static final int FILE_TYPE_BMP = 34;
    public static final int FILE_TYPE_GIF = 32;
    public static final int FILE_TYPE_IMY = 13;
    public static final int FILE_TYPE_JPEG = 31;
    public static final int FILE_TYPE_M3U = 41;
    public static final int FILE_TYPE_M4A = 2;
    public static final int FILE_TYPE_M4V = 22;
    public static final int FILE_TYPE_MID = 11;
    public static final int FILE_TYPE_MKA = 9;
    public static final int FILE_TYPE_MKV = 27;
    public static final int FILE_TYPE_MP2TS = 28;
    public static final int FILE_TYPE_MP3 = 1;
    public static final int FILE_TYPE_MP4 = 21;
    public static final int FILE_TYPE_OGG = 7;
    public static final int FILE_TYPE_PLS = 42;
    public static final int FILE_TYPE_PNG = 33;
    public static final int FILE_TYPE_SMF = 12;
    public static final int FILE_TYPE_WAV = 3;
    public static final int FILE_TYPE_WBMP = 35;
    public static final int FILE_TYPE_WMA = 6;
    public static final int FILE_TYPE_WMV = 25;
    public static final int FILE_TYPE_WPL = 43;
    private static final int FIRST_AUDIO_FILE_TYPE = 1;
    private static final int FIRST_IMAGE_FILE_TYPE = 31;
    private static final int FIRST_MIDI_FILE_TYPE = 11;
    private static final int FIRST_PLAYLIST_FILE_TYPE = 41;
    private static final int FIRST_VIDEO_FILE_TYPE = 21;
    private static final int LAST_AUDIO_FILE_TYPE = 9;
    private static final int LAST_IMAGE_FILE_TYPE = 35;
    private static final int LAST_MIDI_FILE_TYPE = 13;
    private static final int LAST_PLAYLIST_FILE_TYPE = 43;
    private static final int LAST_VIDEO_FILE_TYPE = 28;
    public static final String sFileExtensions;
    private static HashMap<String, MediaFileType> sFileTypeMap;
    private static HashMap<String, Integer> sMimeTypeMap;

    static {
        sFileTypeMap = new HashMap();
        sMimeTypeMap = new HashMap();
        MediaFile.addFileType("MP3", 1, "audio/mpeg");
        MediaFile.addFileType("M4A", 2, "audio/mp4");
        MediaFile.addFileType("WAV", 3, "audio/x-wav");
        MediaFile.addFileType("AMR", 4, "audio/amr");
        MediaFile.addFileType("AWB", 5, "audio/amr-wb");
        if (MediaFile.isWMAEnabled()) {
            MediaFile.addFileType("WMA", 6, "audio/x-ms-wma");
        }
        MediaFile.addFileType("OGG", 7, "application/ogg");
        MediaFile.addFileType("OGA", 7, "application/ogg");
        MediaFile.addFileType("AAC", 8, "audio/aac");
        MediaFile.addFileType("MKA", 9, "audio/x-matroska");
        MediaFile.addFileType("MID", 11, "audio/midi");
        MediaFile.addFileType("MIDI", 11, "audio/midi");
        MediaFile.addFileType("XMF", 11, "audio/midi");
        MediaFile.addFileType("RTTTL", 11, "audio/midi");
        MediaFile.addFileType("SMF", 12, "audio/sp-midi");
        MediaFile.addFileType("IMY", 13, "audio/imelody");
        MediaFile.addFileType("RTX", 11, "audio/midi");
        MediaFile.addFileType("OTA", 11, "audio/midi");
        MediaFile.addFileType("MPEG", 21, "video/mpeg");
        MediaFile.addFileType("MP4", 21, "video/mp4");
        MediaFile.addFileType("M4V", 22, "video/mp4");
        MediaFile.addFileType("3GP", 23, "video/3gpp");
        MediaFile.addFileType("3GPP", 23, "video/3gpp");
        MediaFile.addFileType("3G2", 24, "video/3gpp2");
        MediaFile.addFileType("3GPP2", 24, "video/3gpp2");
        MediaFile.addFileType("MKV", 27, "video/x-matroska");
        MediaFile.addFileType("WEBM", 27, "video/x-matroska");
        MediaFile.addFileType("TS", 28, "video/mp2ts");
        if (MediaFile.isWMVEnabled()) {
            MediaFile.addFileType("WMV", 25, "video/x-ms-wmv");
            MediaFile.addFileType("ASF", 26, "video/x-ms-asf");
        }
        MediaFile.addFileType("JPG", 31, "image/jpeg");
        MediaFile.addFileType("JPEG", 31, "image/jpeg");
        MediaFile.addFileType("GIF", 32, "image/gif");
        MediaFile.addFileType("PNG", 33, "image/png");
        MediaFile.addFileType("BMP", 34, "image/x-ms-bmp");
        MediaFile.addFileType("WBMP", 35, "image/vnd.wap.wbmp");
        MediaFile.addFileType("M3U", 41, "audio/x-mpegurl");
        MediaFile.addFileType("PLS", 42, "audio/x-scpls");
        MediaFile.addFileType("WPL", 43, "application/vnd.ms-wpl");
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = sFileTypeMap.keySet().iterator();
        while (iterator.hasNext()) {
            if (stringBuilder.length() > 0) {
                StringBuilder stringBuilder2 = stringBuilder.append(',');
            }
            String string2 = iterator.next();
            StringBuilder stringBuilder3 = stringBuilder.append(string2);
        }
        sFileExtensions = stringBuilder.toString();
    }

    static void addFileType(String string2, int n, String string3) {
        HashMap<String, MediaFileType> hashMap = sFileTypeMap;
        MediaFileType mediaFileType = new MediaFileType(n, string3);
        MediaFileType mediaFileType2 = hashMap.put(string2, mediaFileType);
        HashMap<String, Integer> hashMap2 = sMimeTypeMap;
        Integer n2 = n;
        Integer n3 = hashMap2.put(string3, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MediaFileType getFileType(String string2) {
        int n = string2.lastIndexOf(".");
        if (n < 0) {
            return null;
        }
        HashMap<String, MediaFileType> hashMap = sFileTypeMap;
        int n2 = n + 1;
        String string3 = string2.substring(n2).toUpperCase();
        return hashMap.get(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getFileTypeForMimeType(String string2) {
        Integer n = sMimeTypeMap.get(string2);
        if (n != null) return n;
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAudioFileType(int n) {
        if (n >= 1) {
            if (n <= 9) return true;
        }
        if (n < 11) return false;
        if (n > 13) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isImageFileType(int n) {
        if (n < 31) return false;
        if (n > 35) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPlayListFileType(int n) {
        if (n < 41) return false;
        if (n > 43) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVideoFileType(int n) {
        if (n < 21) return false;
        if (n > 28) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isWMAEnabled() {
        DecoderCapabilities.AudioDecoder audioDecoder;
        DecoderCapabilities.AudioDecoder audioDecoder2;
        Iterator<DecoderCapabilities.AudioDecoder> iterator = DecoderCapabilities.getAudioDecoders().iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while ((audioDecoder2 = iterator.next()) != (audioDecoder = DecoderCapabilities.AudioDecoder.AUDIO_DECODER_WMA));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isWMVEnabled() {
        DecoderCapabilities.VideoDecoder videoDecoder;
        DecoderCapabilities.VideoDecoder videoDecoder2;
        Iterator<DecoderCapabilities.VideoDecoder> iterator = DecoderCapabilities.getVideoDecoders().iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while ((videoDecoder2 = iterator.next()) != (videoDecoder = DecoderCapabilities.VideoDecoder.VIDEO_DECODER_WMV));
        return true;
    }

    static class MediaFileType {
        int fileType;
        String mimeType;

        MediaFileType(int n, String string2) {
            this.fileType = n;
            this.mimeType = string2;
        }
    }
}

