/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MediaMetadataRetriever {
    private static final int EMBEDDED_PICTURE_TYPE_ANY = 65535;
    public static final int METADATA_KEY_ALBUM = 1;
    public static final int METADATA_KEY_ALBUMARTIST = 13;
    public static final int METADATA_KEY_ARTIST = 2;
    public static final int METADATA_KEY_AUTHOR = 3;
    public static final int METADATA_KEY_CD_TRACK_NUMBER = 0;
    public static final int METADATA_KEY_COMPILATION = 15;
    public static final int METADATA_KEY_COMPOSER = 4;
    public static final int METADATA_KEY_DATE = 5;
    public static final int METADATA_KEY_DISC_NUMBER = 14;
    public static final int METADATA_KEY_DURATION = 9;
    public static final int METADATA_KEY_GENRE = 6;
    public static final int METADATA_KEY_MIMETYPE = 12;
    public static final int METADATA_KEY_NUM_TRACKS = 10;
    public static final int METADATA_KEY_TITLE = 7;
    public static final int METADATA_KEY_WRITER = 11;
    public static final int METADATA_KEY_YEAR = 8;
    public static final int OPTION_CLOSEST = 3;
    public static final int OPTION_CLOSEST_SYNC = 2;
    public static final int OPTION_NEXT_SYNC = 1;
    public static final int OPTION_PREVIOUS_SYNC;
    private int mNativeContext;

    static {
        System.loadLibrary("media_jni");
        MediaMetadataRetriever.native_init();
    }

    public MediaMetadataRetriever() {
        this.native_setup();
    }

    private native Bitmap _getFrameAtTime(long var1, int var3);

    private native byte[] getEmbeddedPicture(int var1);

    private final native void native_finalize();

    private static native void native_init();

    private native void native_setup();

    public native String extractMetadata(int var1);

    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public byte[] getEmbeddedPicture() {
        return this.getEmbeddedPicture(65535);
    }

    public Bitmap getFrameAtTime() {
        return this.getFrameAtTime(65535L, 2);
    }

    public Bitmap getFrameAtTime(long l) {
        return this.getFrameAtTime(l, 2);
    }

    public Bitmap getFrameAtTime(long l, int n) {
        if (n < 0 || n > 3) {
            String string2 = "Unsupported option: " + n;
            throw new IllegalArgumentException(string2);
        }
        return this._getFrameAtTime(l, n);
    }

    public native void release();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDataSource(Context var1_1, Uri var2_2) throws IllegalArgumentException, SecurityException {
        block21: {
            if (var2_2 == null) {
                throw new IllegalArgumentException();
            }
            var3_3 = var2_2.getScheme();
            if (var3_3 == null || var3_3.equals("file")) {
                var4_4 = var2_2.getPath();
                this.setDataSource(var4_4);
                return;
            }
            var5_5 = null;
            var6_6 = var1_1.getContentResolver();
            var7_7 = var6_6;
            var5_5 = var6_6 = var7_7.openAssetFileDescriptor(var2_2, "r");
            if (var5_5 == null) {
                throw new IllegalArgumentException();
            }
            ** GOTO lbl-1000
            {
                catch (SecurityException var8_8) {
                    if (var5_5 == null) ** GOTO lbl-1000
                    var5_5.close();
                    catch (FileNotFoundException var10_10) {}
                    throw new IllegalArgumentException();
lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            var9_9 = var2_2.toString();
                            this.setDataSource(var9_9);
                            return;
                        }
                        catch (Throwable var11_11) {}
                        if (var5_5 == null) throw var11_11;
                        try {}
                        catch (IOException var19_17) {
                            throw var11_11;
                        }
                        ** break block20
lbl-1000:
                        // 1 sources

                        {
                            var12_12 = var5_5.getFileDescriptor();
                            if (!var12_12.valid()) {
                                throw new IllegalArgumentException();
                            }
                            if (var5_5.getDeclaredLength() >= 0L) ** GOTO lbl-1000
                            this.setDataSource(var12_12);
                            break block21;
                        }
lbl-1000:
                        // 1 sources

                        {
                            var14_14 = var5_5.getStartOffset();
                            var16_15 = var5_5.getDeclaredLength();
                            this.setDataSource(var12_12, var14_14, var16_15);
                            break block21;
                        }
                        catch (IOException var18_16) {}
                    }
                    ** continue;
                }
lbl-1000:
                // 1 sources

                {
                    var5_5.close();
                    throw var11_11;
                }
            }
        }
        if (var5_5 == null) {
            return;
        }
        try {
            var5_5.close();
            return;
        }
        catch (IOException var13_13) {
            return;
        }
    }

    public void setDataSource(FileDescriptor fileDescriptor) throws IllegalArgumentException {
        MediaMetadataRetriever mediaMetadataRetriever = this;
        FileDescriptor fileDescriptor2 = fileDescriptor;
        mediaMetadataRetriever.setDataSource(fileDescriptor2, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public native void setDataSource(FileDescriptor var1, long var2, long var4) throws IllegalArgumentException;

    public native void setDataSource(String var1) throws IllegalArgumentException;
}

