/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.media.Metadata;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PowerManager;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;

public class MediaPlayer {
    public static final boolean APPLY_METADATA_FILTER = true;
    public static final boolean BYPASS_METADATA_FILTER = false;
    private static final String IMEDIA_PLAYER = "android.media.IMediaPlayer";
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_ERROR = 100;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    private static final int MEDIA_INFO = 200;
    public static final int MEDIA_INFO_BAD_INTERLEAVING = 800;
    public static final int MEDIA_INFO_BUFFERING_END = 702;
    public static final int MEDIA_INFO_BUFFERING_START = 701;
    public static final int MEDIA_INFO_METADATA_UPDATE = 802;
    public static final int MEDIA_INFO_NOT_SEEKABLE = 801;
    public static final int MEDIA_INFO_UNKNOWN = 1;
    public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    public static final boolean METADATA_ALL = false;
    public static final boolean METADATA_UPDATE_ONLY = true;
    private static final String TAG = "MediaPlayer";
    private EventHandler mEventHandler;
    private int mListenerContext;
    private int mNativeContext;
    private OnBufferingUpdateListener mOnBufferingUpdateListener;
    private OnCompletionListener mOnCompletionListener;
    private OnErrorListener mOnErrorListener;
    private OnInfoListener mOnInfoListener;
    private OnPreparedListener mOnPreparedListener;
    private OnSeekCompleteListener mOnSeekCompleteListener;
    private OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private Surface mSurface;
    private SurfaceHolder mSurfaceHolder;
    private PowerManager.WakeLock mWakeLock = null;

    static {
        System.loadLibrary("media_jni");
        MediaPlayer.native_init();
    }

    /*
     * Enabled aggressive block sorting
     */
    public MediaPlayer() {
        EventHandler eventHandler;
        EventHandler eventHandler2;
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? (eventHandler2 = new EventHandler(this, looper)) : ((looper = Looper.getMainLooper()) != null ? (eventHandler = new EventHandler(this, looper)) : null);
        WeakReference<MediaPlayer> weakReference = new WeakReference<MediaPlayer>(this);
        this.native_setup(weakReference);
    }

    private native void _pause() throws IllegalStateException;

    private native void _release();

    private native void _reset();

    private native void _setVideoSurface();

    private native void _start() throws IllegalStateException;

    private native void _stop() throws IllegalStateException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MediaPlayer create(Context context, int n) {
        try {
            AssetFileDescriptor assetFileDescriptor = context.getResources().openRawResourceFd(n);
            if (assetFileDescriptor == null) {
                return null;
            }
            MediaPlayer mediaPlayer = new MediaPlayer();
            FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
            long l = assetFileDescriptor.getStartOffset();
            long l2 = assetFileDescriptor.getLength();
            mediaPlayer.setDataSource(fileDescriptor, l, l2);
            assetFileDescriptor.close();
            mediaPlayer.prepare();
            return mediaPlayer;
        }
        catch (IOException iOException) {
            int n2 = Log.d(TAG, "create failed:", iOException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            int n3 = Log.d(TAG, "create failed:", illegalArgumentException);
            return null;
        }
        catch (SecurityException securityException) {
            int n4 = Log.d(TAG, "create failed:", securityException);
            return null;
        }
    }

    public static MediaPlayer create(Context context, Uri uri) {
        return MediaPlayer.create(context, uri, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder surfaceHolder) {
        try {
            MediaPlayer mediaPlayer = new MediaPlayer();
            mediaPlayer.setDataSource(context, uri);
            if (surfaceHolder != null) {
                mediaPlayer.setDisplay(surfaceHolder);
            }
            mediaPlayer.prepare();
            return mediaPlayer;
        }
        catch (IOException iOException) {
            int n = Log.d(TAG, "create failed:", iOException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            int n = Log.d(TAG, "create failed:", illegalArgumentException);
            return null;
        }
        catch (SecurityException securityException) {
            int n = Log.d(TAG, "create failed:", securityException);
            return null;
        }
    }

    private final native void native_finalize();

    private final native boolean native_getMetadata(boolean var1, boolean var2, Parcel var3);

    private static final native void native_init();

    private final native int native_invoke(Parcel var1, Parcel var2);

    private final native int native_setMetadataFilter(Parcel var1);

    private final native void native_setup(Object var1);

    private native int native_suspend_resume(boolean var1);

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        MediaPlayer mediaPlayer = (MediaPlayer)((WeakReference)object).get();
        if (mediaPlayer == null) {
            return;
        }
        if (mediaPlayer.mEventHandler == null) {
            return;
        }
        Message message = mediaPlayer.mEventHandler.obtainMessage(n, n2, n3, object2);
        boolean bl = mediaPlayer.mEventHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void stayAwake(boolean bl) {
        if (this.mWakeLock != null) {
            if (bl && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!bl && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = bl;
        this.updateSurfaceScreenOn();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder == null) {
            return;
        }
        SurfaceHolder surfaceHolder = this.mSurfaceHolder;
        boolean bl = this.mScreenOnWhilePlaying && this.mStayAwake;
        surfaceHolder.setKeepScreenOn(bl);
    }

    public native void attachAuxEffect(int var1);

    protected void finalize() {
        this.native_finalize();
    }

    public native int getAudioSessionId();

    public native int getCurrentPosition();

    public native int getDuration();

    public native Bitmap getFrameAt(int var1) throws IllegalStateException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Metadata getMetadata(boolean bl, boolean bl2) {
        Parcel parcel = Parcel.obtain();
        Metadata metadata = new Metadata();
        if (!this.native_getMetadata(bl, bl2, parcel)) {
            parcel.recycle();
            return null;
        }
        if (metadata.parse(parcel)) return metadata;
        parcel.recycle();
        return null;
    }

    public native int getVideoHeight();

    public native int getVideoWidth();

    public int invoke(Parcel parcel, Parcel parcel2) {
        int n = this.native_invoke(parcel, parcel2);
        parcel2.setDataPosition(0);
        return n;
    }

    public native boolean isLooping();

    public native boolean isPlaying();

    public Parcel newRequest() {
        Parcel parcel = Parcel.obtain();
        parcel.writeInterfaceToken(IMEDIA_PLAYER);
        return parcel;
    }

    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
    }

    public native void prepare() throws IOException, IllegalStateException;

    public native void prepareAsync() throws IllegalStateException;

    public void release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.mOnPreparedListener = null;
        this.mOnBufferingUpdateListener = null;
        this.mOnCompletionListener = null;
        this.mOnSeekCompleteListener = null;
        this.mOnErrorListener = null;
        this.mOnInfoListener = null;
        this.mOnVideoSizeChangedListener = null;
        this._release();
    }

    public void reset() {
        this.stayAwake(false);
        this._reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean resume() {
        if (this.native_suspend_resume(false) < 0) {
            return false;
        }
        if (!this.isPlaying()) return true;
        this.stayAwake(true);
        return true;
    }

    public native void seekTo(int var1) throws IllegalStateException;

    public native void setAudioSessionId(int var1) throws IllegalArgumentException, IllegalStateException;

    public native void setAudioStreamType(int var1);

    public native void setAuxEffectSendLevel(float var1);

    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDataSource(Context context, Uri uri, Map<String, String> map) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String string2 = uri.getScheme();
        if (string2 == null || string2.equals("file")) {
            String string3 = uri.getPath();
            this.setDataSource(string3);
            return;
        }
        AssetFileDescriptor assetFileDescriptor = null;
        try {
            block17: {
                block16: {
                    block15: {
                        AssetFileDescriptor assetFileDescriptor2;
                        assetFileDescriptor = assetFileDescriptor2 = context.getContentResolver().openAssetFileDescriptor(uri, "r");
                        if (assetFileDescriptor != null) break block15;
                        if (assetFileDescriptor == null) {
                            return;
                        }
                        break block16;
                    }
                    if (assetFileDescriptor.getDeclaredLength() < 0L) {
                        FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
                        this.setDataSource(fileDescriptor);
                    } else {
                        FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
                        long l = assetFileDescriptor.getStartOffset();
                        long l2 = assetFileDescriptor.getDeclaredLength();
                        this.setDataSource(fileDescriptor, l, l2);
                    }
                    if (assetFileDescriptor == null) break block17;
                }
                assetFileDescriptor.close();
                return;
            }
            return;
        }
        catch (SecurityException securityException) {
            block14: {
                block18: {
                    if (assetFileDescriptor == null) break block14;
                    break block18;
                    catch (Throwable throwable) {
                        if (assetFileDescriptor != null) {
                            assetFileDescriptor.close();
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        if (assetFileDescriptor == null) break block14;
                    }
                }
                assetFileDescriptor.close();
            }
            int n = Log.d(TAG, "Couldn't open file on client side, trying server side");
            String string4 = uri.toString();
            this.setDataSource(string4, map);
            return;
        }
    }

    public void setDataSource(FileDescriptor fileDescriptor) throws IOException, IllegalArgumentException, IllegalStateException {
        MediaPlayer mediaPlayer = this;
        FileDescriptor fileDescriptor2 = fileDescriptor;
        mediaPlayer.setDataSource(fileDescriptor2, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public native void setDataSource(FileDescriptor var1, long var2, long var4) throws IOException, IllegalArgumentException, IllegalStateException;

    public native void setDataSource(String var1) throws IOException, IllegalArgumentException, IllegalStateException;

    public native void setDataSource(String var1, Map<String, String> var2) throws IOException, IllegalArgumentException, IllegalStateException;

    /*
     * Enabled aggressive block sorting
     */
    public void setDisplay(SurfaceHolder surfaceHolder) {
        Surface surface;
        this.mSurfaceHolder = surfaceHolder;
        this.mSurface = surfaceHolder != null ? (surface = surfaceHolder.getSurface()) : null;
        this._setVideoSurface();
        this.updateSurfaceScreenOn();
    }

    public native void setLooping(boolean var1);

    public int setMetadataFilter(Set<Integer> set, Set<Integer> set2) {
        Parcel parcel = this.newRequest();
        int n = parcel.dataSize();
        int n2 = set.size() + 1 + 1;
        int n3 = set2.size();
        int n4 = (n2 + n3) * 4;
        int n5 = n + n4;
        if (parcel.dataCapacity() < n5) {
            parcel.setDataCapacity(n5);
        }
        int n6 = set.size();
        parcel.writeInt(n6);
        for (int n7 : set) {
            parcel.writeInt(n7);
        }
        int n8 = set2.size();
        parcel.writeInt(n8);
        for (int n9 : set2) {
            parcel.writeInt(n9);
        }
        return this.native_setMetadataFilter(parcel);
    }

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener onBufferingUpdateListener) {
        this.mOnBufferingUpdateListener = onBufferingUpdateListener;
    }

    public void setOnCompletionListener(OnCompletionListener onCompletionListener) {
        this.mOnCompletionListener = onCompletionListener;
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnInfoListener(OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    public void setOnPreparedListener(OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    public void setOnSeekCompleteListener(OnSeekCompleteListener onSeekCompleteListener) {
        this.mOnSeekCompleteListener = onSeekCompleteListener;
    }

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener onVideoSizeChangedListener) {
        this.mOnVideoSizeChangedListener = onVideoSizeChangedListener;
    }

    public void setScreenOnWhilePlaying(boolean bl) {
        if (this.mScreenOnWhilePlaying != bl) {
            return;
        }
        this.mScreenOnWhilePlaying = bl;
        this.updateSurfaceScreenOn();
    }

    public native void setVolume(float var1, float var2);

    public void setWakeMode(Context context, int n) {
        PowerManager.WakeLock wakeLock;
        boolean bl = false;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                bl = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        int n2 = 0x20000000 | n;
        String string2 = MediaPlayer.class.getName();
        this.mWakeLock = wakeLock = powerManager.newWakeLock(n2, string2);
        this.mWakeLock.setReferenceCounted(false);
        if (!bl) {
            return;
        }
        this.mWakeLock.acquire();
    }

    public void start() throws IllegalStateException {
        this.stayAwake(true);
        this._start();
    }

    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean suspend() {
        if (this.native_suspend_resume(true) < 0) {
            return false;
        }
        this.stayAwake(false);
        this.mEventHandler.removeCallbacksAndMessages(null);
        return true;
    }

    public static interface OnInfoListener {
        public boolean onInfo(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public boolean onError(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(MediaPlayer var1);
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(MediaPlayer var1, int var2);
    }

    public static interface OnCompletionListener {
        public void onCompletion(MediaPlayer var1);
    }

    public static interface OnPreparedListener {
        public void onPrepared(MediaPlayer var1);
    }

    private class EventHandler
    extends Handler {
        private MediaPlayer mMediaPlayer;

        public EventHandler(MediaPlayer mediaPlayer2, Looper looper) {
            super(looper);
            this.mMediaPlayer = mediaPlayer2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message message) {
            if (this.mMediaPlayer.mNativeContext == 0) {
                int n = Log.w(MediaPlayer.TAG, "mediaplayer went away with unhandled events");
                return;
            }
            switch (message.what) {
                case 0: {
                    return;
                }
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown message type ");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    int n2 = Log.e(MediaPlayer.TAG, string2);
                    return;
                }
                case 1: {
                    if (MediaPlayer.this.mOnPreparedListener == null) {
                        return;
                    }
                    OnPreparedListener onPreparedListener = MediaPlayer.this.mOnPreparedListener;
                    MediaPlayer mediaPlayer = this.mMediaPlayer;
                    onPreparedListener.onPrepared(mediaPlayer);
                    return;
                }
                case 2: {
                    if (MediaPlayer.this.mOnCompletionListener != null) {
                        OnCompletionListener onCompletionListener = MediaPlayer.this.mOnCompletionListener;
                        MediaPlayer mediaPlayer = this.mMediaPlayer;
                        onCompletionListener.onCompletion(mediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 3: {
                    if (MediaPlayer.this.mOnBufferingUpdateListener == null) {
                        return;
                    }
                    OnBufferingUpdateListener onBufferingUpdateListener = MediaPlayer.this.mOnBufferingUpdateListener;
                    MediaPlayer mediaPlayer = this.mMediaPlayer;
                    int n = message.arg1;
                    onBufferingUpdateListener.onBufferingUpdate(mediaPlayer, n);
                    return;
                }
                case 4: {
                    if (MediaPlayer.this.mOnSeekCompleteListener == null) {
                        return;
                    }
                    OnSeekCompleteListener onSeekCompleteListener = MediaPlayer.this.mOnSeekCompleteListener;
                    MediaPlayer mediaPlayer = this.mMediaPlayer;
                    onSeekCompleteListener.onSeekComplete(mediaPlayer);
                    return;
                }
                case 5: {
                    if (MediaPlayer.this.mOnVideoSizeChangedListener == null) {
                        return;
                    }
                    OnVideoSizeChangedListener onVideoSizeChangedListener = MediaPlayer.this.mOnVideoSizeChangedListener;
                    MediaPlayer mediaPlayer = this.mMediaPlayer;
                    int n = message.arg1;
                    int n3 = message.arg2;
                    onVideoSizeChangedListener.onVideoSizeChanged(mediaPlayer, n, n3);
                    return;
                }
                case 100: {
                    StringBuilder stringBuilder = new StringBuilder().append("Error (");
                    int n = message.arg1;
                    StringBuilder stringBuilder2 = stringBuilder.append(n).append(",");
                    int n4 = message.arg2;
                    String string3 = stringBuilder2.append(n4).append(")").toString();
                    int n5 = Log.e(MediaPlayer.TAG, string3);
                    boolean bl = false;
                    if (MediaPlayer.this.mOnErrorListener != null) {
                        OnErrorListener onErrorListener = MediaPlayer.this.mOnErrorListener;
                        MediaPlayer mediaPlayer = this.mMediaPlayer;
                        int n6 = message.arg1;
                        int n7 = message.arg2;
                        bl = onErrorListener.onError(mediaPlayer, n6, n7);
                    }
                    if (MediaPlayer.this.mOnCompletionListener != null && !bl) {
                        OnCompletionListener onCompletionListener = MediaPlayer.this.mOnCompletionListener;
                        MediaPlayer mediaPlayer = this.mMediaPlayer;
                        onCompletionListener.onCompletion(mediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 200: 
            }
            StringBuilder stringBuilder = new StringBuilder().append("Info (");
            int n = message.arg1;
            StringBuilder stringBuilder3 = stringBuilder.append(n).append(",");
            int n8 = message.arg2;
            String string4 = stringBuilder3.append(n8).append(")").toString();
            int n9 = Log.i(MediaPlayer.TAG, string4);
            if (MediaPlayer.this.mOnInfoListener == null) {
                return;
            }
            OnInfoListener onInfoListener = MediaPlayer.this.mOnInfoListener;
            MediaPlayer mediaPlayer = this.mMediaPlayer;
            int n10 = message.arg1;
            int n11 = message.arg2;
            boolean bl = onInfoListener.onInfo(mediaPlayer, n10, n11);
        }
    }
}

