/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class MediaRecorder {
    public static final int MEDIA_RECORDER_ERROR_UNKNOWN = 1;
    public static final int MEDIA_RECORDER_INFO_MAX_DURATION_REACHED = 800;
    public static final int MEDIA_RECORDER_INFO_MAX_FILESIZE_REACHED = 801;
    public static final int MEDIA_RECORDER_INFO_UNKNOWN = 1;
    private static final String TAG = "MediaRecorder";
    private EventHandler mEventHandler;
    private FileDescriptor mFd;
    private int mNativeContext;
    private OnErrorListener mOnErrorListener;
    private OnInfoListener mOnInfoListener;
    private String mPath;
    private Surface mSurface;

    static {
        System.loadLibrary("media_jni");
        MediaRecorder.native_init();
    }

    /*
     * Enabled aggressive block sorting
     */
    public MediaRecorder() {
        EventHandler eventHandler;
        EventHandler eventHandler2;
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? (eventHandler2 = new EventHandler(this, looper)) : ((looper = Looper.getMainLooper()) != null ? (eventHandler = new EventHandler(this, looper)) : null);
        WeakReference<MediaRecorder> weakReference = new WeakReference<MediaRecorder>(this);
        this.native_setup(weakReference);
    }

    private native void _prepare() throws IllegalStateException, IOException;

    private native void _setOutputFile(FileDescriptor var1, long var2, long var4) throws IllegalStateException, IOException;

    public static final int getAudioSourceMax() {
        return 6;
    }

    private final native void native_finalize();

    private static final native void native_init();

    private native void native_reset();

    private final native void native_setup(Object var1) throws IllegalStateException;

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        MediaRecorder mediaRecorder = (MediaRecorder)((WeakReference)object).get();
        if (mediaRecorder == null) {
            return;
        }
        if (mediaRecorder.mEventHandler == null) {
            return;
        }
        Message message = mediaRecorder.mEventHandler.obtainMessage(n, n2, n3, object2);
        boolean bl = mediaRecorder.mEventHandler.sendMessage(message);
    }

    private native void setParameter(String var1);

    protected void finalize() {
        this.native_finalize();
    }

    public native int getMaxAmplitude() throws IllegalStateException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepare() throws IllegalStateException, IOException {
        if (this.mPath != null) {
            String string2 = this.mPath;
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            try {
                FileDescriptor fileDescriptor = fileOutputStream.getFD();
                this._setOutputFile(fileDescriptor, 0L, 0L);
            }
            finally {
                fileOutputStream.close();
            }
        } else {
            if (this.mFd == null) {
                throw new IOException("No valid output file");
            }
            FileDescriptor fileDescriptor = this.mFd;
            MediaRecorder mediaRecorder = this;
            long l = 0L;
            mediaRecorder._setOutputFile(fileDescriptor, 0L, l);
        }
        this._prepare();
    }

    public native void release();

    public void reset() {
        this.native_reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
    }

    public void setAudioChannels(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of channels is not positive");
        }
        Object[] objectArray = new Object[1];
        Integer n2 = n;
        objectArray[0] = n2;
        String string2 = String.format("audio-param-number-of-channels=%d", objectArray);
        this.setParameter(string2);
    }

    public native void setAudioEncoder(int var1) throws IllegalStateException;

    public void setAudioEncodingBitRate(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Audio encoding bit rate is not positive");
        }
        Object[] objectArray = new Object[1];
        Integer n2 = n;
        objectArray[0] = n2;
        String string2 = String.format("audio-param-encoding-bitrate=%d", objectArray);
        this.setParameter(string2);
    }

    public void setAudioSamplingRate(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Audio sampling rate is not positive");
        }
        Object[] objectArray = new Object[1];
        Integer n2 = n;
        objectArray[0] = n2;
        String string2 = String.format("audio-param-sampling-rate=%d", objectArray);
        this.setParameter(string2);
    }

    public native void setAudioSource(int var1) throws IllegalStateException;

    public native void setCamera(Camera var1);

    public native void setMaxDuration(int var1) throws IllegalArgumentException;

    public native void setMaxFileSize(long var1) throws IllegalArgumentException;

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnInfoListener(OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    public void setOrientationHint(int n) {
        if (n != 0 && n != 90 && n != 180 && n != 270) {
            String string2 = "Unsupported angle: " + n;
            throw new IllegalArgumentException(string2);
        }
        Object[] objectArray = new Object[1];
        Integer n2 = n;
        objectArray[0] = n2;
        String string3 = String.format("video-param-rotation-angle-degrees=%d", objectArray);
        this.setParameter(string3);
    }

    public void setOutputFile(FileDescriptor fileDescriptor) throws IllegalStateException {
        this.mPath = null;
        this.mFd = fileDescriptor;
    }

    public void setOutputFile(String string2) throws IllegalStateException {
        this.mFd = null;
        this.mPath = string2;
    }

    public native void setOutputFormat(int var1) throws IllegalStateException;

    public void setPreviewDisplay(Surface surface) {
        this.mSurface = surface;
    }

    public void setProfile(CamcorderProfile camcorderProfile) {
        int n = camcorderProfile.fileFormat;
        this.setOutputFormat(n);
        int n2 = camcorderProfile.videoFrameRate;
        this.setVideoFrameRate(n2);
        int n3 = camcorderProfile.videoFrameWidth;
        int n4 = camcorderProfile.videoFrameHeight;
        this.setVideoSize(n3, n4);
        int n5 = camcorderProfile.videoBitRate;
        this.setVideoEncodingBitRate(n5);
        int n6 = camcorderProfile.audioBitRate;
        this.setAudioEncodingBitRate(n6);
        int n7 = camcorderProfile.audioChannels;
        this.setAudioChannels(n7);
        int n8 = camcorderProfile.audioSampleRate;
        this.setAudioSamplingRate(n8);
        int n9 = camcorderProfile.videoCodec;
        this.setVideoEncoder(n9);
        int n10 = camcorderProfile.audioCodec;
        this.setAudioEncoder(n10);
    }

    public native void setVideoEncoder(int var1) throws IllegalStateException;

    public void setVideoEncodingBitRate(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Video encoding bit rate is not positive");
        }
        Object[] objectArray = new Object[1];
        Integer n2 = n;
        objectArray[0] = n2;
        String string2 = String.format("video-param-encoding-bitrate=%d", objectArray);
        this.setParameter(string2);
    }

    public native void setVideoFrameRate(int var1) throws IllegalStateException;

    public native void setVideoSize(int var1, int var2) throws IllegalStateException;

    public native void setVideoSource(int var1) throws IllegalStateException;

    public native void start() throws IllegalStateException;

    public native void stop() throws IllegalStateException;

    private class EventHandler
    extends Handler {
        private static final int MEDIA_RECORDER_EVENT_ERROR = 1;
        private static final int MEDIA_RECORDER_EVENT_INFO = 2;
        private MediaRecorder mMediaRecorder;

        public EventHandler(MediaRecorder mediaRecorder2, Looper looper) {
            super(looper);
            this.mMediaRecorder = mediaRecorder2;
        }

        @Override
        public void handleMessage(Message message) {
            if (this.mMediaRecorder.mNativeContext == 0) {
                int n = Log.w(MediaRecorder.TAG, "mediarecorder went away with unhandled events");
                return;
            }
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown message type ");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    int n2 = Log.e(MediaRecorder.TAG, string2);
                    return;
                }
                case 1: {
                    if (MediaRecorder.this.mOnErrorListener == null) {
                        return;
                    }
                    OnErrorListener onErrorListener = MediaRecorder.this.mOnErrorListener;
                    MediaRecorder mediaRecorder = this.mMediaRecorder;
                    int n = message.arg1;
                    int n3 = message.arg2;
                    onErrorListener.onError(mediaRecorder, n, n3);
                    return;
                }
                case 2: 
            }
            if (MediaRecorder.this.mOnInfoListener == null) {
                return;
            }
            OnInfoListener onInfoListener = MediaRecorder.this.mOnInfoListener;
            MediaRecorder mediaRecorder = this.mMediaRecorder;
            int n = message.arg1;
            int n4 = message.arg2;
            onInfoListener.onInfo(mediaRecorder, n, n4);
        }
    }

    public static interface OnInfoListener {
        public void onInfo(MediaRecorder var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public void onError(MediaRecorder var1, int var2, int var3);
    }

    public final class VideoEncoder {
        public static final int DEFAULT = 0;
        public static final int H263 = 1;
        public static final int H264 = 2;
        public static final int MPEG_4_SP = 3;

        private VideoEncoder() {
        }
    }

    public final class AudioEncoder {
        public static final int AAC = 3;
        public static final int AAC_PLUS = 4;
        public static final int AMR_NB = 1;
        public static final int AMR_WB = 2;
        public static final int DEFAULT = 0;
        public static final int EAAC_PLUS = 5;

        private AudioEncoder() {
        }
    }

    public final class OutputFormat {
        public static final int AAC_ADIF = 5;
        public static final int AAC_ADTS = 6;
        public static final int AMR_NB = 3;
        public static final int AMR_WB = 4;
        public static final int DEFAULT = 0;
        public static final int MPEG_4 = 2;
        public static final int OUTPUT_FORMAT_MPEG2TS = 8;
        public static final int OUTPUT_FORMAT_RTP_AVP = 7;
        public static final int RAW_AMR = 3;
        public static final int THREE_GPP = 1;

        private OutputFormat() {
        }
    }

    public final class VideoSource {
        public static final int CAMERA = 1;
        public static final int DEFAULT;

        private VideoSource() {
        }
    }

    public final class AudioSource {
        public static final int CAMCORDER = 5;
        public static final int DEFAULT = 0;
        public static final int MIC = 1;
        public static final int VOICE_CALL = 4;
        public static final int VOICE_COMMUNICATION = 7;
        public static final int VOICE_DOWNLINK = 3;
        public static final int VOICE_RECOGNITION = 6;
        public static final int VOICE_UPLINK = 2;

        private AudioSource() {
        }
    }
}

