/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.database.Cursor;
import android.database.SQLException;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.media.MediaFile;
import android.media.MediaScannerClient;
import android.net.Uri;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.MediaStore;
import android.provider.Settings;
import android.sax.ElementListener;
import android.sax.RootElement;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MediaScanner {
    private static final String ALARMS_DIR = "/alarms/";
    private static final String[] AUDIO_PROJECTION;
    private static final int DATE_MODIFIED_AUDIO_COLUMN_INDEX = 2;
    private static final int DATE_MODIFIED_IMAGES_COLUMN_INDEX = 2;
    private static final int DATE_MODIFIED_PLAYLISTS_COLUMN_INDEX = 2;
    private static final int DATE_MODIFIED_VIDEO_COLUMN_INDEX = 2;
    private static final String DEFAULT_RINGTONE_PROPERTY_PREFIX = "ro.config.";
    private static final String[] GENRE_LOOKUP_PROJECTION;
    private static final String[] ID3_GENRES;
    private static final int ID_AUDIO_COLUMN_INDEX = 0;
    private static final int ID_IMAGES_COLUMN_INDEX = 0;
    private static final int ID_PLAYLISTS_COLUMN_INDEX = 0;
    private static final int ID_VIDEO_COLUMN_INDEX = 0;
    private static final String[] IMAGES_PROJECTION;
    private static final String MUSIC_DIR = "/music/";
    private static final String NOTIFICATIONS_DIR = "/notifications/";
    private static final int PATH_AUDIO_COLUMN_INDEX = 1;
    private static final int PATH_IMAGES_COLUMN_INDEX = 1;
    private static final int PATH_PLAYLISTS_COLUMN_INDEX = 1;
    private static final int PATH_VIDEO_COLUMN_INDEX = 1;
    private static final String[] PLAYLISTS_PROJECTION;
    private static final String[] PLAYLIST_MEMBERS_PROJECTION;
    private static final String PODCAST_DIR = "/podcasts/";
    private static final String RINGTONES_DIR = "/ringtones/";
    private static final String TAG = "MediaScanner";
    private static final String[] VIDEO_PROJECTION;
    private Uri mAudioUri;
    private BitmapFactory.Options mBitmapOptions;
    private boolean mCaseInsensitivePaths;
    private MyMediaScannerClient mClient;
    private Context mContext;
    private String mDefaultAlarmAlertFilename;
    private boolean mDefaultAlarmSet;
    private String mDefaultNotificationFilename;
    private boolean mDefaultNotificationSet;
    private String mDefaultRingtoneFilename;
    private boolean mDefaultRingtoneSet;
    private HashMap<String, FileCacheEntry> mFileCache;
    private HashMap<String, Uri> mGenreCache;
    private Uri mGenresUri;
    private Uri mImagesUri;
    private IContentProvider mMediaProvider;
    private int mNativeContext;
    private int mOriginalCount;
    private ArrayList<FileCacheEntry> mPlayLists;
    private Uri mPlaylistsUri;
    private boolean mProcessGenres;
    private boolean mProcessPlaylists;
    private Uri mThumbsUri;
    private Uri mVideoUri;

    static {
        System.loadLibrary("media_jni");
        MediaScanner.native_init();
        String[] stringArray = new String[]{"_id", "_data", "date_modified"};
        AUDIO_PROJECTION = stringArray;
        String[] stringArray2 = new String[]{"_id", "_data", "date_modified"};
        VIDEO_PROJECTION = stringArray2;
        String[] stringArray3 = new String[]{"_id", "_data", "date_modified"};
        IMAGES_PROJECTION = stringArray3;
        String[] stringArray4 = new String[]{"_id", "_data", "date_modified"};
        PLAYLISTS_PROJECTION = stringArray4;
        String[] stringArray5 = new String[]{"playlist_id"};
        PLAYLIST_MEMBERS_PROJECTION = stringArray5;
        String[] stringArray6 = new String[]{"_id", "name"};
        GENRE_LOOKUP_PROJECTION = stringArray6;
        String[] stringArray7 = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall"};
        ID3_GENRES = stringArray7;
    }

    public MediaScanner(Context context) {
        MyMediaScannerClient myMediaScannerClient;
        BitmapFactory.Options options;
        this.mBitmapOptions = options = new BitmapFactory.Options();
        this.mClient = myMediaScannerClient = new MyMediaScannerClient();
        this.native_setup();
        this.mContext = context;
        this.mBitmapOptions.inSampleSize = 1;
        this.mBitmapOptions.inJustDecodeBounds = true;
        this.setDefaultRingtoneFileNames();
    }

    static /* synthetic */ boolean access$1100(MediaScanner mediaScanner) {
        return mediaScanner.mProcessGenres;
    }

    static /* synthetic */ HashMap access$1200(MediaScanner mediaScanner) {
        return mediaScanner.mGenreCache;
    }

    static /* synthetic */ Uri access$1300(MediaScanner mediaScanner) {
        return mediaScanner.mGenresUri;
    }

    static /* synthetic */ String[] access$1400() {
        return GENRE_LOOKUP_PROJECTION;
    }

    static /* synthetic */ boolean access$1500(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultNotificationSet;
    }

    static /* synthetic */ boolean access$1502(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultNotificationSet = bl;
        return bl;
    }

    static /* synthetic */ String access$1600(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultNotificationFilename;
    }

    static /* synthetic */ boolean access$1700(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultRingtoneSet;
    }

    static /* synthetic */ boolean access$1702(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultRingtoneSet = bl;
        return bl;
    }

    static /* synthetic */ String access$1800(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultRingtoneFilename;
    }

    static /* synthetic */ boolean access$1900(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultAlarmSet;
    }

    static /* synthetic */ boolean access$1902(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultAlarmSet = bl;
        return bl;
    }

    static /* synthetic */ String access$2000(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultAlarmAlertFilename;
    }

    static /* synthetic */ Uri access$700(MediaScanner mediaScanner) {
        return mediaScanner.mVideoUri;
    }

    static /* synthetic */ Uri access$800(MediaScanner mediaScanner) {
        return mediaScanner.mImagesUri;
    }

    static /* synthetic */ Uri access$900(MediaScanner mediaScanner) {
        return mediaScanner.mAudioUri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addPlayListEntry(String string2, String string3, Uri uri, ContentValues contentValues, int n) {
        int n2;
        String string4;
        int n3;
        String string5;
        int n4;
        String string6;
        char c;
        boolean bl;
        int n5;
        int n6;
        String string7;
        int n7;
        for (n7 = string2.length(); n7 > 0 && Character.isWhitespace((string7 = string2).charAt(n6 = (n5 = n7 - 1))); n7 += -1) {
        }
        if (n7 < 3) {
            return false;
        }
        int n8 = string2.length();
        if (n7 < n8) {
            String string8 = string2;
            int n9 = 0;
            int n10 = n7;
            string2 = string8.substring(n9, n10);
        }
        if (!(bl = (c = (string6 = string2).charAt(n4 = 0)) == '/' || Character.isLetter(c) && (string5 = string2).charAt(n3 = 1) == ':' && (string4 = string2).charAt(n2 = 2) == '\\')) {
            StringBuilder stringBuilder = new StringBuilder();
            String string9 = string3;
            StringBuilder stringBuilder2 = stringBuilder.append(string9);
            String string10 = string2;
            string2 = stringBuilder2.append(string10).toString();
        }
        FileCacheEntry fileCacheEntry = null;
        int n11 = 0;
        Iterator<FileCacheEntry> iterator = this.mFileCache.values().iterator();
        while (true) {
            String string11;
            FileCacheEntry fileCacheEntry2;
            block11: {
                block10: {
                    if (!iterator.hasNext()) break block10;
                    fileCacheEntry2 = iterator.next();
                    string11 = fileCacheEntry2.mPath;
                    String string12 = string11;
                    String string13 = string2;
                    if (!string12.equalsIgnoreCase(string13)) break block11;
                    fileCacheEntry = fileCacheEntry2;
                }
                if (fileCacheEntry == null) return false;
                Uri uri2 = this.mAudioUri;
                Uri uri3 = fileCacheEntry.mTableUri;
                if (uri2.equals(uri3)) break;
                return false;
            }
            MediaScanner mediaScanner = this;
            String string14 = string11;
            String string15 = string2;
            int n12 = mediaScanner.matchPaths(string14, string15);
            if (n12 <= n11) continue;
            fileCacheEntry = fileCacheEntry2;
            n11 = n12;
        }
        try {
            contentValues.clear();
            Integer n13 = n;
            ContentValues contentValues2 = contentValues;
            String string16 = "play_order";
            Integer n14 = n13;
            contentValues2.put(string16, n14);
            Long l = fileCacheEntry.mRowId;
            ContentValues contentValues3 = contentValues;
            String string17 = "audio_id";
            Long l2 = l;
            contentValues3.put(string17, l2);
            IContentProvider iContentProvider = this.mMediaProvider;
            Uri uri4 = uri;
            ContentValues contentValues4 = contentValues;
            Uri uri5 = iContentProvider.insert(uri4, contentValues4);
            return true;
        }
        catch (RemoteException remoteException) {
            int n15 = Log.e(TAG, "RemoteException in MediaScanner.addPlayListEntry()", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inScanDirectory(String string2, String[] stringArray) {
        int n;
        int n2 = 0;
        while (n2 < (n = stringArray.length)) {
            String string3 = stringArray[n2];
            if (string2.startsWith(string3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void initialize(String string2) {
        Uri uri;
        Uri uri2;
        Uri uri3;
        Uri uri4;
        Uri uri5;
        Uri uri6;
        IContentProvider iContentProvider;
        this.mMediaProvider = iContentProvider = this.mContext.getContentResolver().acquireProvider("media");
        this.mAudioUri = uri6 = MediaStore.Audio.Media.getContentUri(string2);
        this.mVideoUri = uri5 = MediaStore.Video.Media.getContentUri(string2);
        this.mImagesUri = uri4 = MediaStore.Images.Media.getContentUri(string2);
        this.mThumbsUri = uri3 = MediaStore.Images.Thumbnails.getContentUri(string2);
        if (string2.equals("internal")) {
            return;
        }
        this.mProcessPlaylists = true;
        this.mProcessGenres = true;
        HashMap hashMap = new HashMap();
        this.mGenreCache = hashMap;
        this.mGenresUri = uri2 = MediaStore.Audio.Genres.getContentUri(string2);
        this.mPlaylistsUri = uri = MediaStore.Audio.Playlists.getContentUri(string2);
        if (!Process.supportsProcesses()) {
            return;
        }
        this.mCaseInsensitivePaths = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int matchPaths(String string2, String string3) {
        int n = 0;
        int n2 = string2.length();
        int n3 = string3.length();
        while (n2 > 0 && n3 > 0) {
            String string4;
            String string5;
            int n4;
            int n5;
            int n6;
            int n7 = n2 - 1;
            int n8 = string2.lastIndexOf(47, n7);
            int n9 = n3 - 1;
            int n10 = string3.lastIndexOf(47, n9);
            int n11 = n2 - 1;
            int n12 = string2.lastIndexOf(92, n11);
            int n13 = n3 - 1;
            int n14 = string3.lastIndexOf(92, n13);
            int n15 = n10 > n14 ? n10 : n14;
            int n16 = n15 < 0 ? 0 : n15 + 1;
            if (n3 - n16 != (n6 = n2 - (n5 = (n4 = n8 > n12 ? n8 : n12) < 0 ? 0 : n4 + 1)) || !(string5 = string2).regionMatches(true, n5, string4 = string3, n16, n6)) break;
            ++n;
            n2 = n5 - 1;
            n3 = n16 - 1;
        }
        return n;
    }

    private final native void native_finalize();

    private static final native void native_init();

    private final native void native_setup();

    /*
     * Enabled aggressive block sorting
     */
    private void postscan(String[] stringArray) throws RemoteException {
        Uri uri;
        Uri uri2;
        Iterator<FileCacheEntry> iterator = this.mFileCache.values().iterator();
        while (iterator.hasNext()) {
            FileCacheEntry fileCacheEntry = iterator.next();
            String string2 = fileCacheEntry.mPath;
            boolean bl = false;
            if (!fileCacheEntry.mSeenInFileSystem) {
                if (this.inScanDirectory(string2, stringArray)) {
                    bl = true;
                } else if (!new File(string2).exists()) {
                    bl = true;
                }
            }
            if (!bl) continue;
            MediaFile.MediaFileType mediaFileType = MediaFile.getFileType(string2);
            int n = mediaFileType == null ? 0 : mediaFileType.fileType;
            if (MediaFile.isPlayListFileType(n)) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("_data", "");
                Integer n2 = 0;
                contentValues.put("date_modified", n2);
                IContentProvider iContentProvider = this.mMediaProvider;
                Uri uri3 = this.mPlaylistsUri;
                long l = fileCacheEntry.mRowId;
                Uri uri4 = ContentUris.withAppendedId(uri3, l);
                int n3 = iContentProvider.update(uri4, contentValues, null, null);
                continue;
            }
            IContentProvider iContentProvider = this.mMediaProvider;
            Uri uri5 = fileCacheEntry.mTableUri;
            long l = fileCacheEntry.mRowId;
            Uri uri6 = ContentUris.withAppendedId(uri5, l);
            int n4 = iContentProvider.delete(uri6, null, null);
            iterator.remove();
        }
        if (this.mProcessPlaylists) {
            this.processPlayLists();
        }
        if (this.mOriginalCount == 0 && (uri2 = this.mImagesUri).equals(uri = MediaStore.Images.Media.getContentUri("external"))) {
            this.pruneDeadThumbnailFiles();
        }
        this.mGenreCache = null;
        this.mPlayLists = null;
        this.mFileCache = null;
        this.mMediaProvider = null;
    }

    /*
     * Exception decompiling
     */
    private void prescan(String var1_1) throws RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 271->321)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private native void processDirectory(String var1, String var2, MediaScannerClient var3);

    private native void processFile(String var1, String var2, MediaScannerClient var3);

    /*
     * Unable to fully structure code
     */
    private void processM3uPlayList(String var1_1, String var2_2, Uri var3_3, ContentValues var4_4) {
        block21: {
            var5_5 = null;
            var6_6 = new File(var1_1);
            if (!var6_6.exists()) break block21;
            var7_7 = new FileInputStream(var6_6);
            var8_8 = new InputStreamReader(var7_7);
            var9_9 = new BufferedReader(var8_8, 8192);
            var10_10 = var9_9.readLine();
            var11_11 = 0;
            while (var10_10 != null) {
                if (var10_10.length() > 0 && var10_10.charAt(0) != '#') {
                    var4_4.clear();
                    var12_12 = this;
                    var13_13 = var2_2;
                    var14_14 = var3_3;
                    var15_15 = var4_4;
                    if (var12_12.addPlayListEntry(var10_10, var13_13, var14_14, var15_15, var11_11)) {
                        var16_16 = var11_11 + 1;
                    }
                }
                var10_10 = var17_17 = var9_9.readLine();
            }
            var5_5 = var9_9;
        }
        if (var5_5 == null) {
            return;
        }
        try {
            var5_5.close();
            return;
        }
        catch (IOException var18_18) {
            var19_19 = Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", var18_18);
            return;
        }
        catch (IOException var20_20) lbl-1000:
        // 2 sources

        {
            while (true) {
                block22: {
                    try {
                        var21_23 = Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", (Throwable)var20_21);
                        if (var5_5 != null) break block22;
                        return;
                    }
                    catch (Throwable var24_26) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var5_5 != null) {
                                var5_5.close();
                            }
lbl43:
                            // 4 sources

                            throw var24_27;
                            catch (IOException var25_29) {
                                var26_30 = Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", var25_29);
                                ** continue;
                            }
                            break;
                        }
                    }
                }
                try {
                    var5_5.close();
                    return;
                }
                catch (IOException var22_24) {
                    var23_25 = Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", var22_24);
                    return;
                }
                break;
            }
        }
        catch (Throwable var24_28) {
            var5_5 = var9_9;
            ** continue;
        }
        catch (IOException var20_22) {
            var5_5 = var9_9;
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processPlayLists() throws RemoteException {
        var1_1 = this.mPlayLists.iterator();
        block3: while (true) {
            block14: {
                block11: {
                    block10: {
                        block12: {
                            block13: {
                                if (!var1_1.hasNext()) {
                                    return;
                                }
                                var2_2 = var1_1.next();
                                var3_3 = var2_2.mPath;
                                if (!var2_2.mLastModifiedChanged) continue;
                                var4_4 = new ContentValues();
                                var5_5 = var3_3;
                                var6_6 = 47;
                                var7_7 = var5_5.lastIndexOf(var6_6);
                                if (var7_7 < 0) {
                                    var8_85 = new StringBuilder().append("bad path ");
                                    var9_86 = var3_3;
                                    var10_87 = var8_85.append(var9_86).toString();
                                    throw new IllegalArgumentException(var10_87);
                                }
                                var11_8 = var2_2.mRowId;
                                if (var11_8 != 0L) break block12;
                                var13_9 = var3_3;
                                var14_10 = 46;
                                var15_11 = var13_9.lastIndexOf(var14_10);
                                if (var15_11 >= 0) break block13;
                                var16_12 = var7_7 + 1;
                                var17_13 = var3_3;
                                var18_14 = var16_12;
                                var19_15 = var17_13.substring(var18_14);
lbl27:
                                // 2 sources

                                while (true) {
                                    var20_16 = var4_4;
                                    var21_17 = "name";
                                    var22_18 = var19_15;
                                    var20_16.put(var21_17, var22_18);
                                    var23_19 = var4_4;
                                    var24_20 = "_data";
                                    var25_21 = var3_3;
                                    var23_19.put(var24_20, var25_21);
                                    var26_22 = var2_2.mLastModified;
                                    var27_23 = var4_4;
                                    var28_24 = "date_modified";
                                    var29_25 = var26_22;
                                    var27_23.put(var28_24, var29_25);
                                    var30_26 = this.mMediaProvider;
                                    var31_27 = this.mPlaylistsUri;
                                    var32_28 = var30_26;
                                    var33_29 = var31_27;
                                    var34_30 = var4_4;
                                    var35_31 = var32_28.insert(var33_29, var34_30);
                                    var36_32 = ContentUris.parseId(var35_31);
                                    var38_33 = var35_31;
                                    var39_34 = "members";
                                    var40_35 = Uri.withAppendedPath(var38_33, var39_34);
lbl51:
                                    // 2 sources

                                    while (true) {
                                        var41_36 = var7_7 + 1;
                                        var42_37 = var3_3;
                                        var43_38 = 0;
                                        var44_39 = var41_36;
                                        var45_40 = var42_37.substring(var43_38, var44_39);
                                        var46_41 = MediaFile.getFileType(var3_3);
                                        if (var46_41 != null) break block10;
                                        var47_42 = 0;
lbl60:
                                        // 2 sources

                                        while (var47_42 == 41) {
                                            var48_43 = this;
                                            var49_44 = var3_3;
                                            var50_45 = var45_40;
                                            var51_46 = var40_35;
                                            var52_47 = var4_4;
                                            var48_43.processM3uPlayList(var49_44, var50_45, var51_46, var52_47);
lbl67:
                                            // 4 sources

                                            while (true) {
                                                var53_48 = this.mMediaProvider;
                                                var54_49 = MediaScanner.PLAYLIST_MEMBERS_PROJECTION;
                                                var55_50 = var53_48.query(var40_35, var54_49, null, null, null);
                                                if (var55_50 == null) ** GOTO lbl74
                                                if (var55_50.getCount() != 0) continue block3;
lbl74:
                                                // 2 sources

                                                var56_51 = Log.d("MediaScanner", "playlist is empty - deleting");
                                                var57_52 = this.mMediaProvider;
                                                var58_53 = var35_31;
                                                var59_54 = null;
                                                var60_55 = null;
                                                var61_56 = var57_52.delete(var58_53, var59_54, var60_55);
                                                continue block3;
                                                break;
                                            }
                                        }
                                        break block11;
                                        break;
                                    }
                                    break;
                                }
                            }
                            var62_57 = var7_7 + 1;
                            var63_58 = var3_3;
                            var64_59 = var62_57;
                            var65_60 = var15_11;
                            var19_15 = var63_58.substring(var64_59, var65_60);
                            ** continue;
                        }
                        var66_61 = this.mPlaylistsUri;
                        var67_62 = var11_8;
                        var35_31 = ContentUris.withAppendedId(var66_61, var67_62);
                        var69_63 = var2_2.mLastModified;
                        var70_64 = var4_4;
                        var71_65 = "date_modified";
                        var72_66 = var69_63;
                        var70_64.put(var71_65, var72_66);
                        var73_67 = this.mMediaProvider;
                        var74_68 = var35_31;
                        var75_69 = var4_4;
                        var76_70 = null;
                        var77_71 = null;
                        var78_72 = var73_67.update(var74_68, var75_69, var76_70, var77_71);
                        var79_73 = var35_31;
                        var80_74 = "members";
                        var40_35 = Uri.withAppendedPath(var79_73, var80_74);
                        var81_75 = this.mMediaProvider.delete(var40_35, null, null);
                        ** continue;
                    }
                    var47_42 = var46_41.fileType;
                    ** GOTO lbl60
                }
                if (var47_42 != 42) break block14;
                var82_76 = this;
                var83_77 = var3_3;
                var84_78 = var45_40;
                var85_79 = var40_35;
                var86_80 = var4_4;
                var82_76.processPlsPlayList(var83_77, var84_78, var85_79, var86_80);
                ** GOTO lbl67
            }
            if (var47_42 != 43) ** GOTO lbl67
            var87_81 = this;
            var88_82 = var3_3;
            var89_83 = var45_40;
            var90_84 = var40_35;
            var87_81.processWplPlayList(var88_82, var89_83, var90_84);
            ** continue;
            finally {
                if (var55_50 == null) continue;
                var55_50.close();
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processPlsPlayList(String var1_1, String var2_2, Uri var3_3, ContentValues var4_4) {
        block21: {
            var5_5 = null;
            var6_6 = new File(var1_1);
            if (!var6_6.exists()) break block21;
            var7_7 = new FileInputStream(var6_6);
            var8_8 = new InputStreamReader(var7_7);
            var9_9 = new BufferedReader(var8_8, 8192);
            var10_10 = var9_9.readLine();
            var11_11 = 0;
            while (var10_10 != null) {
                if (var10_10.startsWith("File") && (var12_12 = var10_10.indexOf(61)) > 0) {
                    var4_4.clear();
                    var13_13 = var12_12 + 1;
                    var14_14 = var10_10.substring(var13_13);
                    var15_15 = this;
                    var16_16 = var2_2;
                    var17_17 = var3_3;
                    var18_18 = var4_4;
                    if (var15_15.addPlayListEntry(var14_14, var16_16, var17_17, var18_18, var11_11)) {
                        var19_19 = var11_11 + 1;
                    }
                }
                var10_10 = var20_20 = var9_9.readLine();
            }
            var5_5 = var9_9;
        }
        if (var5_5 == null) {
            return;
        }
        try {
            var5_5.close();
            return;
        }
        catch (IOException var21_21) {
            var22_22 = Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", var21_21);
            return;
        }
        catch (IOException var23_23) lbl-1000:
        // 2 sources

        {
            while (true) {
                block22: {
                    try {
                        var24_26 = Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", (Throwable)var23_24);
                        if (var5_5 != null) break block22;
                        return;
                    }
                    catch (Throwable var27_29) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var5_5 != null) {
                                var5_5.close();
                            }
lbl45:
                            // 4 sources

                            throw var27_30;
                            catch (IOException var28_32) {
                                var29_33 = Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", var28_32);
                                ** continue;
                            }
                            break;
                        }
                    }
                }
                try {
                    var5_5.close();
                    return;
                }
                catch (IOException var25_27) {
                    var26_28 = Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", var25_27);
                    return;
                }
                break;
            }
        }
        catch (Throwable var27_31) {
            var5_5 = var9_9;
            ** continue;
        }
        catch (IOException var23_25) {
            var5_5 = var9_9;
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processWplPlayList(String var1_1, String var2_2, Uri var3_3) {
        block24: {
            var4_4 = null;
            var5_5 = new File(var1_1);
            if (!var5_5.exists()) break block24;
            var6_6 = new FileInputStream(var5_5);
            var7_7 = Xml.findEncodingByName("UTF-8");
            var8_8 = new WplHandler(var2_2, var3_3).getContentHandler();
            Xml.parse(var6_6, var7_7, var8_8);
            var4_4 = var6_6;
        }
        if (var4_4 == null) {
            return;
        }
        try {
            var4_4.close();
            return;
        }
        catch (IOException var9_9) {
            var10_10 = Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var9_9);
            return;
        }
        catch (SAXException var11_11) lbl-1000:
        // 2 sources

        {
            while (true) {
                block25: {
                    var11_12.printStackTrace();
                    if (var4_4 != null) break block25;
                    return;
                }
                try {
                    var4_4.close();
                    return;
                }
                catch (IOException var12_17) {
                    var13_18 = Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var12_17);
                    return;
                }
                break;
            }
        }
        catch (IOException var11_13) lbl-1000:
        // 2 sources

        {
            while (true) {
                block26: {
                    var11_14.printStackTrace();
                    if (var4_4 != null) break block26;
                    return;
                    {
                        catch (Throwable var16_21) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                if (var4_4 != null) {
                                    var4_4.close();
                                }
lbl44:
                                // 4 sources

                                throw var16_22;
                                catch (IOException var17_24) {
                                    var18_25 = Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var17_24);
                                    ** continue;
                                }
                                break;
                            }
                        }
                    }
                }
                try {
                    var4_4.close();
                    return;
                }
                catch (IOException var14_19) {
                    var15_20 = Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var14_19);
                    return;
                }
                break;
            }
        }
        catch (Throwable var16_23) {
            var4_4 = var6_6;
            ** continue;
        }
        catch (IOException var11_15) {
            var4_4 = var6_6;
            ** continue;
        }
        catch (SAXException var11_16) {
            var4_4 = var6_6;
            ** continue;
        }
    }

    private void pruneDeadThumbnailFiles() {
        Cursor cursor;
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = new File("/sdcard/DCIM/.thumbnails").list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < (n = stringArray.length); ++i) {
            StringBuilder stringBuilder = new StringBuilder().append("/sdcard/DCIM/.thumbnails").append("/");
            String string2 = stringArray[i];
            String string3 = stringBuilder.append(string2).toString();
            boolean bl = hashSet.add(string3);
        }
        try {
            IContentProvider iContentProvider = this.mMediaProvider;
            Uri uri = this.mThumbsUri;
            String[] stringArray2 = new String[]{"_data"};
            cursor = iContentProvider.query(uri, stringArray2, null, null, null);
            String string4 = "pruneDeadThumbnailFiles... " + cursor;
            int n2 = Log.v(TAG, string4);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    String string5 = cursor.getString(0);
                    boolean bl = hashSet.remove(string5);
                } while (cursor.moveToNext());
            }
            for (String string6 : hashSet) {
                try {
                    boolean bl = new File(string6).delete();
                }
                catch (SecurityException securityException) {}
            }
        }
        catch (RemoteException remoteException) {
            return;
        }
        String string7 = "/pruneDeadThumbnailFiles... " + cursor;
        int n3 = Log.v(TAG, string7);
        if (cursor == null) {
            return;
        }
        cursor.close();
    }

    private void setDefaultRingtoneFileNames() {
        String string2;
        String string3;
        String string4;
        this.mDefaultRingtoneFilename = string4 = SystemProperties.get("ro.config.ringtone");
        this.mDefaultNotificationFilename = string3 = SystemProperties.get("ro.config.notification_sound");
        this.mDefaultAlarmAlertFilename = string2 = SystemProperties.get("ro.config.alarm_alert");
    }

    public native byte[] extractAlbumArt(FileDescriptor var1);

    protected void finalize() {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        IContentProvider iContentProvider = this.mMediaProvider;
        boolean bl = contentResolver.releaseProvider(iContentProvider);
        this.native_finalize();
    }

    public void scanDirectories(String[] stringArray, String string2) {
        try {
            int n;
            long l = System.currentTimeMillis();
            MediaScanner mediaScanner = this;
            String string3 = string2;
            mediaScanner.initialize(string3);
            MediaScanner mediaScanner2 = this;
            String string4 = null;
            mediaScanner2.prescan(string4);
            long l2 = System.currentTimeMillis();
            for (int i = 0; i < (n = stringArray.length); ++i) {
                String string5 = stringArray[i];
                String string6 = MediaFile.sFileExtensions;
                MyMediaScannerClient myMediaScannerClient = this.mClient;
                MediaScanner mediaScanner3 = this;
                String string7 = string5;
                String string8 = string6;
                MyMediaScannerClient myMediaScannerClient2 = myMediaScannerClient;
                mediaScanner3.processDirectory(string7, string8, myMediaScannerClient2);
            }
            long l3 = System.currentTimeMillis();
            this.postscan(stringArray);
            long l4 = System.currentTimeMillis();
            StringBuilder stringBuilder = new StringBuilder().append(" prescan time: ");
            long l5 = l2 - l;
            String string9 = stringBuilder.append(l5).append("ms\n").toString();
            int n2 = Log.d(TAG, string9);
            StringBuilder stringBuilder2 = new StringBuilder().append("    scan time: ");
            long l6 = l3 - l2;
            String string10 = stringBuilder2.append(l6).append("ms\n").toString();
            int n3 = Log.d(TAG, string10);
            StringBuilder stringBuilder3 = new StringBuilder().append("postscan time: ");
            long l7 = l4 - l3;
            String string11 = stringBuilder3.append(l7).append("ms\n").toString();
            int n4 = Log.d(TAG, string11);
            StringBuilder stringBuilder4 = new StringBuilder().append("   total time: ");
            long l8 = l4 - l;
            String string12 = stringBuilder4.append(l8).append("ms\n").toString();
            int n5 = Log.d(TAG, string12);
            return;
        }
        catch (SQLException sQLException) {
            int n = Log.e(TAG, "SQLException in MediaScanner.scan()", sQLException);
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            int n = Log.e(TAG, "UnsupportedOperationException in MediaScanner.scan()", unsupportedOperationException);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in MediaScanner.scan()", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Uri scanSingleFile(String string2, String string3, String string4) {
        try {
            this.initialize(string3);
            this.prescan(string2);
            File file = new File(string2);
            MyMediaScannerClient myMediaScannerClient = this.mClient;
            long l = file.lastModified();
            long l2 = file.length();
            String string5 = string2;
            String string6 = string4;
            Uri uri = myMediaScannerClient.doScanFile(string5, string6, l, l2, true);
            return uri;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "RemoteException in MediaScanner.scanFile()", remoteException);
            return null;
        }
    }

    public native void setLocale(String var1);

    class WplHandler
    implements ElementListener {
        final ContentHandler handler;
        int index;
        String playListDirectory;
        Uri uri;
        ContentValues values;

        public WplHandler(String string2, Uri uri) {
            ContentHandler contentHandler;
            ContentValues contentValues;
            this.values = contentValues = new ContentValues();
            this.index = 0;
            this.playListDirectory = string2;
            this.uri = uri;
            RootElement rootElement = new RootElement("smil");
            rootElement.getChild("body").getChild("seq").getChild("media").setElementListener(this);
            this.handler = contentHandler = rootElement.getContentHandler();
        }

        @Override
        public void end() {
        }

        ContentHandler getContentHandler() {
            return this.handler;
        }

        @Override
        public void start(Attributes attributes) {
            int n;
            String string2 = attributes.getValue("", "src");
            if (string2 == null) {
                return;
            }
            this.values.clear();
            MediaScanner mediaScanner = MediaScanner.this;
            String string3 = this.playListDirectory;
            Uri uri = this.uri;
            ContentValues contentValues = this.values;
            int n2 = this.index;
            if (!mediaScanner.addPlayListEntry(string2, string3, uri, contentValues, n2)) {
                return;
            }
            this.index = n = this.index + 1;
        }
    }

    private class MyMediaScannerClient
    implements MediaScannerClient {
        private String mAlbum;
        private String mAlbumArtist;
        private String mArtist;
        private int mCompilation;
        private String mComposer;
        private int mDuration;
        private long mFileSize;
        private int mFileType;
        private String mGenre;
        private long mLastModified;
        private String mMimeType;
        private String mPath;
        private String mTitle;
        private int mTrack;
        private String mWriter;
        private int mYear;

        private MyMediaScannerClient() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean doesPathHaveFilename(String string2, String string3) {
            int n;
            char c = File.separatorChar;
            int n2 = string2.lastIndexOf(c) + 1;
            if (!string2.regionMatches(n2, string3, 0, n = string3.length())) return false;
            int n3 = n2 + n;
            int n4 = string2.length();
            if (n3 == n4) return false;
            return true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Uri endFile(FileCacheEntry var1_1, boolean var2_2, boolean var3_3, boolean var4_4, boolean var5_5, boolean var6_6) throws RemoteException {
            block39: {
                block37: {
                    block36: {
                        block35: {
                            block41: {
                                block40: {
                                    var7_7 = MediaFile.isAudioFileType(this.mFileType);
                                    var8_8 = MediaFile.isVideoFileType(this.mFileType);
                                    var9_9 = MediaFile.isImageFileType(this.mFileType);
                                    if (!var8_8) break block40;
                                    var10_10 = MediaScanner.access$700(MediaScanner.this);
lbl6:
                                    // 3 sources

                                    while (true) {
                                        var1_1.mTableUri = var11_11 = var10_10;
                                        if (this.mArtist == null || this.mArtist.length() == 0) {
                                            this.mArtist = var12_12 = this.mAlbumArtist;
                                        }
                                        if ((var16_16 = (var14_14 = (var13_13 = this.toValues())).getAsString(var15_15 = "title")) == null || TextUtils.isEmpty(var16_16.trim())) {
                                            var17_17 = var13_13;
                                            var18_18 = "_data";
                                            var16_16 = var17_17.getAsString(var18_18);
                                            var19_19 = var16_16;
                                            var21_21 = var19_19.lastIndexOf(var20_20 = 47);
                                            if (var21_21 >= 0 && (var23_23 = ++var21_21) < (var24_24 = (var22_22 = var16_16.length()))) {
                                                var25_25 = var16_16;
                                                var26_26 = var21_21;
                                                var27_27 = var25_25.substring(var26_26);
                                            }
                                            if ((var30_30 = (var28_28 = var16_16).lastIndexOf(var29_29 = 46)) > 0) {
                                                var31_31 = var16_16;
                                                var32_32 = 0;
                                                var33_33 = var30_30;
                                                var34_34 = var31_31.substring(var32_32, var33_33);
                                            }
                                            var35_35 = var13_13;
                                            var36_36 = "title";
                                            var37_37 = var16_16;
                                            var35_35.put(var36_36, var37_37);
                                        }
                                        if (!"<unknown>".equals(var40_40 = (var38_38 = var13_13).getAsString(var39_39 = "album")) || (var21_21 = (var43_43 = (var41_41 = var13_13).getAsString(var42_42 = "_data")).lastIndexOf(47)) < 0) ** GOTO lbl45
                                        var44_44 = 0;
lbl31:
                                        // 2 sources

                                        while (true) {
                                            var45_45 = var44_44 + 1;
                                            var46_46 = var43_43.indexOf(47, var45_45);
                                            if (var46_46 >= 0 && (var47_47 = var46_46) < (var48_48 = var21_21)) break block35;
                                            if (var44_44 != 0) {
                                                var49_49 = var44_44 + 1;
                                                var50_50 = var43_43;
                                                var51_51 = var49_49;
                                                var52_52 = var21_21;
                                                var53_53 = var50_50.substring(var51_51, var52_52);
                                                var54_54 = var13_13;
                                                var55_55 = "album";
                                                var56_56 = var53_53;
                                                var54_54.put(var55_55, var56_56);
                                            }
lbl45:
                                            // 4 sources

                                            var57_57 = var1_1.mRowId;
                                            if (!var7_7 || var57_57 != 0L) break block36;
                                            var59_58 = var2_2;
                                            var60_59 = var13_13;
                                            var61_60 = "is_ringtone";
                                            var62_61 = var59_58;
                                            var60_59.put(var61_60, var62_61);
                                            var63_62 = var3_3;
                                            var64_63 = var13_13;
                                            var65_64 = "is_notification";
                                            var66_65 = var63_62;
                                            var64_63.put(var65_64, var66_65);
                                            var67_66 = var4_4;
                                            var68_67 = var13_13;
                                            var69_68 = "is_alarm";
                                            var70_69 = var67_66;
                                            var68_67.put(var69_68, var70_69);
                                            var71_70 = var5_5;
                                            var72_71 = var13_13;
                                            var73_72 = "is_music";
                                            var74_73 = var71_70;
                                            var72_71.put(var73_72, var74_73);
                                            var75_74 = var6_6;
                                            var76_75 = var13_13;
                                            var77_76 = "is_podcast";
                                            var78_77 = var75_74;
                                            var76_75.put(var77_76, var78_77);
lbl72:
                                            // 5 sources

                                            while (var57_57 == 0L) {
                                                var79_78 = MediaScanner.access$1000(MediaScanner.this);
                                                var82_81 = var79_78.insert(var80_79 = var10_10, var81_80 = var13_13);
                                                if (var82_81 != null) {
                                                    var1_1.mRowId = var83_82 = (var57_57 = ContentUris.parseId(var82_81));
                                                }
lbl77:
                                                // 4 sources

                                                while (MediaScanner.access$1100(MediaScanner.this) && this.mGenre != null) {
                                                    var85_83 = this.mGenre;
                                                    var86_84 = MediaScanner.access$1200(MediaScanner.this);
                                                    var88_86 = (Uri)var86_84.get(var87_85 = var85_83);
                                                    if (var88_86 != null) ** GOTO lbl192
                                                    var89_87 = MediaScanner.access$1000(MediaScanner.this);
                                                    var90_88 = MediaScanner.access$1300(MediaScanner.this);
                                                    var91_89 = MediaScanner.access$1400();
                                                    var92_90 = new String[]{var85_83};
                                                    var93_91 = var89_87.query(var90_88, var91_89, "name=?", var92_90, null);
                                                    if (var93_91 == null || var93_91.getCount() == 0) {
                                                        var13_13.clear();
                                                        var94_92 = var13_13;
                                                        var95_93 = "name";
                                                        var96_94 = var85_83;
                                                        var94_92.put(var95_93, var96_94);
                                                        var97_95 = MediaScanner.access$1000(MediaScanner.this);
                                                        var98_96 = MediaScanner.access$1300(MediaScanner.this);
                                                        var99_97 = var97_95;
                                                        var100_98 = var98_96;
                                                        var101_99 = var13_13;
                                                        var88_86 = var99_97.insert(var100_98, var101_99);
                                                    }
                                                    ** GOTO lbl-1000
                                                }
                                                ** GOTO lbl203
                                            }
                                            break block37;
                                            break;
                                        }
                                        break;
                                    }
                                }
                                if (!var9_9) break block41;
                                var10_10 = MediaScanner.access$800(MediaScanner.this);
                                ** GOTO lbl6
                            }
                            if (!var7_7) {
                                return null;
                            }
                            var10_10 = MediaScanner.access$900(MediaScanner.this);
                            ** while (true)
                        }
                        var44_44 = var46_46;
                        ** while (true)
                    }
                    if (this.mFileType != 31) ** GOTO lbl72
                    var128_125 = null;
                    try {
                        var129_126 = var1_1.mPath;
                        var128_125 = var130_127 = new ExifInterface(var129_126);
lbl122:
                        // 2 sources

                        while (var128_125 != null) {
                            var132_129 = var128_125;
                            var131_128 = new float[2];
                            var133_130 = var131_128;
                            if (!var132_129.getLatLong(var133_130)) break block38;
                        }
                        ** GOTO lbl72
                    }
                    catch (IOException var193_185) {
                        ** GOTO lbl122
                    }
                    {
                        block38: {
                            var134_131 = Float.valueOf(var131_128[0]);
                            var135_132 = var13_13;
                            var136_133 = "latitude";
                            var137_134 = var134_131;
                            var135_132.put(var136_133, var137_134);
                            var138_135 = Float.valueOf(var131_128[1]);
                            var139_136 = var13_13;
                            var140_137 = "longitude";
                            var141_138 = var138_135;
                            var139_136.put(var140_137, var141_138);
                        }
                        if ((var142_139 = var128_125.getGpsDateTime()) != 65535L) {
                            var144_140 = var142_139;
                            var145_141 = var13_13;
                            var146_142 = "datetaken";
                            var147_144 = var144_140;
                            var145_141.put(var146_142, var147_144);
                        }
                        if ((var149_146 = (var148_145 = var128_125.getAttributeInt("Orientation", -1))) == (var146_143 = -1)) ** GOTO lbl72
                        switch (var148_145) {
                            default: {
                                var151_147 = 0;
lbl149:
                                // 4 sources

                                while (true) {
                                    var152_148 = var151_147;
                                    var153_149 = var13_13;
                                    var154_150 = "orientation";
                                    var155_151 = var152_148;
                                    var153_149.put(var154_150, var155_151);
                                    ** GOTO lbl72
                                    break;
                                }
                            }
                            case 6: {
                                var151_147 = 90;
                                ** GOTO lbl149
                            }
                            case 3: {
                                var151_147 = 180;
                                ** GOTO lbl149
                            }
                            case 8: 
                        }
                        var151_147 = 270;
                        ** continue;
                        break;
                    }
                }
                var156_152 = var10_10;
                var157_153 = var57_57;
                var82_81 = ContentUris.withAppendedId(var156_152, var157_153);
                var159_154 = MediaScanner.access$1000(MediaScanner.this);
                var160_155 = var82_81;
                var161_156 = var13_13;
                var162_157 = null;
                var163_158 = null;
                var164_159 = var159_154.update(var160_155, var161_156, var162_157, var163_158);
                ** GOTO lbl77
                catch (Throwable var170_164) {
                    if (var93_91 == null) throw var170_164;
                    var93_91.close();
                    throw var170_164;
                }
lbl181:
                // 2 sources

                while (true) {
                    if (var88_86 != null) {
                        var102_100 = var88_86;
                        var103_101 = "members";
                        var88_86 = Uri.withAppendedPath(var102_100, var103_101);
                        var104_102 = MediaScanner.access$1200(MediaScanner.this);
                        var105_103 = var85_83;
                        var106_104 = var88_86;
                        var107_105 = var104_102.put(var105_103, var106_104);
                    }
                    if (var93_91 != null) {
                        var93_91.close();
                    }
lbl192:
                    // 4 sources

                    if (var88_86 != null) {
                        var13_13.clear();
                        var108_106 = var57_57;
                        var109_107 = var13_13;
                        var110_108 = "audio_id";
                        var111_109 = var108_106;
                        var109_107.put(var110_108, var111_109);
                        var112_110 = MediaScanner.access$1000(MediaScanner.this);
                        var113_111 = var88_86;
                        var114_112 = var13_13;
                        var115_113 = var112_110.insert(var113_111, var114_112);
                    }
lbl203:
                    // 4 sources

                    if (var3_3 && !MediaScanner.access$1500(MediaScanner.this)) {
                        if (!TextUtils.isEmpty(MediaScanner.access$1600(MediaScanner.this))) {
                            var118_116 = this;
                            var116_114 = var1_1.mPath;
                            var119_117 = var116_114;
                            var117_115 = MediaScanner.access$1600(MediaScanner.this);
                            var120_118 = var117_115;
                            if (var118_116.doesPathHaveFilename(var119_117, var120_118) == false) return var82_81;
                        }
                        var121_119 = this;
                        var122_120 = "notification_sound";
                        var123_121 = var10_10;
                        var124_122 = var57_57;
                        var121_119.setSettingIfNotSet(var122_120, var123_121, var124_122);
                        var126_123 = MediaScanner.access$1502(MediaScanner.this, true);
                        return var82_81;
                    }
                    break block39;
                    break;
                }
lbl-1000:
                // 1 sources

                {
                    var165_160 = var93_91.moveToNext();
                    var166_161 = MediaScanner.access$1300(MediaScanner.this);
                    var167_162 = var93_91.getLong(0);
                    var88_86 = var169_163 = ContentUris.withAppendedId(var166_161, var167_162);
                    ** continue;
                }
            }
            if (var2_2 && !MediaScanner.access$1700(MediaScanner.this)) {
                if (!TextUtils.isEmpty(MediaScanner.access$1800(MediaScanner.this))) {
                    var173_167 = this;
                    var171_165 = var1_1.mPath;
                    var174_168 = var171_165;
                    var172_166 = MediaScanner.access$1800(MediaScanner.this);
                    var175_169 = var172_166;
                    if (var173_167.doesPathHaveFilename(var174_168, var175_169) == false) return var82_81;
                }
                var176_170 = this;
                var177_171 = "ringtone";
                var178_172 = var10_10;
                var179_173 = var57_57;
                var176_170.setSettingIfNotSet(var177_171, var178_172, var179_173);
                var181_174 = MediaScanner.access$1702(MediaScanner.this, true);
                return var82_81;
            }
            if (var4_4 == false) return var82_81;
            if (MediaScanner.access$1900(MediaScanner.this) != false) return var82_81;
            if (!TextUtils.isEmpty(MediaScanner.access$2000(MediaScanner.this))) {
                var184_177 = this;
                var182_175 = var1_1.mPath;
                var185_178 = var182_175;
                var183_176 = MediaScanner.access$2000(MediaScanner.this);
                var186_179 = var183_176;
                if (var184_177.doesPathHaveFilename(var185_178, var186_179) == false) return var82_81;
            }
            var187_180 = this;
            var188_181 = "alarm_alert";
            var189_182 = var10_10;
            var190_183 = var57_57;
            var187_180.setSettingIfNotSet(var188_181, var189_182, var190_183);
            var192_184 = MediaScanner.access$1902(MediaScanner.this, true);
            return var82_81;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int parseSubstring(String string2, int n, int n2) {
            int n3 = string2.length();
            if (n != n3) {
                return n2;
            }
            int n4 = n + 1;
            char c = string2.charAt(n);
            if (c < '0' || c > '9') {
                int n5 = n4;
                return n2;
            }
            int n6 = c - 48;
            while (n4 < n3) {
                n = n4 + 1;
                c = string2.charAt(n4);
                if (c < '0') return n6;
                if (c > '9') {
                    return n6;
                }
                int n7 = n6 * 10;
                int n8 = c - 48;
                n6 = n7 + n8;
                n4 = n;
            }
            int n9 = n4;
            return n6;
        }

        private void setSettingIfNotSet(String string2, Uri uri, long l) {
            if (!TextUtils.isEmpty(Settings.System.getString(MediaScanner.this.mContext.getContentResolver(), string2))) {
                return;
            }
            ContentResolver contentResolver = MediaScanner.this.mContext.getContentResolver();
            String string3 = ContentUris.withAppendedId(uri, l).toString();
            boolean bl = Settings.System.putString(contentResolver, string2, string3);
        }

        /*
         * Enabled aggressive block sorting
         */
        private ContentValues toValues() {
            ContentValues contentValues = new ContentValues();
            String string2 = this.mPath;
            contentValues.put("_data", string2);
            String string3 = this.mTitle;
            contentValues.put("title", string3);
            Long l = this.mLastModified;
            contentValues.put("date_modified", l);
            Long l2 = this.mFileSize;
            contentValues.put("_size", l2);
            String string4 = this.mMimeType;
            contentValues.put("mime_type", string4);
            if (MediaFile.isVideoFileType(this.mFileType)) {
                String string5 = this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>";
                contentValues.put("artist", string5);
                String string6 = this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>";
                contentValues.put("album", string6);
                Integer n = this.mDuration;
                contentValues.put("duration", n);
                return contentValues;
            }
            if (MediaFile.isImageFileType(this.mFileType)) return contentValues;
            if (!MediaFile.isAudioFileType(this.mFileType)) return contentValues;
            String string7 = this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>";
            contentValues.put("artist", string7);
            String string8 = "album_artist";
            String string9 = this.mAlbumArtist != null && this.mAlbumArtist.length() > 0 ? this.mAlbumArtist : null;
            contentValues.put(string8, string9);
            String string10 = this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>";
            contentValues.put("album", string10);
            String string11 = this.mComposer;
            contentValues.put("composer", string11);
            if (this.mYear != 0) {
                Integer n = this.mYear;
                contentValues.put("year", n);
            }
            Integer n = this.mTrack;
            contentValues.put("track", n);
            Integer n2 = this.mDuration;
            contentValues.put("duration", n2);
            Integer n3 = this.mCompilation;
            contentValues.put("compilation", n3);
            return contentValues;
        }

        @Override
        public void addNoMediaFolder(String string2) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("_data", "");
            String string3 = string2 + '%';
            String[] stringArray = new String[]{string3};
            try {
                IContentProvider iContentProvider = MediaScanner.this.mMediaProvider;
                Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                int n = iContentProvider.update(uri, contentValues, "_data LIKE ?", stringArray);
                IContentProvider iContentProvider2 = MediaScanner.this.mMediaProvider;
                Uri uri2 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                int n2 = iContentProvider2.update(uri2, contentValues, "_data LIKE ?", stringArray);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public FileCacheEntry beginFile(String string2, String string3, long l, long l2) {
            int n;
            long l3;
            String string4;
            int n2;
            int n3;
            int n4;
            FileCacheEntry fileCacheEntry;
            MediaFile.MediaFileType mediaFileType;
            long l4;
            int n5;
            int n6;
            String string5 = string2;
            int n7 = 47;
            int n8 = string5.lastIndexOf(n7);
            if (n8 >= 0 && (n6 = n8 + 2) < (n5 = string2.length())) {
                String string6 = string2;
                int n9 = n8 + 1;
                int n10 = n9;
                String string7 = "._";
                int n11 = 0;
                int n12 = 2;
                if (string6.regionMatches(n10, string7, n11, n12)) {
                    return null;
                }
                int n13 = string2.length() - 4;
                if (string2.regionMatches(true, n13, ".jpg", 0, 4)) {
                    int n14;
                    int n15;
                    int n16;
                    int n17 = n8 + 1;
                    if (string2.regionMatches(true, n17, "AlbumArt_{", 0, 10)) return null;
                    int n18 = n8 + 1;
                    if (string2.regionMatches(true, n18, "AlbumArt.", 0, 9)) {
                        return null;
                    }
                    int n19 = string2.length() - n8 - 1;
                    int n20 = n19;
                    if (n20 == (n19 = 17)) {
                        n16 = n8 + 1;
                        if (string2.regionMatches(true, n16, "AlbumArtSmall", 0, 13)) return null;
                    }
                    if ((n15 = n19) == (n16 = 10) && string2.regionMatches(true, n14 = n8 + 1, "Folder", 0, 6)) {
                        return null;
                    }
                }
            }
            Object var29_25 = null;
            this.mMimeType = var29_25;
            if (string3 != null) {
                int n21;
                this.mFileType = n21 = MediaFile.getFileTypeForMimeType(string3);
                if (this.mFileType != 0) {
                    String string8;
                    this.mMimeType = string8 = string3;
                }
            }
            this.mFileSize = l4 = l2;
            if (this.mMimeType == null && (mediaFileType = MediaFile.getFileType(string2)) != null) {
                String string9;
                int n22;
                this.mFileType = n22 = mediaFileType.fileType;
                this.mMimeType = string9 = mediaFileType.mimeType;
            }
            String string10 = string2;
            if (MediaScanner.this.mCaseInsensitivePaths) {
                string10 = string2.toLowerCase();
            }
            if ((fileCacheEntry = (FileCacheEntry)MediaScanner.this.mFileCache.get(string10)) == null) {
                String string11 = string2;
                FileCacheEntry fileCacheEntry2 = new FileCacheEntry(null, 0L, string11, 0L);
                FileCacheEntry fileCacheEntry3 = MediaScanner.this.mFileCache.put(string10, fileCacheEntry2);
            }
            fileCacheEntry.mSeenInFileSystem = true;
            long l5 = fileCacheEntry.mLastModified;
            long l6 = l - l5;
            if (l6 > 1L || l6 < 65535L) {
                long l7;
                fileCacheEntry.mLastModified = l7 = l;
                fileCacheEntry.mLastModifiedChanged = true;
            }
            if (MediaScanner.this.mProcessPlaylists && MediaFile.isPlayListFileType(this.mFileType)) {
                boolean bl = MediaScanner.this.mPlayLists.add(fileCacheEntry);
                return null;
            }
            Object var49_41 = null;
            this.mArtist = var49_41;
            Object var50_42 = null;
            this.mAlbumArtist = var50_42;
            Object var51_43 = null;
            this.mAlbum = var51_43;
            Object var52_44 = null;
            this.mTitle = var52_44;
            Object var53_45 = null;
            this.mComposer = var53_45;
            Object var54_46 = null;
            this.mGenre = var54_46;
            this.mTrack = n4 = 0;
            this.mYear = n3 = 0;
            this.mDuration = n2 = 0;
            this.mPath = string4 = string2;
            this.mLastModified = l3 = l;
            Object var61_52 = null;
            this.mWriter = var61_52;
            this.mCompilation = n = 0;
            return fileCacheEntry;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Uri doScanFile(String string2, String string3, long l, long l2, boolean bl) {
            Uri uri = null;
            try {
                Uri uri2;
                String string4;
                FileCacheEntry fileCacheEntry = this.beginFile(string2, string3, l, l2);
                if (fileCacheEntry == null) return uri;
                if (!fileCacheEntry.mLastModifiedChanged) {
                    if (!bl) return uri;
                }
                boolean bl2 = (string4 = string2.toLowerCase()).indexOf(MediaScanner.RINGTONES_DIR) > 0;
                boolean bl3 = string4.indexOf(MediaScanner.NOTIFICATIONS_DIR) > 0;
                boolean bl4 = string4.indexOf(MediaScanner.ALARMS_DIR) > 0;
                boolean bl5 = string4.indexOf(MediaScanner.PODCAST_DIR) > 0;
                boolean bl6 = string4.indexOf(MediaScanner.MUSIC_DIR) > 0 || !bl2 && !bl3 && !bl4 && !bl5;
                if (MediaFile.isImageFileType(this.mFileType)) return uri2;
                MediaScanner.this.processFile(string2, string3, this);
                uri2 = this.endFile(fileCacheEntry, bl2, bl3, bl4, bl6, bl5);
                return uri2;
            }
            catch (RemoteException remoteException) {
                int n = Log.e(MediaScanner.TAG, "RemoteException in MediaScanner.scanFile()", remoteException);
                return uri;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleStringTag(String string2, String string3) {
            int n;
            if (string2.equalsIgnoreCase("title") || string2.startsWith("title;")) {
                this.mTitle = string3;
                return;
            }
            if (string2.equalsIgnoreCase("artist") || string2.startsWith("artist;")) {
                String string4;
                this.mArtist = string4 = string3.trim();
                return;
            }
            if (string2.equalsIgnoreCase("albumartist") || string2.startsWith("albumartist;")) {
                String string5;
                this.mAlbumArtist = string5 = string3.trim();
                return;
            }
            if (string2.equalsIgnoreCase("album") || string2.startsWith("album;")) {
                String string6;
                this.mAlbum = string6 = string3.trim();
                return;
            }
            if (string2.equalsIgnoreCase("composer") || string2.startsWith("composer;")) {
                String string7;
                this.mComposer = string7 = string3.trim();
                return;
            }
            if (string2.equalsIgnoreCase("genre") || string2.startsWith("genre;")) {
                if (string3.length() > 0) {
                    int n2;
                    int n3 = -1;
                    char c = string3.charAt(0);
                    if (c == '(') {
                        n3 = this.parseSubstring(string3, 1, -1);
                    } else if (c >= '0' && c <= '9') {
                        n3 = this.parseSubstring(string3, 0, -1);
                    }
                    if (n3 >= 0 && n3 < (n2 = ID3_GENRES.length)) {
                        string3 = ID3_GENRES[n3];
                    } else if (n3 == 255) {
                        string3 = null;
                    }
                }
                this.mGenre = string3;
                return;
            }
            if (string2.equalsIgnoreCase("year") || string2.startsWith("year;")) {
                int n4;
                this.mYear = n4 = this.parseSubstring(string3, 0, 0);
                return;
            }
            if (string2.equalsIgnoreCase("tracknumber") || string2.startsWith("tracknumber;")) {
                int n5;
                int n6 = this.parseSubstring(string3, 0, 0);
                this.mTrack = n5 = this.mTrack / 1000 * 1000 + n6;
                return;
            }
            if (string2.equalsIgnoreCase("discnumber") || string2.equals("set") || string2.startsWith("set;")) {
                int n7;
                int n8 = this.parseSubstring(string3, 0, 0) * 1000;
                int n9 = this.mTrack % 1000;
                this.mTrack = n7 = n8 + n9;
                return;
            }
            if (string2.equalsIgnoreCase("duration")) {
                int n10;
                this.mDuration = n10 = this.parseSubstring(string3, 0, 0);
                return;
            }
            if (string2.equalsIgnoreCase("writer") || string2.startsWith("writer;")) {
                String string8;
                this.mWriter = string8 = string3.trim();
                return;
            }
            if (!string2.equalsIgnoreCase("compilation")) {
                return;
            }
            this.mCompilation = n = this.parseSubstring(string3, 0, 0);
        }

        @Override
        public void scanFile(String string2, long l, long l2) {
            MyMediaScannerClient myMediaScannerClient = this;
            String string3 = string2;
            long l3 = l;
            long l4 = l2;
            Uri uri = myMediaScannerClient.doScanFile(string3, null, l3, l4, false);
        }

        @Override
        public void scanFile(String string2, String string3, long l, long l2) {
            MyMediaScannerClient myMediaScannerClient = this;
            String string4 = string2;
            String string5 = string3;
            long l3 = l;
            long l4 = l2;
            Uri uri = myMediaScannerClient.doScanFile(string4, string5, l3, l4, false);
        }

        @Override
        public void setMimeType(String string2) {
            int n;
            String string3 = this.mMimeType;
            if ("audio/mp4".equals(string3) && string2.startsWith("video")) {
                return;
            }
            this.mMimeType = string2;
            this.mFileType = n = MediaFile.getFileTypeForMimeType(string2);
        }
    }

    private static class FileCacheEntry {
        long mLastModified;
        boolean mLastModifiedChanged;
        String mPath;
        long mRowId;
        boolean mSeenInFileSystem;
        Uri mTableUri;

        FileCacheEntry(Uri uri, long l, String string2, long l2) {
            this.mTableUri = uri;
            this.mRowId = l;
            this.mPath = string2;
            this.mLastModified = l2;
            this.mSeenInFileSystem = false;
            this.mLastModifiedChanged = false;
        }

        public String toString() {
            return this.mPath;
        }
    }
}

