/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.IMediaScannerListener;
import android.media.IMediaScannerService;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

public class MediaScannerConnection
implements ServiceConnection {
    private static final String TAG = "MediaScannerConnection";
    private MediaScannerConnectionClient mClient;
    private boolean mConnected;
    private Context mContext;
    private IMediaScannerListener.Stub mListener;
    private IMediaScannerService mService;

    public MediaScannerConnection(Context context, MediaScannerConnectionClient mediaScannerConnectionClient) {
        IMediaScannerListener.Stub stub;
        this.mListener = stub = new IMediaScannerListener.Stub(){

            @Override
            public void scanCompleted(String string2, Uri uri) {
                MediaScannerConnectionClient mediaScannerConnectionClient = MediaScannerConnection.this.mClient;
                if (mediaScannerConnectionClient == null) {
                    return;
                }
                mediaScannerConnectionClient.onScanCompleted(string2, uri);
            }
        };
        this.mContext = context;
        this.mClient = mediaScannerConnectionClient;
    }

    public static void scanFile(Context context, String[] stringArray, String[] stringArray2, OnScanCompletedListener onScanCompletedListener) {
        MediaScannerConnection mediaScannerConnection;
        ClientProxy clientProxy = new ClientProxy(stringArray, stringArray2, onScanCompletedListener);
        clientProxy.mConnection = mediaScannerConnection = new MediaScannerConnection(context, clientProxy);
        mediaScannerConnection.connect();
    }

    public void connect() {
        synchronized (this) {
            if (!this.mConnected) {
                String string2 = IMediaScannerService.class.getName();
                Intent intent = new Intent(string2);
                boolean bl = this.mContext.bindService(intent, this, 1);
                this.mConnected = true;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() {
        synchronized (this) {
            boolean bl = this.mConnected;
            if (bl) {
                try {
                    this.mContext.unbindService(this);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                this.mConnected = bl = false;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected() {
        synchronized (this) {
            if (this.mService == null) return false;
            boolean bl = this.mConnected;
            if (!bl) return false;
            return true;
        }
    }

    @Override
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        synchronized (this) {
            IMediaScannerService iMediaScannerService;
            this.mService = iMediaScannerService = IMediaScannerService.Stub.asInterface(iBinder);
            if (this.mService != null && this.mClient != null) {
                this.mClient.onMediaScannerConnected();
            }
            return;
        }
    }

    @Override
    public void onServiceDisconnected(ComponentName componentName) {
        synchronized (this) {
            this.mService = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scanFile(String string2, String string3) {
        synchronized (this) {
            if (this.mService == null || !this.mConnected) {
                throw new IllegalStateException("not connected to MediaScannerService");
            }
            try {
                IMediaScannerService iMediaScannerService = this.mService;
                IMediaScannerListener.Stub stub = this.mListener;
                iMediaScannerService.requestScanFile(string2, string3, stub);
            }
            catch (RemoteException remoteException) {
                String string4 = "Failed to scan file " + string2;
                int n = Log.d(TAG, string4);
            }
            return;
        }
    }

    static class ClientProxy
    implements MediaScannerConnectionClient {
        final OnScanCompletedListener mClient;
        MediaScannerConnection mConnection;
        final String[] mMimeTypes;
        int mNextPath;
        final String[] mPaths;

        ClientProxy(String[] stringArray, String[] stringArray2, OnScanCompletedListener onScanCompletedListener) {
            this.mPaths = stringArray;
            this.mMimeTypes = stringArray2;
            this.mClient = onScanCompletedListener;
        }

        @Override
        public void onMediaScannerConnected() {
            this.scanNextPath();
        }

        @Override
        public void onScanCompleted(String string2, Uri uri) {
            if (this.mClient != null) {
                this.mClient.onScanCompleted(string2, uri);
            }
            this.scanNextPath();
        }

        /*
         * Enabled aggressive block sorting
         */
        void scanNextPath() {
            int n;
            String string2;
            int n2 = this.mNextPath;
            int n3 = this.mPaths.length;
            if (n2 >= n3) {
                this.mConnection.disconnect();
                return;
            }
            if (this.mMimeTypes != null) {
                String[] stringArray = this.mMimeTypes;
                int n4 = this.mNextPath;
                string2 = stringArray[n4];
            } else {
                string2 = null;
            }
            MediaScannerConnection mediaScannerConnection = this.mConnection;
            String[] stringArray = this.mPaths;
            int n5 = this.mNextPath;
            String string3 = stringArray[n5];
            mediaScannerConnection.scanFile(string3, string2);
            this.mNextPath = n = this.mNextPath + 1;
        }
    }

    public static interface MediaScannerConnectionClient
    extends OnScanCompletedListener {
        public void onMediaScannerConnected();

        @Override
        public void onScanCompleted(String var1, Uri var2);
    }

    public static interface OnScanCompletedListener {
        public void onScanCompleted(String var1, Uri var2);
    }
}

