/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Parcel;
import android.util.Log;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;

public class Metadata {
    public static final int ALBUM = 4;
    public static final int ALBUM_ART = 14;
    public static final int ANY = 0;
    public static final int ARTIST = 5;
    public static final int AUDIO_BIT_RATE = 18;
    public static final int AUDIO_CODEC = 23;
    public static final int AUDIO_SAMPLE_RATE = 20;
    public static final int AUTHOR = 6;
    public static final int BIT_RATE = 17;
    public static final int BOOLEAN_VAL = 3;
    public static final int BYTE_ARRAY_VAL = 8;
    public static final int CAPTION = 16;
    public static final int CD_TRACK_MAX = 12;
    public static final int CD_TRACK_NUM = 11;
    public static final int COMMENT = 2;
    public static final int COMPOSER = 7;
    public static final int COPYRIGHT = 3;
    public static final int DATE = 9;
    public static final int DATE_VAL = 7;
    public static final int DOUBLE_VAL = 5;
    public static final int DRM_CRIPPLED = 28;
    public static final int DURATION = 10;
    private static final int FIRST_CUSTOM = 8192;
    public static final int GENRE = 8;
    public static final int INTEGER_VAL = 2;
    private static final int LAST_SYSTEM = 32;
    private static final int LAST_TYPE = 8;
    public static final int LONG_VAL = 4;
    public static final Set<Integer> MATCH_ALL;
    public static final Set<Integer> MATCH_NONE;
    public static final int MIME_TYPE = 22;
    public static final int NUM_TRACKS = 27;
    public static final int PAUSE_AVAILABLE = 29;
    public static final int RATING = 13;
    public static final int SEEK_AVAILABLE = 32;
    public static final int SEEK_BACKWARD_AVAILABLE = 30;
    public static final int SEEK_FORWARD_AVAILABLE = 31;
    public static final int STRING_VAL = 1;
    private static final String TAG = "media.Metadata";
    public static final int TIMED_TEXT_VAL = 6;
    public static final int TITLE = 1;
    public static final int VIDEO_BIT_RATE = 19;
    public static final int VIDEO_CODEC = 24;
    public static final int VIDEO_FRAME = 15;
    public static final int VIDEO_FRAME_RATE = 21;
    public static final int VIDEO_HEIGHT = 25;
    public static final int VIDEO_WIDTH = 26;
    private static final int kInt32Size = 4;
    private static final int kMetaHeaderSize = 8;
    private static final int kMetaMarker = 1296389185;
    private static final int kRecordHeaderSize = 12;
    private final HashMap<Integer, Integer> mKeyToPosMap;
    private Parcel mParcel;

    static {
        MATCH_NONE = Collections.EMPTY_SET;
        MATCH_ALL = Collections.singleton(0);
    }

    public Metadata() {
        HashMap hashMap = new HashMap();
        this.mKeyToPosMap = hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkMetadataId(int n) {
        if (n > 0) {
            if (32 >= n) return true;
            if (n >= 8192) return true;
        }
        String string2 = "Invalid metadata ID " + n;
        int n2 = Log.e(TAG, string2);
        return false;
    }

    private void checkType(int n, int n2) {
        HashMap<Integer, Integer> hashMap = this.mKeyToPosMap;
        Integer n3 = n;
        int n4 = hashMap.get(n3);
        this.mParcel.setDataPosition(n4);
        int n5 = this.mParcel.readInt();
        if (n5 != n2) {
            return;
        }
        String string2 = "Wrong type " + n2 + " but got " + n5;
        throw new IllegalStateException(string2);
    }

    public static int firstCustomId() {
        return 8192;
    }

    public static int lastSytemId() {
        return 32;
    }

    public static int lastType() {
        return 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean scanAllRecords(Parcel parcel, int n) {
        int n2 = 0;
        boolean bl = false;
        this.mKeyToPosMap.clear();
        while (true) {
            int n3;
            int n4;
            block9: {
                block5: {
                    int n5;
                    block8: {
                        block7: {
                            block6: {
                                if (n <= 12) break block5;
                                n4 = parcel.dataPosition();
                                n3 = parcel.readInt();
                                if (n3 > 12) break block6;
                                int n6 = Log.e(TAG, "Record is too short");
                                bl = true;
                                break block5;
                            }
                            n5 = parcel.readInt();
                            if (this.checkMetadataId(n5)) break block7;
                            bl = true;
                            break block5;
                        }
                        HashMap<Integer, Integer> hashMap = this.mKeyToPosMap;
                        Integer n7 = n5;
                        if (!hashMap.containsKey(n7)) break block8;
                        int n8 = Log.e(TAG, "Duplicate metadata ID found");
                        bl = true;
                        break block5;
                    }
                    HashMap<Integer, Integer> hashMap = this.mKeyToPosMap;
                    Integer n9 = n5;
                    Integer n10 = parcel.dataPosition();
                    Integer n11 = hashMap.put(n9, n10);
                    int n12 = parcel.readInt();
                    if (n12 > 0 && n12 <= 8) break block9;
                    String string2 = "Invalid metadata type " + n12;
                    int n13 = Log.e(TAG, string2);
                    bl = true;
                }
                if (n == 0 && !bl) {
                    return true;
                }
                String string3 = "Ran out of data or error on record " + n2;
                int n14 = Log.e(TAG, string3);
                this.mKeyToPosMap.clear();
                return false;
            }
            int n15 = n4 + n3;
            parcel.setDataPosition(n15);
            n -= n3;
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(int n) {
        this.checkType(n, 3);
        if (this.mParcel.readInt() != 1) return false;
        return true;
    }

    public byte[] getByteArray(int n) {
        this.checkType(n, 8);
        return this.mParcel.createByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date getDate(int n) {
        this.checkType(n, 7);
        long l = this.mParcel.readLong();
        String string2 = this.mParcel.readString();
        if (string2.length() == 0) {
            return new Date(l);
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(string2));
        calendar.setTimeInMillis(l);
        return calendar.getTime();
    }

    public double getDouble(int n) {
        this.checkType(n, 5);
        return this.mParcel.readDouble();
    }

    public int getInt(int n) {
        this.checkType(n, 2);
        return this.mParcel.readInt();
    }

    public long getLong(int n) {
        this.checkType(n, 4);
        return this.mParcel.readLong();
    }

    public String getString(int n) {
        this.checkType(n, 1);
        return this.mParcel.readString();
    }

    public TimedText getTimedText(int n) {
        this.checkType(n, 6);
        long l = this.mParcel.readLong();
        Date date = new Date(l);
        int n2 = this.mParcel.readInt();
        String string2 = this.mParcel.readString();
        return new TimedText(date, n2, string2);
    }

    public boolean has(int n) {
        if (!this.checkMetadataId(n)) {
            String string2 = "Invalid key: " + n;
            throw new IllegalArgumentException(string2);
        }
        HashMap<Integer, Integer> hashMap = this.mKeyToPosMap;
        Integer n2 = n;
        return hashMap.containsKey(n2);
    }

    public Set<Integer> keySet() {
        return this.mKeyToPosMap.keySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parse(Parcel parcel) {
        if (parcel.dataAvail() < 8) {
            StringBuilder stringBuilder = new StringBuilder().append("Not enough data ");
            int n = parcel.dataAvail();
            String string2 = stringBuilder.append(n).toString();
            int n2 = Log.e(TAG, string2);
            return false;
        }
        int n = parcel.dataPosition();
        int n3 = parcel.readInt();
        if (parcel.dataAvail() + 4 < n3 || n3 < 8) {
            StringBuilder stringBuilder = new StringBuilder().append("Bad size ").append(n3).append(" avail ");
            int n4 = parcel.dataAvail();
            String string3 = stringBuilder.append(n4).append(" position ").append(n).toString();
            int n5 = Log.e(TAG, string3);
            parcel.setDataPosition(n);
            return false;
        }
        int n6 = parcel.readInt();
        if (n6 != 1296389185) {
            StringBuilder stringBuilder = new StringBuilder().append("Marker missing ");
            String string4 = Integer.toHexString(n6);
            String string5 = stringBuilder.append(string4).toString();
            int n7 = Log.e(TAG, string5);
            parcel.setDataPosition(n);
            return false;
        }
        int n8 = n3 - 8;
        if (!this.scanAllRecords(parcel, n8)) {
            parcel.setDataPosition(n);
            return false;
        }
        this.mParcel = parcel;
        return true;
    }

    public class TimedText {
        private int mDuration;
        private String mText;
        private Date mTime;

        public TimedText(Date date, int n, String string2) {
            this.mTime = date;
            this.mDuration = n;
            this.mText = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(80);
            Date date = this.mTime;
            StringBuilder stringBuilder2 = stringBuilder.append(date).append("-");
            int n = this.mDuration;
            StringBuilder stringBuilder3 = stringBuilder2.append(n).append(":");
            String string2 = this.mText;
            StringBuilder stringBuilder4 = stringBuilder3.append(string2);
            return stringBuilder.toString();
        }
    }
}

