/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.io.IOException;
import java.io.InputStream;

public final class ResampleInputStream
extends InputStream {
    private static final String TAG = "ResampleInputStream";
    private static final int mFirLength = 29;
    private byte[] mBuf;
    private int mBufCount;
    private InputStream mInputStream;
    private final byte[] mOneByte;
    private final int mRateIn;
    private final int mRateOut;

    static {
        System.loadLibrary("media_jni");
    }

    public ResampleInputStream(InputStream inputStream, int n, int n2) {
        byte[] byArray = new byte[1];
        this.mOneByte = byArray;
        int n3 = n2 * 2;
        if (n != n3) {
            throw new IllegalArgumentException("only support 2:1 at the moment");
        }
        this.mInputStream = inputStream;
        this.mRateIn = 2;
        this.mRateOut = 1;
    }

    private static native void fir21(byte[] var0, int var1, byte[] var2, int var3, int var4);

    @Override
    public void close() throws IOException {
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
            return;
        }
        finally {
            this.mInputStream = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.mInputStream == null) {
            return;
        }
        this.close();
        throw new IllegalStateException("someone forgot to close ResampleInputStream");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        byte[] byArray = this.mOneByte;
        if (this.read(byArray, 0, 1) != 1) return -1;
        return this.mOneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = byArray.length;
        return this.read(byArray, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.mInputStream == null) {
            throw new IllegalStateException("not open");
        }
        int n3 = n2 / 2;
        int n4 = this.mRateIn;
        int n5 = n3 * n4;
        int n6 = this.mRateOut;
        int n7 = (n5 / n6 + 29) * 2;
        if (this.mBuf == null) {
            byte[] byArray2 = new byte[n7];
            this.mBuf = byArray2;
        } else {
            int n8 = this.mBuf.length;
            if (n7 > n8) {
                byte[] byArray3 = new byte[n7];
                byte[] byArray4 = this.mBuf;
                int n9 = this.mBufCount;
                System.arraycopy(byArray4, 0, byArray3, 0, n9);
                this.mBuf = byArray3;
            }
        }
        while (true) {
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            if ((n15 = (n14 = (n13 = this.mBufCount / 2 - 29) * (n12 = this.mRateOut)) / (n11 = this.mRateIn) * 2) > 0) {
                int n16;
                if (n15 < n2) {
                    n2 = n15;
                } else {
                    int n17 = n2 / 2 * 2;
                }
                byte[] byArray5 = this.mBuf;
                int n18 = n2 / 2;
                ResampleInputStream.fir21(byArray5, 0, byArray, n, n18);
                int n19 = this.mRateIn * n2;
                int n20 = this.mRateOut;
                int n21 = n19 / n20;
                this.mBufCount = n16 = this.mBufCount - n21;
                if (this.mBufCount <= 0) return n2;
                byte[] byArray6 = this.mBuf;
                byte[] byArray7 = this.mBuf;
                int n22 = this.mBufCount;
                System.arraycopy(byArray6, n21, byArray7, 0, n22);
                return n2;
            }
            InputStream inputStream = this.mInputStream;
            byte[] byArray8 = this.mBuf;
            int n23 = this.mBufCount;
            int n24 = this.mBuf.length;
            int n25 = this.mBufCount;
            int n26 = n24 - n25;
            int n27 = inputStream.read(byArray8, n23, n26);
            if (n27 == -1) {
                return -1;
            }
            this.mBufCount = n10 = this.mBufCount + n27;
        }
    }
}

