/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;

public class Ringtone {
    private static final String[] DRM_COLUMNS;
    private static final String[] MEDIA_COLUMNS;
    private static String TAG;
    private AssetFileDescriptor mAssetFileDescriptor;
    private MediaPlayer mAudio;
    private AudioManager mAudioManager;
    private Context mContext;
    private FileDescriptor mFileDescriptor;
    private int mStreamType = 2;
    private String mTitle;
    private Uri mUri;

    static {
        TAG = "Ringtone";
        String[] stringArray = new String[]{"_id", "_data", "title"};
        MEDIA_COLUMNS = stringArray;
        String[] stringArray2 = new String[]{"_id", "_data", "title"};
        DRM_COLUMNS = stringArray2;
    }

    Ringtone(Context context) {
        AudioManager audioManager;
        this.mContext = context;
        this.mAudioManager = audioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    /*
     * Unable to fully structure code
     */
    private static String getTitle(Context var0, Uri var1_1, boolean var2_2) {
        block15: {
            block18: {
                block17: {
                    block16: {
                        var3_3 = null;
                        var4_4 = var0.getContentResolver();
                        var5_5 = null;
                        if (var1_1 == null) break block16;
                        var6_6 = var1_1.getAuthority();
                        if (!"settings".equals(var6_6)) break block17;
                        if (var2_2) {
                            var7_7 = RingtoneManager.getDefaultType(var1_1);
                            var8_8 = RingtoneManager.getActualDefaultRingtoneUri(var0, var7_7);
                            var9_9 = Ringtone.getTitle(var0, var8_8, false);
                            var10_10 = new Object[]{var9_9};
                            var5_5 = var0.getString(17040145, var10_10);
                        }
                    }
lbl14:
                    // 3 sources

                    while (true) {
                        if (var5_5 == null && (var5_5 = var0.getString(17040148)) == null) {
                            var5_5 = "";
                        }
                        var11_11 = var5_5;
lbl18:
                        // 2 sources

                        return var11_11;
                    }
                }
                if (!"drm".equals(var6_6)) break block18;
                var12_12 = Ringtone.DRM_COLUMNS;
                var13_13 = var1_1;
                var14_14 = null;
                var15_15 = null;
                var3_3 = var4_4.query(var13_13, var12_12, null, var14_14, var15_15);
lbl27:
                // 3 sources

                while (var3_3 != null) {
                    if (var3_3.getCount() != 1) break block15;
                    var16_16 = var3_3.moveToFirst();
                    var11_11 = var17_17 = var3_3.getString(2);
                    if (var3_3 != null) {
                        var3_3.close();
                        ** continue;
                    }
lbl35:
                    // 3 sources

                    ** GOTO lbl18
                }
                break block15;
            }
            if (!"media".equals(var6_6)) ** GOTO lbl27
            var18_19 = Ringtone.MEDIA_COLUMNS;
            var19_20 = var1_1;
            var20_21 = null;
            var21_22 = null;
            var3_3 = var4_4.query(var19_20, var18_19, null, var20_21, var21_22);
            ** GOTO lbl27
        }
        try {
            var5_5 = var17_18 = var1_1.getLastPathSegment();
            if (var3_3 == null) ** GOTO lbl14
            var3_3.close();
            ** continue;
        }
        catch (Throwable var22_23) {
            if (var3_3 != null) {
                var3_3.close();
            }
            throw var22_23;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void openMediaPlayer() throws IOException {
        MediaPlayer mediaPlayer;
        this.mAudio = mediaPlayer = new MediaPlayer();
        if (this.mUri != null) {
            MediaPlayer mediaPlayer2 = this.mAudio;
            Context context = this.mContext;
            Uri uri = this.mUri;
            mediaPlayer2.setDataSource(context, uri);
        } else if (this.mFileDescriptor != null) {
            MediaPlayer mediaPlayer3 = this.mAudio;
            FileDescriptor fileDescriptor = this.mFileDescriptor;
            mediaPlayer3.setDataSource(fileDescriptor);
        } else {
            if (this.mAssetFileDescriptor == null) {
                throw new IOException("No data source set.");
            }
            if (this.mAssetFileDescriptor.getDeclaredLength() < 0L) {
                MediaPlayer mediaPlayer4 = this.mAudio;
                FileDescriptor fileDescriptor = this.mAssetFileDescriptor.getFileDescriptor();
                mediaPlayer4.setDataSource(fileDescriptor);
            } else {
                MediaPlayer mediaPlayer5 = this.mAudio;
                FileDescriptor fileDescriptor = this.mAssetFileDescriptor.getFileDescriptor();
                long l = this.mAssetFileDescriptor.getStartOffset();
                long l2 = this.mAssetFileDescriptor.getDeclaredLength();
                mediaPlayer5.setDataSource(fileDescriptor, l, l2);
            }
        }
        MediaPlayer mediaPlayer6 = this.mAudio;
        int n = this.mStreamType;
        mediaPlayer6.setAudioStreamType(n);
        this.mAudio.prepare();
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTitle(Context context) {
        String string2;
        if (this.mTitle != null) {
            return this.mTitle;
        }
        Uri uri = this.mUri;
        this.mTitle = string2 = Ringtone.getTitle(context, uri, true);
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPlaying() {
        if (this.mAudio == null) return false;
        if (!this.mAudio.isPlaying()) return false;
        return true;
    }

    void open(AssetFileDescriptor assetFileDescriptor) throws IOException {
        this.mAssetFileDescriptor = assetFileDescriptor;
        this.openMediaPlayer();
    }

    void open(Uri uri) throws IOException {
        this.mUri = uri;
        this.openMediaPlayer();
    }

    void open(FileDescriptor fileDescriptor) throws IOException {
        this.mFileDescriptor = fileDescriptor;
        this.openMediaPlayer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void play() {
        if (this.mAudio == null) {
            try {
                this.openMediaPlayer();
            }
            catch (Exception exception) {
                int n = Log.e(TAG, "play() caught ", exception);
                this.mAudio = null;
            }
        }
        if (this.mAudio == null) {
            return;
        }
        AudioManager audioManager = this.mAudioManager;
        int n = this.mStreamType;
        if (audioManager.getStreamVolume(n) == 0) {
            return;
        }
        this.mAudio.start();
    }

    public void setStreamType(int n) {
        this.mStreamType = n;
        if (this.mAudio == null) {
            return;
        }
        try {
            this.openMediaPlayer();
            return;
        }
        catch (IOException iOException) {
            int n2 = Log.w(TAG, "Couldn't set the stream type", iOException);
            return;
        }
    }

    void setTitle(String string2) {
        this.mTitle = string2;
    }

    public void stop() {
        if (this.mAudio == null) {
            return;
        }
        this.mAudio.reset();
        this.mAudio.release();
        this.mAudio = null;
    }
}

