/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.media.Ringtone;
import android.net.Uri;
import android.os.Environment;
import android.provider.DrmStore;
import android.provider.MediaStore;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.database.SortCursor;
import java.util.ArrayList;
import java.util.List;

public class RingtoneManager {
    public static final String ACTION_RINGTONE_PICKER = "android.intent.action.RINGTONE_PICKER";
    private static final String[] DRM_COLUMNS;
    public static final String EXTRA_RINGTONE_DEFAULT_URI = "android.intent.extra.ringtone.DEFAULT_URI";
    public static final String EXTRA_RINGTONE_EXISTING_URI = "android.intent.extra.ringtone.EXISTING_URI";
    public static final String EXTRA_RINGTONE_INCLUDE_DRM = "android.intent.extra.ringtone.INCLUDE_DRM";
    public static final String EXTRA_RINGTONE_PICKED_URI = "android.intent.extra.ringtone.PICKED_URI";
    public static final String EXTRA_RINGTONE_SHOW_DEFAULT = "android.intent.extra.ringtone.SHOW_DEFAULT";
    public static final String EXTRA_RINGTONE_SHOW_SILENT = "android.intent.extra.ringtone.SHOW_SILENT";
    public static final String EXTRA_RINGTONE_TITLE = "android.intent.extra.ringtone.TITLE";
    public static final String EXTRA_RINGTONE_TYPE = "android.intent.extra.ringtone.TYPE";
    public static final int ID_COLUMN_INDEX = 0;
    private static final String[] INTERNAL_COLUMNS;
    private static final String[] MEDIA_COLUMNS;
    private static final String TAG = "RingtoneManager";
    public static final int TITLE_COLUMN_INDEX = 1;
    public static final int TYPE_ALARM = 4;
    public static final int TYPE_ALL = 7;
    public static final int TYPE_NOTIFICATION = 2;
    public static final int TYPE_RINGTONE = 1;
    public static final int URI_COLUMN_INDEX = 2;
    private Activity mActivity;
    private Context mContext;
    private Cursor mCursor;
    private List<String> mFilterColumns;
    private boolean mIncludeDrm;
    private Ringtone mPreviousRingtone;
    private boolean mStopPreviousRingtone;
    private int mType = 1;

    static {
        String string2;
        String string3;
        String string4;
        String[] stringArray = new String[4];
        stringArray[0] = "_id";
        stringArray[1] = "title";
        StringBuilder stringBuilder = new StringBuilder().append("\"");
        Uri uri = MediaStore.Audio.Media.INTERNAL_CONTENT_URI;
        stringArray[2] = string4 = stringBuilder.append(uri).append("\"").toString();
        stringArray[3] = "title_key";
        INTERNAL_COLUMNS = stringArray;
        String[] stringArray2 = new String[4];
        stringArray2[0] = "_id";
        stringArray2[1] = "title";
        StringBuilder stringBuilder2 = new StringBuilder().append("\"");
        Uri uri2 = DrmStore.Audio.CONTENT_URI;
        stringArray2[2] = string3 = stringBuilder2.append(uri2).append("\"").toString();
        stringArray2[3] = "title AS title_key";
        DRM_COLUMNS = stringArray2;
        String[] stringArray3 = new String[4];
        stringArray3[0] = "_id";
        stringArray3[1] = "title";
        StringBuilder stringBuilder3 = new StringBuilder().append("\"");
        Uri uri3 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        stringArray3[2] = string2 = stringBuilder3.append(uri3).append("\"").toString();
        stringArray3[3] = "title_key";
        MEDIA_COLUMNS = stringArray3;
    }

    public RingtoneManager(Activity activity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.mFilterColumns = arrayList;
        this.mStopPreviousRingtone = true;
        this.mActivity = activity;
        this.mContext = activity;
        int n = this.mType;
        this.setType(n);
    }

    public RingtoneManager(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.mFilterColumns = arrayList;
        this.mStopPreviousRingtone = true;
        this.mContext = context;
        int n = this.mType;
        this.setType(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String constructBooleanTrueWhereClause(List<String> list) {
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; i += -1) {
            String string2 = list.get(i);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append("=1 or ");
        }
        if (list.size() <= 0) return stringBuilder.toString();
        int n = stringBuilder.length() - 4;
        stringBuilder.setLength(n);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Uri getActualDefaultRingtoneUri(Context context, int n) {
        String string2 = RingtoneManager.getSettingForType(n);
        if (string2 == null) {
            return null;
        }
        String string3 = Settings.System.getString(context.getContentResolver(), string2);
        if (string3 == null) return null;
        return Uri.parse(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getDefaultType(Uri uri) {
        if (uri == null) {
            return -1;
        }
        Uri uri2 = Settings.System.DEFAULT_RINGTONE_URI;
        if (uri.equals(uri2)) {
            return 1;
        }
        Uri uri3 = Settings.System.DEFAULT_NOTIFICATION_URI;
        if (uri.equals(uri3)) {
            return 2;
        }
        Uri uri4 = Settings.System.DEFAULT_ALARM_ALERT_URI;
        if (!uri.equals(uri4)) return -1;
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Uri getDefaultUri(int n) {
        if ((n & 1) != 0) {
            return Settings.System.DEFAULT_RINGTONE_URI;
        }
        if ((n & 2) != 0) {
            return Settings.System.DEFAULT_NOTIFICATION_URI;
        }
        if ((n & 4) == 0) return null;
        return Settings.System.DEFAULT_ALARM_ALERT_URI;
    }

    private Cursor getDrmRingtones() {
        Uri uri = DrmStore.Audio.CONTENT_URI;
        String[] stringArray = DRM_COLUMNS;
        RingtoneManager ringtoneManager = this;
        String[] stringArray2 = null;
        return ringtoneManager.query(uri, stringArray, null, stringArray2, "title");
    }

    private Cursor getInternalRingtones() {
        Uri uri = MediaStore.Audio.Media.INTERNAL_CONTENT_URI;
        String[] stringArray = INTERNAL_COLUMNS;
        String string2 = RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns);
        return this.query(uri, stringArray, string2, null, "title_key");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cursor getMediaRingtones() {
        String string2 = Environment.getExternalStorageState();
        if (!string2.equals("mounted")) {
            if (!string2.equals("mounted_ro")) return null;
        }
        Uri uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        String[] stringArray = MEDIA_COLUMNS;
        String string3 = RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns);
        return this.query(uri, stringArray, string3, null, "title_key");
    }

    public static Ringtone getRingtone(Context context, Uri uri) {
        return RingtoneManager.getRingtone(context, uri, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Ringtone getRingtone(Context context, Uri uri, int n) {
        try {
            Ringtone ringtone = new Ringtone(context);
            if (n >= 0) {
                ringtone.setStreamType(n);
            }
            ringtone.open(uri);
            return ringtone;
        }
        catch (Exception exception) {
            String string2 = "Failed to open ringtone " + uri;
            int n2 = Log.e(TAG, string2);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getSettingForType(int n) {
        if ((n & 1) != 0) {
            return "ringtone";
        }
        if ((n & 2) != 0) {
            return "notification_sound";
        }
        if ((n & 4) == 0) return null;
        return "alarm_alert";
    }

    private static Uri getUriFromCursor(Cursor cursor) {
        Uri uri = Uri.parse(cursor.getString(2));
        long l = cursor.getLong(0);
        return ContentUris.withAppendedId(uri, l);
    }

    public static Uri getValidRingtoneUri(Context context) {
        RingtoneManager ringtoneManager = new RingtoneManager(context);
        Cursor cursor = ringtoneManager.getInternalRingtones();
        Uri uri = RingtoneManager.getValidRingtoneUriFromCursorAndClose(context, cursor);
        if (uri == null) {
            Cursor cursor2 = ringtoneManager.getMediaRingtones();
            uri = RingtoneManager.getValidRingtoneUriFromCursorAndClose(context, cursor2);
        }
        if (uri == null) {
            Cursor cursor3 = ringtoneManager.getDrmRingtones();
            uri = RingtoneManager.getValidRingtoneUriFromCursorAndClose(context, cursor3);
        }
        return uri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Uri getValidRingtoneUriFromCursorAndClose(Context context, Cursor cursor) {
        if (cursor == null) return null;
        Uri uri = null;
        if (cursor.moveToFirst()) {
            uri = RingtoneManager.getUriFromCursor(cursor);
        }
        cursor.close();
        return uri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDefault(Uri uri) {
        if (RingtoneManager.getDefaultType(uri) == -1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        if (this.mActivity != null) {
            Activity activity = this.mActivity;
            Uri uri2 = uri;
            String[] stringArray3 = stringArray;
            String string4 = string2;
            String[] stringArray4 = stringArray2;
            String string5 = string3;
            return activity.managedQuery(uri2, stringArray3, string4, stringArray4, string5);
        }
        ContentResolver contentResolver = this.mContext.getContentResolver();
        Uri uri3 = uri;
        String[] stringArray5 = stringArray;
        String string6 = string2;
        String[] stringArray6 = stringArray2;
        String string7 = string3;
        return contentResolver.query(uri3, stringArray5, string6, stringArray6, string7);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setActualDefaultRingtoneUri(Context context, int n, Uri uri) {
        String string2 = RingtoneManager.getSettingForType(n);
        if (string2 == null) {
            return;
        }
        ContentResolver contentResolver = context.getContentResolver();
        String string3 = uri != null ? uri.toString() : null;
        boolean bl = Settings.System.putString(contentResolver, string2, string3);
    }

    private void setFilterColumnsList(int n) {
        List<String> list = this.mFilterColumns;
        list.clear();
        if ((n & 1) != 0) {
            boolean bl = list.add("is_ringtone");
        }
        if ((n & 2) != 0) {
            boolean bl = list.add("is_notification");
        }
        if ((n & 4) == 0) {
            return;
        }
        boolean bl = list.add("is_alarm");
    }

    /*
     * Enabled aggressive block sorting
     */
    public Cursor getCursor() {
        Cursor cursor;
        if (this.mCursor != null && this.mCursor.requery()) {
            return this.mCursor;
        }
        Cursor cursor2 = this.getInternalRingtones();
        Cursor cursor3 = this.mIncludeDrm ? this.getDrmRingtones() : null;
        Cursor cursor4 = this.getMediaRingtones();
        Cursor[] cursorArray = new Cursor[]{cursor2, cursor3, cursor4};
        this.mCursor = cursor = new SortCursor(cursorArray, "title_key");
        return cursor;
    }

    public boolean getIncludeDrm() {
        return this.mIncludeDrm;
    }

    public Ringtone getRingtone(int n) {
        Ringtone ringtone;
        if (this.mStopPreviousRingtone && this.mPreviousRingtone != null) {
            this.mPreviousRingtone.stop();
        }
        Context context = this.mContext;
        Uri uri = this.getRingtoneUri(n);
        int n2 = this.inferStreamType();
        this.mPreviousRingtone = ringtone = RingtoneManager.getRingtone(context, uri, n2);
        return this.mPreviousRingtone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRingtonePosition(Uri uri) {
        if (uri == null) {
            return -1;
        }
        Cursor cursor = this.getCursor();
        int n = cursor.getCount();
        if (!cursor.moveToFirst()) {
            return -1;
        }
        Uri uri2 = null;
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            long l;
            Uri uri3;
            String string3 = cursor.getString(2);
            if (uri2 == null || !string3.equals(string2)) {
                uri2 = Uri.parse(string3);
            }
            if (uri.equals(uri3 = ContentUris.withAppendedId(uri2, l = cursor.getLong(0)))) {
                return n2;
            }
            boolean bl = cursor.move(1);
            string2 = string3;
            ++n2;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Uri getRingtoneUri(int n) {
        Cursor cursor = this.getCursor();
        if (cursor.moveToPosition(n)) return RingtoneManager.getUriFromCursor(cursor);
        return null;
    }

    public boolean getStopPreviousRingtone() {
        return this.mStopPreviousRingtone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int inferStreamType() {
        switch (this.mType) {
            default: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 2: 
        }
        return 5;
    }

    public void setIncludeDrm(boolean bl) {
        this.mIncludeDrm = bl;
    }

    public void setStopPreviousRingtone(boolean bl) {
        this.mStopPreviousRingtone = bl;
    }

    public void setType(int n) {
        if (this.mCursor != null) {
            throw new IllegalStateException("Setting filter columns should be done before querying for ringtones.");
        }
        this.mType = n;
        this.setFilterColumnsList(n);
    }

    public void stopPreviousRingtone() {
        if (this.mPreviousRingtone == null) {
            return;
        }
        this.mPreviousRingtone.stop();
    }
}

