/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.util.AndroidRuntimeException;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class SoundPool {
    private static final boolean DEBUG = false;
    private static final int SAMPLE_LOADED = 1;
    private static final String TAG = "SoundPool";
    private EventHandler mEventHandler;
    private final Object mLock;
    private int mNativeContext;
    private OnLoadCompleteListener mOnLoadCompleteListener;

    static {
        System.loadLibrary("soundpool");
    }

    public SoundPool(int n, int n2, int n3) {
        Object object;
        WeakReference<SoundPool> weakReference = new WeakReference<SoundPool>(this);
        if (this.native_setup(weakReference, n, n2, n3) != 0) {
            throw new RuntimeException("Native setup failed");
        }
        this.mLock = object = new Object();
        Looper looper = Looper.myLooper();
        if (looper != null) {
            EventHandler eventHandler;
            this.mEventHandler = eventHandler = new EventHandler(this, looper);
            return;
        }
        looper = Looper.getMainLooper();
        if (looper != null) {
            EventHandler eventHandler;
            this.mEventHandler = eventHandler = new EventHandler(this, looper);
            return;
        }
        this.mEventHandler = null;
    }

    private final native int _load(FileDescriptor var1, long var2, long var4, int var6);

    private final native int _load(String var1, int var2);

    private final native int native_setup(Object var1, int var2, int var3, int var4);

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        SoundPool soundPool = (SoundPool)((WeakReference)object).get();
        if (soundPool == null) {
            return;
        }
        if (soundPool.mEventHandler == null) {
            return;
        }
        Message message = soundPool.mEventHandler.obtainMessage(n, n2, n3, object2);
        boolean bl = soundPool.mEventHandler.sendMessage(message);
    }

    public final native void autoPause();

    public final native void autoResume();

    protected void finalize() {
        this.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int load(Context context, int n, int n2) {
        AssetFileDescriptor assetFileDescriptor = context.getResources().openRawResourceFd(n);
        int n3 = 0;
        if (assetFileDescriptor == null) return n3;
        FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
        long l = assetFileDescriptor.getStartOffset();
        long l2 = assetFileDescriptor.getLength();
        SoundPool soundPool = this;
        int n4 = n2;
        n3 = soundPool._load(fileDescriptor, l, l2, n4);
        try {
            assetFileDescriptor.close();
            return n3;
        }
        catch (IOException iOException) {
            return n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int load(AssetFileDescriptor assetFileDescriptor, int n) {
        if (assetFileDescriptor == null) return 0;
        long l = assetFileDescriptor.getLength();
        if (l < 0L) {
            throw new AndroidRuntimeException("no length for fd");
        }
        FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
        long l2 = assetFileDescriptor.getStartOffset();
        SoundPool soundPool = this;
        int n2 = n;
        return soundPool._load(fileDescriptor, l2, l, n2);
    }

    public int load(FileDescriptor fileDescriptor, long l, long l2, int n) {
        return this._load(fileDescriptor, l, l2, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int load(String string2, int n) {
        if (string2.startsWith("http:")) {
            return this._load(string2, n);
        }
        int n2 = 0;
        try {
            File file = new File(string2);
            if (file == null) return n2;
            ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open(file, 0x10000000);
            if (parcelFileDescriptor == null) return n2;
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            long l = file.length();
            SoundPool soundPool = this;
            int n3 = n;
            n2 = soundPool._load(fileDescriptor, 0L, l, n3);
            parcelFileDescriptor.close();
            return n2;
        }
        catch (IOException iOException) {
            String string3 = "error loading " + string2;
            int n4 = Log.e(TAG, string3);
            return n2;
        }
    }

    public final native void pause(int var1);

    public final native int play(int var1, float var2, float var3, int var4, int var5, float var6);

    public final native void release();

    public final native void resume(int var1);

    public final native void setLoop(int var1, int var2);

    public void setOnLoadCompleteListener(OnLoadCompleteListener onLoadCompleteListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnLoadCompleteListener = onLoadCompleteListener;
            return;
        }
    }

    public final native void setPriority(int var1, int var2);

    public final native void setRate(int var1, float var2);

    public final native void setVolume(int var1, float var2, float var3);

    public final native void stop(int var1);

    public final native boolean unload(int var1);

    private class EventHandler
    extends Handler {
        private SoundPool mSoundPool;

        public EventHandler(SoundPool soundPool2, Looper looper) {
            super(looper);
            this.mSoundPool = soundPool2;
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown message type ");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    int n2 = Log.e(SoundPool.TAG, string2);
                    return;
                }
                case 1: 
            }
            Object object = SoundPool.this.mLock;
            synchronized (object) {
                if (SoundPool.this.mOnLoadCompleteListener != null) {
                    OnLoadCompleteListener onLoadCompleteListener = SoundPool.this.mOnLoadCompleteListener;
                    SoundPool soundPool = this.mSoundPool;
                    int n = message.arg1;
                    int n3 = message.arg2;
                    onLoadCompleteListener.onLoadComplete(soundPool, n, n3);
                }
                return;
            }
        }
    }

    public static interface OnLoadCompleteListener {
        public void onLoadComplete(SoundPool var1, int var2, int var3);
    }
}

