/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.media.MediaFile;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.FileInputStream;
import java.io.IOException;

public class ThumbnailUtils {
    private static final int MAX_NUM_PIXELS_MICRO_THUMBNAIL = 16384;
    private static final int MAX_NUM_PIXELS_THUMBNAIL = 196608;
    private static final int OPTIONS_NONE = 0;
    public static final int OPTIONS_RECYCLE_INPUT = 2;
    private static final int OPTIONS_SCALE_UP = 1;
    private static final String TAG = "ThumbnailUtils";
    public static final int TARGET_SIZE_MICRO_THUMBNAIL = 96;
    public static final int TARGET_SIZE_MINI_THUMBNAIL = 320;
    private static final int UNCONSTRAINED = 255;

    private static void closeSilently(ParcelFileDescriptor parcelFileDescriptor) {
        if (parcelFileDescriptor == null) {
            return;
        }
        try {
            parcelFileDescriptor.close();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int computeInitialSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3;
        int n4;
        double d = options.outWidth;
        double d2 = options.outHeight;
        if (n2 == -1) {
            n4 = 1;
        } else {
            double d3 = d * d2;
            double d4 = n2;
            n4 = (int)Math.ceil(Math.sqrt(d3 / d4));
        }
        if (n == -1) {
            n3 = 128;
        } else {
            double d5 = n;
            double d6 = Math.floor(d / d5);
            double d7 = n;
            double d8 = Math.floor(d2 / d7);
            n3 = (int)Math.min(d6, d8);
        }
        if (n3 < n4) {
            return n4;
        }
        if (n2 == -1 && n == -1) {
            return 1;
        }
        if (n != -1) return n3;
        return n4;
    }

    private static int computeSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3;
        int n4 = ThumbnailUtils.computeInitialSampleSize(options, n, n2);
        if (n4 <= 8) {
            for (n3 = 1; n3 < n4; n3 <<= 1) {
            }
        } else {
            n3 = (n4 + 7) / 8 * 8;
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    public static Bitmap createImageThumbnail(String var0, int var1_1) {
        block10: {
            var2_2 = null;
            if (var1_1 != var2_2) ** GOTO lbl29
            var3_3 = true;
lbl4:
            // 2 sources

            while (var3_3) {
                var4_4 = 320;
lbl6:
                // 2 sources

                while (var3_3) {
                    var5_5 = 196608;
lbl8:
                    // 2 sources

                    while (true) {
                        var6_6 = new SizedThumbnailBitmap();
                        var7_7 = null;
                        var8_8 = MediaFile.getFileType(var0);
                        if (var8_8 != null && var8_8.fileType == 31) {
                            ThumbnailUtils.createThumbnailFromEXIF(var0, var4_4, var5_5, var6_6);
                            var7_7 = var6_6.mBitmap;
                        }
                        if (var7_7 != null) break block10;
                        var9_9 = new FileInputStream(var0).getFD();
                        var10_10 = new BitmapFactory.Options();
                        var10_10.inSampleSize = 1;
                        var10_10.inJustDecodeBounds = true;
                        var11_11 = BitmapFactory.decodeFileDescriptor(var9_9, null, var10_10);
                        if (var10_10.mCancel || var10_10.outWidth == -1 || var10_10.outHeight == -1) {
                            var2_2 = null;
lbl24:
                            // 2 sources

                            return var2_2;
                        }
                        break block11;
                        break;
                    }
                }
                ** GOTO lbl34
            }
            {
                block11: {
                    block12: {
                        break block12;
lbl29:
                        // 1 sources

                        var3_3 = false;
                        ** GOTO lbl4
                    }
                    var4_4 = 96;
                    ** GOTO lbl6
lbl34:
                    // 1 sources

                    var5_5 = 16384;
                    ** continue;
                }
                var10_10.inSampleSize = var12_12 = ThumbnailUtils.computeSampleSize(var10_10, var4_4, var5_5);
                var10_10.inJustDecodeBounds = false;
                var10_10.inDither = false;
                var10_10.inPreferredConfig = var13_13 = Bitmap.Config.ARGB_8888;
                var7_7 = var14_14 = BitmapFactory.decodeFileDescriptor(var9_9, null, var10_10);
            }
        }
lbl43:
        // 2 sources

        while (true) {
            if (var1_1 == 3) {
                var7_7 = ThumbnailUtils.extractThumbnail(var7_7, 96, 96, 2);
            }
            var2_2 = var7_7;
            ** continue;
            break;
        }
        catch (IOException var15_15) {
            var16_16 = Log.e("ThumbnailUtils", "", var15_15);
            ** continue;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createThumbnailFromEXIF(String string2, int n, int n2, SizedThumbnailBitmap sizedThumbnailBitmap) {
        Bitmap bitmap;
        int n3;
        byte[] byArray;
        block10: {
            byte[] byArray2;
            ExifInterface exifInterface;
            block9: {
                byte[] byArray3;
                block8: {
                    byte[] byArray4;
                    if (string2 == null) {
                        return;
                    }
                    ExifInterface exifInterface2 = null;
                    byArray3 = null;
                    try {
                        exifInterface = new ExifInterface(string2);
                        if (exifInterface == null) break block8;
                    }
                    catch (IOException iOException) {
                        exifInterface = exifInterface2;
                        IOException iOException2 = iOException;
                        int n4 = Log.w(TAG, iOException2);
                        byArray = byArray3;
                        ExifInterface exifInterface3 = exifInterface;
                        break block10;
                    }
                    byArray2 = byArray4 = exifInterface.getThumbnail();
                    break block9;
                    {
                        catch (IOException iOException) {}
                    }
                }
                byArray2 = byArray3;
            }
            byArray = byArray2;
            ExifInterface exifInterface4 = exifInterface;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        BitmapFactory.Options options2 = new BitmapFactory.Options();
        int n5 = 0;
        if (byArray != null) {
            int n6;
            options2.inJustDecodeBounds = true;
            int n7 = byArray.length;
            Bitmap bitmap2 = BitmapFactory.decodeByteArray(byArray, 0, n7, options2);
            options2.inSampleSize = n6 = ThumbnailUtils.computeSampleSize(options2, n, n2);
            int n8 = options2.outWidth;
            int n9 = options2.inSampleSize;
            int n10 = n8 / n9;
        }
        options.inJustDecodeBounds = true;
        Bitmap bitmap3 = BitmapFactory.decodeFile(string2, options);
        options.inSampleSize = n3 = ThumbnailUtils.computeSampleSize(options, n, n2);
        int n11 = options.outWidth;
        int n12 = options.inSampleSize;
        int n13 = n11 / n12;
        if (byArray != null && n5 >= n13) {
            Bitmap bitmap4;
            n = options2.outWidth;
            int n14 = options2.outHeight;
            options2.inJustDecodeBounds = false;
            int n15 = byArray.length;
            sizedThumbnailBitmap.mBitmap = bitmap4 = BitmapFactory.decodeByteArray(byArray, 0, n15, options2);
            if (sizedThumbnailBitmap.mBitmap == null) {
                return;
            }
            sizedThumbnailBitmap.mThumbnailData = byArray;
            sizedThumbnailBitmap.mThumbnailWidth = n;
            sizedThumbnailBitmap.mThumbnailHeight = n14;
            return;
        }
        options.inJustDecodeBounds = false;
        sizedThumbnailBitmap.mBitmap = bitmap = BitmapFactory.decodeFile(string2, options);
    }

    /*
     * Unable to fully structure code
     */
    public static Bitmap createVideoThumbnail(String var0, int var1_1) {
        var2_2 = null;
        var3_3 = new MediaMetadataRetriever();
        var3_3.setDataSource(var0);
        var2_2 = var4_4 = var3_3.getFrameAtTime(65535L);
        try {
            var3_3.release();
        }
        catch (RuntimeException var10_10) {
            ** continue;
        }
lbl8:
        // 6 sources

        while (true) {
            if (var1_1 == 3 && var2_2 != null) {
                var2_2 = ThumbnailUtils.extractThumbnail(var2_2, 96, 96, 2);
            }
            return var2_2;
        }
        catch (IllegalArgumentException var5_5) {
            try {
                var3_3.release();
            }
            catch (RuntimeException var6_6) {}
        }
        catch (RuntimeException var7_7) {
            try {
                var3_3.release();
            }
            catch (RuntimeException var8_8) {}
        }
        catch (Throwable var9_9) {
            var3_3.release();
lbl27:
            // 2 sources

            throw var9_9;
        }
        {
            catch (RuntimeException var11_11) {
                ** continue;
            }
        }
    }

    public static Bitmap extractThumbnail(Bitmap bitmap, int n, int n2) {
        return ThumbnailUtils.extractThumbnail(bitmap, n, n2, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap extractThumbnail(Bitmap bitmap, int n, int n2, int n3) {
        float f;
        int n4;
        if (bitmap == null) {
            return null;
        }
        int n5 = bitmap.getWidth();
        if (n5 < (n4 = bitmap.getHeight())) {
            float f2 = n;
            float f3 = bitmap.getWidth();
            f = f2 / f3;
        } else {
            float f4 = n2;
            float f5 = bitmap.getHeight();
            f = f4 / f5;
        }
        Matrix matrix = new Matrix();
        matrix.setScale(f, f);
        int n6 = n3 | 1;
        return ThumbnailUtils.transform(matrix, bitmap, n, n2, n6);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Bitmap makeBitmap(int var0, int var1_1, Uri var2_2, ContentResolver var3_3, ParcelFileDescriptor var4_4, BitmapFactory.Options var5_5) {
        block10: {
            if (var4_4 == null) {
                var4_4 = var6_6 /* !! */  = ThumbnailUtils.makeInputStream(var2_2, var3_3);
            }
            if (var4_4 == null) {
                ThumbnailUtils.closeSilently(var4_4);
                var7_7 /* !! */  = null;
lbl7:
                // 4 sources

                return var7_7 /* !! */ ;
            }
            if (var5_5 != null) ** GOTO lbl12
            var5_5 = new BitmapFactory.Options();
lbl12:
            // 2 sources

            var8_8 = var4_4.getFileDescriptor();
            var5_5.inSampleSize = 1;
            var5_5.inJustDecodeBounds = true;
            var9_9 = BitmapFactory.decodeFileDescriptor(var8_8, null, var5_5);
            if (!var5_5.mCancel && var5_5.outWidth != -1 && (var10_10 = var5_5.outHeight) != -1) break block10;
            ThumbnailUtils.closeSilently(var4_4);
            var7_7 /* !! */  = null;
            ** GOTO lbl7
        }
        try {
            var5_5.inSampleSize = var11_11 = ThumbnailUtils.computeSampleSize(var5_5, var0, var1_1);
            var5_5.inJustDecodeBounds = false;
            var5_5.inDither = false;
            var5_5.inPreferredConfig = var12_12 = Bitmap.Config.ARGB_8888;
            var13_13 /* !! */  = var6_6 /* !! */  = BitmapFactory.decodeFileDescriptor(var8_8, null, var5_5);
        }
        catch (OutOfMemoryError var14_14) {
            var15_15 = Log.e("ThumbnailUtils", "Got oom exception ", var14_14);
            var7_7 /* !! */  = null;
            ** continue;
        }
        finally {
            ThumbnailUtils.closeSilently(var4_4);
        }
        ThumbnailUtils.closeSilently(var4_4);
        var7_7 /* !! */  = var13_13 /* !! */ ;
        ** GOTO lbl7
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ParcelFileDescriptor makeInputStream(Uri uri, ContentResolver contentResolver) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(uri, "r");
            return parcelFileDescriptor;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Bitmap transform(Matrix matrix, Bitmap bitmap, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Bitmap bitmap2;
        Bitmap bitmap3;
        float f;
        float f2;
        float f3;
        float f4;
        boolean bl = (n3 & 1) != 0;
        boolean bl2 = (n3 & 2) != 0;
        int n10 = bitmap.getWidth() - n;
        int n11 = bitmap.getHeight() - n2;
        if (!(bl || n10 >= 0 && n11 >= 0)) {
            Bitmap.Config config = Bitmap.Config.ARGB_8888;
            Bitmap bitmap4 = Bitmap.createBitmap(n, n2, config);
            Canvas canvas = new Canvas(bitmap4);
            int n12 = n10 / 2;
            int n13 = Math.max(0, n12);
            int n14 = n11 / 2;
            int n15 = Math.max(0, n14);
            int n16 = bitmap.getWidth();
            int n17 = Math.min(n, n16) + n13;
            int n18 = bitmap.getHeight();
            int n19 = Math.min(n2, n18) + n15;
            Rect rect = new Rect(n13, n15, n17, n19);
            int n20 = rect.width();
            int n21 = (n - n20) / 2;
            int n22 = rect.height();
            int n23 = (n2 - n22) / 2;
            int n24 = n - n21;
            int n25 = n2 - n23;
            Rect rect2 = new Rect(n21, n23, n24, n25);
            canvas.drawBitmap(bitmap, rect, rect2, null);
            if (!bl2) return bitmap4;
            bitmap.recycle();
            return bitmap4;
        }
        float f5 = bitmap.getWidth();
        float f6 = f5 / (f4 = (float)bitmap.getHeight());
        if (f6 > (f3 = (f2 = (float)n) / (f = (float)n2))) {
            float f7 = (float)n2 / f4;
            if (f7 < 0.9f || f7 > 1.0f) {
                matrix.setScale(f7, f7);
            } else {
                matrix = null;
            }
        } else {
            float f8 = (float)n / f5;
            if (f8 < 0.9f || f8 > 1.0f) {
                matrix.setScale(f8, f8);
            } else {
                matrix = null;
            }
        }
        if (matrix != null) {
            int n26 = bitmap.getWidth();
            int n27 = bitmap.getHeight();
            Bitmap bitmap5 = bitmap;
            Matrix matrix2 = matrix;
            bitmap3 = Bitmap.createBitmap(bitmap5, 0, 0, n26, n27, matrix2, true);
        } else {
            bitmap3 = bitmap;
        }
        if (bl2 && bitmap3 != bitmap) {
            bitmap.recycle();
        }
        if ((bitmap2 = Bitmap.createBitmap(bitmap3, n9 = (n8 = Math.max(0, n7 = bitmap3.getWidth() - n)) / 2, n6 = (n5 = Math.max(0, n4 = bitmap3.getHeight() - n2)) / 2, n, n2)) == bitmap3) return bitmap2;
        if (!bl2) {
            if (bitmap3 == bitmap) return bitmap2;
        }
        bitmap3.recycle();
        return bitmap2;
    }

    private static class SizedThumbnailBitmap {
        public Bitmap mBitmap;
        public byte[] mThumbnailData;
        public int mThumbnailHeight;
        public int mThumbnailWidth;

        private SizedThumbnailBitmap() {
        }
    }
}

