/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;

public class AudioEffect {
    public static final String ACTION_CLOSE_AUDIO_EFFECT_CONTROL_SESSION = "android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION";
    public static final String ACTION_DISPLAY_AUDIO_EFFECT_CONTROL_PANEL = "android.media.action.DISPLAY_AUDIO_EFFECT_CONTROL_PANEL";
    public static final String ACTION_OPEN_AUDIO_EFFECT_CONTROL_SESSION = "android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION";
    public static final int ALREADY_EXISTS = 254;
    public static final int CONTENT_TYPE_GAME = 2;
    public static final int CONTENT_TYPE_MOVIE = 1;
    public static final int CONTENT_TYPE_MUSIC = 0;
    public static final int CONTENT_TYPE_VOICE = 3;
    public static final String EFFECT_AUXILIARY = "Auxiliary";
    public static final String EFFECT_INSERT = "Insert";
    public static final UUID EFFECT_TYPE_BASS_BOOST;
    public static final UUID EFFECT_TYPE_ENV_REVERB;
    public static final UUID EFFECT_TYPE_EQUALIZER;
    public static final UUID EFFECT_TYPE_NULL;
    public static final UUID EFFECT_TYPE_PRESET_REVERB;
    public static final UUID EFFECT_TYPE_VIRTUALIZER;
    public static final int ERROR = 255;
    public static final int ERROR_BAD_VALUE = 252;
    public static final int ERROR_DEAD_OBJECT = 249;
    public static final int ERROR_INVALID_OPERATION = 251;
    public static final int ERROR_NO_INIT = 253;
    public static final int ERROR_NO_MEMORY = 250;
    public static final String EXTRA_AUDIO_SESSION = "android.media.extra.AUDIO_SESSION";
    public static final String EXTRA_CONTENT_TYPE = "android.media.extra.CONTENT_TYPE";
    public static final String EXTRA_PACKAGE_NAME = "android.media.extra.PACKAGE_NAME";
    public static final int NATIVE_EVENT_CONTROL_STATUS = 0;
    public static final int NATIVE_EVENT_ENABLED_STATUS = 1;
    public static final int NATIVE_EVENT_PARAMETER_CHANGED = 2;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int SUCCESS = 0;
    private static final String TAG = "AudioEffect-JAVA";
    private OnControlStatusChangeListener mControlChangeStatusListener;
    private Descriptor mDescriptor;
    private OnEnableStatusChangeListener mEnableStatusChangeListener;
    private int mId;
    private int mJniData;
    public final Object mListenerLock;
    private int mNativeAudioEffect;
    public NativeEventHandler mNativeEventHandler;
    private OnParameterChangeListener mParameterChangeListener;
    private int mState = 0;
    private final Object mStateLock;

    static {
        System.loadLibrary("audioeffect_jni");
        AudioEffect.native_init();
        EFFECT_TYPE_ENV_REVERB = UUID.fromString("c2e5d5f0-94bd-4763-9cac-4e234d06839e");
        EFFECT_TYPE_PRESET_REVERB = UUID.fromString("47382d60-ddd8-11db-bf3a-0002a5d5c51b");
        EFFECT_TYPE_EQUALIZER = UUID.fromString("0bed4300-ddd6-11db-8f34-0002a5d5c51b");
        EFFECT_TYPE_BASS_BOOST = UUID.fromString("0634f220-ddd4-11db-a0fc-0002a5d5c51b");
        EFFECT_TYPE_VIRTUALIZER = UUID.fromString("37cc2c00-dddd-11db-8577-0002a5d5c51b");
        EFFECT_TYPE_NULL = UUID.fromString("ec7178ec-e5e1-4432-a3f4-4657e6795210");
    }

    public AudioEffect(UUID uUID, UUID uUID2, int n, int n2) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        Object object;
        int n3;
        Object object2;
        Object object3;
        this.mStateLock = object3 = new Object();
        this.mEnableStatusChangeListener = null;
        this.mControlChangeStatusListener = null;
        this.mParameterChangeListener = null;
        this.mListenerLock = object2 = new Object();
        this.mNativeEventHandler = null;
        int[] nArray = new int[1];
        Object[] objectArray = new Descriptor[1];
        WeakReference<AudioEffect> weakReference = new WeakReference<AudioEffect>(this);
        String string2 = uUID.toString();
        String string3 = uUID2.toString();
        AudioEffect audioEffect = this;
        int n4 = n;
        int n5 = n2;
        int n6 = audioEffect.native_setup(weakReference, string2, string3, n4, n5, nArray, objectArray);
        if (n6 != 0 && n6 != -1) {
            String string4 = "Error code " + n6 + " when initializing AudioEffect.";
            int n7 = Log.e(TAG, string4);
            switch (n6) {
                default: {
                    String string5 = "Cannot initialize effect engine for type: " + uUID + "Error: " + n6;
                    throw new RuntimeException(string5);
                }
                case -4: {
                    String string6 = "Effect type: " + uUID + " not supported.";
                    throw new IllegalArgumentException(string6);
                }
                case -5: 
            }
            throw new UnsupportedOperationException("Effect library not loaded");
        }
        this.mId = n3 = nArray[0];
        this.mDescriptor = object = objectArray[0];
        Object object4 = this.mStateLock;
        synchronized (object4) {
            int n8 = 1;
            this.mState = n8;
            return;
        }
    }

    private void createNativeEventHandler() {
        Looper looper = Looper.myLooper();
        if (looper != null) {
            NativeEventHandler nativeEventHandler;
            this.mNativeEventHandler = nativeEventHandler = new NativeEventHandler(this, looper);
            return;
        }
        looper = Looper.getMainLooper();
        if (looper != null) {
            NativeEventHandler nativeEventHandler;
            this.mNativeEventHandler = nativeEventHandler = new NativeEventHandler(this, looper);
            return;
        }
        this.mNativeEventHandler = null;
    }

    private final native int native_command(int var1, int var2, byte[] var3, int[] var4, byte[] var5);

    private final native void native_finalize();

    private final native boolean native_getEnabled();

    private final native int native_getParameter(int var1, byte[] var2, int[] var3, byte[] var4);

    private final native boolean native_hasControl();

    private static final native void native_init();

    private static native Object[] native_query_effects();

    private final native void native_release();

    private final native int native_setEnabled(boolean var1);

    private final native int native_setParameter(int var1, byte[] var2, int var3, byte[] var4);

    private final native int native_setup(Object var1, String var2, String var3, int var4, int var5, int[] var6, Object[] var7);

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        AudioEffect audioEffect = (AudioEffect)((WeakReference)object).get();
        if (audioEffect == null) {
            return;
        }
        if (audioEffect.mNativeEventHandler == null) {
            return;
        }
        Message message = audioEffect.mNativeEventHandler.obtainMessage(n, n2, n3, object2);
        boolean bl = audioEffect.mNativeEventHandler.sendMessage(message);
    }

    public static Descriptor[] queryEffects() {
        return (Descriptor[])AudioEffect.native_query_effects();
    }

    public int byteArrayToInt(byte[] byArray) {
        return this.byteArrayToInt(byArray, 0);
    }

    public int byteArrayToInt(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        ByteBuffer byteBuffer2 = byteBuffer.order(byteOrder);
        return byteBuffer.getInt(n);
    }

    public short byteArrayToShort(byte[] byArray) {
        return this.byteArrayToShort(byArray, 0);
    }

    public short byteArrayToShort(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        ByteBuffer byteBuffer2 = byteBuffer.order(byteOrder);
        return byteBuffer.getShort(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkState(String string2) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 1) {
                String string3 = string2 + " called on uninitialized AudioEffect.";
                throw new IllegalStateException(string3);
            }
            return;
        }
    }

    public void checkStatus(int n) {
        switch (n) {
            default: {
                throw new RuntimeException("AudioEffect: set/get parameter error");
            }
            case -4: {
                throw new IllegalArgumentException("AudioEffect: bad parameter value");
            }
            case -5: {
                throw new UnsupportedOperationException("AudioEffect: invalid parameter operation");
            }
            case 0: 
        }
    }

    public int command(int n, byte[] byArray, byte[] byArray2) throws IllegalStateException {
        this.checkState("command()");
        int n2 = byArray2.length;
        int[] nArray = new int[]{n2};
        int n3 = byArray.length;
        AudioEffect audioEffect = this;
        int n4 = n;
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        int n5 = audioEffect.native_command(n4, n3, byArray3, nArray, byArray4);
        int n6 = byArray2.length;
        int n7 = nArray[0];
        if (n6 > n7) {
            byte[] byArray5 = new byte[nArray[0]];
            int n8 = nArray[0];
            System.arraycopy(byArray2, 0, byArray5, 0, n8);
            byte[] byArray6 = byArray5;
        }
        return n5;
    }

    public byte[] concatArrays(byte[] ... byArray) {
        int n = 0;
        byte[][] byArray2 = byArray;
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray2[i].length;
            n += n3;
        }
        byte[] byArray3 = new byte[n];
        int n4 = 0;
        for (byte[] byArray4 : byArray) {
            int n5 = byArray4.length;
            System.arraycopy(byArray4, 0, byArray3, n4, n5);
            int n6 = byArray4.length;
            n4 += n6;
        }
        return byArray3;
    }

    protected void finalize() {
        this.native_finalize();
    }

    public Descriptor getDescriptor() throws IllegalStateException {
        this.checkState("getDescriptor()");
        return this.mDescriptor;
    }

    public boolean getEnabled() throws IllegalStateException {
        this.checkState("getEnabled()");
        return this.native_getEnabled();
    }

    public int getId() throws IllegalStateException {
        this.checkState("getId()");
        return this.mId;
    }

    public int getParameter(int n, byte[] byArray) throws IllegalStateException {
        byte[] byArray2 = this.intToByteArray(n);
        return this.getParameter(byArray2, byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getParameter(int n, int[] nArray) throws IllegalStateException {
        int n2;
        int n3;
        if (nArray.length > 2) {
            return -1;
        }
        byte[] byArray = this.intToByteArray(n);
        byte[] byArray2 = new byte[nArray.length * 4];
        int n4 = this.getParameter(byArray, byArray2);
        nArray[0] = n3 = this.byteArrayToInt(byArray2);
        if (byArray2.length <= 4) return n4;
        nArray[1] = n2 = this.byteArrayToInt(byArray2, 4);
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getParameter(int n, short[] sArray) throws IllegalStateException {
        short s;
        short s2;
        if (sArray.length > 2) {
            return -1;
        }
        byte[] byArray = this.intToByteArray(n);
        byte[] byArray2 = new byte[sArray.length * 2];
        int n2 = this.getParameter(byArray, byArray2);
        sArray[0] = s2 = this.byteArrayToShort(byArray2);
        if (byArray2.length <= 2) return n2;
        sArray[1] = s = this.byteArrayToShort(byArray2, 2);
        return n2;
    }

    public int getParameter(byte[] byArray, byte[] byArray2) throws IllegalStateException {
        this.checkState("getParameter()");
        int n = byArray2.length;
        int[] nArray = new int[]{n};
        int n2 = byArray.length;
        int n3 = this.native_getParameter(n2, byArray, nArray, byArray2);
        int n4 = byArray2.length;
        int n5 = nArray[0];
        if (n4 > n5) {
            byte[] byArray3 = new byte[nArray[0]];
            int n6 = nArray[0];
            System.arraycopy(byArray2, 0, byArray3, 0, n6);
            byte[] byArray4 = byArray3;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getParameter(int[] nArray, byte[] byArray) throws IllegalStateException {
        if (nArray.length > 2) {
            return -1;
        }
        int n = nArray[0];
        byte[] byArray2 = this.intToByteArray(n);
        if (nArray.length <= 1) return this.getParameter(byArray2, byArray);
        int n2 = nArray[1];
        byte[] byArray3 = this.intToByteArray(n2);
        byte[] byArray4 = new byte[]{(byte)byArray2, (byte)byArray3};
        byArray2 = this.concatArrays((byte[][])byArray4);
        return this.getParameter(byArray2, byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getParameter(int[] nArray, int[] nArray2) throws IllegalStateException {
        int n;
        int n2;
        if (nArray.length > 2) return -1;
        if (nArray2.length > 2) {
            return -1;
        }
        int n3 = nArray[0];
        byte[] byArray = this.intToByteArray(n3);
        if (nArray.length > 1) {
            int n4 = nArray[1];
            byte[] byArray2 = this.intToByteArray(n4);
            byte[] byArray3 = new byte[]{(byte)byArray, (byte)byArray2};
            byArray = this.concatArrays((byte[][])byArray3);
        }
        byte[] byArray4 = new byte[nArray2.length * 4];
        int n5 = this.getParameter(byArray, byArray4);
        nArray2[0] = n2 = this.byteArrayToInt(byArray4);
        if (byArray4.length <= 4) return n5;
        nArray2[1] = n = this.byteArrayToInt(byArray4, 4);
        return n5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getParameter(int[] nArray, short[] sArray) throws IllegalStateException {
        short s;
        short s2;
        if (nArray.length > 2) return -1;
        if (sArray.length > 2) {
            return -1;
        }
        int n = nArray[0];
        byte[] byArray = this.intToByteArray(n);
        if (nArray.length > 1) {
            int n2 = nArray[1];
            byte[] byArray2 = this.intToByteArray(n2);
            byte[] byArray3 = new byte[]{(byte)byArray, (byte)byArray2};
            byArray = this.concatArrays((byte[][])byArray3);
        }
        byte[] byArray4 = new byte[sArray.length * 2];
        int n3 = this.getParameter(byArray, byArray4);
        sArray[0] = s2 = this.byteArrayToShort(byArray4);
        if (byArray4.length <= 2) return n3;
        sArray[1] = s = this.byteArrayToShort(byArray4, 2);
        return n3;
    }

    public boolean hasControl() throws IllegalStateException {
        this.checkState("hasControl()");
        return this.native_hasControl();
    }

    public byte[] intToByteArray(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        ByteBuffer byteBuffer2 = byteBuffer.order(byteOrder);
        ByteBuffer byteBuffer3 = byteBuffer.putInt(n);
        return byteBuffer.array();
    }

    public void release() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.native_release();
            this.mState = 0;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setControlStatusListener(OnControlStatusChangeListener onControlStatusChangeListener) {
        Object object = this.mListenerLock;
        // MONITORENTER : object
        this.mControlChangeStatusListener = onControlStatusChangeListener;
        // MONITOREXIT : object
        if (onControlStatusChangeListener == null) {
            return;
        }
        if (this.mNativeEventHandler != null) {
            return;
        }
        this.createNativeEventHandler();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setEnableStatusListener(OnEnableStatusChangeListener onEnableStatusChangeListener) {
        Object object = this.mListenerLock;
        // MONITORENTER : object
        this.mEnableStatusChangeListener = onEnableStatusChangeListener;
        // MONITOREXIT : object
        if (onEnableStatusChangeListener == null) {
            return;
        }
        if (this.mNativeEventHandler != null) {
            return;
        }
        this.createNativeEventHandler();
    }

    public int setEnabled(boolean bl) throws IllegalStateException {
        this.checkState("setEnabled()");
        return this.native_setEnabled(bl);
    }

    public int setParameter(int n, int n2) throws IllegalStateException {
        byte[] byArray = this.intToByteArray(n);
        byte[] byArray2 = this.intToByteArray(n2);
        return this.setParameter(byArray, byArray2);
    }

    public int setParameter(int n, short s) throws IllegalStateException {
        byte[] byArray = this.intToByteArray(n);
        byte[] byArray2 = this.shortToByteArray(s);
        return this.setParameter(byArray, byArray2);
    }

    public int setParameter(int n, byte[] byArray) throws IllegalStateException {
        byte[] byArray2 = this.intToByteArray(n);
        return this.setParameter(byArray2, byArray);
    }

    public int setParameter(byte[] byArray, byte[] byArray2) throws IllegalStateException {
        this.checkState("setParameter()");
        int n = byArray.length;
        int n2 = byArray2.length;
        return this.native_setParameter(n, byArray, n2, byArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setParameter(int[] nArray, byte[] byArray) throws IllegalStateException {
        if (nArray.length > 2) {
            return -1;
        }
        int n = nArray[0];
        byte[] byArray2 = this.intToByteArray(n);
        if (nArray.length <= 1) return this.setParameter(byArray2, byArray);
        int n2 = nArray[1];
        byte[] byArray3 = this.intToByteArray(n2);
        byte[] byArray4 = new byte[]{(byte)byArray2, (byte)byArray3};
        byArray2 = this.concatArrays((byte[][])byArray4);
        return this.setParameter(byArray2, byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setParameter(int[] nArray, int[] nArray2) throws IllegalStateException {
        if (nArray.length > 2) return -1;
        if (nArray2.length > 2) {
            return -1;
        }
        int n = nArray[0];
        byte[] byArray = this.intToByteArray(n);
        if (nArray.length > 1) {
            int n2 = nArray[1];
            byte[] byArray2 = this.intToByteArray(n2);
            byte[] byArray3 = new byte[]{(byte)byArray, (byte)byArray2};
            byArray = this.concatArrays((byte[][])byArray3);
        }
        int n3 = nArray2[0];
        byte[] byArray4 = this.intToByteArray(n3);
        if (nArray2.length <= 1) return this.setParameter(byArray, byArray4);
        int n4 = nArray2[1];
        byte[] byArray5 = this.intToByteArray(n4);
        byte[] byArray6 = new byte[]{(byte)byArray4, (byte)byArray5};
        byArray4 = this.concatArrays((byte[][])byArray6);
        return this.setParameter(byArray, byArray4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setParameter(int[] nArray, short[] sArray) throws IllegalStateException {
        if (nArray.length > 2) return -1;
        if (sArray.length > 2) {
            return -1;
        }
        int n = nArray[0];
        byte[] byArray = this.intToByteArray(n);
        if (nArray.length > 1) {
            int n2 = nArray[1];
            byte[] byArray2 = this.intToByteArray(n2);
            byte[] byArray3 = new byte[]{(byte)byArray, (byte)byArray2};
            byArray = this.concatArrays((byte[][])byArray3);
        }
        short s = sArray[0];
        byte[] byArray4 = this.shortToByteArray(s);
        if (sArray.length <= 1) return this.setParameter(byArray, byArray4);
        short s2 = sArray[1];
        byte[] byArray5 = this.shortToByteArray(s2);
        byte[] byArray6 = new byte[]{(byte)byArray4, (byte)byArray5};
        byArray4 = this.concatArrays((byte[][])byArray6);
        return this.setParameter(byArray, byArray4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        Object object = this.mListenerLock;
        // MONITORENTER : object
        this.mParameterChangeListener = onParameterChangeListener;
        // MONITOREXIT : object
        if (onParameterChangeListener == null) {
            return;
        }
        if (this.mNativeEventHandler != null) {
            return;
        }
        this.createNativeEventHandler();
    }

    public byte[] shortToByteArray(short s) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        ByteBuffer byteBuffer2 = byteBuffer.order(byteOrder);
        short s2 = s;
        ByteBuffer byteBuffer3 = byteBuffer.putShort(s2);
        return byteBuffer.array();
    }

    private class NativeEventHandler
    extends Handler {
        private AudioEffect mAudioEffect;

        public NativeEventHandler(AudioEffect audioEffect2, Looper looper) {
            super(looper);
            this.mAudioEffect = audioEffect2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message message) {
            if (this.mAudioEffect == null) {
                return;
            }
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("handleMessage() Unknown event type: ");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    int n2 = Log.e(AudioEffect.TAG, string2);
                    return;
                }
                case 1: {
                    Object object = AudioEffect.this.mListenerLock;
                    // MONITORENTER : object
                    OnEnableStatusChangeListener onEnableStatusChangeListener = this.mAudioEffect.mEnableStatusChangeListener;
                    // MONITOREXIT : object
                    if (onEnableStatusChangeListener == null) {
                        return;
                    }
                    object = this.mAudioEffect;
                    boolean bl = message.arg1 != 0;
                    onEnableStatusChangeListener.onEnableStatusChange((AudioEffect)object, bl);
                    return;
                }
                case 0: {
                    Object object = AudioEffect.this.mListenerLock;
                    // MONITORENTER : object
                    OnControlStatusChangeListener onControlStatusChangeListener = this.mAudioEffect.mControlChangeStatusListener;
                    // MONITOREXIT : object
                    if (onControlStatusChangeListener == null) {
                        return;
                    }
                    object = this.mAudioEffect;
                    boolean bl = message.arg1 != 0;
                    onControlStatusChangeListener.onControlStatusChange((AudioEffect)object, bl);
                    return;
                }
                case 2: 
            }
            Object object = AudioEffect.this.mListenerLock;
            // MONITORENTER : object
            OnParameterChangeListener onParameterChangeListener = this.mAudioEffect.mParameterChangeListener;
            // MONITOREXIT : object
            if (onParameterChangeListener == null) {
                return;
            }
            int n = message.arg1;
            byte[] byArray = (byte[])message.obj;
            int n3 = AudioEffect.this.byteArrayToInt(byArray, 0);
            int n4 = AudioEffect.this.byteArrayToInt(byArray, 4);
            int n5 = AudioEffect.this.byteArrayToInt(byArray, 8);
            byte[] byArray2 = new byte[n4];
            byte[] byArray3 = new byte[n5];
            System.arraycopy(byArray, 12, byArray2, 0, n4);
            System.arraycopy(byArray, n, byArray3, 0, n5);
            AudioEffect audioEffect = this.mAudioEffect;
            onParameterChangeListener.onParameterChange(audioEffect, n3, byArray2, byArray3);
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(AudioEffect var1, int var2, byte[] var3, byte[] var4);
    }

    public static interface OnControlStatusChangeListener {
        public void onControlStatusChange(AudioEffect var1, boolean var2);
    }

    public static interface OnEnableStatusChangeListener {
        public void onEnableStatusChange(AudioEffect var1, boolean var2);
    }

    public static class Descriptor {
        public String connectMode;
        public String implementor;
        public String name;
        public UUID type;
        public UUID uuid;

        public Descriptor() {
        }

        public Descriptor(String string2, String string3, String string4, String string5, String string6) {
            UUID uUID;
            UUID uUID2;
            this.type = uUID2 = UUID.fromString(string2);
            this.uuid = uUID = UUID.fromString(string3);
            this.connectMode = string4;
            this.name = string5;
            this.implementor = string6;
        }
    }
}

