/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import java.util.StringTokenizer;
import java.util.UUID;

public class BassBoost
extends AudioEffect {
    public static final int PARAM_STRENGTH = 1;
    public static final int PARAM_STRENGTH_SUPPORTED = 0;
    private static final String TAG = "BassBoost";
    private BaseParameterListener mBaseParamListener;
    private OnParameterChangeListener mParamListener;
    private final Object mParamListenerLock;
    private boolean mStrengthSupported;

    /*
     * Enabled aggressive block sorting
     */
    public BassBoost(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        Object object;
        UUID uUID = EFFECT_TYPE_BASS_BOOST;
        UUID uUID2 = EFFECT_TYPE_NULL;
        super(uUID, uUID2, n, n2);
        this.mStrengthSupported = false;
        this.mParamListener = null;
        this.mBaseParamListener = null;
        this.mParamListenerLock = object = new Object();
        int[] nArray = new int[1];
        int n3 = this.getParameter(0, nArray);
        this.checkStatus(n3);
        boolean bl = nArray[0] != 0;
        this.mStrengthSupported = bl;
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        Settings settings = new Settings();
        short[] sArray = null;
        int n = this.getParameter(1, sArray);
        this.checkStatus(n);
        void var4_4 = sArray[0];
        settings.strength = var4_4;
        return settings;
    }

    public short getRoundedStrength() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] sArray = null;
        int n = this.getParameter(1, sArray);
        this.checkStatus(n);
        return (short)sArray[0];
    }

    public boolean getStrengthSupported() {
        return this.mStrengthSupported;
    }

    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                BaseParameterListener baseParameterListener;
                this.mParamListener = onParameterChangeListener;
                BaseParameterListener baseParameterListener2 = this.mBaseParamListener = (baseParameterListener = new BaseParameterListener());
                super.setParameterListener(baseParameterListener2);
            }
            return;
        }
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short s = settings.strength;
        int n = this.setParameter(1, s);
        this.checkStatus(n);
    }

    public void setStrength(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int n = this.setParameter(1, s);
        this.checkStatus(n);
    }

    public static class Settings {
        public short strength;

        public Settings() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Settings(String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=;");
            int n = stringTokenizer.countTokens();
            if (stringTokenizer.countTokens() != 3) {
                String string3 = "settings: " + string2;
                throw new IllegalArgumentException(string3);
            }
            String string4 = stringTokenizer.nextToken();
            if (!string4.equals(BassBoost.TAG)) {
                String string5 = "invalid settings for BassBoost: " + string4;
                throw new IllegalArgumentException(string5);
            }
            try {
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("strength")) {
                    String string6 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string6);
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = "invalid value for key: " + string4;
                throw new IllegalArgumentException(string7);
            }
            {
                short s;
                this.strength = s = Short.parseShort(stringTokenizer.nextToken());
                return;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("BassBoost;strength=");
            String string2 = Short.toString(this.strength);
            String string3 = stringBuilder.append(string2).toString();
            return new String(string3);
        }
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            OnParameterChangeListener onParameterChangeListener = null;
            Object object = BassBoost.this.mParamListenerLock;
            // MONITORENTER : object
            if (BassBoost.this.mParamListener != null) {
                onParameterChangeListener = BassBoost.this.mParamListener;
            }
            // MONITOREXIT : object
            if (onParameterChangeListener == null) {
                return;
            }
            int n2 = -1;
            short s = -1;
            if (byArray.length == 4) {
                n2 = BassBoost.this.byteArrayToInt(byArray, 0);
            }
            if (byArray2.length == 2) {
                s = BassBoost.this.byteArrayToShort(byArray2, 0);
            }
            if (n2 == -1) {
                return;
            }
            if (s == -1) {
                return;
            }
            BassBoost bassBoost = BassBoost.this;
            onParameterChangeListener.onParameterChange(bassBoost, n, n2, s);
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(BassBoost var1, int var2, int var3, short var4);
    }
}

