/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import java.util.StringTokenizer;
import java.util.UUID;

public class EnvironmentalReverb
extends AudioEffect {
    public static final int PARAM_DECAY_HF_RATIO = 3;
    public static final int PARAM_DECAY_TIME = 2;
    public static final int PARAM_DENSITY = 9;
    public static final int PARAM_DIFFUSION = 8;
    private static final int PARAM_PROPERTIES = 10;
    public static final int PARAM_REFLECTIONS_DELAY = 5;
    public static final int PARAM_REFLECTIONS_LEVEL = 4;
    public static final int PARAM_REVERB_DELAY = 7;
    public static final int PARAM_REVERB_LEVEL = 6;
    public static final int PARAM_ROOM_HF_LEVEL = 1;
    public static final int PARAM_ROOM_LEVEL = 0;
    private static int PROPERTY_SIZE = 0;
    private static final String TAG = "EnvironmentalReverb";
    private BaseParameterListener mBaseParamListener;
    private OnParameterChangeListener mParamListener;
    private final Object mParamListenerLock;

    static {
        PROPERTY_SIZE = 26;
    }

    public EnvironmentalReverb(int n, int n2) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        Object object;
        UUID uUID = EFFECT_TYPE_ENV_REVERB;
        UUID uUID2 = EFFECT_TYPE_NULL;
        super(uUID, uUID2, n, n2);
        this.mParamListener = null;
        this.mBaseParamListener = null;
        this.mParamListenerLock = object = new Object();
    }

    public short getDecayHFRatio() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        int n = this.getParameter(3, byArray);
        this.checkStatus(n);
        return this.byteArrayToShort(byArray);
    }

    public int getDecayTime() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[4];
        int n = this.getParameter(2, byArray);
        this.checkStatus(n);
        return this.byteArrayToInt(byArray);
    }

    public short getDensity() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        int n = this.getParameter(9, byArray);
        this.checkStatus(n);
        return this.byteArrayToShort(byArray);
    }

    public short getDiffusion() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        int n = this.getParameter(8, byArray);
        this.checkStatus(n);
        return this.byteArrayToShort(byArray);
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short s;
        short s2;
        int n;
        short s3;
        int n2;
        short s4;
        short s5;
        int n3;
        short s6;
        short s7;
        byte[] byArray = new byte[PROPERTY_SIZE];
        int n4 = this.getParameter(10, byArray);
        this.checkStatus(n4);
        Settings settings = new Settings();
        settings.roomLevel = s7 = this.byteArrayToShort(byArray, 0);
        settings.roomHFLevel = s6 = this.byteArrayToShort(byArray, 2);
        settings.decayTime = n3 = this.byteArrayToInt(byArray, 4);
        settings.decayHFRatio = s5 = this.byteArrayToShort(byArray, 8);
        settings.reflectionsLevel = s4 = this.byteArrayToShort(byArray, 10);
        settings.reflectionsDelay = n2 = this.byteArrayToInt(byArray, 12);
        settings.reverbLevel = s3 = this.byteArrayToShort(byArray, 16);
        settings.reverbDelay = n = this.byteArrayToInt(byArray, 18);
        settings.diffusion = s2 = this.byteArrayToShort(byArray, 22);
        settings.density = s = this.byteArrayToShort(byArray, 24);
        return settings;
    }

    public int getReflectionsDelay() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[4];
        int n = this.getParameter(5, byArray);
        this.checkStatus(n);
        return this.byteArrayToInt(byArray);
    }

    public short getReflectionsLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        int n = this.getParameter(4, byArray);
        this.checkStatus(n);
        return this.byteArrayToShort(byArray);
    }

    public int getReverbDelay() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[4];
        int n = this.getParameter(7, byArray);
        this.checkStatus(n);
        return this.byteArrayToInt(byArray);
    }

    public short getReverbLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        int n = this.getParameter(6, byArray);
        this.checkStatus(n);
        return this.byteArrayToShort(byArray);
    }

    public short getRoomHFLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        int n = this.getParameter(1, byArray);
        this.checkStatus(n);
        return this.byteArrayToShort(byArray);
    }

    public short getRoomLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        int n = this.getParameter(0, byArray);
        this.checkStatus(n);
        return this.byteArrayToShort(byArray);
    }

    public void setDecayHFRatio(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = this.shortToByteArray(s);
        int n = this.setParameter(3, byArray);
        this.checkStatus(n);
    }

    public void setDecayTime(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = this.intToByteArray(n);
        int n2 = this.setParameter(2, byArray);
        this.checkStatus(n2);
    }

    public void setDensity(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = this.shortToByteArray(s);
        int n = this.setParameter(9, byArray);
        this.checkStatus(n);
    }

    public void setDiffusion(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = this.shortToByteArray(s);
        int n = this.setParameter(8, byArray);
        this.checkStatus(n);
    }

    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                BaseParameterListener baseParameterListener;
                this.mParamListener = onParameterChangeListener;
                BaseParameterListener baseParameterListener2 = this.mBaseParamListener = (baseParameterListener = new BaseParameterListener());
                super.setParameterListener(baseParameterListener2);
            }
            return;
        }
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[10];
        short s = settings.roomLevel;
        byte[] byArray2 = this.shortToByteArray(s);
        byArray[0] = (byte)byArray2;
        short s2 = settings.roomHFLevel;
        byte[] byArray3 = this.shortToByteArray(s2);
        byArray[1] = (byte)byArray3;
        int n = settings.decayTime;
        byte[] byArray4 = this.intToByteArray(n);
        byArray[2] = (byte)byArray4;
        short s3 = settings.decayHFRatio;
        byte[] byArray5 = this.shortToByteArray(s3);
        byArray[3] = (byte)byArray5;
        short s4 = settings.reflectionsLevel;
        byte[] byArray6 = this.shortToByteArray(s4);
        byArray[4] = (byte)byArray6;
        int n2 = settings.reflectionsDelay;
        byte[] byArray7 = this.intToByteArray(n2);
        byArray[5] = (byte)byArray7;
        short s5 = settings.reverbLevel;
        byte[] byArray8 = this.shortToByteArray(s5);
        byArray[6] = (byte)byArray8;
        int n3 = settings.reverbDelay;
        byte[] byArray9 = this.intToByteArray(n3);
        byArray[7] = (byte)byArray9;
        short s6 = settings.diffusion;
        byte[] byArray10 = this.shortToByteArray(s6);
        byArray[8] = (byte)byArray10;
        short s7 = settings.density;
        byte[] byArray11 = this.shortToByteArray(s7);
        byArray[9] = (byte)byArray11;
        byte[] byArray12 = this.concatArrays((byte[][])byArray);
        int n4 = this.setParameter(10, byArray12);
        this.checkStatus(n4);
    }

    public void setReflectionsDelay(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = this.intToByteArray(n);
        int n2 = this.setParameter(5, byArray);
        this.checkStatus(n2);
    }

    public void setReflectionsLevel(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = this.shortToByteArray(s);
        int n = this.setParameter(4, byArray);
        this.checkStatus(n);
    }

    public void setReverbDelay(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = this.intToByteArray(n);
        int n2 = this.setParameter(7, byArray);
        this.checkStatus(n2);
    }

    public void setReverbLevel(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = this.shortToByteArray(s);
        int n = this.setParameter(6, byArray);
        this.checkStatus(n);
    }

    public void setRoomHFLevel(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = this.shortToByteArray(s);
        int n = this.setParameter(1, byArray);
        this.checkStatus(n);
    }

    public void setRoomLevel(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = this.shortToByteArray(s);
        int n = this.setParameter(0, byArray);
        this.checkStatus(n);
    }

    public static class Settings {
        public short decayHFRatio;
        public int decayTime;
        public short density;
        public short diffusion;
        public int reflectionsDelay;
        public short reflectionsLevel;
        public int reverbDelay;
        public short reverbLevel;
        public short roomHFLevel;
        public short roomLevel;

        public Settings() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Settings(String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=;");
            int n = stringTokenizer.countTokens();
            if (stringTokenizer.countTokens() != 21) {
                String string3 = "settings: " + string2;
                throw new IllegalArgumentException(string3);
            }
            String string4 = stringTokenizer.nextToken();
            if (!string4.equals(EnvironmentalReverb.TAG)) {
                String string5 = "invalid settings for EnvironmentalReverb: " + string4;
                throw new IllegalArgumentException(string5);
            }
            try {
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("roomLevel")) {
                    String string6 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string6);
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = "invalid value for key: " + string4;
                throw new IllegalArgumentException(string7);
            }
            {
                short s;
                short s2;
                int n2;
                short s3;
                int n3;
                short s4;
                short s5;
                int n4;
                short s6;
                short s7;
                this.roomLevel = s7 = Short.parseShort(stringTokenizer.nextToken());
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("roomHFLevel")) {
                    String string8 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string8);
                }
                this.roomHFLevel = s6 = Short.parseShort(stringTokenizer.nextToken());
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("decayTime")) {
                    String string9 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string9);
                }
                this.decayTime = n4 = Integer.parseInt(stringTokenizer.nextToken());
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("decayHFRatio")) {
                    String string10 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string10);
                }
                this.decayHFRatio = s5 = Short.parseShort(stringTokenizer.nextToken());
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("reflectionsLevel")) {
                    String string11 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string11);
                }
                this.reflectionsLevel = s4 = Short.parseShort(stringTokenizer.nextToken());
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("reflectionsDelay")) {
                    String string12 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string12);
                }
                this.reflectionsDelay = n3 = Integer.parseInt(stringTokenizer.nextToken());
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("reverbLevel")) {
                    String string13 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string13);
                }
                this.reverbLevel = s3 = Short.parseShort(stringTokenizer.nextToken());
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("reverbDelay")) {
                    String string14 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string14);
                }
                this.reverbDelay = n2 = Integer.parseInt(stringTokenizer.nextToken());
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("diffusion")) {
                    String string15 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string15);
                }
                this.diffusion = s2 = Short.parseShort(stringTokenizer.nextToken());
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("density")) {
                    String string16 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string16);
                }
                this.density = s = Short.parseShort(stringTokenizer.nextToken());
                return;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("EnvironmentalReverb;roomLevel=");
            String string2 = Short.toString(this.roomLevel);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(";roomHFLevel=");
            String string3 = Short.toString(this.roomHFLevel);
            StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(";decayTime=");
            String string4 = Integer.toString(this.decayTime);
            StringBuilder stringBuilder4 = stringBuilder3.append(string4).append(";decayHFRatio=");
            String string5 = Short.toString(this.decayHFRatio);
            StringBuilder stringBuilder5 = stringBuilder4.append(string5).append(";reflectionsLevel=");
            String string6 = Short.toString(this.reflectionsLevel);
            StringBuilder stringBuilder6 = stringBuilder5.append(string6).append(";reflectionsDelay=");
            String string7 = Integer.toString(this.reflectionsDelay);
            StringBuilder stringBuilder7 = stringBuilder6.append(string7).append(";reverbLevel=");
            String string8 = Short.toString(this.reverbLevel);
            StringBuilder stringBuilder8 = stringBuilder7.append(string8).append(";reverbDelay=");
            String string9 = Integer.toString(this.reverbDelay);
            StringBuilder stringBuilder9 = stringBuilder8.append(string9).append(";diffusion=");
            String string10 = Short.toString(this.diffusion);
            StringBuilder stringBuilder10 = stringBuilder9.append(string10).append(";density=");
            String string11 = Short.toString(this.density);
            String string12 = stringBuilder10.append(string11).toString();
            return new String(string12);
        }
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            OnParameterChangeListener onParameterChangeListener = null;
            Object object = EnvironmentalReverb.this.mParamListenerLock;
            // MONITORENTER : object
            if (EnvironmentalReverb.this.mParamListener != null) {
                onParameterChangeListener = EnvironmentalReverb.this.mParamListener;
            }
            // MONITOREXIT : object
            if (onParameterChangeListener == null) {
                return;
            }
            int n2 = -1;
            int n3 = -1;
            if (byArray.length == 4) {
                n2 = EnvironmentalReverb.this.byteArrayToInt(byArray, 0);
            }
            if (byArray2.length == 2) {
                n3 = EnvironmentalReverb.this.byteArrayToShort(byArray2, 0);
            } else if (byArray2.length == 4) {
                n3 = EnvironmentalReverb.this.byteArrayToInt(byArray2, 0);
            }
            if (n2 == -1) {
                return;
            }
            if (n3 == -1) {
                return;
            }
            EnvironmentalReverb environmentalReverb = EnvironmentalReverb.this;
            onParameterChangeListener.onParameterChange(environmentalReverb, n, n2, n3);
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(EnvironmentalReverb var1, int var2, int var3, int var4);
    }
}

