/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.UUID;

public class Equalizer
extends AudioEffect {
    public static final int PARAM_BAND_FREQ_RANGE = 4;
    public static final int PARAM_BAND_LEVEL = 2;
    public static final int PARAM_CENTER_FREQ = 3;
    public static final int PARAM_CURRENT_PRESET = 6;
    public static final int PARAM_GET_BAND = 5;
    public static final int PARAM_GET_NUM_OF_PRESETS = 7;
    public static final int PARAM_GET_PRESET_NAME = 8;
    public static final int PARAM_LEVEL_RANGE = 1;
    public static final int PARAM_NUM_BANDS = 0;
    private static final int PARAM_PROPERTIES = 9;
    public static final int PARAM_STRING_SIZE_MAX = 32;
    private static final String TAG = "Equalizer";
    private BaseParameterListener mBaseParamListener;
    private short mNumBands;
    private int mNumPresets;
    private OnParameterChangeListener mParamListener;
    private final Object mParamListenerLock;
    private String[] mPresetNames;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Equalizer(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        Object object;
        UUID uUID = EFFECT_TYPE_EQUALIZER;
        UUID uUID2 = EFFECT_TYPE_NULL;
        super(uUID, uUID2, n, n2);
        this.mNumBands = 0;
        this.mParamListener = null;
        this.mBaseParamListener = null;
        this.mParamListenerLock = object = new Object();
        short s = this.getNumberOfBands();
        short s2 = this.getNumberOfPresets();
        this.mNumPresets = s2;
        if (this.mNumPresets == 0) {
            return;
        }
        String[] stringArray = new String[this.mNumPresets];
        this.mPresetNames = stringArray;
        byte[] byArray = new byte[32];
        int[] nArray = new int[2];
        nArray[0] = 8;
        int n3 = 0;
        int n4;
        while (n3 < (n4 = this.mNumPresets)) {
            nArray[1] = n3;
            int n5 = this.getParameter(nArray, byArray);
            this.checkStatus(n5);
            int n6 = 0;
            while (byArray[n6] != null) {
                ++n6;
            }
            try {
                String string2;
                String[] stringArray2 = this.mPresetNames;
                stringArray2[n3] = string2 = new String(byArray, 0, n6, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                int n7 = Log.e(TAG, "preset name decode error");
            }
            ++n3;
        }
        return;
    }

    public short getBand(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] nArray = new int[2];
        short[] sArray = null;
        nArray[0] = 5;
        nArray[1] = n;
        int n2 = this.getParameter(nArray, sArray);
        this.checkStatus(n2);
        return (short)sArray[0];
    }

    public int[] getBandFreqRange(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        nArray[0] = 4;
        nArray[1] = s;
        int n = this.getParameter(nArray, nArray2);
        this.checkStatus(n);
        return nArray2;
    }

    public short getBandLevel(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] nArray = new int[2];
        short[] sArray = null;
        nArray[0] = 2;
        nArray[1] = s;
        int n = this.getParameter(nArray, sArray);
        this.checkStatus(n);
        return (short)sArray[0];
    }

    public short[] getBandLevelRange() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] sArray = null;
        int n = this.getParameter(1, sArray);
        this.checkStatus(n);
        return sArray;
    }

    public int getCenterFreq(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] nArray = new int[2];
        int[] nArray2 = new int[1];
        nArray[0] = 3;
        nArray[1] = s;
        int n = this.getParameter(nArray, nArray2);
        this.checkStatus(n);
        return nArray2[0];
    }

    public short getCurrentPreset() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] sArray = null;
        int n = this.getParameter(6, sArray);
        this.checkStatus(n);
        return (short)sArray[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short getNumberOfBands() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (this.mNumBands != null) {
            return this.mNumBands;
        }
        int[] nArray = new int[]{0};
        short[] sArray = null;
        int n = this.getParameter(nArray, sArray);
        this.checkStatus(n);
        void var5_5 = sArray[0];
        this.mNumBands = var5_5;
        return this.mNumBands;
    }

    public short getNumberOfPresets() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] sArray = null;
        int n = this.getParameter(7, sArray);
        this.checkStatus(n);
        return (short)sArray[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPresetName(short s) {
        if (s < 0) return "";
        int n = this.mNumPresets;
        if (s >= n) return "";
        return this.mPresetNames[s];
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int n;
        short s;
        short s2;
        byte[] byArray = new byte[this.mNumBands * 2 + 4];
        int n2 = this.getParameter(9, byArray);
        this.checkStatus(n2);
        Settings settings = new Settings();
        settings.curPreset = s2 = this.byteArrayToShort(byArray, 0);
        settings.numBands = s = this.byteArrayToShort(byArray, 2);
        short s3 = this.mNumBands;
        settings.bandLevels = (short[])s3;
        for (int i = 0; i < (n = this.mNumBands); ++i) {
            short s4;
            short[] sArray = settings.bandLevels;
            int n3 = i * 2 + 4;
            sArray[i] = s4 = this.byteArrayToShort(byArray, n3);
        }
        return settings;
    }

    public void setBandLevel(short s, short s2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] nArray = new int[2];
        short[] sArray = null;
        nArray[0] = 2;
        nArray[1] = s;
        sArray[0] = s2;
        int n = this.setParameter(nArray, sArray);
        this.checkStatus(n);
    }

    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                BaseParameterListener baseParameterListener;
                this.mParamListener = onParameterChangeListener;
                BaseParameterListener baseParameterListener2 = this.mBaseParamListener = (baseParameterListener = new BaseParameterListener());
                super.setParameterListener(baseParameterListener2);
            }
            return;
        }
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int n;
        short s;
        short s2;
        short s3 = settings.numBands;
        int n2 = settings.bandLevels.length;
        if (s3 == n2 || (s2 = settings.numBands) != (s = this.mNumBands)) {
            StringBuilder stringBuilder = new StringBuilder().append("settings invalid band count: ");
            short s4 = settings.numBands;
            String string2 = stringBuilder.append(s4).toString();
            throw new IllegalArgumentException(string2);
        }
        byte[] byArray = new byte[2];
        short s5 = settings.curPreset;
        byte[] byArray2 = this.shortToByteArray(s5);
        byArray[0] = (byte)byArray2;
        short s6 = this.mNumBands;
        byte[] byArray3 = this.shortToByteArray(s6);
        byArray[1] = (byte)byArray3;
        byte[] byArray4 = this.concatArrays((byte[][])byArray);
        for (int i = 0; i < (n = this.mNumBands); ++i) {
            byte[] byArray5 = new byte[2];
            byArray5[0] = (byte)byArray4;
            short s7 = settings.bandLevels[i];
            byte[] byArray6 = this.shortToByteArray(s7);
            byArray5[1] = (byte)byArray6;
            byArray4 = this.concatArrays((byte[][])byArray5);
        }
        int n3 = this.setParameter(9, byArray4);
        this.checkStatus(n3);
    }

    public void usePreset(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int n = this.setParameter(6, s);
        this.checkStatus(n);
    }

    public static class Settings {
        public short[] bandLevels = null;
        public short curPreset;
        public short numBands = 0;

        public Settings() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Settings(String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=;");
            int n = stringTokenizer.countTokens();
            if (stringTokenizer.countTokens() < 5) {
                String string3 = "settings: " + string2;
                throw new IllegalArgumentException(string3);
            }
            String string4 = stringTokenizer.nextToken();
            if (!string4.equals(Equalizer.TAG)) {
                String string5 = "invalid settings for Equalizer: " + string4;
                throw new IllegalArgumentException(string5);
            }
            try {
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("curPreset")) {
                    String string6 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string6);
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = "invalid value for key: " + string4;
                throw new IllegalArgumentException(string7);
            }
            {
                int n2;
                short s;
                short s2;
                this.curPreset = s2 = Short.parseShort(stringTokenizer.nextToken());
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("numBands")) {
                    String string8 = "invalid key name: " + string4;
                    throw new IllegalArgumentException(string8);
                }
                this.numBands = s = Short.parseShort(stringTokenizer.nextToken());
                int n3 = stringTokenizer.countTokens();
                if (n3 != (n2 = this.numBands * 2)) {
                    String string9 = "settings: " + string2;
                    throw new IllegalArgumentException(string9);
                }
                short s3 = this.numBands;
                this.bandLevels = (short[])s3;
                int n4 = 0;
                int n5;
                while (n4 < (n5 = this.numBands)) {
                    short s4;
                    int n6;
                    StringBuilder stringBuilder;
                    String string10;
                    string4 = stringTokenizer.nextToken();
                    if (!string4.equals(string10 = (stringBuilder = new StringBuilder().append("band")).append(n6 = n4 + 1).append("Level").toString())) {
                        String string11 = "invalid key name: " + string4;
                        throw new IllegalArgumentException(string11);
                    }
                    short[] sArray = this.bandLevels;
                    sArray[n4] = s4 = Short.parseShort(stringTokenizer.nextToken());
                    ++n4;
                }
                return;
            }
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder().append("Equalizer;curPreset=");
            String string2 = Short.toString(this.curPreset);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(";numBands=");
            String string3 = Short.toString(this.numBands);
            String string4 = stringBuilder2.append(string3).toString();
            String string5 = new String(string4);
            for (int i = 0; i < (n = this.numBands); ++i) {
                StringBuilder stringBuilder3 = new StringBuilder().append(";band");
                int n2 = i + 1;
                StringBuilder stringBuilder4 = stringBuilder3.append(n2).append("Level=");
                String string6 = Short.toString(this.bandLevels[i]);
                String string7 = stringBuilder4.append(string6).toString();
                string5 = string5.concat(string7);
            }
            return string5;
        }
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            OnParameterChangeListener onParameterChangeListener = null;
            Object object = Equalizer.this.mParamListenerLock;
            // MONITORENTER : object
            if (Equalizer.this.mParamListener != null) {
                onParameterChangeListener = Equalizer.this.mParamListener;
            }
            // MONITOREXIT : object
            if (onParameterChangeListener == null) {
                return;
            }
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            if (byArray.length >= 4) {
                n2 = Equalizer.this.byteArrayToInt(byArray, 0);
                if (byArray.length >= 8) {
                    n3 = Equalizer.this.byteArrayToInt(byArray, 4);
                }
            }
            if (byArray2.length == 2) {
                n4 = Equalizer.this.byteArrayToShort(byArray2, 0);
            } else if (byArray2.length == 4) {
                n4 = Equalizer.this.byteArrayToInt(byArray2, 0);
            }
            if (n2 == -1) {
                return;
            }
            if (n4 == -1) {
                return;
            }
            Equalizer equalizer = Equalizer.this;
            int n5 = n;
            onParameterChangeListener.onParameterChange(equalizer, n5, n2, n3, n4);
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(Equalizer var1, int var2, int var3, int var4, int var5);
    }
}

