/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;

public class Visualizer {
    public static final int ALREADY_EXISTS = 254;
    public static final int ERROR = 255;
    public static final int ERROR_BAD_VALUE = 252;
    public static final int ERROR_DEAD_OBJECT = 249;
    public static final int ERROR_INVALID_OPERATION = 251;
    public static final int ERROR_NO_INIT = 253;
    public static final int ERROR_NO_MEMORY = 250;
    private static final int NATIVE_EVENT_FFT_CAPTURE = 1;
    private static final int NATIVE_EVENT_PCM_CAPTURE = 0;
    public static final int STATE_ENABLED = 2;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int SUCCESS = 0;
    private static final String TAG = "Visualizer-JAVA";
    private OnDataCaptureListener mCaptureListener;
    private int mId;
    private int mJniData;
    private final Object mListenerLock;
    private NativeEventHandler mNativeEventHandler;
    private int mNativeVisualizer;
    private int mState = 0;
    private final Object mStateLock;

    static {
        System.loadLibrary("audioeffect_jni");
        Visualizer.native_init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Visualizer(int n) throws UnsupportedOperationException, RuntimeException {
        Object object;
        Object object2;
        this.mStateLock = object2 = new Object();
        this.mListenerLock = object = new Object();
        this.mNativeEventHandler = null;
        this.mCaptureListener = null;
        int[] nArray = new int[1];
        Object object3 = this.mStateLock;
        synchronized (object3) {
            int n2;
            this.mState = 0;
            WeakReference<Visualizer> weakReference = new WeakReference<Visualizer>(this);
            int n3 = this.native_setup(weakReference, n, nArray);
            if (n3 != 0 && n3 != -1) {
                String string2 = "Error code " + n3 + " when initializing Visualizer.";
                int n4 = Log.e(TAG, string2);
                switch (n3) {
                    default: {
                        String string3 = "Cannot initialize Visualizer engine, error: " + n3;
                        throw new RuntimeException(string3);
                    }
                    case -5: 
                }
                throw new UnsupportedOperationException("Effect library not loaded");
            }
            this.mId = n2 = nArray[0];
            this.mState = this.native_getEnabled() ? 2 : 1;
            return;
        }
    }

    public static native int[] getCaptureSizeRange();

    public static native int getMaxCaptureRate();

    private final native void native_finalize();

    private final native int native_getCaptureSize();

    private final native boolean native_getEnabled();

    private final native int native_getFft(byte[] var1);

    private final native int native_getSamplingRate();

    private final native int native_getWaveForm(byte[] var1);

    private static final native void native_init();

    private final native void native_release();

    private final native int native_setCaptureSize(int var1);

    private final native int native_setEnabled(boolean var1);

    private final native int native_setPeriodicCapture(int var1, boolean var2, boolean var3);

    private final native int native_setup(Object var1, int var2, int[] var3);

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        Visualizer visualizer = (Visualizer)((WeakReference)object).get();
        if (visualizer == null) {
            return;
        }
        if (visualizer.mNativeEventHandler == null) {
            return;
        }
        Message message = visualizer.mNativeEventHandler.obtainMessage(n, n2, n3, object2);
        boolean bl = visualizer.mNativeEventHandler.sendMessage(message);
    }

    protected void finalize() {
        this.native_finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCaptureSize() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 0) return this.native_getCaptureSize();
            StringBuilder stringBuilder = new StringBuilder().append("getCaptureSize() called in wrong state: ");
            int n = this.mState;
            String string2 = stringBuilder.append(n).toString();
            throw new IllegalStateException(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getEnabled() {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 0) return this.native_getEnabled();
            StringBuilder stringBuilder = new StringBuilder().append("getEnabled() called in wrong state: ");
            int n = this.mState;
            String string2 = stringBuilder.append(n).toString();
            throw new IllegalStateException(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getFft(byte[] byArray) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 2) return this.native_getFft(byArray);
            StringBuilder stringBuilder = new StringBuilder().append("getFft() called in wrong state: ");
            int n = this.mState;
            String string2 = stringBuilder.append(n).toString();
            throw new IllegalStateException(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSamplingRate() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 0) return this.native_getSamplingRate();
            StringBuilder stringBuilder = new StringBuilder().append("getSamplingRate() called in wrong state: ");
            int n = this.mState;
            String string2 = stringBuilder.append(n).toString();
            throw new IllegalStateException(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getWaveForm(byte[] byArray) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 2) return this.native_getWaveForm(byArray);
            StringBuilder stringBuilder = new StringBuilder().append("getWaveForm() called in wrong state: ");
            int n = this.mState;
            String string2 = stringBuilder.append(n).toString();
            throw new IllegalStateException(string2);
        }
    }

    public void release() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.native_release();
            this.mState = 0;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setCaptureSize(int n) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 1) return this.native_setCaptureSize(n);
            StringBuilder stringBuilder = new StringBuilder().append("setCaptureSize() called in wrong state: ");
            int n2 = this.mState;
            String string2 = stringBuilder.append(n2).toString();
            throw new IllegalStateException(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int setDataCaptureListener(OnDataCaptureListener onDataCaptureListener, int n, boolean bl, boolean bl2) {
        int n2;
        Object object = this.mListenerLock;
        // MONITORENTER : object
        this.mCaptureListener = onDataCaptureListener;
        // MONITOREXIT : object
        if (onDataCaptureListener == null) {
            bl = false;
            bl2 = false;
        }
        if ((n2 = this.native_setPeriodicCapture(n, bl, bl2)) != 0) return n2;
        if (onDataCaptureListener == null) return n2;
        if (this.mNativeEventHandler != null) return n2;
        Looper looper = Looper.myLooper();
        if (looper != null) {
            NativeEventHandler nativeEventHandler;
            this.mNativeEventHandler = nativeEventHandler = new NativeEventHandler(this, looper);
            return n2;
        }
        looper = Looper.getMainLooper();
        if (looper != null) {
            NativeEventHandler nativeEventHandler;
            this.mNativeEventHandler = nativeEventHandler = new NativeEventHandler(this, looper);
            return n2;
        }
        this.mNativeEventHandler = null;
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setEnabled(boolean bl) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                StringBuilder stringBuilder = new StringBuilder().append("setEnabled() called in wrong state: ");
                int n = this.mState;
                String string2 = stringBuilder.append(n).toString();
                throw new IllegalStateException(string2);
            }
            int n = 0;
            if ((bl && this.mState == 1 || !bl && this.mState == 2) && (n = this.native_setEnabled(bl)) == 0) {
                int n2 = bl ? 2 : 1;
                this.mState = n2;
            }
            return n;
        }
    }

    private class NativeEventHandler
    extends Handler {
        private Visualizer mVisualizer;

        public NativeEventHandler(Visualizer visualizer2, Looper looper) {
            super(looper);
            this.mVisualizer = visualizer2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message message) {
            if (this.mVisualizer == null) {
                return;
            }
            Object object = Visualizer.this.mListenerLock;
            // MONITORENTER : object
            OnDataCaptureListener onDataCaptureListener = this.mVisualizer.mCaptureListener;
            // MONITOREXIT : object
            if (onDataCaptureListener == null) {
                return;
            }
            byte[] byArray = (byte[])message.obj;
            int n = message.arg1;
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown native event: ");
                    int n2 = message.what;
                    String string2 = stringBuilder.append(n2).toString();
                    int n3 = Log.e(Visualizer.TAG, string2);
                    return;
                }
                case 0: {
                    Visualizer visualizer = this.mVisualizer;
                    onDataCaptureListener.onWaveFormDataCapture(visualizer, byArray, n);
                    return;
                }
                case 1: 
            }
            Visualizer visualizer = this.mVisualizer;
            onDataCaptureListener.onFftDataCapture(visualizer, byArray, n);
        }
    }

    public static interface OnDataCaptureListener {
        public void onFftDataCapture(Visualizer var1, byte[] var2, int var3);

        public void onWaveFormDataCapture(Visualizer var1, byte[] var2, int var3);
    }
}

