/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IConnectivityManager;
import android.net.NetworkInfo;
import android.os.Binder;
import android.os.RemoteException;

public class ConnectivityManager {
    public static final String ACTION_BACKGROUND_DATA_SETTING_CHANGED = "android.net.conn.BACKGROUND_DATA_SETTING_CHANGED";
    public static final String ACTION_TETHER_STATE_CHANGED = "android.net.conn.TETHER_STATE_CHANGED";
    public static final String CONNECTIVITY_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
    public static final int DEFAULT_NETWORK_PREFERENCE = 1;
    public static final String EXTRA_ACTIVE_TETHER = "activeArray";
    public static final String EXTRA_AVAILABLE_TETHER = "availableArray";
    public static final String EXTRA_ERRORED_TETHER = "erroredArray";
    public static final String EXTRA_EXTRA_INFO = "extraInfo";
    public static final String EXTRA_INET_CONDITION = "inetCondition";
    public static final String EXTRA_IS_FAILOVER = "isFailover";
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_NO_CONNECTIVITY = "noConnectivity";
    public static final String EXTRA_OTHER_NETWORK_INFO = "otherNetwork";
    public static final String EXTRA_REASON = "reason";
    public static final String INET_CONDITION_ACTION = "android.net.conn.INET_CONDITION_ACTION";
    public static final int MAX_NETWORK_TYPE = 5;
    public static final int MAX_RADIO_TYPE = 1;
    public static final int TETHER_ERROR_DISABLE_NAT_ERROR = 9;
    public static final int TETHER_ERROR_ENABLE_NAT_ERROR = 8;
    public static final int TETHER_ERROR_IFACE_CFG_ERROR = 10;
    public static final int TETHER_ERROR_MASTER_ERROR = 5;
    public static final int TETHER_ERROR_NO_ERROR = 0;
    public static final int TETHER_ERROR_SERVICE_UNAVAIL = 2;
    public static final int TETHER_ERROR_TETHER_IFACE_ERROR = 6;
    public static final int TETHER_ERROR_UNAVAIL_IFACE = 4;
    public static final int TETHER_ERROR_UNKNOWN_IFACE = 1;
    public static final int TETHER_ERROR_UNSUPPORTED = 3;
    public static final int TETHER_ERROR_UNTETHER_IFACE_ERROR = 7;
    public static final int TYPE_BLUETOOTH = 7;
    public static final int TYPE_DUMMY = 8;
    public static final int TYPE_ETHERNET = 9;
    public static final int TYPE_MOBILE = 0;
    public static final int TYPE_MOBILE_DUN = 4;
    public static final int TYPE_MOBILE_HIPRI = 5;
    public static final int TYPE_MOBILE_MMS = 2;
    public static final int TYPE_MOBILE_SUPL = 3;
    public static final int TYPE_WIFI = 1;
    public static final int TYPE_WIMAX = 6;
    private IConnectivityManager mService;

    private ConnectivityManager() {
    }

    public ConnectivityManager(IConnectivityManager iConnectivityManager) {
        if (iConnectivityManager == null) {
            throw new IllegalArgumentException("ConnectivityManager() cannot be constructed with null service");
        }
        this.mService = iConnectivityManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNetworkTypeValid(int n) {
        if (n < 0) return false;
        if (n > 5) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NetworkInfo getActiveNetworkInfo() {
        try {
            NetworkInfo networkInfo = this.mService.getActiveNetworkInfo();
            return networkInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NetworkInfo[] getAllNetworkInfo() {
        try {
            NetworkInfo[] networkInfoArray = this.mService.getAllNetworkInfo();
            return networkInfoArray;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBackgroundDataSetting() {
        try {
            boolean bl = this.mService.getBackgroundDataSetting();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLastTetherError(String string2) {
        try {
            int n = this.mService.getLastTetherError(string2);
            return n;
        }
        catch (RemoteException remoteException) {
            return 2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getMobileDataEnabled() {
        try {
            boolean bl = this.mService.getMobileDataEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NetworkInfo getNetworkInfo(int n) {
        try {
            NetworkInfo networkInfo = this.mService.getNetworkInfo(n);
            return networkInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNetworkPreference() {
        try {
            int n = this.mService.getNetworkPreference();
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getTetherableIfaces() {
        try {
            String[] stringArray = this.mService.getTetherableIfaces();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getTetherableUsbRegexs() {
        try {
            String[] stringArray = this.mService.getTetherableUsbRegexs();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getTetherableWifiRegexs() {
        try {
            String[] stringArray = this.mService.getTetherableWifiRegexs();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getTetheredIfaces() {
        try {
            String[] stringArray = this.mService.getTetheredIfaces();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getTetheringErroredIfaces() {
        try {
            String[] stringArray = this.mService.getTetheringErroredIfaces();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTetheringSupported() {
        try {
            boolean bl = this.mService.isTetheringSupported();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void reportInetCondition(int n, int n2) {
        try {
            this.mService.reportInetCondition(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean requestRouteToHost(int n, int n2) {
        try {
            boolean bl = this.mService.requestRouteToHost(n, n2);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void setBackgroundDataSetting(boolean bl) {
        try {
            this.mService.setBackgroundDataSetting(bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setMobileDataEnabled(boolean bl) {
        try {
            this.mService.setMobileDataEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setNetworkPreference(int n) {
        try {
            this.mService.setNetworkPreference(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setRadio(int n, boolean bl) {
        try {
            boolean bl2 = this.mService.setRadio(n, bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setRadios(boolean bl) {
        try {
            boolean bl2 = this.mService.setRadios(bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int startUsingNetworkFeature(int n, String string2) {
        try {
            IConnectivityManager iConnectivityManager = this.mService;
            Binder binder = new Binder();
            int n2 = iConnectivityManager.startUsingNetworkFeature(n, string2, binder);
            return n2;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int stopUsingNetworkFeature(int n, String string2) {
        try {
            int n2 = this.mService.stopUsingNetworkFeature(n, string2);
            return n2;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int tether(String string2) {
        try {
            int n = this.mService.tether(string2);
            return n;
        }
        catch (RemoteException remoteException) {
            return 2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int untether(String string2) {
        try {
            int n = this.mService.untether(string2);
            return n;
        }
        catch (RemoteException remoteException) {
            return 2;
        }
    }
}

