/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.provider.Downloads;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class Downloads {
    public static final String ACTION_DOWNLOAD_COMPLETED = "android.intent.action.DOWNLOAD_COMPLETED";
    public static final String COLUMN_NOTIFICATION_EXTRAS = "notificationextras";
    private static final int DOWNLOADS_COLUMN_CURRENT_BYTES = 5;
    private static final int DOWNLOADS_COLUMN_FILENAME = 3;
    private static final int DOWNLOADS_COLUMN_ID = 0;
    private static final int DOWNLOADS_COLUMN_LAST_MODIFICATION = 4;
    private static final int DOWNLOADS_COLUMN_STATUS = 2;
    private static final int DOWNLOADS_COLUMN_URI = 1;
    private static final String[] DOWNLOADS_PROJECTION;
    public static final int DOWNLOAD_DESTINATION_CACHE = 2;
    public static final int DOWNLOAD_DESTINATION_CACHE_PURGEABLE = 3;
    public static final int DOWNLOAD_DESTINATION_EXTERNAL = 1;
    public static final long DOWNLOAD_ID_INVALID = 255L;
    public static final int STATUS_DEVICE_NOT_FOUND_ERROR = 499;
    private static final int STATUS_DOWNLOADED_UPDATE = 4;
    private static final int STATUS_DOWNLOADING_UPDATE = 3;
    public static final int STATUS_INSUFFICIENT_SPACE_ERROR = 498;
    private static final int STATUS_INVALID = 0;
    public static final int STATUS_NOT_ACCEPTABLE = 406;
    public static final int STATUS_PENDING = 190;
    public static final int STATUS_RUNNING = 192;
    public static final int STATUS_SUCCESS = 200;
    public static final int STATUS_UNHANDLED_REDIRECT = 493;
    public static final int STATUS_UNKNOWN_ERROR = 491;

    static {
        String[] stringArray = new String[]{"_id", "entity", "status", "_data", "lastmod", "current_bytes"};
        DOWNLOADS_PROJECTION = stringArray;
    }

    private Downloads() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int getStatusOfDownload(Cursor cursor, long l) {
        int n = cursor.getInt(2);
        long l2 = SystemClock.elapsedRealtime();
        if (!Downloads.Impl.isStatusCompleted(n)) {
            long l3 = cursor.getLong(4);
            long l4 = System.currentTimeMillis();
            if (l4 < l3) return 0;
            if (l4 - l3 <= l) return 3;
            return 0;
        }
        if (Downloads.Impl.isStatusError(n)) {
            return 0;
        }
        if (cursor.getString(3) != null) return 4;
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isStatusError(int n) {
        if (n < 400) return false;
        if (n >= 600) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isStatusSuccess(int n) {
        if (n < 200) return false;
        if (n >= 300) return false;
        return true;
    }

    public static class DownloadBase {
        DownloadBase() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public static long startDownloadByUri(Context context, String string2, String string3, boolean bl, int n, boolean bl2, boolean bl3, String string4, String string5, String string6, String string7) {
            ContentResolver contentResolver = context.getContentResolver();
            ContentValues contentValues = new ContentValues();
            contentValues.put("uri", string2);
            contentValues.put("cookiedata", string3);
            int n2 = bl ? 0 : 2;
            Integer n3 = n2;
            contentValues.put("visibility", n3);
            if (string4 != null) {
                contentValues.put("title", string4);
            }
            contentValues.put("entity", string2);
            int n4 = 0;
            switch (n) {
                case 1: {
                    n4 = 0;
                    break;
                }
                case 2: {
                    if (bl2) {
                        n4 = 1;
                        break;
                    }
                    n4 = 3;
                    break;
                }
                case 3: {
                    n4 = 2;
                    break;
                }
            }
            Integer n5 = n4;
            contentValues.put("destination", n5);
            Boolean bl4 = bl3;
            contentValues.put("no_integrity", bl4);
            if (string5 != null && string6 != null) {
                contentValues.put("notificationpackage", string5);
                contentValues.put("notificationclass", string6);
                if (string7 != null) {
                    contentValues.put(Downloads.COLUMN_NOTIFICATION_EXTRAS, string7);
                }
            }
            Uri uri = Downloads.Impl.CONTENT_URI;
            Uri uri2 = contentResolver.insert(uri, contentValues);
            long l = 65535L;
            if (uri2 == null) return l;
            return Long.parseLong(uri2.getLastPathSegment());
        }
    }

    public static final class ById
    extends DownloadBase {
        private ById() {
        }

        public static void deleteDownload(Context context, long l) {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = ById.getDownloadUri(l);
            int n = contentResolver.delete(uri, null, null);
        }

        private static Uri getDownloadUri(long l) {
            StringBuilder stringBuilder = new StringBuilder();
            Uri uri = Downloads.Impl.CONTENT_URI;
            return Uri.parse(stringBuilder.append(uri).append("/").append(l).toString());
        }

        /*
         * Exception decompiling
         */
        public static String getMimeTypeForId(Context var0, long var1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static final StatusInfo getStatus(Context context, long l) {
            long l2;
            int n;
            long l3;
            StatusInfo statusInfo;
            Cursor cursor;
            block9: {
                long l4;
                int n2;
                long l5;
                String string2;
                StatusInfo statusInfo2;
                Uri uri = ById.getDownloadUri(l);
                ContentResolver contentResolver = context.getContentResolver();
                String[] stringArray = DOWNLOADS_PROJECTION;
                cursor = contentResolver.query(uri, stringArray, null, null, null);
                boolean bl = cursor.moveToNext();
                if (!bl) {
                    if (cursor == null) return null;
                    cursor.close();
                    return null;
                }
                statusInfo = statusInfo2 = new StatusInfo();
                l3 = 0L;
                l3 = Downloads.getStatusOfDownload(cursor, l3);
                if (l3 != 3 && l3 != 4) break block9;
                l3 = l3 == 4 ? (long)1 : (long)0;
                statusInfo.completed = l3;
                statusInfo.filename = string2 = cursor.getString(3);
                statusInfo.id = l5 = cursor.getLong(0);
                statusInfo.statusCode = n2 = cursor.getInt(2);
                statusInfo.bytesSoFar = l4 = cursor.getLong(5);
                if (cursor != null) {
                    cursor.close();
                }
                StatusInfo statusInfo3 = statusInfo;
                return statusInfo;
            }
            l3 = 4;
            long l6 = cursor.getLong((int)l3);
            statusInfo.statusCode = n = cursor.getInt(2);
            statusInfo.bytesSoFar = l2 = cursor.getLong(5);
            if (cursor != null) {
                cursor.close();
            }
            StatusInfo statusInfo4 = statusInfo;
            return statusInfo;
            catch (Throwable throwable) {
                void var24_23;
                block10: {
                    boolean bl = false;
                    break block10;
                    catch (Throwable throwable2) {
                        StatusInfo statusInfo5 = statusInfo;
                    }
                }
                if (cursor == null) throw var24_23;
                cursor.close();
                throw var24_23;
            }
        }

        public static ParcelFileDescriptor openDownload(Context context, long l, String string2) throws FileNotFoundException {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = ById.getDownloadUri(l);
            return contentResolver.openFileDescriptor(uri, string2);
        }

        public static InputStream openDownloadStream(Context context, long l) throws FileNotFoundException, IOException {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = ById.getDownloadUri(l);
            return contentResolver.openInputStream(uri);
        }
    }

    public static final class ByUri
    extends DownloadBase {
        private static final String[] PROJECTION;
        private static final String QUERY_WHERE_APP_DATA_CLAUSE = "entity=?";
        private static final String QUERY_WHERE_CLAUSE = "notificationpackage=? AND notificationclass=?";

        static {
            String[] stringArray = new String[]{"_id", "current_bytes", "total_bytes"};
            PROJECTION = stringArray;
        }

        private ByUri() {
        }

        private static final Cursor getCurrentOtaDownloads(Context context, String string2) {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = Downloads.Impl.CONTENT_URI;
            String[] stringArray = DOWNLOADS_PROJECTION;
            String[] stringArray2 = new String[]{string2};
            return contentResolver.query(uri, stringArray, QUERY_WHERE_APP_DATA_CLAUSE, stringArray2, null);
        }

        public static final int getProgressColumnCurrentBytes() {
            return 1;
        }

        public static final int getProgressColumnId() {
            return 0;
        }

        public static final int getProgressColumnTotalBytes() {
            return 2;
        }

        public static final Cursor getProgressCursor(Context context, long l) {
            Uri uri = Downloads.Impl.CONTENT_URI;
            String string2 = String.valueOf(l);
            Uri uri2 = Uri.withAppendedPath(uri, string2);
            ContentResolver contentResolver = context.getContentResolver();
            String[] stringArray = PROJECTION;
            String[] stringArray2 = null;
            String string3 = null;
            return contentResolver.query(uri2, stringArray, null, stringArray2, string3);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static final StatusInfo getStatus(Context context, String string2, long l) {
            Object object;
            boolean bl = false;
            long l2 = 0L;
            Cursor cursor = ByUri.getCurrentOtaDownloads(context, string2);
            boolean bl2 = false;
            while (cursor != null) {
                long l3;
                int n;
                Object object2;
                block11: {
                    if (!cursor.moveToNext()) break;
                    if (bl == null) {
                        object2 = new StatusInfo();
                        object = object2;
                        break block11;
                    }
                    object = bl;
                }
                int n2 = Downloads.getStatusOfDownload(cursor, l);
                if (n2 == 3 || n2 == 4) {
                    long l4;
                    int n3;
                    long l5;
                    String string3;
                    l = n2 == 4 ? (long)1 : (long)0;
                    object.completed = l;
                    object.filename = string3 = cursor.getString(3);
                    object.id = l5 = cursor.getLong(0);
                    object.statusCode = n3 = cursor.getInt(2);
                    object.bytesSoFar = l4 = cursor.getLong(5);
                    if (cursor != null) {
                        cursor.close();
                    }
                    Object object3 = object;
                    return object;
                }
                n2 = 4;
                object2 = cursor.getLong(n2);
                if (l2 != false && object2 < l2) {
                    bl = object;
                    continue;
                }
                boolean bl3 = true;
                Object object4 = object2;
                object.statusCode = n = cursor.getInt(2);
                object.bytesSoFar = l3 = cursor.getLong(5);
                bl = object;
            }
            if (cursor != null) {
                cursor.close();
            }
            boolean bl4 = bl;
            return bl;
            catch (Throwable throwable) {
                Throwable throwable2;
                block12: {
                    long l6 = l2;
                    long l7 = l2;
                    throwable2 = throwable;
                    boolean bl5 = bl;
                    long l8 = l7;
                    break block12;
                    catch (Throwable throwable3) {
                        long l9 = l2;
                        long l10 = l2;
                        throwable2 = throwable3;
                        Object object5 = object;
                        long l11 = l10;
                    }
                }
                if (cursor == null) throw throwable2;
                cursor.close();
                throw throwable2;
            }
        }

        public static final void removeAllDownloadsByPackage(Context context, String string2, String string3) {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = Downloads.Impl.CONTENT_URI;
            String[] stringArray = new String[]{string2, string3};
            int n = contentResolver.delete(uri, QUERY_WHERE_CLAUSE, stringArray);
        }
    }

    public static final class StatusInfo {
        public long bytesSoFar = 65535L;
        public boolean completed = false;
        public String filename = null;
        public long id = 65535L;
        public int statusCode = -1;

        public boolean isComplete() {
            return Downloads.Impl.isStatusCompleted(this.statusCode);
        }

        public boolean isSuccessful() {
            return Downloads.Impl.isStatusCompleted(this.statusCode);
        }
    }
}

