/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Credentials;
import android.net.LocalSocketAddress;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class LocalSocketImpl {
    private FileDescriptor fd;
    private SocketInputStream fis;
    private SocketOutputStream fos;
    FileDescriptor[] inboundFileDescriptors;
    FileDescriptor[] outboundFileDescriptors;
    private Object readMonitor;
    private Object writeMonitor;

    LocalSocketImpl() {
        Object object;
        Object object2;
        this.readMonitor = object2 = new Object();
        this.writeMonitor = object = new Object();
    }

    LocalSocketImpl(FileDescriptor fileDescriptor) throws IOException {
        Object object;
        Object object2;
        this.readMonitor = object2 = new Object();
        this.writeMonitor = object = new Object();
        this.fd = fileDescriptor;
    }

    private native FileDescriptor accept(FileDescriptor var1, LocalSocketImpl var2) throws IOException;

    private native int available_native(FileDescriptor var1) throws IOException;

    private native void bindLocal(FileDescriptor var1, String var2, int var3) throws IOException;

    private native void close_native(FileDescriptor var1) throws IOException;

    private native void connectLocal(FileDescriptor var1, String var2, int var3) throws IOException;

    private native FileDescriptor create_native(boolean var1) throws IOException;

    private native int getOption_native(FileDescriptor var1, int var2) throws IOException;

    private native Credentials getPeerCredentials_native(FileDescriptor var1) throws IOException;

    private native void listen_native(FileDescriptor var1, int var2) throws IOException;

    private native int read_native(FileDescriptor var1) throws IOException;

    private native int readba_native(byte[] var1, int var2, int var3, FileDescriptor var4) throws IOException;

    private native void setOption_native(FileDescriptor var1, int var2, int var3, int var4) throws IOException;

    private native void shutdown(FileDescriptor var1, boolean var2);

    private native void write_native(int var1, FileDescriptor var2) throws IOException;

    private native void writeba_native(byte[] var1, int var2, int var3, FileDescriptor var4) throws IOException;

    protected void accept(LocalSocketImpl localSocketImpl) throws IOException {
        FileDescriptor fileDescriptor;
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        FileDescriptor fileDescriptor2 = this.fd;
        localSocketImpl.fd = fileDescriptor = this.accept(fileDescriptor2, localSocketImpl);
    }

    protected int available() throws IOException {
        return this.getInputStream().available();
    }

    public void bind(LocalSocketAddress localSocketAddress) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        FileDescriptor fileDescriptor = this.fd;
        String string2 = localSocketAddress.getName();
        int n = localSocketAddress.getNamespace().getId();
        this.bindLocal(fileDescriptor, string2, n);
    }

    public void close() throws IOException {
        synchronized (this) {
            if (this.fd == null) {
                return;
            }
            FileDescriptor fileDescriptor = this.fd;
            this.close_native(fileDescriptor);
            this.fd = null;
            return;
        }
    }

    protected void connect(LocalSocketAddress localSocketAddress, int n) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        FileDescriptor fileDescriptor = this.fd;
        String string2 = localSocketAddress.getName();
        int n2 = localSocketAddress.getNamespace().getId();
        this.connectLocal(fileDescriptor, string2, n2);
    }

    public void create(boolean bl) throws IOException {
        FileDescriptor fileDescriptor;
        if (this.fd != null) {
            return;
        }
        this.fd = fileDescriptor = this.create_native(bl);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public FileDescriptor[] getAncillaryFileDescriptors() throws IOException {
        Object object = this.readMonitor;
        synchronized (object) {
            FileDescriptor[] fileDescriptorArray = this.inboundFileDescriptors;
            this.inboundFileDescriptors = null;
            return fileDescriptorArray;
        }
    }

    protected FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    protected InputStream getInputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        synchronized (this) {
            if (this.fis == null) {
                SocketInputStream socketInputStream;
                this.fis = socketInputStream = new SocketInputStream();
            }
            SocketInputStream socketInputStream = this.fis;
            return socketInputStream;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getOption(int n) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        if (n == 4102) {
            return 0;
        }
        FileDescriptor fileDescriptor = this.fd;
        int n2 = this.getOption_native(fileDescriptor, n);
        switch (n) {
            default: {
                return n2;
            }
            case 4097: 
            case 4098: 
        }
        return n2;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        synchronized (this) {
            if (this.fos == null) {
                SocketOutputStream socketOutputStream;
                this.fos = socketOutputStream = new SocketOutputStream();
            }
            SocketOutputStream socketOutputStream = this.fos;
            return socketOutputStream;
        }
    }

    public Credentials getPeerCredentials() throws IOException {
        FileDescriptor fileDescriptor = this.fd;
        return this.getPeerCredentials_native(fileDescriptor);
    }

    public LocalSocketAddress getSockAddress() throws IOException {
        return null;
    }

    protected void listen(int n) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        FileDescriptor fileDescriptor = this.fd;
        this.listen_native(fileDescriptor, n);
    }

    protected void sendUrgentData(int n) throws IOException {
        throw new RuntimeException("not impled");
    }

    public void setFileDescriptorsForSend(FileDescriptor[] fileDescriptorArray) {
        Object object = this.writeMonitor;
        synchronized (object) {
            this.outboundFileDescriptors = fileDescriptorArray;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setOption(int n, Object object) throws IOException {
        int n2 = -1;
        int n3 = 0;
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        if (object instanceof Integer) {
            n3 = (Integer)object;
        } else {
            if (!(object instanceof Boolean)) {
                String string2 = "bad value: " + object;
                throw new IOException(string2);
            }
            n2 = (Boolean)object != false ? 1 : 0;
        }
        FileDescriptor fileDescriptor = this.fd;
        this.setOption_native(fileDescriptor, n, n2, n3);
    }

    protected void shutdownInput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        FileDescriptor fileDescriptor = this.fd;
        this.shutdown(fileDescriptor, true);
    }

    protected void shutdownOutput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        FileDescriptor fileDescriptor = this.fd;
        this.shutdown(fileDescriptor, false);
    }

    protected boolean supportsUrgentData() {
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = super.toString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" fd:");
        FileDescriptor fileDescriptor = this.fd;
        return stringBuilder2.append(fileDescriptor).toString();
    }

    class SocketOutputStream
    extends OutputStream {
        SocketOutputStream() {
        }

        @Override
        public void close() throws IOException {
            LocalSocketImpl.this.close();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void write(int n) throws IOException {
            Object object = LocalSocketImpl.this.writeMonitor;
            synchronized (object) {
                FileDescriptor fileDescriptor = LocalSocketImpl.this.fd;
                if (fileDescriptor == null) {
                    throw new IOException("socket closed");
                }
                LocalSocketImpl.this.write_native(n, fileDescriptor);
                return;
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            int n = byArray.length;
            this.write(byArray, 0, n);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Object object = LocalSocketImpl.this.writeMonitor;
            synchronized (object) {
                int n3;
                int n4;
                FileDescriptor fileDescriptor = LocalSocketImpl.this.fd;
                if (fileDescriptor == null) {
                    throw new IOException("socket closed");
                }
                if (n >= 0 && n2 >= 0 && (n4 = n + n2) <= (n3 = byArray.length)) {
                    LocalSocketImpl.this.writeba_native(byArray, n, n2, fileDescriptor);
                    return;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    class SocketInputStream
    extends InputStream {
        SocketInputStream() {
        }

        @Override
        public int available() throws IOException {
            LocalSocketImpl localSocketImpl = LocalSocketImpl.this;
            FileDescriptor fileDescriptor = LocalSocketImpl.this.fd;
            return localSocketImpl.available_native(fileDescriptor);
        }

        @Override
        public void close() throws IOException {
            LocalSocketImpl.this.close();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read() throws IOException {
            Object object = LocalSocketImpl.this.readMonitor;
            synchronized (object) {
                FileDescriptor fileDescriptor = LocalSocketImpl.this.fd;
                if (fileDescriptor != null) return LocalSocketImpl.this.read_native(fileDescriptor);
                throw new IOException("socket closed");
            }
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            int n = byArray.length;
            return this.read(byArray, 0, n);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            Object object = LocalSocketImpl.this.readMonitor;
            synchronized (object) {
                FileDescriptor fileDescriptor = LocalSocketImpl.this.fd;
                if (fileDescriptor == null) {
                    throw new IOException("socket closed");
                }
                if (n < 0) throw new ArrayIndexOutOfBoundsException();
                if (n2 < 0) throw new ArrayIndexOutOfBoundsException();
                int n3 = n + n2;
                int n4 = byArray.length;
                if (n3 > n4) throw new ArrayIndexOutOfBoundsException();
                return LocalSocketImpl.this.readba_native(byArray, n, n2, fileDescriptor);
            }
        }
    }
}

