/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ParseException;
import android.net.Uri;
import java.util.HashMap;
import java.util.Map;

public class MailTo {
    private static final String BODY = "body";
    private static final String CC = "cc";
    public static final String MAILTO_SCHEME = "mailto:";
    private static final String SUBJECT = "subject";
    private static final String TO = "to";
    private HashMap<String, String> mHeaders;

    private MailTo() {
        HashMap hashMap = new HashMap();
        this.mHeaders = hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMailTo(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith(MAILTO_SCHEME)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static MailTo parse(String string2) throws ParseException {
        String string3;
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (!MailTo.isMailTo(string2)) {
            throw new ParseException("Not a mailto scheme");
        }
        int n = MAILTO_SCHEME.length();
        Uri uri = Uri.parse(string2.substring(n));
        MailTo mailTo = new MailTo();
        String[] stringArray = uri.getQuery();
        if (stringArray != null) {
            stringArray = stringArray.split("&");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String[] stringArray2 = stringArray[n3].split("=");
                if (stringArray2.length != 0) {
                    void var7_10;
                    HashMap<String, String> hashMap = mailTo.mHeaders;
                    String string4 = Uri.decode(stringArray2[0]).toLowerCase();
                    if (stringArray2.length > 1) {
                        String string5 = Uri.decode(stringArray2[1]);
                    } else {
                        Object var7_11 = null;
                    }
                    String string6 = hashMap.put(string4, (String)var7_10);
                }
                int n4 = n3 + 1;
            }
        }
        if ((string3 = uri.getPath()) == null) {
            String string7 = string3;
            return mailTo;
        }
        String string8 = mailTo.getTo();
        String string9 = string8 != null ? string3 + ", " + string8 : string3;
        String string10 = mailTo.mHeaders.put(TO, string9);
        return mailTo;
    }

    public String getBody() {
        return this.mHeaders.get(BODY);
    }

    public String getCc() {
        return this.mHeaders.get(CC);
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public String getSubject() {
        return this.mHeaders.get(SUBJECT);
    }

    public String getTo() {
        return this.mHeaders.get(TO);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(MAILTO_SCHEME);
        StringBuilder stringBuilder2 = stringBuilder.append('?');
        for (Map.Entry<String, String> entry : this.mHeaders.entrySet()) {
            String string2 = Uri.encode(entry.getKey());
            StringBuilder stringBuilder3 = stringBuilder.append(string2);
            StringBuilder stringBuilder4 = stringBuilder.append('=');
            String string3 = Uri.encode(entry.getValue());
            StringBuilder stringBuilder5 = stringBuilder.append(string3);
            StringBuilder stringBuilder6 = stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }
}

