/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.Phone;

public class MobileDataStateTracker
extends NetworkStateTracker {
    private static final boolean DBG = false;
    private static final String TAG = "MobileDataStateTracker";
    private String mApnName;
    private String mApnType;
    private String mApnTypeToWatchFor;
    private boolean mEnabled;
    private boolean mIsDefaultOrHipri;
    private Phone.DataState mMobileDataState;
    private ITelephony mPhoneService;
    private BroadcastReceiver mStateReceiver;

    /*
     * Enabled aggressive block sorting
     */
    public MobileDataStateTracker(Context context, Handler handler, int n, String string2) {
        String string3;
        String string4;
        int n2 = TelephonyManager.getDefault().getNetworkType();
        String string5 = TelephonyManager.getDefault().getNetworkTypeName();
        MobileDataStateTracker mobileDataStateTracker = this;
        Context context2 = context;
        Handler handler2 = handler;
        int n3 = n;
        String string6 = string2;
        super(context2, handler2, n3, n2, string6, string5);
        this.mIsDefaultOrHipri = false;
        this.mApnType = string4 = MobileDataStateTracker.networkTypeToApnType(n);
        this.mApnTypeToWatchFor = TextUtils.equals(this.mApnType, "hipri") ? "default" : (string3 = this.mApnType);
        if (n == 0 || n == 5) {
            this.mIsDefaultOrHipri = true;
        }
        this.mPhoneService = null;
        this.mEnabled = n == 0;
        String[] stringArray = new String[]{"net.rmnet0.dns1", "net.rmnet0.dns2", "net.eth0.dns1", "net.eth0.dns2", "net.eth0.dns3", "net.eth0.dns4", "net.gprs.dns1", "net.gprs.dns2", "net.ppp0.dns1", "net.ppp0.dns2"};
        this.mDnsPropNames = stringArray;
    }

    static /* synthetic */ Phone.DataState access$100(MobileDataStateTracker mobileDataStateTracker, Intent intent) {
        return mobileDataStateTracker.getMobileDataState(intent);
    }

    static /* synthetic */ String access$202(MobileDataStateTracker mobileDataStateTracker, String string2) {
        mobileDataStateTracker.mApnName = string2;
        return string2;
    }

    static /* synthetic */ boolean access$300(MobileDataStateTracker mobileDataStateTracker, String string2) {
        return mobileDataStateTracker.isApnTypeIncluded(string2);
    }

    static /* synthetic */ boolean access$400(MobileDataStateTracker mobileDataStateTracker) {
        return mobileDataStateTracker.mEnabled;
    }

    static /* synthetic */ boolean access$402(MobileDataStateTracker mobileDataStateTracker, boolean bl) {
        mobileDataStateTracker.mEnabled = bl;
        return bl;
    }

    static /* synthetic */ Phone.DataState access$500(MobileDataStateTracker mobileDataStateTracker) {
        return mobileDataStateTracker.mMobileDataState;
    }

    static /* synthetic */ Phone.DataState access$502(MobileDataStateTracker mobileDataStateTracker, Phone.DataState dataState) {
        mobileDataStateTracker.mMobileDataState = dataState;
        return dataState;
    }

    static /* synthetic */ boolean access$600(MobileDataStateTracker mobileDataStateTracker) {
        return mobileDataStateTracker.mIsDefaultOrHipri;
    }

    static /* synthetic */ String access$700(MobileDataStateTracker mobileDataStateTracker) {
        return mobileDataStateTracker.mApnType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Phone.DataState getMobileDataState(Intent intent) {
        String string2 = intent.getStringExtra("state");
        if (string2 == null) return Phone.DataState.DISCONNECTED;
        String string3 = intent.getStringExtra("apnType");
        if (!this.isApnTypeIncluded(string3)) return Phone.DataState.DISCONNECTED;
        return Enum.valueOf(Phone.DataState.class, string2);
    }

    private void getPhoneService(boolean bl) {
        ITelephony iTelephony;
        if (this.mPhoneService != null && !bl) {
            return;
        }
        this.mPhoneService = iTelephony = ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isApnTypeIncluded(String string2) {
        int n;
        if (string2 == null) {
            return false;
        }
        String[] stringArray = string2.split(",");
        int n2 = 0;
        while (n2 < (n = stringArray.length)) {
            String string3 = stringArray[n2];
            String string4 = this.mApnTypeToWatchFor;
            if (TextUtils.equals(string3, string4)) return true;
            if (TextUtils.equals(stringArray[n2], "*")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String networkTypeToApnType(int n) {
        switch (n) {
            default: {
                String string2 = "Error mapping networkType " + n + " to apnType.";
                int n2 = Log.e(TAG, string2);
                return null;
            }
            case 0: {
                return "default";
            }
            case 2: {
                return "mms";
            }
            case 3: {
                return "supl";
            }
            case 4: {
                return "dun";
            }
            case 5: 
        }
        return "hipri";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int setEnableApn(String string2, boolean bl) {
        this.getPhoneService(false);
        int n = 0;
        while (true) {
            block8: {
                block7: {
                    if (n >= 2) break block7;
                    if (this.mPhoneService != null) break block8;
                    int n2 = Log.w(TAG, "Ignoring feature request because could not acquire PhoneService");
                }
                StringBuilder stringBuilder = new StringBuilder().append("Could not ");
                String string3 = bl ? "enable" : "disable";
                String string4 = stringBuilder.append(string3).append(" APN type \"").append(string2).append("\"").toString();
                int n3 = Log.w(TAG, string4);
                return 3;
            }
            int n4 = this.mPhoneService.disableApnType(string2);
            if (!bl) return n4;
            try {
                return this.mPhoneService.enableApnType(string2);
            }
            catch (RemoteException remoteException) {
                if (n == 0) {
                    this.getPhoneService(true);
                }
                ++n;
                continue;
            }
            break;
        }
    }

    public int getNetworkSubtype() {
        return TelephonyManager.getDefault().getNetworkType();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getTcpBufferSizesPropName() {
        String string2 = "unknown";
        Context context = this.mContext;
        switch (new TelephonyManager(context).getNetworkType()) {
            case 1: {
                string2 = "gprs";
                return "net.tcp.buffersize." + string2;
            }
            case 2: {
                string2 = "edge";
                return "net.tcp.buffersize." + string2;
            }
            case 3: {
                string2 = "umts";
                return "net.tcp.buffersize." + string2;
            }
            case 8: {
                string2 = "hsdpa";
                return "net.tcp.buffersize." + string2;
            }
            case 9: {
                string2 = "hsupa";
                return "net.tcp.buffersize." + string2;
            }
            case 10: {
                string2 = "hspa";
                return "net.tcp.buffersize." + string2;
            }
            case 4: {
                string2 = "cdma";
                return "net.tcp.buffersize." + string2;
            }
            case 7: {
                string2 = "1xrtt";
                return "net.tcp.buffersize." + string2;
            }
            case 5: {
                string2 = "evdo";
                return "net.tcp.buffersize." + string2;
            }
            case 6: {
                string2 = "evdo";
                return "net.tcp.buffersize." + string2;
            }
            case 12: {
                string2 = "evdo";
                return "net.tcp.buffersize." + string2;
            }
        }
        return "net.tcp.buffersize." + string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAvailable() {
        this.getPhoneService(false);
        int n = 0;
        while (n < 2) {
            if (this.mPhoneService == null) {
                return false;
            }
            try {
                boolean bl = this.mPhoneService.isDataConnectivityPossible();
                return bl;
            }
            catch (RemoteException remoteException) {
                if (n == 0) {
                    this.getPhoneService(true);
                }
                ++n;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean reconnect() {
        this.setTeardownRequested(false);
        String string2 = this.mApnType;
        switch (this.setEnableApn(string2, true)) {
            default: {
                int n = Log.e(TAG, "Error in reconnect - unexpected response.");
                this.mEnabled = false;
                return this.mEnabled;
            }
            case 0: {
                Phone.DataState dataState;
                this.mEnabled = true;
                this.mMobileDataState = dataState = Phone.DataState.CONNECTING;
                NetworkInfo.DetailedState detailedState = NetworkInfo.DetailedState.CONNECTING;
                this.setDetailedState(detailedState, "apnChanged", null);
                Intent intent = new Intent("android.intent.action.ANY_DATA_STATE");
                String string3 = Phone.DataState.CONNECTED.toString();
                Intent intent2 = intent.putExtra("state", string3);
                Intent intent3 = intent.putExtra("reason", "apnChanged");
                String string4 = this.mApnTypeToWatchFor;
                Intent intent4 = intent.putExtra("apnType", string4);
                String string5 = this.mApnName;
                Intent intent5 = intent.putExtra("apn", string5);
                String string6 = this.mInterfaceName;
                Intent intent6 = intent.putExtra("iface", string6);
                Intent intent7 = intent.putExtra("networkUnvailable", false);
                if (this.mStateReceiver == null) return this.mEnabled;
                BroadcastReceiver broadcastReceiver = this.mStateReceiver;
                Context context = this.mContext;
                broadcastReceiver.onReceive(context, intent);
                return this.mEnabled;
            }
            case 1: {
                this.mEnabled = true;
                return this.mEnabled;
            }
            case 3: {
                if (this.mPhoneService != null || this.mApnType != "default") break;
                this.mEnabled = true;
                return false;
            }
            case 2: 
        }
        if (this.mApnType == "default") return this.mEnabled;
        this.mEnabled = false;
        return this.mEnabled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean requestRouteToHost(int n) {
        if (this.mInterfaceName == null) return false;
        if (n == -1) return false;
        if (NetworkUtils.addHostRoute(this.mInterfaceName, n) != 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setRadio(boolean bl) {
        this.getPhoneService(false);
        int n = 0;
        while (true) {
            block8: {
                block7: {
                    if (n >= 2) break block7;
                    if (this.mPhoneService != null) break block8;
                    int n2 = Log.w(TAG, "Ignoring mobile radio request because could not acquire PhoneService");
                }
                StringBuilder stringBuilder = new StringBuilder().append("Could not set radio power to ");
                String string2 = bl ? "on" : "off";
                String string3 = stringBuilder.append(string2).toString();
                int n3 = Log.w(TAG, string3);
                return false;
            }
            try {
                boolean bl2 = this.mPhoneService.setRadio(bl);
                return bl2;
            }
            catch (RemoteException remoteException) {
                if (n == 0) {
                    this.getPhoneService(true);
                }
                ++n;
                continue;
            }
            break;
        }
    }

    @Override
    public void startMonitoring() {
        Phone.DataState dataState;
        IntentFilter intentFilter = new IntentFilter("android.intent.action.ANY_DATA_STATE");
        intentFilter.addAction("android.intent.action.DATA_CONNECTION_FAILED");
        intentFilter.addAction("android.intent.action.SERVICE_STATE");
        MobileDataStateReceiver mobileDataStateReceiver = new MobileDataStateReceiver();
        this.mStateReceiver = mobileDataStateReceiver;
        Context context = this.mContext;
        BroadcastReceiver broadcastReceiver = this.mStateReceiver;
        Intent intent = context.registerReceiver(broadcastReceiver, intentFilter);
        if (intent != null) {
            Phone.DataState dataState2;
            this.mMobileDataState = dataState2 = this.getMobileDataState(intent);
            return;
        }
        this.mMobileDataState = dataState = Phone.DataState.DISCONNECTED;
    }

    @Override
    public int startUsingNetworkFeature(String string2, int n, int n2) {
        return -1;
    }

    @Override
    public int stopUsingNetworkFeature(String string2, int n, int n2) {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean teardown() {
        this.setTeardownRequested(true);
        String string2 = this.mApnType;
        if (this.setEnableApn(string2, false) == 3) return false;
        return true;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Mobile data state: ");
        Phone.DataState dataState = this.mMobileDataState;
        StringBuffer stringBuffer2 = stringBuffer.append((Object)dataState);
        return stringBuffer.toString();
    }

    private class MobileDataStateReceiver
    extends BroadcastReceiver {
        ConnectivityManager mConnectivityManager;

        private MobileDataStateReceiver() {
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onReceive(Context var1_1, Intent var2_2) {
            synchronized (this) {
                block20: {
                    block19: {
                        var3_3 = TelephonyManager.getDefault();
                        var4_4 = MobileDataStateTracker.this;
                        var5_5 = var3_3.isNetworkRoaming();
                        var4_4.setRoamingStatus(var5_5);
                        var6_6 = MobileDataStateTracker.this;
                        var7_7 = var3_3.getNetworkType();
                        var8_8 = var3_3.getNetworkTypeName();
                        var6_6.setSubtype(var7_7, var8_8);
                        if (!var2_2.getAction().equals("android.intent.action.ANY_DATA_STATE")) break block19;
                        var9_9 = MobileDataStateTracker.access$100(MobileDataStateTracker.this, var2_2);
                        var10_10 = var2_2.getStringExtra("reason");
                        var11_11 = var2_2.getStringExtra("apn");
                        var12_12 = var2_2.getStringExtra("apnType");
                        var13_13 = MobileDataStateTracker.access$202(MobileDataStateTracker.this, var11_11);
                        var14_14 = var2_2.getBooleanExtra("networkUnvailable", false);
                        var15_15 = MobileDataStateTracker.this.mNetworkInfo;
                        var16_16 = var14_14 == false;
                        var15_15.setIsAvailable(var16_16);
                        if (!MobileDataStateTracker.access$300(MobileDataStateTracker.this, var12_12)) {
                            return;
                        }
                        if (!MobileDataStateTracker.access$400(MobileDataStateTracker.this)) {
                            var17_17 = Phone.DataState.CONNECTED;
                            if (var9_9 == var17_17) {
                                var18_18 = MobileDataStateTracker.this;
                                var18_18.mInterfaceName = var19_19 = var2_2.getStringExtra("iface");
                            }
                            return;
                        }
                        if (MobileDataStateTracker.access$500(MobileDataStateTracker.this) == var9_9) break block20;
                        var21_20 = MobileDataStateTracker.access$502(MobileDataStateTracker.this, var9_9);
                        var22_21 = 1.$SwitchMap$com$android$internal$telephony$Phone$DataState;
                        var23_22 = var9_9.ordinal();
                        switch (var22_21[var23_22]) {
                            case 1: {
                                if (MobileDataStateTracker.this.isTeardownRequested()) {
                                    var24_23 = MobileDataStateTracker.access$402(MobileDataStateTracker.this, false);
                                    MobileDataStateTracker.this.setTeardownRequested(false);
                                }
                                var25_24 = MobileDataStateTracker.this;
                                var26_25 = NetworkInfo.DetailedState.DISCONNECTED;
                                var25_24.setDetailedState(var26_25, var10_10, var11_11);
                                var27_26 = true;
                                if (MobileDataStateTracker.access$600(MobileDataStateTracker.this)) {
                                    var28_27 = MobileDataStateTracker.access$700(MobileDataStateTracker.this);
                                    var29_28 = "default".equals(var28_27) != false ? 5 : 0;
                                    if (this.mConnectivityManager == null) {
                                        this.mConnectivityManager = var30_29 = (ConnectivityManager)var1_1.getSystemService("connectivity");
                                    }
                                    if (this.mConnectivityManager != null && (var31_30 = this.mConnectivityManager.getNetworkInfo(var29_28)) != null && var31_30.isConnected()) {
                                        var27_26 = false;
                                    }
                                }
                                if (var27_26 && MobileDataStateTracker.this.mInterfaceName != null) {
                                    var32_31 = NetworkUtils.resetConnections(MobileDataStateTracker.this.mInterfaceName);
                                    ** break;
                                }
                                ** GOTO lbl61
                            }
                            case 2: {
                                var33_32 = MobileDataStateTracker.this;
                                var34_33 = NetworkInfo.DetailedState.CONNECTING;
                                var33_32.setDetailedState(var34_33, var10_10, var11_11);
                                ** break;
                            }
                            case 3: {
                                var35_34 = MobileDataStateTracker.this;
                                var36_35 = NetworkInfo.DetailedState.SUSPENDED;
                                var35_34.setDetailedState(var36_35, var10_10, var11_11);
                            }
lbl61:
                            // 5 sources

                            default: {
                                break block20;
                            }
                            case 4: 
                        }
                        var37_36 = MobileDataStateTracker.this;
                        var37_36.mInterfaceName = var38_37 = var2_2.getStringExtra("iface");
                        if (MobileDataStateTracker.this.mInterfaceName == null) {
                            var39_38 = Log.d("MobileDataStateTracker", "CONNECTED event did not supply interface name.");
                        }
                        var40_39 = MobileDataStateTracker.this;
                        var40_39.mDefaultGatewayAddr = var41_40 = var2_2.getIntExtra("gateway", 0);
                        var42_41 = MobileDataStateTracker.this;
                        var43_42 = NetworkInfo.DetailedState.CONNECTED;
                        var42_41.setDetailedState(var43_42, var10_10, var11_11);
                        break block20;
                    }
                    if (var2_2.getAction().equals("android.intent.action.DATA_CONNECTION_FAILED")) {
                        var44_43 = MobileDataStateTracker.access$402(MobileDataStateTracker.this, false);
                        var45_44 = var2_2.getStringExtra("reason");
                        var46_45 = var2_2.getStringExtra("apn");
                        var47_46 = MobileDataStateTracker.this;
                        var48_47 = NetworkInfo.DetailedState.FAILED;
                        var47_46.setDetailedState(var48_47, var45_44, var46_45);
                    }
                }
                return;
            }
        }
    }
}

