/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ConnectivityManager;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.EnumMap;

public class NetworkInfo
implements Parcelable {
    public static final Parcelable.Creator<NetworkInfo> CREATOR;
    private static final EnumMap<DetailedState, State> stateMap;
    private DetailedState mDetailedState;
    private String mExtraInfo;
    private boolean mIsAvailable;
    private boolean mIsFailover;
    private boolean mIsRoaming;
    private int mNetworkType;
    private String mReason;
    private State mState;
    private int mSubtype;
    private String mSubtypeName;
    private String mTypeName;

    static {
        EnumMap<DetailedState, State> enumMap = stateMap = new EnumMap(DetailedState.class);
        DetailedState detailedState = DetailedState.IDLE;
        State state = State.DISCONNECTED;
        State state2 = enumMap.put(detailedState, state);
        EnumMap<DetailedState, State> enumMap2 = stateMap;
        DetailedState detailedState2 = DetailedState.SCANNING;
        State state3 = State.DISCONNECTED;
        State state4 = enumMap2.put(detailedState2, state3);
        EnumMap<DetailedState, State> enumMap3 = stateMap;
        DetailedState detailedState3 = DetailedState.CONNECTING;
        State state5 = State.CONNECTING;
        State state6 = enumMap3.put(detailedState3, state5);
        EnumMap<DetailedState, State> enumMap4 = stateMap;
        DetailedState detailedState4 = DetailedState.AUTHENTICATING;
        State state7 = State.CONNECTING;
        State state8 = enumMap4.put(detailedState4, state7);
        EnumMap<DetailedState, State> enumMap5 = stateMap;
        DetailedState detailedState5 = DetailedState.OBTAINING_IPADDR;
        State state9 = State.CONNECTING;
        State state10 = enumMap5.put(detailedState5, state9);
        EnumMap<DetailedState, State> enumMap6 = stateMap;
        DetailedState detailedState6 = DetailedState.CONNECTED;
        State state11 = State.CONNECTED;
        State state12 = enumMap6.put(detailedState6, state11);
        EnumMap<DetailedState, State> enumMap7 = stateMap;
        DetailedState detailedState7 = DetailedState.SUSPENDED;
        State state13 = State.SUSPENDED;
        State state14 = enumMap7.put(detailedState7, state13);
        EnumMap<DetailedState, State> enumMap8 = stateMap;
        DetailedState detailedState8 = DetailedState.DISCONNECTING;
        State state15 = State.DISCONNECTING;
        State state16 = enumMap8.put(detailedState8, state15);
        EnumMap<DetailedState, State> enumMap9 = stateMap;
        DetailedState detailedState9 = DetailedState.DISCONNECTED;
        State state17 = State.DISCONNECTED;
        State state18 = enumMap9.put(detailedState9, state17);
        EnumMap<DetailedState, State> enumMap10 = stateMap;
        DetailedState detailedState10 = DetailedState.FAILED;
        State state19 = State.DISCONNECTED;
        State state20 = enumMap10.put(detailedState10, state19);
        CREATOR = new Parcelable.Creator<NetworkInfo>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public NetworkInfo createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                int n2 = parcel.readInt();
                String string2 = parcel.readString();
                String string3 = parcel.readString();
                NetworkInfo networkInfo = new NetworkInfo(n, n2, string2, string3);
                State state = State.valueOf(parcel.readString());
                State state2 = NetworkInfo.access$002(networkInfo, state);
                DetailedState detailedState = DetailedState.valueOf(parcel.readString());
                DetailedState detailedState2 = NetworkInfo.access$102(networkInfo, detailedState);
                boolean bl = parcel.readInt() != 0;
                boolean bl2 = NetworkInfo.access$202(networkInfo, bl);
                boolean bl3 = parcel.readInt() != 0;
                boolean bl4 = NetworkInfo.access$302(networkInfo, bl3);
                boolean bl5 = parcel.readInt() != 0;
                boolean bl6 = NetworkInfo.access$402(networkInfo, bl5);
                String string4 = parcel.readString();
                String string5 = NetworkInfo.access$502(networkInfo, string4);
                String string6 = parcel.readString();
                String string7 = NetworkInfo.access$602(networkInfo, string6);
                return networkInfo;
            }

            public NetworkInfo[] newArray(int n) {
                return new NetworkInfo[n];
            }
        };
    }

    public NetworkInfo(int n) {
    }

    NetworkInfo(int n, int n2, String string2, String string3) {
        State state;
        if (!ConnectivityManager.isNetworkTypeValid(n)) {
            String string4 = "Invalid network type: " + n;
            throw new IllegalArgumentException(string4);
        }
        this.mNetworkType = n;
        this.mSubtype = n2;
        this.mTypeName = string2;
        this.mSubtypeName = string3;
        DetailedState detailedState = DetailedState.IDLE;
        this.setDetailedState(detailedState, null, null);
        this.mState = state = State.UNKNOWN;
        this.mIsAvailable = false;
        this.mIsRoaming = false;
    }

    static /* synthetic */ State access$002(NetworkInfo networkInfo, State state) {
        networkInfo.mState = state;
        return state;
    }

    static /* synthetic */ DetailedState access$102(NetworkInfo networkInfo, DetailedState detailedState) {
        networkInfo.mDetailedState = detailedState;
        return detailedState;
    }

    static /* synthetic */ boolean access$202(NetworkInfo networkInfo, boolean bl) {
        networkInfo.mIsFailover = bl;
        return bl;
    }

    static /* synthetic */ boolean access$302(NetworkInfo networkInfo, boolean bl) {
        networkInfo.mIsAvailable = bl;
        return bl;
    }

    static /* synthetic */ boolean access$402(NetworkInfo networkInfo, boolean bl) {
        networkInfo.mIsRoaming = bl;
        return bl;
    }

    static /* synthetic */ String access$502(NetworkInfo networkInfo, String string2) {
        networkInfo.mReason = string2;
        return string2;
    }

    static /* synthetic */ String access$602(NetworkInfo networkInfo, String string2) {
        networkInfo.mExtraInfo = string2;
        return string2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public DetailedState getDetailedState() {
        return this.mDetailedState;
    }

    public String getExtraInfo() {
        return this.mExtraInfo;
    }

    public String getReason() {
        return this.mReason;
    }

    public State getState() {
        return this.mState;
    }

    public int getSubtype() {
        return this.mSubtype;
    }

    public String getSubtypeName() {
        return this.mSubtypeName;
    }

    public int getType() {
        return this.mNetworkType;
    }

    public String getTypeName() {
        return this.mTypeName;
    }

    public boolean isAvailable() {
        return this.mIsAvailable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected() {
        State state = this.mState;
        State state2 = State.CONNECTED;
        if (state != state2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnectedOrConnecting() {
        State state = this.mState;
        State state2 = State.CONNECTED;
        if (state == state2) return true;
        State state3 = this.mState;
        State state4 = State.CONNECTING;
        if (state3 != state4) return false;
        return true;
    }

    public boolean isFailover() {
        return this.mIsFailover;
    }

    public boolean isRoaming() {
        return this.mIsRoaming;
    }

    void setDetailedState(DetailedState detailedState, String string2, String string3) {
        State state;
        this.mDetailedState = detailedState;
        this.mState = state = stateMap.get((Object)detailedState);
        this.mReason = string2;
        this.mExtraInfo = string3;
    }

    public void setFailover(boolean bl) {
        this.mIsFailover = bl;
    }

    public void setIsAvailable(boolean bl) {
        this.mIsAvailable = bl;
    }

    void setRoaming(boolean bl) {
        this.mIsRoaming = bl;
    }

    void setSubtype(int n, String string2) {
        this.mSubtype = n;
        this.mSubtypeName = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NetworkInfo: ");
        StringBuilder stringBuilder2 = stringBuilder.append("type: ");
        String string2 = this.getTypeName();
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("[");
        String string3 = this.getSubtypeName();
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("], state: ");
        State state = this.mState;
        StringBuilder stringBuilder5 = stringBuilder4.append((Object)state).append("/");
        DetailedState detailedState = this.mDetailedState;
        StringBuilder stringBuilder6 = stringBuilder5.append((Object)detailedState).append(", reason: ");
        String string4 = this.mReason == null ? "(unspecified)" : this.mReason;
        StringBuilder stringBuilder7 = stringBuilder6.append(string4).append(", extra: ");
        String string5 = this.mExtraInfo == null ? "(none)" : this.mExtraInfo;
        StringBuilder stringBuilder8 = stringBuilder7.append(string5).append(", roaming: ");
        boolean bl = this.mIsRoaming;
        StringBuilder stringBuilder9 = stringBuilder8.append(bl).append(", failover: ");
        boolean bl2 = this.mIsFailover;
        StringBuilder stringBuilder10 = stringBuilder9.append(bl2).append(", isAvailable: ");
        boolean bl3 = this.mIsAvailable;
        StringBuilder stringBuilder11 = stringBuilder10.append(bl3);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mNetworkType;
        parcel.writeInt(n2);
        int n3 = this.mSubtype;
        parcel.writeInt(n3);
        String string2 = this.mTypeName;
        parcel.writeString(string2);
        String string3 = this.mSubtypeName;
        parcel.writeString(string3);
        String string4 = this.mState.name();
        parcel.writeString(string4);
        String string5 = this.mDetailedState.name();
        parcel.writeString(string5);
        int n4 = this.mIsFailover ? 1 : 0;
        parcel.writeInt(n4);
        int n5 = this.mIsAvailable ? 1 : 0;
        parcel.writeInt(n5);
        int n6 = this.mIsRoaming ? 1 : 0;
        parcel.writeInt(n6);
        String string6 = this.mReason;
        parcel.writeString(string6);
        String string7 = this.mExtraInfo;
        parcel.writeString(string7);
    }

    public static final class DetailedState
    extends Enum<DetailedState> {
        private static final /* synthetic */ DetailedState[] $VALUES;
        public static final /* enum */ DetailedState AUTHENTICATING;
        public static final /* enum */ DetailedState CONNECTED;
        public static final /* enum */ DetailedState CONNECTING;
        public static final /* enum */ DetailedState DISCONNECTED;
        public static final /* enum */ DetailedState DISCONNECTING;
        public static final /* enum */ DetailedState FAILED;
        public static final /* enum */ DetailedState IDLE;
        public static final /* enum */ DetailedState OBTAINING_IPADDR;
        public static final /* enum */ DetailedState SCANNING;
        public static final /* enum */ DetailedState SUSPENDED;

        static {
            IDLE = new DetailedState();
            SCANNING = new DetailedState();
            CONNECTING = new DetailedState();
            AUTHENTICATING = new DetailedState();
            OBTAINING_IPADDR = new DetailedState();
            CONNECTED = new DetailedState();
            SUSPENDED = new DetailedState();
            DISCONNECTING = new DetailedState();
            DISCONNECTED = new DetailedState();
            FAILED = new DetailedState();
            DetailedState detailedState = IDLE;
            DetailedState detailedState2 = SCANNING;
            DetailedState detailedState3 = CONNECTING;
            DetailedState detailedState4 = AUTHENTICATING;
            DetailedState detailedState5 = OBTAINING_IPADDR;
            DetailedState detailedState6 = CONNECTED;
            DetailedState detailedState7 = SUSPENDED;
            DetailedState detailedState8 = DISCONNECTING;
            DetailedState detailedState9 = DISCONNECTED;
            DetailedState detailedState10 = FAILED;
            DetailedState[] detailedStateArray = new DetailedState[]{detailedState, detailedState2, detailedState3, detailedState4, detailedState5, detailedState6, detailedState7, detailedState8, detailedState9, detailedState10};
            $VALUES = detailedStateArray;
        }

        public static DetailedState valueOf(String string2) {
            return Enum.valueOf(DetailedState.class, string2);
        }

        public static DetailedState[] values() {
            return (DetailedState[])$VALUES.clone();
        }
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State CONNECTED;
        public static final /* enum */ State CONNECTING;
        public static final /* enum */ State DISCONNECTED;
        public static final /* enum */ State DISCONNECTING;
        public static final /* enum */ State SUSPENDED;
        public static final /* enum */ State UNKNOWN;

        static {
            CONNECTING = new State();
            CONNECTED = new State();
            SUSPENDED = new State();
            DISCONNECTING = new State();
            DISCONNECTED = new State();
            UNKNOWN = new State();
            State state = CONNECTING;
            State state2 = CONNECTED;
            State state3 = SUSPENDED;
            State state4 = DISCONNECTING;
            State state5 = DISCONNECTED;
            State state6 = UNKNOWN;
            State[] stateArray = new State[]{state, state2, state3, state4, state5, state6};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

