/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileWriter;
import java.io.IOException;

public abstract class NetworkStateTracker
extends Handler {
    private static boolean DBG = false;
    public static final int EVENT_CONFIGURATION_CHANGED = 4;
    public static final int EVENT_NETWORK_SUBTYPE_CHANGED = 6;
    public static final int EVENT_NOTIFICATION_CHANGED = 3;
    public static final int EVENT_ROAMING_CHANGED = 5;
    public static final int EVENT_SCAN_RESULTS_AVAILABLE = 2;
    public static final int EVENT_STATE_CHANGED = 1;
    private static final int MAX_NETWORK_STATE_TRACKER_EVENT = 100;
    private static final int MIN_NETWORK_STATE_TRACKER_EVENT = 1;
    private static final String TAG = "NetworkStateTracker";
    protected Context mContext;
    protected int mDefaultGatewayAddr;
    protected String[] mDnsPropNames;
    protected String mInterfaceName;
    protected NetworkInfo mNetworkInfo;
    private boolean mPrivateDnsRouteSet;
    protected Handler mTarget;
    private boolean mTeardownRequested;

    static {
        DBG = false;
    }

    public NetworkStateTracker(Context context, Handler handler, int n, int n2, String string2, String string3) {
        NetworkInfo networkInfo;
        this.mContext = context;
        this.mTarget = handler;
        this.mTeardownRequested = false;
        this.mNetworkInfo = networkInfo = new NetworkInfo(n, n2, string2, string3);
    }

    protected static String[] getNameServerList(String[] stringArray) {
        int n;
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < (n = stringArray.length); ++i) {
            String string2 = SystemProperties.get(stringArray[i]);
            if (TextUtils.isEmpty(string2) || TextUtils.equals(string2, "0.0.0.0")) continue;
            int n2 = 0 + 1;
            stringArray2[0] = string2;
            int n3 = n2;
        }
        return stringArray2;
    }

    private void setBufferSize(String string2) {
        try {
            String[] stringArray = string2.split(",");
            if (stringArray.length == 6) {
                String string3 = stringArray[0];
                this.stringToFile("/sys/kernel/ipv4/tcp_rmem_min", string3);
                String string4 = stringArray[1];
                this.stringToFile("/sys/kernel/ipv4/tcp_rmem_def", string4);
                String string5 = stringArray[2];
                this.stringToFile("/sys/kernel/ipv4/tcp_rmem_max", string5);
                String string6 = stringArray[3];
                this.stringToFile("/sys/kernel/ipv4/tcp_wmem_min", string6);
                String string7 = stringArray[4];
                this.stringToFile("/sys/kernel/ipv4/tcp_wmem_def", string7);
                String string8 = stringArray[5];
                this.stringToFile("/sys/kernel/ipv4/tcp_wmem_max", string8);
                return;
            }
            String string9 = "Invalid buffersize string: " + string2;
            int n = Log.w(TAG, string9);
            return;
        }
        catch (IOException iOException) {
            String string10 = "Can't set tcp buffer sizes:" + iOException;
            int n = Log.w(TAG, string10);
            return;
        }
    }

    private void stringToFile(String string2, String string3) throws IOException {
        FileWriter fileWriter = new FileWriter(string2);
        try {
            fileWriter.write(string3);
            return;
        }
        finally {
            fileWriter.close();
        }
    }

    public void addDefaultRoute() {
        if (this.mInterfaceName == null) {
            return;
        }
        if (this.mDefaultGatewayAddr == 0) {
            return;
        }
        if (DBG) {
            StringBuilder stringBuilder = new StringBuilder().append("addDefaultRoute for ");
            String string2 = this.mNetworkInfo.getTypeName();
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" (");
            String string3 = this.mInterfaceName;
            StringBuilder stringBuilder3 = stringBuilder2.append(string3).append("), GatewayAddr=");
            int n = this.mDefaultGatewayAddr;
            String string4 = stringBuilder3.append(n).toString();
            int n2 = Log.d(TAG, string4);
        }
        String string5 = this.mInterfaceName;
        int n = this.mDefaultGatewayAddr;
        int n3 = NetworkUtils.setDefaultRoute(string5, n);
    }

    public void addPrivateDnsRoutes() {
        if (DBG) {
            StringBuilder stringBuilder = new StringBuilder().append("addPrivateDnsRoutes for ").append(this).append("(");
            String string2 = this.mInterfaceName;
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(") - mPrivateDnsRouteSet = ");
            boolean bl = this.mPrivateDnsRouteSet;
            String string3 = stringBuilder2.append(bl).toString();
            int n = Log.d(TAG, string3);
        }
        if (this.mInterfaceName == null) {
            return;
        }
        if (this.mPrivateDnsRouteSet) {
            return;
        }
        for (String string4 : this.getNameServers()) {
            int n = NetworkUtils.lookupHost(string4);
            if (n == -1 || n == 0) continue;
            if (DBG) {
                String string5 = "  adding " + string4 + " (" + n + ")";
                int n2 = Log.d(TAG, string5);
            }
            int n3 = NetworkUtils.addHostRoute(this.mInterfaceName, n);
        }
        this.mPrivateDnsRouteSet = true;
    }

    public String[] getNameServers() {
        return NetworkStateTracker.getNameServerList(this.mDnsPropNames);
    }

    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public abstract String getTcpBufferSizesPropName();

    public void interpretScanResultsAvailable() {
    }

    public abstract boolean isAvailable();

    public boolean isTeardownRequested() {
        return this.mTeardownRequested;
    }

    public abstract boolean reconnect();

    public void releaseWakeLock() {
    }

    public void removeDefaultRoute() {
        if (this.mInterfaceName == null) {
            return;
        }
        if (DBG) {
            StringBuilder stringBuilder = new StringBuilder().append("removeDefaultRoute for ");
            String string2 = this.mNetworkInfo.getTypeName();
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" (");
            String string3 = this.mInterfaceName;
            String string4 = stringBuilder2.append(string3).append(")").toString();
            int n = Log.d(TAG, string4);
        }
        int n = NetworkUtils.removeDefaultRoute(this.mInterfaceName);
    }

    public void removePrivateDnsRoutes() {
        if (this.mInterfaceName == null) {
            return;
        }
        if (!this.mPrivateDnsRouteSet) {
            return;
        }
        if (DBG) {
            StringBuilder stringBuilder = new StringBuilder().append("removePrivateDnsRoutes for ");
            String string2 = this.mNetworkInfo.getTypeName();
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" (");
            String string3 = this.mInterfaceName;
            String string4 = stringBuilder2.append(string3).append(")").toString();
            int n = Log.d(TAG, string4);
        }
        int n = NetworkUtils.removeHostRoutes(this.mInterfaceName);
        this.mPrivateDnsRouteSet = false;
    }

    public boolean requestRouteToHost(int n) {
        return false;
    }

    protected void sendScanResultsAvailable() {
        Handler handler = this.mTarget;
        NetworkInfo networkInfo = this.mNetworkInfo;
        handler.obtainMessage(2, networkInfo).sendToTarget();
    }

    public void setDetailedState(NetworkInfo.DetailedState detailedState) {
        this.setDetailedState(detailedState, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDetailedState(NetworkInfo.DetailedState detailedState, String string2, String string3) {
        NetworkInfo.DetailedState detailedState2;
        NetworkInfo.State state;
        NetworkInfo.DetailedState detailedState3;
        if (DBG) {
            StringBuilder stringBuilder = new StringBuilder().append("setDetailed state, old =");
            NetworkInfo.DetailedState detailedState4 = this.mNetworkInfo.getDetailedState();
            String string4 = stringBuilder.append((Object)detailedState4).append(" and new state=").append((Object)detailedState).toString();
            int n = Log.d(TAG, string4);
        }
        if (detailedState == (detailedState3 = this.mNetworkInfo.getDetailedState())) {
            return;
        }
        NetworkInfo.State state2 = this.mNetworkInfo.getState();
        boolean bl = state2 == (state = NetworkInfo.State.CONNECTING);
        String string5 = this.mNetworkInfo.getReason();
        if (bl && detailedState == (detailedState2 = NetworkInfo.DetailedState.CONNECTED) && string2 == null && string5 != null) {
            string2 = string5;
        }
        this.mNetworkInfo.setDetailedState(detailedState, string2, string3);
        Handler handler = this.mTarget;
        NetworkInfo networkInfo = this.mNetworkInfo;
        handler.obtainMessage(1, networkInfo).sendToTarget();
    }

    protected void setDetailedStateInternal(NetworkInfo.DetailedState detailedState) {
        this.mNetworkInfo.setDetailedState(detailedState, null, null);
    }

    public abstract boolean setRadio(boolean var1);

    protected void setRoamingStatus(boolean bl) {
        boolean bl2 = this.mNetworkInfo.isRoaming();
        if (bl != bl2) {
            return;
        }
        this.mNetworkInfo.setRoaming(bl);
        Handler handler = this.mTarget;
        NetworkInfo networkInfo = this.mNetworkInfo;
        handler.obtainMessage(5, networkInfo).sendToTarget();
    }

    protected void setSubtype(int n, String string2) {
        int n2 = this.mNetworkInfo.getSubtype();
        if (n != n2) {
            return;
        }
        this.mNetworkInfo.setSubtype(n, string2);
        if (!this.mNetworkInfo.isConnected()) {
            return;
        }
        Handler handler = this.mTarget;
        NetworkInfo networkInfo = this.mNetworkInfo;
        handler.obtainMessage(6, n2, 0, networkInfo).sendToTarget();
    }

    public void setTeardownRequested(boolean bl) {
        this.mTeardownRequested = bl;
    }

    public abstract void startMonitoring();

    public abstract int startUsingNetworkFeature(String var1, int var2, int var3);

    public abstract int stopUsingNetworkFeature(String var1, int var2, int var3);

    public abstract boolean teardown();

    public void updateNetworkSettings() {
        String string2 = this.getTcpBufferSizesPropName();
        String string3 = SystemProperties.get(string2);
        if (string3.length() == 0) {
            String string4 = string2 + " not found in system properties. Using defaults";
            int n = Log.w(TAG, string4);
            string2 = "net.tcp.buffersize.default";
            string3 = SystemProperties.get(string2);
        }
        if (string3.length() == 0) {
            return;
        }
        if (DBG) {
            String string5 = "Setting TCP values: [" + string3 + "] which comes from [" + string2 + "]";
            int n = Log.v(TAG, string5);
        }
        this.setBufferSize(string3);
    }
}

