/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.SSLSessionCache;
import android.os.SystemProperties;
import android.util.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.harmony.xnet.provider.jsse.ClientSessionContext;
import org.apache.harmony.xnet.provider.jsse.OpenSSLContextImpl;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl;
import org.apache.harmony.xnet.provider.jsse.SSLClientSessionCache;

public class SSLCertificateSocketFactory
extends SSLSocketFactory {
    private static final HostnameVerifier HOSTNAME_VERIFIER;
    private static final TrustManager[] INSECURE_TRUST_MANAGER;
    private static final String TAG = "SSLCertificateSocketFactory";
    private final int mHandshakeTimeoutMillis;
    private SSLSocketFactory mInsecureFactory;
    private final boolean mSecure;
    private SSLSocketFactory mSecureFactory;
    private final SSLClientSessionCache mSessionCache;

    static {
        TrustManager[] trustManagerArray = new TrustManager[1];
        X509TrustManager x509TrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        trustManagerArray[0] = x509TrustManager;
        INSECURE_TRUST_MANAGER = trustManagerArray;
        HOSTNAME_VERIFIER = HttpsURLConnection.getDefaultHostnameVerifier();
    }

    @Deprecated
    public SSLCertificateSocketFactory(int n) {
        this(n, null, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private SSLCertificateSocketFactory(int n, SSLSessionCache sSLSessionCache, boolean bl) {
        SSLClientSessionCache sSLClientSessionCache = null;
        this.mInsecureFactory = sSLClientSessionCache;
        this.mSecureFactory = sSLClientSessionCache;
        this.mHandshakeTimeoutMillis = n;
        if (sSLSessionCache != null) {
            sSLClientSessionCache = sSLSessionCache.mSessionCache;
        }
        this.mSessionCache = sSLClientSessionCache;
        this.mSecure = bl;
    }

    public static SocketFactory getDefault(int n) {
        return new SSLCertificateSocketFactory(n, null, true);
    }

    public static SSLSocketFactory getDefault(int n, SSLSessionCache sSLSessionCache) {
        return new SSLCertificateSocketFactory(n, sSLSessionCache, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSLSocketFactory getDelegate() {
        synchronized (this) {
            SSLSocketFactory sSLSocketFactory;
            if (!this.mSecure || SSLCertificateSocketFactory.isSslCheckRelaxed()) {
                SSLSocketFactory sSLSocketFactory2;
                if (this.mInsecureFactory != null) return this.mInsecureFactory;
                if (this.mSecure) {
                    int n = Log.w(TAG, "*** BYPASSING SSL SECURITY CHECKS (socket.relaxsslcheck=yes) ***");
                } else {
                    int n = Log.w(TAG, "Bypassing SSL security checks at caller's request");
                }
                TrustManager[] trustManagerArray = INSECURE_TRUST_MANAGER;
                this.mInsecureFactory = sSLSocketFactory2 = this.makeSocketFactory(trustManagerArray);
                return this.mInsecureFactory;
            }
            if (this.mSecureFactory != null) return this.mSecureFactory;
            this.mSecureFactory = sSLSocketFactory = this.makeSocketFactory(null);
            return this.mSecureFactory;
        }
    }

    public static org.apache.http.conn.ssl.SSLSocketFactory getHttpSocketFactory(int n, SSLSessionCache sSLSessionCache) {
        SSLCertificateSocketFactory sSLCertificateSocketFactory = new SSLCertificateSocketFactory(n, sSLSessionCache, true);
        return new org.apache.http.conn.ssl.SSLSocketFactory((SSLSocketFactory)sSLCertificateSocketFactory);
    }

    public static SSLSocketFactory getInsecure(int n, SSLSessionCache sSLSessionCache) {
        return new SSLCertificateSocketFactory(n, sSLSessionCache, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSslCheckRelaxed() {
        String string2 = SystemProperties.get("ro.debuggable");
        if (!"1".equals(string2)) return false;
        String string3 = SystemProperties.get("socket.relaxsslcheck");
        if (!"yes".equals(string3)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SSLSocketFactory makeSocketFactory(TrustManager[] trustManagerArray) {
        try {
            OpenSSLContextImpl openSSLContextImpl = new OpenSSLContextImpl();
            openSSLContextImpl.engineInit(null, trustManagerArray, null);
            ClientSessionContext clientSessionContext = openSSLContextImpl.engineGetClientSessionContext();
            SSLClientSessionCache sSLClientSessionCache = this.mSessionCache;
            clientSessionContext.setPersistentCache(sSLClientSessionCache);
            SSLSocketFactory sSLSocketFactory = openSSLContextImpl.engineGetSocketFactory();
            return sSLSocketFactory;
        }
        catch (KeyManagementException keyManagementException) {
            int n = Log.wtf(TAG, keyManagementException);
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
    }

    public static void verifyHostname(Socket socket, String string2) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("Attempt to verify non-SSL socket");
        }
        if (SSLCertificateSocketFactory.isSslCheckRelaxed()) {
            return;
        }
        SSLSocket sSLSocket = (SSLSocket)socket;
        sSLSocket.startHandshake();
        SSLSession sSLSession = sSLSocket.getSession();
        if (sSLSession == null) {
            throw new SSLException("Cannot verify SSL socket without session");
        }
        if (HOSTNAME_VERIFIER.verify(string2, sSLSession)) {
            return;
        }
        String string3 = "Cannot verify hostname: " + string2;
        throw new SSLPeerUnverifiedException(string3);
    }

    @Override
    public Socket createSocket() throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket();
        int n = this.mHandshakeTimeoutMillis;
        openSSLSocketImpl.setHandshakeTimeout(n);
        return openSSLSocketImpl;
    }

    @Override
    public Socket createSocket(String string2, int n) throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket(string2, n);
        int n2 = this.mHandshakeTimeoutMillis;
        openSSLSocketImpl.setHandshakeTimeout(n2);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname((Socket)openSSLSocketImpl, string2);
        }
        return openSSLSocketImpl;
    }

    @Override
    public Socket createSocket(String string2, int n, InetAddress inetAddress, int n2) throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket(string2, n, inetAddress, n2);
        int n3 = this.mHandshakeTimeoutMillis;
        openSSLSocketImpl.setHandshakeTimeout(n3);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname((Socket)openSSLSocketImpl, string2);
        }
        return openSSLSocketImpl;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket(inetAddress, n);
        int n2 = this.mHandshakeTimeoutMillis;
        openSSLSocketImpl.setHandshakeTimeout(n2);
        return openSSLSocketImpl;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket(inetAddress, n, inetAddress2, n2);
        int n3 = this.mHandshakeTimeoutMillis;
        openSSLSocketImpl.setHandshakeTimeout(n3);
        return openSSLSocketImpl;
    }

    @Override
    public Socket createSocket(Socket socket, String string2, int n, boolean bl) throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket(socket, string2, n, bl);
        int n2 = this.mHandshakeTimeoutMillis;
        openSSLSocketImpl.setHandshakeTimeout(n2);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname((Socket)openSSLSocketImpl, string2);
        }
        return openSSLSocketImpl;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.getDelegate().getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.getDelegate().getSupportedCipherSuites();
    }
}

