/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IThrottleManager;
import android.os.RemoteException;

public class ThrottleManager {
    public static final int DIRECTION_RX = 1;
    public static final int DIRECTION_TX = 0;
    public static final String EXTRA_CYCLE_END = "cycleEnd";
    public static final String EXTRA_CYCLE_READ = "cycleRead";
    public static final String EXTRA_CYCLE_START = "cycleStart";
    public static final String EXTRA_CYCLE_WRITE = "cycleWrite";
    public static final String EXTRA_THROTTLE_LEVEL = "level";
    public static final int PERIOD_24HOUR = 6;
    public static final int PERIOD_60MIN = 8;
    public static final int PERIOD_60SEC = 10;
    public static final int PERIOD_7DAY = 4;
    public static final int PERIOD_CYCLE = 0;
    public static final int PERIOD_DAY = 5;
    public static final int PERIOD_HOUR = 7;
    public static final int PERIOD_MINUTE = 9;
    public static final int PERIOD_MONTH = 2;
    public static final int PERIOD_SECOND = 11;
    public static final int PERIOD_WEEK = 3;
    public static final int PERIOD_YEAR = 1;
    public static final String POLICY_CHANGED_ACTION = "android.net.thrott.POLICY_CHANGED_ACTION";
    public static final String THROTTLE_ACTION = "android.net.thrott.THROTTLE_ACTION";
    public static final String THROTTLE_POLL_ACTION = "android.net.thrott.POLL_ACTION";
    private IThrottleManager mService;

    private ThrottleManager() {
    }

    public ThrottleManager(IThrottleManager iThrottleManager) {
        if (iThrottleManager == null) {
            throw new IllegalArgumentException("ThrottleManager() cannot be constructed with null service");
        }
        this.mService = iThrottleManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getByteCount(String string2, int n, int n2, int n3) {
        try {
            long l = this.mService.getByteCount(string2, n, n2, n3);
            return l;
        }
        catch (RemoteException remoteException) {
            return 65535L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCliffLevel(String string2, int n) {
        try {
            int n2 = this.mService.getCliffLevel(string2, n);
            return n2;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getCliffThreshold(String string2, int n) {
        try {
            long l = this.mService.getCliffThreshold(string2, n);
            return l;
        }
        catch (RemoteException remoteException) {
            return 65535L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getHelpUri() {
        try {
            String string2 = this.mService.getHelpUri();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getPeriodStartTime(String string2) {
        try {
            long l = this.mService.getPeriodStartTime(string2);
            return l;
        }
        catch (RemoteException remoteException) {
            return 65535L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getResetTime(String string2) {
        try {
            long l = this.mService.getResetTime(string2);
            return l;
        }
        catch (RemoteException remoteException) {
            return 65535L;
        }
    }
}

