/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public abstract class Uri
implements Parcelable,
Comparable<Uri> {
    public static final Parcelable.Creator<Uri> CREATOR;
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final Uri EMPTY;
    private static final char[] HEX_DIGITS;
    private static final String LOG;
    private static final String NOT_CACHED;
    private static final int NOT_CALCULATED = 254;
    private static final int NOT_FOUND = 255;
    private static final String NOT_HIERARCHICAL = "This isn't a hierarchical URI.";
    private static final int NULL_TYPE_ID;
    private static final byte[] REPLACEMENT;

    static {
        LOG = Uri.class.getSimpleName();
        NOT_CACHED = new String("NOT CACHED");
        Part part = Part.NULL;
        PathPart pathPart = PathPart.EMPTY;
        Part part2 = Part.NULL;
        Part part3 = Part.NULL;
        1 var4_4 = null;
        EMPTY = new HierarchicalUri(null, part, pathPart, part2, part3);
        CREATOR = new Parcelable.Creator<Uri>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Uri createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                switch (n) {
                    default: {
                        String string2 = "Unknown URI type: " + n;
                        throw new AssertionError((Object)string2);
                    }
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return StringUri.readFrom(parcel);
                    }
                    case 2: {
                        return OpaqueUri.readFrom(parcel);
                    }
                    case 3: 
                }
                return HierarchicalUri.readFrom(parcel);
            }

            public Uri[] newArray(int n) {
                return new Uri[n];
            }
        };
        HEX_DIGITS = "0123456789ABCDEF".toCharArray();
        REPLACEMENT = new byte[]{255, 253};
    }

    private Uri() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String decode(String var0) {
        if (var0 == null) {
            return null;
        }
        var2_2 = null;
        var3_3 = null;
        var4_4 = var0.length();
        var5_5 = 0;
        block5: while (var5_5 < var4_4) {
            block14: {
                var6_6 = var0.indexOf(37, var5_5);
                if (var6_6 == -1) {
                    if (var2_2 == null) {
                        return var0;
                    }
                    var7_16 = var2_2.append(var0, var5_5, var4_4);
                    return var2_2.toString();
                }
                if (var2_2 == null) {
                    var2_2 = new StringBuilder(var4_4);
                    var3_3 = new ByteArrayOutputStream(4);
                } else {
                    var3_3.reset();
                }
                if (var6_6 > var5_5) {
                    var8_7 = var2_2.append(var0, var5_5, var6_6);
                    var5_5 = var6_6;
                }
                while (var5_5 + 2 >= var4_4) {
                    try {
                        var9_8 = Uri.REPLACEMENT;
                        var3_3.write(var9_8);
                    }
                    catch (UnsupportedEncodingException var12_17) {
                        throw new AssertionError((Object)var12_17);
                    }
                    catch (IOException var18_18) {
                        throw new AssertionError((Object)var18_18);
                    }
lbl31:
                    // 3 sources

                    while ((var5_5 += 3) >= var4_4 || var0.charAt(var5_5) != '%') {
                        var10_9 = var3_3.toString("UTF-8");
                        var11_10 = var2_2.append(var10_9);
                        continue block5;
                    }
                }
                var13_11 = var5_5 + 1;
                {
                    var14_12 = Character.digit(var0.charAt(var13_11), 16);
                    var15_13 = var5_5 + 2;
                    var16_14 = Character.digit(var0.charAt(var15_13), 16);
                    if (var14_12 != -1 && var16_14 != -1) break block14;
                    var17_15 = Uri.REPLACEMENT;
                    var3_3.write(var17_15);
                    ** GOTO lbl31
                }
            }
            var13_11 = (var14_12 << 4) + var16_14;
            {
                var3_3.write(var13_11);
                ** GOTO lbl31
            }
        }
        if (var2_2 != null) return var2_2.toString();
        return var0;
    }

    public static String encode(String string2) {
        return Uri.encode(string2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String encode(String string2, String string3) {
        if (string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            for (n4 = n2; n4 < n && Uri.isAllowed(string2.charAt(n4), string3); ++n4) {
            }
            if (n4 != n) {
                if (n2 == 0) {
                    return string2;
                }
                StringBuilder stringBuilder2 = stringBuilder.append(string2, n2, n);
                return stringBuilder.toString();
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (n4 > n2) {
                StringBuilder stringBuilder3 = stringBuilder.append(string2, n2, n4);
            }
            int n5 = n4;
            for (n3 = n5 + 1; n3 < n && !Uri.isAllowed(string2.charAt(n3), string3); ++n3) {
            }
            String string4 = string2.substring(n5, n3);
            try {
                byte[] byArray = string4.getBytes(DEFAULT_ENCODING);
                int n6 = byArray.length;
                for (int i = 0; i < n6; ++i) {
                    StringBuilder stringBuilder4 = stringBuilder.append('%');
                    char[] cArray = HEX_DIGITS;
                    int n7 = (byArray[i] & 0xF0) >> 4;
                    char c = cArray[n7];
                    StringBuilder stringBuilder5 = stringBuilder.append(c);
                    char[] cArray2 = HEX_DIGITS;
                    int n8 = byArray[i] & 0xF;
                    char c2 = cArray2[n8];
                    StringBuilder stringBuilder6 = stringBuilder.append(c2);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
            n2 = n3;
        }
        if (stringBuilder != null) return stringBuilder.toString();
        return string2;
    }

    public static Uri fromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        PathPart pathPart = PathPart.fromDecoded(file.getAbsolutePath());
        Part part = Part.EMPTY;
        Part part2 = Part.NULL;
        Part part3 = Part.NULL;
        return new HierarchicalUri("file", part, pathPart, part2, part3);
    }

    public static Uri fromParts(String string2, String string3, String string4) {
        if (string2 == null) {
            throw new NullPointerException("scheme");
        }
        if (string3 == null) {
            throw new NullPointerException("ssp");
        }
        Part part = Part.fromDecoded(string3);
        Part part2 = Part.fromDecoded(string4);
        return new OpaqueUri(string2, part, part2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAllowed(char c, String string2) {
        if (c >= 'A') {
            if (c <= 'Z') return true;
        }
        if (c >= 'a') {
            if (c <= 'z') return true;
        }
        if (c >= '0') {
            if (c <= '9') return true;
        }
        if ("_-!.~'()*".indexOf(c) != -1) return true;
        if (string2 == null) return false;
        if (string2.indexOf(c) == -1) return false;
        return true;
    }

    public static Uri parse(String string2) {
        return new StringUri(string2);
    }

    public static Uri withAppendedPath(Uri uri, String string2) {
        return uri.buildUpon().appendEncodedPath(string2).build();
    }

    public static void writeToParcel(Parcel parcel, Uri uri) {
        if (uri == null) {
            parcel.writeInt(0);
            return;
        }
        uri.writeToParcel(parcel, 0);
    }

    public abstract Builder buildUpon();

    @Override
    public int compareTo(Uri uri) {
        String string2 = this.toString();
        String string3 = uri.toString();
        return string2.compareTo(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Uri)) {
            return false;
        }
        Uri uri = (Uri)object;
        String string2 = this.toString();
        String string3 = uri.toString();
        return string2.equals(string3);
    }

    public abstract String getAuthority();

    public abstract String getEncodedAuthority();

    public abstract String getEncodedFragment();

    public abstract String getEncodedPath();

    public abstract String getEncodedQuery();

    public abstract String getEncodedSchemeSpecificPart();

    public abstract String getEncodedUserInfo();

    public abstract String getFragment();

    public abstract String getHost();

    public abstract String getLastPathSegment();

    public abstract String getPath();

    public abstract List<String> getPathSegments();

    public abstract int getPort();

    public abstract String getQuery();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getQueryParameter(String string2) {
        if (this.isOpaque()) {
            throw new UnsupportedOperationException(NOT_HIERARCHICAL);
        }
        if (string2 == null) {
            throw new NullPointerException("key");
        }
        String string3 = this.getEncodedQuery();
        if (string3 == null) {
            return null;
        }
        String string4 = Uri.encode(string2, null);
        int n = string4.length();
        int n2 = 0;
        int n3 = string3.length();
        int n4 = n + 1;
        int n5 = n3 - n4;
        while (n2 <= n5) {
            int n6;
            int n7 = string3.indexOf(string4, n2);
            if (n7 == -1) {
                return null;
            }
            int n8 = n7 + n;
            int n9 = string3.length();
            if (n8 >= n9) return null;
            if (string3.charAt(n8) != '=') {
                n2 = n8 + 1;
                continue;
            }
            if (n7 == 0 || string3.charAt(n6 = n7 - 1) == '&') {
                int n10 = string3.indexOf(38, n8);
                if (n10 == -1) {
                    n10 = string3.length();
                }
                int n11 = n8 + 1;
                return Uri.decode(string3.substring(n11, n10));
            }
            n2 = n8 + 1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getQueryParameters(String string2) {
        int n;
        int n2;
        ArrayList<String> arrayList;
        String string3;
        void var3_4;
        if (this.isOpaque()) {
            throw new UnsupportedOperationException(NOT_HIERARCHICAL);
        }
        String string4 = this.getEncodedQuery();
        if (string4 == null) {
            List list = Collections.emptyList();
            return var3_4;
        }
        try {
            String string5;
            String string6 = string5 = URLEncoder.encode(string2, DEFAULT_ENCODING);
            string4 = "&" + string4;
            string3 = "&" + string6 + "=";
            arrayList = new ArrayList<String>();
            n2 = 0;
            n = string4.length();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        while (true) {
            if (n2 >= n || (n2 = string4.indexOf(string3, n2)) == -1) {
                List list = Collections.unmodifiableList(arrayList);
                return var3_4;
            }
            int n3 = string3.length();
            int n4 = n2 + n3;
            int n5 = string4.indexOf(38, n4);
            if (n5 == -1) {
                n5 = string4.length();
            }
            String string7 = Uri.decode(string4.substring(n4, n5));
            boolean bl = arrayList.add(string7);
            n2 = n5;
        }
    }

    public abstract String getScheme();

    public abstract String getSchemeSpecificPart();

    public abstract String getUserInfo();

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAbsolute() {
        if (this.isRelative()) return false;
        return true;
    }

    public abstract boolean isHierarchical();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOpaque() {
        if (this.isHierarchical()) return false;
        return true;
    }

    public abstract boolean isRelative();

    public abstract String toString();

    static class PathPart
    extends AbstractPart {
        static final PathPart EMPTY;
        static final PathPart NULL;
        private PathSegments pathSegments;

        static {
            NULL = new PathPart(null, null);
            EMPTY = new PathPart("", "");
        }

        private PathPart(String string2, String string3) {
            super(string2, string3);
        }

        static PathPart appendDecodedSegment(PathPart pathPart, String string2) {
            String string3 = Uri.encode(string2);
            return PathPart.appendEncodedSegment(pathPart, string3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static PathPart appendEncodedSegment(PathPart pathPart, String string2) {
            String string3;
            int n;
            if (pathPart == null) {
                return PathPart.fromEncoded("/" + string2);
            }
            String string4 = pathPart.getEncoded();
            if (string4 == null) {
                string4 = "";
            }
            if ((n = string4.length()) == 0) {
                string3 = "/" + string2;
                return PathPart.fromEncoded(string3);
            }
            int n2 = n - 1;
            if (string4.charAt(n2) == '/') {
                string3 = string4 + string2;
                return PathPart.fromEncoded(string3);
            }
            string3 = string4 + "/" + string2;
            return PathPart.fromEncoded(string3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static PathPart from(String string2, String string3) {
            if (string2 == null) {
                return NULL;
            }
            if (string2.length() != 0) return new PathPart(string2, string3);
            return EMPTY;
        }

        static PathPart fromDecoded(String string2) {
            return PathPart.from(NOT_CACHED, string2);
        }

        static PathPart fromEncoded(String string2) {
            String string3 = NOT_CACHED;
            return PathPart.from(string2, string3);
        }

        /*
         * Enabled aggressive block sorting
         */
        static PathPart makeAbsolute(PathPart pathPart) {
            String string2;
            String string3;
            String string4;
            String string5;
            String string6 = pathPart.encoded;
            String string7 = NOT_CACHED;
            boolean bl = string6 != string7;
            String string8 = bl ? pathPart.encoded : pathPart.decoded;
            if (string8 == null) return pathPart;
            if (string8.length() == 0) return pathPart;
            if (string8.startsWith("/")) {
                return pathPart;
            }
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder().append("/");
                String string9 = pathPart.encoded;
                string5 = stringBuilder.append(string9).toString();
            } else {
                string5 = NOT_CACHED;
            }
            boolean bl2 = (string4 = pathPart.decoded) != (string3 = NOT_CACHED);
            if (bl2) {
                StringBuilder stringBuilder = new StringBuilder().append("/");
                String string10 = pathPart.decoded;
                string2 = stringBuilder.append(string10).toString();
                return new PathPart(string5, string2);
            } else {
                string2 = NOT_CACHED;
            }
            return new PathPart(string5, string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static PathPart readFrom(Parcel parcel) {
            switch (parcel.readInt()) {
                default: {
                    throw new AssertionError();
                }
                case 0: {
                    String string2 = parcel.readString();
                    String string3 = parcel.readString();
                    return PathPart.from(string2, string3);
                }
                case 1: {
                    return PathPart.fromEncoded(parcel.readString());
                }
                case 2: 
            }
            return PathPart.fromDecoded(parcel.readString());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        String getEncoded() {
            String string2;
            String string3 = this.encoded;
            String string4 = NOT_CACHED;
            boolean bl = string3 != string4;
            if (bl) {
                return this.encoded;
            }
            this.encoded = string2 = Uri.encode(this.decoded, "/");
            return string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        PathSegments getPathSegments() {
            int n;
            PathSegments pathSegments;
            if (this.pathSegments != null) {
                return this.pathSegments;
            }
            String string2 = this.getEncoded();
            if (string2 == null) {
                this.pathSegments = pathSegments = PathSegments.EMPTY;
                return pathSegments;
            }
            PathSegmentsBuilder pathSegmentsBuilder = new PathSegmentsBuilder();
            int n2 = 0;
            while ((n = string2.indexOf(47, n2)) > -1) {
                if (n2 < n) {
                    String string3 = Uri.decode(string2.substring(n2, n));
                    pathSegmentsBuilder.add(string3);
                }
                n2 = n + 1;
            }
            int n3 = string2.length();
            if (n2 < n3) {
                String string4 = Uri.decode(string2.substring(n2));
                pathSegmentsBuilder.add(string4);
            }
            this.pathSegments = pathSegments = pathSegmentsBuilder.build();
            return pathSegments;
        }
    }

    static class Part
    extends AbstractPart {
        static final Part EMPTY;
        static final Part NULL;

        static {
            NULL = new EmptyPart(null);
            EMPTY = new EmptyPart("");
        }

        private Part(String string2, String string3) {
            super(string2, string3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Part from(String string2, String string3) {
            if (string2 == null) {
                return NULL;
            }
            if (string2.length() == 0) {
                return EMPTY;
            }
            if (string3 == null) {
                return NULL;
            }
            if (string3.length() != 0) return new Part(string2, string3);
            return EMPTY;
        }

        static Part fromDecoded(String string2) {
            return Part.from(NOT_CACHED, string2);
        }

        static Part fromEncoded(String string2) {
            String string3 = NOT_CACHED;
            return Part.from(string2, string3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Part nonNull(Part part) {
            if (part != null) return part;
            return NULL;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Part readFrom(Parcel parcel) {
            switch (parcel.readInt()) {
                default: {
                    throw new AssertionError();
                }
                case 0: {
                    String string2 = parcel.readString();
                    String string3 = parcel.readString();
                    return Part.from(string2, string3);
                }
                case 1: {
                    return Part.fromEncoded(parcel.readString());
                }
                case 2: 
            }
            return Part.fromDecoded(parcel.readString());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        String getEncoded() {
            String string2;
            String string3 = this.encoded;
            String string4 = NOT_CACHED;
            boolean bl = string3 != string4;
            if (bl) {
                return this.encoded;
            }
            this.encoded = string2 = Uri.encode(this.decoded);
            return string2;
        }

        boolean isEmpty() {
            return false;
        }

        private static class EmptyPart
        extends Part {
            public EmptyPart(String string2) {
                super(string2, string2);
            }

            @Override
            boolean isEmpty() {
                return true;
            }
        }
    }

    static abstract class AbstractPart {
        volatile String decoded;
        volatile String encoded;

        AbstractPart(String string2, String string3) {
            this.encoded = string2;
            this.decoded = string3;
        }

        /*
         * Enabled aggressive block sorting
         */
        final String getDecoded() {
            String string2;
            String string3 = this.decoded;
            String string4 = NOT_CACHED;
            boolean bl = string3 != string4;
            if (bl) {
                return this.decoded;
            }
            this.decoded = string2 = Uri.decode(this.encoded);
            return string2;
        }

        abstract String getEncoded();

        /*
         * Enabled aggressive block sorting
         */
        final void writeTo(Parcel parcel) {
            String string2 = this.encoded;
            String string3 = NOT_CACHED;
            boolean bl = string2 != string3;
            String string4 = this.decoded;
            String string5 = NOT_CACHED;
            boolean bl2 = string4 != string5;
            if (bl && bl2) {
                parcel.writeInt(0);
                String string6 = this.encoded;
                parcel.writeString(string6);
                String string7 = this.decoded;
                parcel.writeString(string7);
                return;
            }
            if (bl) {
                parcel.writeInt(1);
                String string8 = this.encoded;
                parcel.writeString(string8);
                return;
            }
            if (bl2) {
                parcel.writeInt(2);
                String string9 = this.decoded;
                parcel.writeString(string9);
                return;
            }
            throw new AssertionError();
        }

        static class Representation {
            static final int BOTH = 0;
            static final int DECODED = 2;
            static final int ENCODED = 1;

            Representation() {
            }
        }
    }

    public static final class Builder {
        private Part authority;
        private Part fragment;
        private Part opaquePart;
        private PathPart path;
        private Part query;
        private String scheme;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean hasSchemeOrAuthority() {
            if (this.scheme != null) return true;
            if (this.authority == null) return false;
            Part part = this.authority;
            Part part2 = Part.NULL;
            if (part == part2) return false;
            return true;
        }

        public Builder appendEncodedPath(String string2) {
            PathPart pathPart = PathPart.appendEncodedSegment(this.path, string2);
            return this.path(pathPart);
        }

        public Builder appendPath(String string2) {
            PathPart pathPart = PathPart.appendDecodedSegment(this.path, string2);
            return this.path(pathPart);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder appendQueryParameter(String string2, String string3) {
            Part part;
            this.opaquePart = null;
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = Uri.encode(string2, null);
            StringBuilder stringBuilder2 = stringBuilder.append(string4).append("=");
            String string5 = Uri.encode(string3, null);
            String string6 = stringBuilder2.append(string5).toString();
            if (this.query == null) {
                Part part2;
                this.query = part2 = Part.fromEncoded(string6);
                return this;
            }
            String string7 = this.query.getEncoded();
            if (string7 == null || string7.length() == 0) {
                Part part3;
                this.query = part3 = Part.fromEncoded(string6);
                return this;
            }
            this.query = part = Part.fromEncoded(string7 + "&" + string6);
            return this;
        }

        Builder authority(Part part) {
            this.opaquePart = null;
            this.authority = part;
            return this;
        }

        public Builder authority(String string2) {
            Part part = Part.fromDecoded(string2);
            return this.authority(part);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public Uri build() {
            PathPart pathPart;
            void var4_5;
            if (this.opaquePart != null) {
                if (this.scheme == null) {
                    throw new UnsupportedOperationException("An opaque URI must have a scheme.");
                }
                String string2 = this.scheme;
                Part part = this.opaquePart;
                Part part2 = this.fragment;
                OpaqueUri opaqueUri = new OpaqueUri(string2, part, part2);
                return var4_5;
            }
            PathPart pathPart2 = this.path;
            if (pathPart2 == null || pathPart2 == (pathPart = PathPart.NULL)) {
                pathPart2 = PathPart.EMPTY;
            } else if (this.hasSchemeOrAuthority()) {
                pathPart2 = PathPart.makeAbsolute(pathPart2);
            }
            String string3 = this.scheme;
            Part part = this.authority;
            Part part3 = this.query;
            Part part4 = this.fragment;
            HierarchicalUri hierarchicalUri = new HierarchicalUri(string3, part, pathPart2, part3, part4);
            return var4_5;
        }

        public Builder encodedAuthority(String string2) {
            Part part = Part.fromEncoded(string2);
            return this.authority(part);
        }

        public Builder encodedFragment(String string2) {
            Part part = Part.fromEncoded(string2);
            return this.fragment(part);
        }

        public Builder encodedOpaquePart(String string2) {
            Part part = Part.fromEncoded(string2);
            return this.opaquePart(part);
        }

        public Builder encodedPath(String string2) {
            PathPart pathPart = PathPart.fromEncoded(string2);
            return this.path(pathPart);
        }

        public Builder encodedQuery(String string2) {
            Part part = Part.fromEncoded(string2);
            return this.query(part);
        }

        Builder fragment(Part part) {
            this.fragment = part;
            return this;
        }

        public Builder fragment(String string2) {
            Part part = Part.fromDecoded(string2);
            return this.fragment(part);
        }

        Builder opaquePart(Part part) {
            this.opaquePart = part;
            return this;
        }

        public Builder opaquePart(String string2) {
            Part part = Part.fromDecoded(string2);
            return this.opaquePart(part);
        }

        Builder path(PathPart pathPart) {
            this.opaquePart = null;
            this.path = pathPart;
            return this;
        }

        public Builder path(String string2) {
            PathPart pathPart = PathPart.fromDecoded(string2);
            return this.path(pathPart);
        }

        Builder query(Part part) {
            this.opaquePart = null;
            this.query = part;
            return this;
        }

        public Builder query(String string2) {
            Part part = Part.fromDecoded(string2);
            return this.query(part);
        }

        public Builder scheme(String string2) {
            this.scheme = string2;
            return this;
        }

        public String toString() {
            return this.build().toString();
        }
    }

    private static class HierarchicalUri
    extends AbstractHierarchicalUri {
        static final int TYPE_ID = 3;
        private final Part authority;
        private final Part fragment;
        private final PathPart path;
        private final Part query;
        private final String scheme;
        private Part ssp;
        private volatile String uriString;

        /*
         * Enabled aggressive block sorting
         */
        private HierarchicalUri(String string2, Part part, PathPart pathPart, Part part2, Part part3) {
            Part part4;
            Part part5;
            Part part6;
            String string3;
            this.uriString = string3 = NOT_CACHED;
            this.scheme = string2;
            this.authority = part6 = Part.nonNull(part);
            PathPart pathPart2 = pathPart == null ? PathPart.NULL : pathPart;
            this.path = pathPart2;
            this.query = part5 = Part.nonNull(part2);
            this.fragment = part4 = Part.nonNull(part3);
        }

        private void appendSspTo(StringBuilder stringBuilder) {
            String string2;
            String string3 = this.authority.getEncoded();
            if (string3 != null) {
                StringBuilder stringBuilder2 = stringBuilder.append("//").append(string3);
            }
            if ((string2 = this.path.getEncoded()) != null) {
                StringBuilder stringBuilder3 = stringBuilder.append(string2);
            }
            if (this.query.isEmpty()) {
                return;
            }
            StringBuilder stringBuilder4 = stringBuilder.append('?');
            String string4 = this.query.getEncoded();
            StringBuilder stringBuilder5 = stringBuilder4.append(string4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Part getSsp() {
            Part part;
            if (this.ssp != null) return this.ssp;
            this.ssp = part = Part.fromEncoded(this.makeSchemeSpecificPart());
            return part;
        }

        private String makeSchemeSpecificPart() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendSspTo(stringBuilder);
            return stringBuilder.toString();
        }

        private String makeUriString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.scheme != null) {
                String string2 = this.scheme;
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(':');
            }
            this.appendSspTo(stringBuilder);
            if (!this.fragment.isEmpty()) {
                StringBuilder stringBuilder3 = stringBuilder.append('#');
                String string3 = this.fragment.getEncoded();
                StringBuilder stringBuilder4 = stringBuilder3.append(string3);
            }
            return stringBuilder.toString();
        }

        static Uri readFrom(Parcel parcel) {
            String string2 = parcel.readString();
            Part part = Part.readFrom(parcel);
            PathPart pathPart = PathPart.readFrom(parcel);
            Part part2 = Part.readFrom(parcel);
            Part part3 = Part.readFrom(parcel);
            return new HierarchicalUri(string2, part, pathPart, part2, part3);
        }

        @Override
        public Builder buildUpon() {
            Builder builder = new Builder();
            String string2 = this.scheme;
            Builder builder2 = builder.scheme(string2);
            Part part = this.authority;
            Builder builder3 = builder2.authority(part);
            PathPart pathPart = this.path;
            Builder builder4 = builder3.path(pathPart);
            Part part2 = this.query;
            Builder builder5 = builder4.query(part2);
            Part part3 = this.fragment;
            return builder5.fragment(part3);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String getAuthority() {
            return this.authority.getDecoded();
        }

        @Override
        public String getEncodedAuthority() {
            return this.authority.getEncoded();
        }

        @Override
        public String getEncodedFragment() {
            return this.fragment.getEncoded();
        }

        @Override
        public String getEncodedPath() {
            return this.path.getEncoded();
        }

        @Override
        public String getEncodedQuery() {
            return this.query.getEncoded();
        }

        @Override
        public String getEncodedSchemeSpecificPart() {
            return this.getSsp().getEncoded();
        }

        @Override
        public String getFragment() {
            return this.fragment.getDecoded();
        }

        @Override
        public String getPath() {
            return this.path.getDecoded();
        }

        @Override
        public List<String> getPathSegments() {
            return this.path.getPathSegments();
        }

        @Override
        public String getQuery() {
            return this.query.getDecoded();
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public String getSchemeSpecificPart() {
            return this.getSsp().getDecoded();
        }

        @Override
        public boolean isHierarchical() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isRelative() {
            if (this.scheme != null) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String toString() {
            String string2;
            String string3 = this.uriString;
            String string4 = NOT_CACHED;
            boolean bl = string3 != string4;
            if (bl) {
                return this.uriString;
            }
            this.uriString = string2 = this.makeUriString();
            return string2;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(3);
            String string2 = this.scheme;
            parcel.writeString(string2);
            this.authority.writeTo(parcel);
            this.path.writeTo(parcel);
            this.query.writeTo(parcel);
            this.fragment.writeTo(parcel);
        }
    }

    private static abstract class AbstractHierarchicalUri
    extends Uri {
        private volatile String host;
        private volatile int port;
        private Part userInfo;

        private AbstractHierarchicalUri() {
            String string2;
            this.host = string2 = NOT_CACHED;
            this.port = -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Part getUserInfoPart() {
            Part part;
            if (this.userInfo != null) return this.userInfo;
            this.userInfo = part = Part.fromEncoded(this.parseUserInfo());
            return part;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String parseHost() {
            String string2;
            String string3 = this.getEncodedAuthority();
            if (string3 == null) {
                return null;
            }
            int n = string3.indexOf(64);
            int n2 = string3.indexOf(58, n);
            if (n2 == -1) {
                int n3 = n + 1;
                string2 = string3.substring(n3);
                return AbstractHierarchicalUri.decode(string2);
            }
            int n4 = n + 1;
            string2 = string3.substring(n4, n2);
            return AbstractHierarchicalUri.decode(string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int parsePort() {
            String string2 = this.getEncodedAuthority();
            if (string2 == null) {
                return -1;
            }
            int n = string2.indexOf(64);
            int n2 = string2.indexOf(58, n);
            if (n2 == -1) {
                return -1;
            }
            int n3 = n2 + 1;
            String string3 = AbstractHierarchicalUri.decode(string2.substring(n3));
            try {
                int n4 = Integer.parseInt(string3);
                return n4;
            }
            catch (NumberFormatException numberFormatException) {
                int n5 = Log.w(LOG, "Error parsing port string.", numberFormatException);
                return -1;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String parseUserInfo() {
            String string2 = this.getEncodedAuthority();
            if (string2 == null) {
                return null;
            }
            int n = string2.indexOf(64);
            if (n != -1) return string2.substring(0, n);
            return null;
        }

        @Override
        public final String getEncodedUserInfo() {
            return this.getUserInfoPart().getEncoded();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String getHost() {
            String string2;
            String string3 = this.host;
            String string4 = NOT_CACHED;
            boolean bl = string3 != string4;
            if (bl) {
                return this.host;
            }
            this.host = string2 = this.parseHost();
            return string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getLastPathSegment() {
            List<String> list = this.getPathSegments();
            int n = list.size();
            if (n == 0) {
                return null;
            }
            int n2 = n - 1;
            return list.get(n2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getPort() {
            int n;
            if (this.port != -1) return this.port;
            this.port = n = this.parsePort();
            return n;
        }

        @Override
        public String getUserInfo() {
            return this.getUserInfoPart().getDecoded();
        }
    }

    static class PathSegmentsBuilder {
        String[] segments;
        int size = 0;

        PathSegmentsBuilder() {
        }

        /*
         * Enabled aggressive block sorting
         */
        void add(String string2) {
            int n;
            if (this.segments == null) {
                String[] stringArray = new String[4];
                this.segments = stringArray;
            } else {
                int n2 = this.size + 1;
                int n3 = this.segments.length;
                if (n2 != n3) {
                    String[] stringArray = new String[this.segments.length * 2];
                    String[] stringArray2 = this.segments;
                    int n4 = this.segments.length;
                    System.arraycopy(stringArray2, 0, stringArray, 0, n4);
                    this.segments = stringArray;
                }
            }
            String[] stringArray = this.segments;
            int n5 = this.size;
            this.size = n = n5 + 1;
            stringArray[n5] = string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        PathSegments build() {
            PathSegments pathSegments;
            if (this.segments == null) {
                return PathSegments.EMPTY;
            }
            try {
                String[] stringArray = this.segments;
                int n = this.size;
                pathSegments = new PathSegments(stringArray, n);
                return pathSegments;
            }
            finally {
                this.segments = null;
                return pathSegments;
            }
        }
    }

    static class PathSegments
    extends AbstractList<String>
    implements RandomAccess {
        static final PathSegments EMPTY = new PathSegments(null, 0);
        final String[] segments;
        final int size;

        PathSegments(String[] stringArray, int n) {
            this.segments = stringArray;
            this.size = n;
        }

        @Override
        public String get(int n) {
            int n2 = this.size;
            if (n >= n2) {
                throw new IndexOutOfBoundsException();
            }
            return this.segments[n];
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private static class OpaqueUri
    extends Uri {
        static final int TYPE_ID = 2;
        private volatile String cachedString;
        private final Part fragment;
        private final String scheme;
        private final Part ssp;

        /*
         * Enabled aggressive block sorting
         */
        private OpaqueUri(String string2, Part part, Part part2) {
            String string3;
            this.cachedString = string3 = NOT_CACHED;
            this.scheme = string2;
            this.ssp = part;
            Part part3 = part2 == null ? Part.NULL : part2;
            this.fragment = part3;
        }

        static Uri readFrom(Parcel parcel) {
            String string2 = parcel.readString();
            Part part = Part.readFrom(parcel);
            Part part2 = Part.readFrom(parcel);
            return new OpaqueUri(string2, part, part2);
        }

        @Override
        public Builder buildUpon() {
            Builder builder = new Builder();
            String string2 = this.scheme;
            Builder builder2 = builder.scheme(string2);
            Part part = this.ssp;
            Builder builder3 = builder2.opaquePart(part);
            Part part2 = this.fragment;
            return builder3.fragment(part2);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String getAuthority() {
            return null;
        }

        @Override
        public String getEncodedAuthority() {
            return null;
        }

        @Override
        public String getEncodedFragment() {
            return this.fragment.getEncoded();
        }

        @Override
        public String getEncodedPath() {
            return null;
        }

        @Override
        public String getEncodedQuery() {
            return null;
        }

        @Override
        public String getEncodedSchemeSpecificPart() {
            return this.ssp.getEncoded();
        }

        @Override
        public String getEncodedUserInfo() {
            return null;
        }

        @Override
        public String getFragment() {
            return this.fragment.getDecoded();
        }

        @Override
        public String getHost() {
            return null;
        }

        @Override
        public String getLastPathSegment() {
            return null;
        }

        @Override
        public String getPath() {
            return null;
        }

        @Override
        public List<String> getPathSegments() {
            return Collections.emptyList();
        }

        @Override
        public int getPort() {
            return -1;
        }

        @Override
        public String getQuery() {
            return null;
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public String getSchemeSpecificPart() {
            return this.ssp.getDecoded();
        }

        @Override
        public String getUserInfo() {
            return null;
        }

        @Override
        public boolean isHierarchical() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isRelative() {
            if (this.scheme != null) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String toString() {
            String string2;
            String string3 = this.cachedString;
            String string4 = NOT_CACHED;
            boolean bl = string3 != string4;
            if (bl) {
                return this.cachedString;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string5 = this.scheme;
            StringBuilder stringBuilder2 = stringBuilder.append(string5).append(':');
            String string6 = this.getEncodedSchemeSpecificPart();
            StringBuilder stringBuilder3 = stringBuilder.append(string6);
            if (!this.fragment.isEmpty()) {
                StringBuilder stringBuilder4 = stringBuilder.append('#');
                String string7 = this.fragment.getEncoded();
                StringBuilder stringBuilder5 = stringBuilder4.append(string7);
            }
            this.cachedString = string2 = stringBuilder.toString();
            return string2;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(2);
            String string2 = this.scheme;
            parcel.writeString(string2);
            this.ssp.writeTo(parcel);
            this.fragment.writeTo(parcel);
        }
    }

    private static class StringUri
    extends AbstractHierarchicalUri {
        static final int TYPE_ID = 1;
        private Part authority;
        private volatile int cachedFsi = -1;
        private volatile int cachedSsi = -1;
        private Part fragment;
        private PathPart path;
        private Part query;
        private volatile String scheme;
        private Part ssp;
        private final String uriString;

        private StringUri(String string2) {
            String string3;
            this.scheme = string3 = NOT_CACHED;
            if (string2 == null) {
                throw new NullPointerException("uriString");
            }
            this.uriString = string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int findFragmentSeparator() {
            int n;
            if (this.cachedFsi != -1) return this.cachedFsi;
            String string2 = this.uriString;
            int n2 = this.findSchemeSeparator();
            this.cachedFsi = n = string2.indexOf(35, n2);
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int findSchemeSeparator() {
            int n;
            if (this.cachedSsi != -1) return this.cachedSsi;
            this.cachedSsi = n = this.uriString.indexOf(58);
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Part getAuthorityPart() {
            Part part;
            if (this.authority != null) return this.authority;
            String string2 = this.uriString;
            int n = this.findSchemeSeparator();
            this.authority = part = Part.fromEncoded(StringUri.parseAuthority(string2, n));
            return part;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Part getFragmentPart() {
            Part part;
            if (this.fragment != null) return this.fragment;
            this.fragment = part = Part.fromEncoded(this.parseFragment());
            return part;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private PathPart getPathPart() {
            PathPart pathPart;
            if (this.path != null) return this.path;
            this.path = pathPart = PathPart.fromEncoded(this.parsePath());
            return pathPart;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Part getQueryPart() {
            Part part;
            if (this.query != null) return this.query;
            this.query = part = Part.fromEncoded(this.parseQuery());
            return part;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Part getSsp() {
            Part part;
            if (this.ssp != null) return this.ssp;
            this.ssp = part = Part.fromEncoded(this.parseSsp());
            return part;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static String parseAuthority(String string2, int n) {
            int n2;
            int n3;
            int n4 = string2.length();
            if (n4 <= (n3 = n + 2)) return null;
            int n5 = n + 1;
            if (string2.charAt(n5) != '/') return null;
            int n6 = n + 2;
            if (string2.charAt(n6) != '/') return null;
            block3: for (n2 = n + 3; n2 < n4; ++n2) {
                switch (string2.charAt(n2)) {
                    default: {
                        continue block3;
                    }
                    case '#': 
                    case '/': 
                    case '?': {
                        break block3;
                    }
                }
            }
            int n7 = n + 3;
            return string2.substring(n7, n2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String parseFragment() {
            int n = this.findFragmentSeparator();
            if (n == -1) {
                return null;
            }
            String string2 = this.uriString;
            int n2 = n + 1;
            return string2.substring(n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        private String parsePath() {
            String string2 = this.uriString;
            int n = this.findSchemeSeparator();
            if (n <= -1) return StringUri.parsePath(string2, n);
            int n2 = n + 1;
            int n3 = string2.length();
            if (n2 != n3) {
                return null;
            }
            boolean bl = false;
            if (bl) {
                return null;
            }
            int n4 = n + 1;
            if (string2.charAt(n4) == '/') return StringUri.parsePath(string2, n);
            return null;
        }

        /*
         * Exception decompiling
         */
        static String parsePath(String var0, int var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String parseQuery() {
            String string2 = this.uriString;
            int n = this.findSchemeSeparator();
            int n2 = string2.indexOf(63, n);
            if (n2 == -1) {
                return null;
            }
            int n3 = this.findFragmentSeparator();
            if (n3 == -1) {
                String string3 = this.uriString;
                int n4 = n2 + 1;
                return string3.substring(n4);
            }
            if (n3 < n2) {
                return null;
            }
            String string4 = this.uriString;
            int n5 = n2 + 1;
            return string4.substring(n5, n3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String parseScheme() {
            int n = this.findSchemeSeparator();
            if (n != -1) return this.uriString.substring(0, n);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String parseSsp() {
            int n = this.findSchemeSeparator();
            int n2 = this.findFragmentSeparator();
            if (n2 == -1) {
                String string2 = this.uriString;
                int n3 = n + 1;
                return string2.substring(n3);
            }
            String string3 = this.uriString;
            int n4 = n + 1;
            return string3.substring(n4, n2);
        }

        static Uri readFrom(Parcel parcel) {
            String string2 = parcel.readString();
            return new StringUri(string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Builder buildUpon() {
            if (this.isHierarchical()) {
                Builder builder = new Builder();
                String string2 = this.getScheme();
                Builder builder2 = builder.scheme(string2);
                Part part = this.getAuthorityPart();
                Builder builder3 = builder2.authority(part);
                PathPart pathPart = this.getPathPart();
                Builder builder4 = builder3.path(pathPart);
                Part part2 = this.getQueryPart();
                Builder builder5 = builder4.query(part2);
                Part part3 = this.getFragmentPart();
                return builder5.fragment(part3);
            }
            Builder builder = new Builder();
            String string3 = this.getScheme();
            Builder builder6 = builder.scheme(string3);
            Part part = this.getSsp();
            Builder builder7 = builder6.opaquePart(part);
            Part part4 = this.getFragmentPart();
            return builder7.fragment(part4);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String getAuthority() {
            return this.getAuthorityPart().getDecoded();
        }

        @Override
        public String getEncodedAuthority() {
            return this.getAuthorityPart().getEncoded();
        }

        @Override
        public String getEncodedFragment() {
            return this.getFragmentPart().getEncoded();
        }

        @Override
        public String getEncodedPath() {
            return this.getPathPart().getEncoded();
        }

        @Override
        public String getEncodedQuery() {
            return this.getQueryPart().getEncoded();
        }

        @Override
        public String getEncodedSchemeSpecificPart() {
            return this.getSsp().getEncoded();
        }

        @Override
        public String getFragment() {
            return this.getFragmentPart().getDecoded();
        }

        @Override
        public String getPath() {
            return this.getPathPart().getDecoded();
        }

        @Override
        public List<String> getPathSegments() {
            return this.getPathPart().getPathSegments();
        }

        @Override
        public String getQuery() {
            return this.getQueryPart().getDecoded();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String getScheme() {
            String string2;
            String string3 = this.scheme;
            String string4 = NOT_CACHED;
            boolean bl = string3 != string4;
            if (bl) {
                return this.scheme;
            }
            this.scheme = string2 = this.parseScheme();
            return string2;
        }

        @Override
        public String getSchemeSpecificPart() {
            return this.getSsp().getDecoded();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isHierarchical() {
            int n;
            int n2 = this.findSchemeSeparator();
            if (n2 == -1) {
                return true;
            }
            int n3 = this.uriString.length();
            if (n3 != (n = n2 + 1)) {
                return false;
            }
            String string2 = this.uriString;
            int n4 = n2 + 1;
            if (string2.charAt(n4) != '/') return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isRelative() {
            if (this.findSchemeSeparator() != -1) return false;
            return true;
        }

        @Override
        public String toString() {
            return this.uriString;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(1);
            String string2 = this.uriString;
            parcel.writeString(string2);
        }
    }
}

