/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class UrlQuerySanitizer {
    private static final ValueSanitizer sAllButNulAndAngleBracketsLegal;
    private static final ValueSanitizer sAllButNulLegal;
    private static final ValueSanitizer sAllButWhitespaceLegal;
    private static final ValueSanitizer sAllIllegal;
    private static final ValueSanitizer sAmpAndSpaceLegal;
    private static final ValueSanitizer sAmpLegal;
    private static final ValueSanitizer sSpaceLegal;
    private static final ValueSanitizer sURLLegal;
    private static final ValueSanitizer sUrlAndSpaceLegal;
    private boolean mAllowUnregisteredParamaters;
    private final HashMap<String, String> mEntries;
    private final ArrayList<ParameterValuePair> mEntriesList;
    private boolean mPreferFirstRepeatedParameter;
    private final HashMap<String, ValueSanitizer> mSanitizers;
    private ValueSanitizer mUnregisteredParameterValueSanitizer;

    static {
        sAllIllegal = new IllegalCharacterValueSanitizer(0);
        sAllButNulLegal = new IllegalCharacterValueSanitizer(1535);
        sAllButWhitespaceLegal = new IllegalCharacterValueSanitizer(1532);
        sURLLegal = new IllegalCharacterValueSanitizer(404);
        sUrlAndSpaceLegal = new IllegalCharacterValueSanitizer(405);
        sAmpLegal = new IllegalCharacterValueSanitizer(128);
        sAmpAndSpaceLegal = new IllegalCharacterValueSanitizer(129);
        sSpaceLegal = new IllegalCharacterValueSanitizer(1);
        sAllButNulAndAngleBracketsLegal = new IllegalCharacterValueSanitizer(1439);
    }

    public UrlQuerySanitizer() {
        ValueSanitizer valueSanitizer;
        HashMap hashMap = new HashMap();
        this.mSanitizers = hashMap;
        HashMap hashMap2 = new HashMap();
        this.mEntries = hashMap2;
        ArrayList arrayList = new ArrayList();
        this.mEntriesList = arrayList;
        this.mUnregisteredParameterValueSanitizer = valueSanitizer = UrlQuerySanitizer.getAllIllegal();
    }

    public UrlQuerySanitizer(String string2) {
        ValueSanitizer valueSanitizer;
        HashMap hashMap = new HashMap();
        this.mSanitizers = hashMap;
        HashMap hashMap2 = new HashMap();
        this.mEntries = hashMap2;
        ArrayList arrayList = new ArrayList();
        this.mEntriesList = arrayList;
        this.mUnregisteredParameterValueSanitizer = valueSanitizer = UrlQuerySanitizer.getAllIllegal();
        this.setAllowUnregisteredParamaters(true);
        this.parseUrl(string2);
    }

    public static final ValueSanitizer getAllButNulAndAngleBracketsLegal() {
        return sAllButNulAndAngleBracketsLegal;
    }

    public static final ValueSanitizer getAllButNulLegal() {
        return sAllButNulLegal;
    }

    public static final ValueSanitizer getAllButWhitespaceLegal() {
        return sAllButWhitespaceLegal;
    }

    public static final ValueSanitizer getAllIllegal() {
        return sAllIllegal;
    }

    public static final ValueSanitizer getAmpAndSpaceLegal() {
        return sAmpAndSpaceLegal;
    }

    public static final ValueSanitizer getAmpLegal() {
        return sAmpLegal;
    }

    public static final ValueSanitizer getSpaceLegal() {
        return sSpaceLegal;
    }

    public static final ValueSanitizer getUrlAndSpaceLegal() {
        return sUrlAndSpaceLegal;
    }

    public static final ValueSanitizer getUrlLegal() {
        return sURLLegal;
    }

    protected void addSanitizedEntry(String string2, String string3) {
        ArrayList<ParameterValuePair> arrayList = this.mEntriesList;
        ParameterValuePair parameterValuePair = new ParameterValuePair(string2, string3);
        boolean bl = arrayList.add(parameterValuePair);
        if (this.mPreferFirstRepeatedParameter && this.mEntries.containsKey(string2)) {
            return;
        }
        String string4 = this.mEntries.put(string2, string3);
    }

    protected void clear() {
        this.mEntries.clear();
        this.mEntriesList.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c < 'a') return -1;
        if (c > 'f') return -1;
        return c - 97 + 10;
    }

    public boolean getAllowUnregisteredParamaters() {
        return this.mAllowUnregisteredParamaters;
    }

    public ValueSanitizer getEffectiveValueSanitizer(String string2) {
        ValueSanitizer valueSanitizer = this.getValueSanitizer(string2);
        if (valueSanitizer == null && this.mAllowUnregisteredParamaters) {
            valueSanitizer = this.getUnregisteredParameterValueSanitizer();
        }
        return valueSanitizer;
    }

    public List<ParameterValuePair> getParameterList() {
        return this.mEntriesList;
    }

    public Set<String> getParameterSet() {
        return this.mEntries.keySet();
    }

    public boolean getPreferFirstRepeatedParameter() {
        return this.mPreferFirstRepeatedParameter;
    }

    public ValueSanitizer getUnregisteredParameterValueSanitizer() {
        return this.mUnregisteredParameterValueSanitizer;
    }

    public String getValue(String string2) {
        return this.mEntries.get(string2);
    }

    public ValueSanitizer getValueSanitizer(String string2) {
        return this.mSanitizers.get(string2);
    }

    public boolean hasParameter(String string2) {
        return this.mEntries.containsKey(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isHexDigit(char c) {
        if (this.decodeHexDigit(c) < 0) return false;
        return true;
    }

    protected void parseEntry(String string2, String string3) {
        String string4 = this.unescape(string2);
        ValueSanitizer valueSanitizer = this.getEffectiveValueSanitizer(string4);
        if (valueSanitizer == null) {
            return;
        }
        String string5 = this.unescape(string3);
        String string6 = valueSanitizer.sanitize(string5);
        this.addSanitizedEntry(string4, string6);
    }

    public void parseQuery(String string2) {
        this.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() <= 0) continue;
            int n = string3.indexOf(61);
            if (n < 0) {
                this.parseEntry(string3, "");
                continue;
            }
            String string4 = string3.substring(0, n);
            int n2 = n + 1;
            String string5 = string3.substring(n2);
            this.parseEntry(string4, string5);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseUrl(String string2) {
        String string3;
        int n = string2.indexOf(63);
        if (n >= 0) {
            int n2 = n + 1;
            string3 = string2.substring(n2);
        } else {
            string3 = "";
        }
        this.parseQuery(string3);
    }

    public void registerParameter(String string2, ValueSanitizer valueSanitizer) {
        if (valueSanitizer == null) {
            ValueSanitizer valueSanitizer2 = this.mSanitizers.remove(string2);
        }
        ValueSanitizer valueSanitizer3 = this.mSanitizers.put(string2, valueSanitizer);
    }

    public void registerParameters(String[] stringArray, ValueSanitizer valueSanitizer) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            HashMap<String, ValueSanitizer> hashMap = this.mSanitizers;
            String string2 = stringArray[n2];
            ValueSanitizer valueSanitizer2 = hashMap.put(string2, valueSanitizer);
            ++n2;
        }
        return;
    }

    public void setAllowUnregisteredParamaters(boolean bl) {
        this.mAllowUnregisteredParamaters = bl;
    }

    public void setPreferFirstRepeatedParameter(boolean bl) {
        this.mPreferFirstRepeatedParameter = bl;
    }

    public void setUnregisteredParameterValueSanitizer(ValueSanitizer valueSanitizer) {
        this.mUnregisteredParameterValueSanitizer = valueSanitizer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String unescape(String string2) {
        int n = string2.indexOf(37);
        if (n < 0 && (n = string2.indexOf(43)) < 0) {
            return string2;
        }
        int n2 = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        String string3 = string2.substring(0, n);
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        int n3 = n;
        while (n3 < n2) {
            char c = string2.charAt(n3);
            if (c == '+') {
                c = ' ';
            } else if (c == '%' && n3 + 2 < n2) {
                int n4 = n3 + 1;
                char c2 = string2.charAt(n4);
                int n5 = n3 + 2;
                char c3 = string2.charAt(n5);
                if (this.isHexDigit(c2) && this.isHexDigit(c3)) {
                    int n6 = this.decodeHexDigit(c2) * 16;
                    int n7 = this.decodeHexDigit(c3);
                    c = (char)(n6 + n7);
                    n3 += 2;
                }
            }
            StringBuilder stringBuilder3 = stringBuilder.append(c);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static class IllegalCharacterValueSanitizer
    implements ValueSanitizer {
        public static final int ALL_BUT_NUL_AND_ANGLE_BRACKETS_LEGAL = 1439;
        public static final int ALL_BUT_NUL_LEGAL = 1535;
        public static final int ALL_BUT_WHITESPACE_LEGAL = 1532;
        public static final int ALL_ILLEGAL = 0;
        public static final int ALL_OK = 2047;
        public static final int ALL_WHITESPACE_OK = 3;
        public static final int AMP_AND_SPACE_LEGAL = 129;
        public static final int AMP_LEGAL = 128;
        public static final int AMP_OK = 128;
        public static final int DQUOTE_OK = 8;
        public static final int GT_OK = 64;
        private static final String JAVASCRIPT_PREFIX = "javascript:";
        public static final int LT_OK = 32;
        private static final int MIN_SCRIPT_PREFIX_LENGTH = 0;
        public static final int NON_7_BIT_ASCII_OK = 4;
        public static final int NUL_OK = 512;
        public static final int OTHER_WHITESPACE_OK = 2;
        public static final int PCT_OK = 256;
        public static final int SCRIPT_URL_OK = 1024;
        public static final int SPACE_LEGAL = 1;
        public static final int SPACE_OK = 1;
        public static final int SQUOTE_OK = 16;
        public static final int URL_AND_SPACE_LEGAL = 405;
        public static final int URL_LEGAL = 404;
        private static final String VBSCRIPT_PREFIX = "vbscript:";
        private int mFlags;

        static {
            int n = JAVASCRIPT_PREFIX.length();
            int n2 = VBSCRIPT_PREFIX.length();
            MIN_SCRIPT_PREFIX_LENGTH = Math.min(n, n2);
        }

        public IllegalCharacterValueSanitizer(int n) {
            this.mFlags = n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean characterIsLegal(char c) {
            switch (c) {
                default: {
                    if (c >= ' ') {
                        if (c < '\u007f') return true;
                    }
                    if (c < '\u0080') return false;
                    if ((this.mFlags & 4) == 0) return false;
                    return true;
                }
                case ' ': {
                    if ((this.mFlags & 1) == 0) return false;
                    return true;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': {
                    if ((this.mFlags & 2) == 0) return false;
                    return true;
                }
                case '\"': {
                    if ((this.mFlags & 8) == 0) return false;
                    return true;
                }
                case '\'': {
                    if ((this.mFlags & 0x10) == 0) return false;
                    return true;
                }
                case '<': {
                    if ((this.mFlags & 0x20) == 0) return false;
                    return true;
                }
                case '>': {
                    if ((this.mFlags & 0x40) == 0) return false;
                    return true;
                }
                case '&': {
                    if ((this.mFlags & 0x80) == 0) return false;
                    return true;
                }
                case '%': {
                    if ((this.mFlags & 0x100) == 0) return false;
                    return true;
                }
                case '\u0000': {
                    if ((this.mFlags & 0x200) == 0) return false;
                    return true;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isWhitespace(char c) {
            switch (c) {
                default: {
                    return false;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String trimWhitespace(String string2) {
            char c;
            char c2;
            int n;
            int n2;
            int n3 = n2 = string2.length() - 1;
            for (n = 0; n <= n3 && this.isWhitespace(c2 = string2.charAt(n)); ++n) {
            }
            while (n3 >= n && this.isWhitespace(c = string2.charAt(n3))) {
                n3 += -1;
            }
            if (n == 0 && n3 != n2) {
                return string2;
            }
            int n4 = n3 + 1;
            return string2.substring(n, n4);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String sanitize(String string2) {
            int n;
            if (string2 == null) {
                return null;
            }
            int n2 = string2.length();
            if ((this.mFlags & 0x400) != 0 && n2 >= (n = MIN_SCRIPT_PREFIX_LENGTH)) {
                String string3 = string2.toLowerCase();
                if (string3.startsWith(JAVASCRIPT_PREFIX)) return "";
                if (string3.startsWith(VBSCRIPT_PREFIX)) {
                    return "";
                }
            }
            if ((this.mFlags & 3) == 0) {
                string2 = this.trimWhitespace(string2);
                n2 = string2.length();
            }
            StringBuilder stringBuilder = new StringBuilder(n2);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = string2.charAt(n3);
                if (!this.characterIsLegal((char)n4)) {
                    n4 = (this.mFlags & 1) != 0 ? 32 : 95;
                }
                StringBuilder stringBuilder2 = stringBuilder.append((char)n4);
                ++n3;
            }
            return stringBuilder.toString();
        }
    }

    public static interface ValueSanitizer {
        public String sanitize(String var1);
    }

    public class ParameterValuePair {
        public String mParameter;
        public String mValue;

        public ParameterValuePair(String string2, String string3) {
            this.mParameter = string2;
            this.mValue = string3;
        }
    }
}

