/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.ContentResolver;
import android.content.Context;
import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.os.Looper;
import android.util.Log;
import com.android.internal.http.HttpDateTime;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;

public final class AndroidHttpClient
implements HttpClient {
    public static long DEFAULT_SYNC_MIN_GZIP_BYTES = 0L;
    private static final String TAG = "AndroidHttpClient";
    private static final HttpRequestInterceptor sThreadCheckInterceptor;
    private volatile LoggingConfiguration curlConfiguration;
    private final HttpClient delegate;
    private RuntimeException mLeakedException;

    static {
        DEFAULT_SYNC_MIN_GZIP_BYTES = 256L;
        sThreadCheckInterceptor = new HttpRequestInterceptor(){

            @Override
            public void process(HttpRequest httpRequest, HttpContext httpContext) {
                Looper looper;
                if (Looper.myLooper() == null) {
                    return;
                }
                Looper looper2 = Looper.myLooper();
                if (looper2 != (looper = Looper.getMainLooper())) {
                    return;
                }
                throw new RuntimeException("This thread forbids HTTP requests");
            }
        };
    }

    private AndroidHttpClient(ClientConnectionManager clientConnectionManager, HttpParams httpParams) {
        IllegalStateException illegalStateException = new IllegalStateException("AndroidHttpClient created and never closed");
        this.mLeakedException = illegalStateException;
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient(clientConnectionManager, httpParams){

            @Override
            protected HttpContext createHttpContext() {
                BasicHttpContext basicHttpContext = new BasicHttpContext();
                AuthSchemeRegistry authSchemeRegistry = this.getAuthSchemes();
                basicHttpContext.setAttribute("http.authscheme-registry", authSchemeRegistry);
                CookieSpecRegistry cookieSpecRegistry = this.getCookieSpecs();
                basicHttpContext.setAttribute("http.cookiespec-registry", cookieSpecRegistry);
                CredentialsProvider credentialsProvider = this.getCredentialsProvider();
                basicHttpContext.setAttribute("http.auth.credentials-provider", credentialsProvider);
                return basicHttpContext;
            }

            @Override
            protected BasicHttpProcessor createHttpProcessor() {
                BasicHttpProcessor basicHttpProcessor = super.createHttpProcessor();
                HttpRequestInterceptor httpRequestInterceptor = sThreadCheckInterceptor;
                basicHttpProcessor.addRequestInterceptor(httpRequestInterceptor);
                AndroidHttpClient androidHttpClient = AndroidHttpClient.this;
                CurlLogger curlLogger = androidHttpClient.new CurlLogger();
                basicHttpProcessor.addRequestInterceptor(curlLogger);
                return basicHttpProcessor;
            }
        };
        this.delegate = defaultHttpClient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractHttpEntity getCompressedEntity(byte[] byArray, ContentResolver contentResolver) throws IOException {
        long l = byArray.length;
        long l2 = AndroidHttpClient.getMinGzipSize(contentResolver);
        if (l < l2) {
            return new ByteArrayEntity(byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        ((OutputStream)gZIPOutputStream).write(byArray);
        ((OutputStream)gZIPOutputStream).close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(byArray2);
        byteArrayEntity.setContentEncoding("gzip");
        return byteArrayEntity;
    }

    public static long getMinGzipSize(ContentResolver contentResolver) {
        return DEFAULT_SYNC_MIN_GZIP_BYTES;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream getUngzippedContent(HttpEntity httpEntity) throws IOException {
        InputStream inputStream = httpEntity.getContent();
        if (inputStream == null) {
            return inputStream;
        }
        Header header = httpEntity.getContentEncoding();
        if (header == null) {
            return inputStream;
        }
        String string2 = header.getValue();
        if (string2 == null) {
            return inputStream;
        }
        if (!string2.contains("gzip")) return inputStream;
        inputStream = new GZIPInputStream(inputStream);
        return inputStream;
    }

    public static void modifyRequestToAcceptGzipResponse(HttpRequest httpRequest) {
        httpRequest.addHeader("Accept-Encoding", "gzip");
    }

    public static AndroidHttpClient newInstance(String string2) {
        return AndroidHttpClient.newInstance(string2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AndroidHttpClient newInstance(String string2, Context context) {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled(basicHttpParams, false);
        HttpConnectionParams.setConnectionTimeout(basicHttpParams, 20000);
        HttpConnectionParams.setSoTimeout(basicHttpParams, 20000);
        HttpConnectionParams.setSocketBufferSize(basicHttpParams, 8192);
        HttpClientParams.setRedirecting(basicHttpParams, false);
        SSLSessionCache sSLSessionCache = context == null ? null : new SSLSessionCache(context);
        HttpProtocolParams.setUserAgent(basicHttpParams, string2);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        PlainSocketFactory plainSocketFactory = PlainSocketFactory.getSocketFactory();
        Scheme scheme = new Scheme("http", plainSocketFactory, 80);
        Scheme scheme2 = schemeRegistry.register(scheme);
        SSLSocketFactory sSLSocketFactory = SSLCertificateSocketFactory.getHttpSocketFactory(30000, sSLSessionCache);
        Scheme scheme3 = new Scheme("https", sSLSocketFactory, 443);
        Scheme scheme4 = schemeRegistry.register(scheme3);
        ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager(basicHttpParams, schemeRegistry);
        return new AndroidHttpClient(threadSafeClientConnManager, basicHttpParams);
    }

    public static long parseDate(String string2) {
        return HttpDateTime.parse(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String toCurl(HttpUriRequest object, boolean bl) throws IOException {
        HttpRequest httpRequest;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("curl ");
        for (Header header : object.getAllHeaders()) {
            if (!bl && (header.getName().equals("Authorization") || header.getName().equals("Cookie"))) continue;
            StringBuilder stringBuilder3 = stringBuilder.append("--header \"");
            String string2 = header.toString().trim();
            StringBuilder stringBuilder4 = stringBuilder.append(string2);
            StringBuilder stringBuilder5 = stringBuilder.append("\" ");
        }
        URI uRI = object.getURI();
        URI uRI2 = object instanceof RequestWrapper && (httpRequest = ((RequestWrapper)object).getOriginal()) instanceof HttpUriRequest ? ((HttpUriRequest)httpRequest).getURI() : uRI;
        StringBuilder stringBuilder6 = stringBuilder.append("\"");
        StringBuilder stringBuilder7 = stringBuilder.append(uRI2);
        StringBuilder stringBuilder8 = stringBuilder.append("\"");
        if (!(object instanceof HttpEntityEnclosingRequest)) return stringBuilder.toString();
        if ((object = ((HttpEntityEnclosingRequest)object).getEntity()) == null) return stringBuilder.toString();
        if (!object.isRepeatable()) return stringBuilder.toString();
        if (object.getContentLength() < 1024L) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object.writeTo(byteArrayOutputStream);
            String string3 = byteArrayOutputStream.toString();
            StringBuilder stringBuilder9 = stringBuilder.append(" --data-ascii \"").append(string3).append("\"");
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder10 = stringBuilder.append(" [TOO MUCH DATA TO INCLUDE]");
        return stringBuilder.toString();
    }

    public void close() {
        if (this.mLeakedException == null) {
            return;
        }
        this.getConnectionManager().shutdown();
        this.mLeakedException = null;
    }

    public void disableCurlLogging() {
        this.curlConfiguration = null;
    }

    public void enableCurlLogging(String string2, int n) {
        LoggingConfiguration loggingConfiguration;
        if (string2 == null) {
            throw new NullPointerException("name");
        }
        if (n < 2 || n > 7) {
            throw new IllegalArgumentException("Level is out of range [2..7]");
        }
        this.curlConfiguration = loggingConfiguration = new LoggingConfiguration(string2, n);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.delegate.execute(httpHost, httpRequest, responseHandler);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.delegate.execute(httpHost, httpRequest, responseHandler, httpContext);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.delegate.execute(httpUriRequest, responseHandler);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.delegate.execute(httpUriRequest, responseHandler, httpContext);
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        return this.delegate.execute(httpHost, httpRequest);
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        return this.delegate.execute(httpHost, httpRequest, httpContext);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException {
        return this.delegate.execute(httpUriRequest);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) throws IOException {
        return this.delegate.execute(httpUriRequest, httpContext);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mLeakedException == null) {
            return;
        }
        RuntimeException runtimeException = this.mLeakedException;
        int n = Log.e(TAG, "Leak found", runtimeException);
        this.mLeakedException = null;
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }

    @Override
    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    private class CurlLogger
    implements HttpRequestInterceptor {
        private CurlLogger() {
        }

        @Override
        public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
            LoggingConfiguration loggingConfiguration = AndroidHttpClient.this.curlConfiguration;
            if (loggingConfiguration == null) {
                return;
            }
            if (!loggingConfiguration.isLoggable()) {
                return;
            }
            if (!(httpRequest instanceof HttpUriRequest)) {
                return;
            }
            String string2 = AndroidHttpClient.toCurl((HttpUriRequest)httpRequest, false);
            loggingConfiguration.println(string2);
        }
    }

    private static class LoggingConfiguration {
        private final int level;
        private final String tag;

        private LoggingConfiguration(String string2, int n) {
            this.tag = string2;
            this.level = n;
        }

        private boolean isLoggable() {
            String string2 = this.tag;
            int n = this.level;
            return Log.isLoggable(string2, n);
        }

        private void println(String string2) {
            int n = this.level;
            String string3 = this.tag;
            int n2 = Log.println(n, string3, string2);
        }
    }
}

